/***************************************************************************
                          hbcideskey.h  -  description
                             -------------------
    begin                : Sat Jun 30 2001
    copyright            : (C) 2001 by fabian kaiser
    email                : fabian.kaiser@gmx.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HBCIDESKEY_H
#define HBCIDESKEY_H

#include <string>
#include <openhbci/dllimport.h>
#include <openhbci/cryptkey.h>
#include <openhbci/rsakey.h>

using namespace std;

/* forward declarations */
namespace HBCI {
  class RSAKey;
}

namespace HBCI {

/**
 * @short Performs encryption and decryption with 2-key-3des in cbc-mode.
 *
 * Also padding method ANSI X9.32 is available.
 * @author fabian kaiser
 */
class DLLIMPORT DESKey : public CryptKey  {
public: 
	DESKey();
	/** create a des-key for specified password */
	DESKey(string password);
	virtual ~DESKey();
	
	/** create a new instance of DESKey (random-key) */
	DLLIMPORT static DESKey createKey();
	
	/** encrypt data */
	virtual bool encrypt();
	
	/** decrypt data */
	virtual bool decrypt();
	
	/** return the 16-byte key-string */
	const string &getKeyString() const { return keyData;};
	
	
	/** encrypt a RSAKey and return a string-representation */
	string encryptRSAKey(RSAKey *rsaKey);
	
	/** decrypt a string wich contains a RSAKey and return this key */
	RSAKey *decryptRSAKey(const string &encryptedKey);
	
	
	/** set the 16-byte key-string */
	void setKeyString(const string &data) { keyData = data;};
	
	/** get some random data */
	DLLIMPORT static unsigned char* getRndData(int length) ;
private:
	void  unpaddWithANSIX9_23() ;
	void paddWithANSIX9_23() ;
	
	
	bool crypt(int mode);
	string keyData;
};
} /* namespace HBCI */
#endif
