/* hbcistringlist.cpp
 *
 * Some helper functions for string list manipulation in C.
 *
 * Copyright (C) 2002 Christian Stimming
 */

#include "assert.h"

#include "hbcistringlist.h"
#include "hbcistring.h"

void list_string_delete(list_string *l)
{
    delete l;
}
void list_string_iter_delete(list_string_iter *l)
{
    delete l;
}
int list_string_size(const list_string *l)
{
    assert(l);
    return l->size();
}
list_string_iter* list_string_begin(const list_string *l)
{
    assert(l);
    return new list_string_iter(l->begin());
}
list_string_iter* list_string_end(const list_string *l)
{
    assert(l);
    return new list_string_iter(l->end());
}
const char* list_string_iter_get(const list_string_iter *l)
{
    assert(l);
    return (**l).c_str();
}
void list_string_iter_next(list_string_iter *l)
{
    assert(l);
    l->operator++();
}
int list_string_iter_equal(const list_string_iter *l1, 
			   const list_string_iter *l2)
{
    assert(l1);
    assert(l2);
    return (*l1) == (*l2);
}
void *list_string_foreach (const list_string *list, 
			   list_string_cb func,
			   void *user_data)
{
    assert(list);
    assert(func);
    list_string_iter iter, end;
    void *ret = 0l;

    end = list->end();
    for ( iter = list->begin(); iter != end; iter++ ) {
	ret = (*func)( (*iter).c_str(), user_data);
	if (ret)
	    break;
    }
    return ret;
}

char *list_string_concat (const list_string *list)
{
    return list_string_concat_delim(list, "");
}

char *list_string_concat_delim (const list_string *list,
				const char *delim)
{
    assert(list);
    list_string_iter iter, end;
    string del(delim), res;
    bool firstone = true;

    end = list->end();
    for ( iter = list->begin(); iter != end; iter++ ) {
	if (!firstone) 
	    res += del;
	else
	    firstone = false;
	res += *iter;
    }
    
    return hbci_strdup (res);
}

