/***************************************************************************
 $RCSfile: outboxjobs.h,v $
                             -------------------
    cvs         : $Id: outboxjobs.h,v 1.58 2003/07/02 08:04:02 cstim Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OUTBOXJOBS_H
#define OUTBOXJOBS_H

/** @file outboxjobs.h
 *
 * @short Miscellaneous OutboxJobs and their C wrappers. */

#ifdef __cplusplus
#include <string>
#include <list>
#endif /* __cplusplus */

#include <openhbci/dllimport.h>
#include <openhbci/pointer.h>
#include <openhbci/customer.h>
#include <openhbci/user.h>
#include <openhbci/bank.h>
#include <openhbci/account.h>
#include <openhbci/outboxjob.h>
#include <openhbci/statusreport.h>

#ifdef __cplusplus

namespace HBCI {

/**
 * This job updates the list of accounts for a customer, if necessary.
 * In fact this job does NOTHING ;-) All this job is supposed to do is
 * done by HBCIAPI.
 * @short Job that updates the list of Account's for a Customer
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DLLIMPORT OutboxJobGetAccounts: public OutboxJob {
private:
    Pointer<MessageQueue> _mbox;
    int _resultcode;

public:
    OutboxJobGetAccounts(Pointer<Customer> c);
    ~OutboxJobGetAccounts();

    bool createHBCIJobs(Pointer<MessageQueue> mbox, int n=0);
    bool evaluate();
    bool commit(int msgNumber=HBCI_COMMIT_WHOLE_JOB);
    string description() const;
    JobProgressType type() const { return JOB_GET_ACCOUNTS; };
    list<int> resultCodes() const;
};

} /* namespace HBCI */
/** @ingroup HBCI_OutboxJobg */
typedef struct HBCI::OutboxJobGetAccounts HBCI_OutboxJobGetAccounts;

extern "C" {
#else /* __cplusplus */
    typedef struct HBCI_OutboxJobGetAccounts HBCI_OutboxJobGetAccounts;
#endif /* __cplusplus */
    /** @name HBCI_OutboxJobGetAccounts 
     * @ingroup HBCI_OutboxJobg
     * 
     * @short This job updates the list of accounts for a customer, if
     * necessary. */
    /*@{*/
    /** Constructor */
    extern HBCI_OutboxJobGetAccounts *HBCI_OutboxJobGetAccounts_new(HBCI_Customer *c);
    /** Upcast */
    extern HBCI_OutboxJob *HBCI_OutboxJobGetAccounts_OutboxJob(HBCI_OutboxJobGetAccounts *j);
    /*@}*/
#ifdef __cplusplus
}
#endif /* __cplusplus */


#ifdef __cplusplus

namespace HBCI {

/**
 * @short Base class for synchronization jobs.
 *
 * This job synchronizes with the server according to arguments.
 * @short Job that synchronizes with the server
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DLLIMPORT OutboxJobSynchronize: public OutboxJob {
private:
    const API *_hbciapi;
    Pointer<JOBDialogInit> _initjob;
    Pointer<Job> _syncjob;
    Pointer<Job> _exitjob;
    int _syncwhat;

protected:
    /**
     * @param api The HBCI::API this job is working with
     * @param c Customer that invokes this job
     * @param syncwhat what to synchronize, possible values are<ul>
     * <li>HBCI_SYNC_SYSTEMID
     *  to sync the system id</li>
     * <li>HBCI_SYNC_MSGNUMBER
     *  to sync the msg number (not used for now)</li>
     * <li>HBCI_SYNC_SIGNATUREID
     *  to sync the signature id (not used for now)</li>
     * </ul>For now only the first is supported.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    OutboxJobSynchronize(const API *api,
                         Pointer<Customer> c,
                         int syncwhat);
    ~OutboxJobSynchronize();

    bool createHBCIJobs(Pointer<MessageQueue> mbox, int n=0);
    bool evaluate();
    bool commit(int msgNumber=HBCI_COMMIT_WHOLE_JOB);
    string description() const { return "Synchronisation";};
    list<int> resultCodes() const;

    /**
     * This is a job which handles dialog initialization end closing itself.
     * @author Martin Preuss<martin@libchipcard.de>
     */
    bool isDialogJob() const { return true;};

 protected:
    /**
     * This job creates two messages (open/sync and close dialog)
     * @author Martin Preuss<martin@libchipcard.de>
     */
    int messages() const { return 2;};
};

} /* namespace HBCI */
/** @ingroup HBCI_OutboxJobg */
typedef struct HBCI::OutboxJobSynchronize HBCI_OutboxJobSynchronize;

#else /* __cplusplus */
typedef struct HBCI_OutboxJobSynchronize HBCI_OutboxJobSynchronize;
#endif /* __cplusplus */


#ifdef __cplusplus

namespace HBCI {

/**
 * This job gets the system id to synchronize it.
 * @short Job that gets the system id to synchronize it
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DLLIMPORT OutboxJobGetSystemId: public OutboxJobSynchronize {
public:
    OutboxJobGetSystemId(const API *api, Pointer<Customer> c);
    ~OutboxJobGetSystemId();

    string description() const { return "Get SystemId";};
    JobProgressType type() const { return JOB_GET_SYSTEMID; };
};

} /* namespace HBCI */
/** @ingroup HBCI_OutboxJobg */
typedef struct HBCI::OutboxJobGetSystemId HBCI_OutboxJobGetSystemId;

extern "C" {
#else /* __cplusplus */
    typedef struct HBCI_OutboxJobGetSystemId HBCI_OutboxJobGetSystemId;
#endif /* __cplusplus */
    /** @name HBCI_OutboxJobGetSystemId 
     * @ingroup HBCI_OutboxJobg
     * 
     * @short This job gets the system id. */
    /*@{*/
    /** Constructor */
    extern HBCI_OutboxJobGetSystemId *HBCI_OutboxJobGetSystemId_new(const HBCI_API *api, HBCI_Customer *c);
    /** Upcast */
    extern HBCI_OutboxJob *HBCI_OutboxJobGetSystemId_OutboxJob(HBCI_OutboxJobGetSystemId *j);
    /*@}*/
#ifdef __cplusplus
}
#endif /* __cplusplus */



#ifdef __cplusplus
namespace HBCI {
  /**
   * This job retrieves the transactions of one account.
   * @short Job that retrieves all Transaction's of one Account
   * @author Martin Preuss<martin@libchipcard.de>
   */
class DLLIMPORT OutboxJobGetStatusReports: public OutboxJob {
  private:
    Pointer<JOBGetStatusReport> _job;
    Date _fromdate;
    Date _todate;
    int _maxentries;
    list<StatusReport> _reports;

  public:
    /**
     * This job retrieves a list of transaction statements from the server.
     * @author Martin Preuss<martin@libchipcard.de>
     * @param c Customer that invokes this job.
     * @param fromDate date of the first day you want to inspect, if invalid
     * then the first possible date will be used. Please note that some
     * banks NEED this date to be set
     * @param todate date of the last day you want to inspect, if invalid
     * then the current date will be used.
     * @param maxEntries The maximum number of entries that should be fetched.
     */
    OutboxJobGetStatusReports(Pointer<Customer> c,
			      const Date &fromDate,
			      const Date &todate,
			      int maxEntries);
    ~OutboxJobGetStatusReports();

    bool createHBCIJobs(Pointer<MessageQueue> mbox, int n=0);
    bool evaluate();
    bool stillMessagesToSend(int nextMsg) const;
    bool commit(int msgNumber=HBCI_COMMIT_WHOLE_JOB);
    string description() const;
    JobProgressType type() const { return JOB_GET_STATUS; };
    list<int> resultCodes() const;

    /**
     * @short Returns the list of status reports that this job retrieved.
     */
    const list<StatusReport> &statusReports() const { return _reports;};

  };
} /* namespace HBCI */

/** @ingroup HBCI_OutboxJobg */
typedef struct HBCI::OutboxJobGetStatusReports HBCI_OutboxJobGetStatusReports;

extern "C" {
#else /* __cplusplus */
    typedef struct HBCI_OutboxJobGetStatusReports HBCI_OutboxJobGetStatusReports;
#endif /* __cplusplus */
    /** @name HBCI_OutboxJobGetStatusReport 
     * @ingroup HBCI_OutboxJobg
     * 
     * @short This job gets the system id. */
    /*@{*/
    /** Constructor 
     * @param c Customer that invokes this job.
     * @param fromdate date of the first day you want to inspect, if invalid
     * then the first possible date will be used. Please note that some
     * banks NEED this date to be set
     * @param todate date of the last day you want to inspect, if invalid
     * then the current date will be used.
     * @param maxEntries The maximum number of entries that should be fetched.
     */
    extern HBCI_OutboxJobGetStatusReports *
    HBCI_OutboxJobGetStatusReports_new(HBCI_Customer *c,
				      const HBCI_Date *fromdate,
				      const HBCI_Date *todate,
				      int maxEntries);
    /** Upcast */
    extern HBCI_OutboxJob *
    HBCI_OutboxJobGetStatusReports_OutboxJob(HBCI_OutboxJobGetStatusReports *j);
    /**
     * @short Returns the list of status reports that this job retrieved.
     */
    extern const list_HBCI_StatusReport *
    HBCI_OutboxJobGetStatusReports_statusReports
    (const HBCI_OutboxJobGetStatusReports *j);
    /*@}*/
#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
