/* progressmonitorcb.h
    copyright   : (C) 2002 by Christian Stimming
    email       : stimming@tuhh.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROGRESSMONITORCB_H
#define PROGRESSMONITORCB_H

/** @file progressmonitorcb.h
 *
 * @short Callback-using HBCI::ProgressMonitorCB, intended to be used
 * from C wrapper @ref HBCI_ProgressMonitorCB. */

#include <openhbci/dllimport.h>
#include <openhbci/progressmonitor.h>
#include <openhbci/interactorcb.h>

/** Function that signals that a transaction has started.
 * 
 * @param type The type of transaction started.
 * @param jobs Number of jobs to be performed in this transaction.
 * @param user_data The arbitrary data given in the class constructor.
 */
typedef void (*TransStartedFuncTyp) (TransProgressType type,
				     int jobs,
				     void *user_data);
/** Function that signals that a job has started.
 *
 * @param type The type of job started.
 * @param actions Number of actions that will be performed in this job.
 * @param user_data The arbitrary data given in the class constructor.
 */
typedef void (*JobStartedFuncTyp) (JobProgressType type,
				   int actions,
				   void *user_data);
/** Function that signals that an action has started.
 *
 * @param type Type of action that has started.
 * @param user_data The arbitrary data given in the class constructor.
 */
typedef void (*ActStartedFuncTyp) (ActionProgressType type,
				   void *user_data);

#ifdef __cplusplus

namespace HBCI {

/**
 * @short Callback based implementation of ProgressMonitor.
 *
 * This is an implementation of the ProgressMonitor that has seperate
 * callbacks for each method. Those callbacks can be set
 * individually. This class is especially intended to be used through
 * its C wrappers.
 *
 * @author Christian Stimming <stimming@tuhh.de>
 */
class DLLIMPORT ProgressMonitorCB : public ProgressMonitor {
  private:
    VoidFuncTyp _destrCB;
    TransStartedFuncTyp _transStartedCB;
    VoidFuncTyp _transFinCB;
    JobStartedFuncTyp _jobStartedCB;
    VoidFuncTyp _jobFinCB;
    ActStartedFuncTyp _actStartedCB;
    VoidFuncTyp _actFinCB;
    LoggingFuncTyp _logMessageCB;
    void *_user_data;
    
  public:
    /*ProgressMonitorCB(void *user_data);*/
    /** Constructor.
     *
     * This one takes already <i>all</i> callback functions that are
     * used throughout this class. The names show to which member
     * method they belong. 
     *
     * user_data is an arbitrary pointer that will be passed on to
     * each callback function.
     *
     * Any of the arguments is allowed to be NULL -- in that case, the
     * default implementation of the member method will be used.
     *
     * @author Christian Stimming <stimming@tuhh.de>*/
    ProgressMonitorCB(VoidFuncTyp destrCB,
		      TransStartedFuncTyp transStartedCB,
		      VoidFuncTyp transFinCB,
		      JobStartedFuncTyp jobStartedCB,
		      VoidFuncTyp jobFinCB,
		      ActStartedFuncTyp actStartedCB,
		      VoidFuncTyp actFinCB,
		      LoggingFuncTyp logMessageCB,
		      void *user_data);

    ~ProgressMonitorCB();

    /*void setDestr(VoidFuncTyp destrCB)
      { _destrCB = destrCB; };*/
    
    void transactionStarted(TransProgressType type,
			    string const &descr, 
			    int jobs);
/*     void setTransStarted(TransStartedFuncTyp transStartedCB) */
/* 	{ _transStartedCB = transStartedCB; }; */
	    
    void transactionFinished();
/*     void setTransFin(VoidFuncTyp transFinCB) */
/* 	{ _transFinCB = transFinCB; }; */
        
    void jobStarted(JobProgressType type,
		    const string &descr, 
		    int actions);
/*     void setJobStarted(JobStartedFuncTyp jobStartedCB) */
/* 	{ _jobStartedCB = jobStartedCB; }; */

    void jobFinished();
    /*    void setJobFin(VoidFuncTyp jobFinCB)*/
    /*	{ _jobFinCB = jobFinCB; };*/

    void actionStarted(ActionProgressType type,
		       const string &descr);
/*     void setActStarted(ActStartedFuncTyp actStartedCB) */
/* 	{ _actStartedCB = actStartedCB; }; */

    void actionFinished();
/*     void setActFin(VoidFuncTyp actFinCB) */
/* 	{ _actFinCB = actFinCB; }; */

    void logMessage(const string &msg);
/*     void setLogMessage(LoggingFuncTyp logMessageCB) */
/* 	{ _logMessageCB = logMessageCB; }; */
};

} /* namespace HBCI */
typedef struct HBCI::ProgressMonitorCB HBCI_ProgressMonitorCB;

extern "C" {
#else /* __cplusplus */
typedef struct HBCI_ProgressMonitorCB HBCI_ProgressMonitorCB;
#endif /* __cplusplus */
    /** Constructor */
/*     extern HBCI_ProgressMonitorCB * */
/*     HBCI_ProgressMonitorCB_new(void *user_data); */
    extern HBCI_ProgressMonitorCB *
    HBCI_ProgressMonitorCB_new(VoidFuncTyp destrCB,
			       TransStartedFuncTyp transStartedCB,
			       VoidFuncTyp transFinCB,
			       JobStartedFuncTyp jobStartedCB,
			       VoidFuncTyp jobFinCB,
			       ActStartedFuncTyp actStartedCB,
			       VoidFuncTyp actFinCB,
			       LoggingFuncTyp logMessageCB,
			       void *user_data);
    /** Upcast */
    extern HBCI_ProgressMonitor *
    HBCI_ProgressMonitorCB_ProgressMonitor(HBCI_ProgressMonitorCB *p);
    
    /*extern void 
    HBCI_ProgressMonitorCB_setDestr(HBCI_ProgressMonitorCB *p, 
				    VoidFuncTyp destrCB);
    extern void 
    HBCI_ProgressMonitorCB_setTransStarted(HBCI_ProgressMonitorCB *p, 
					   TransStartedFuncTyp transStartedCB);
    extern void 
    HBCI_ProgressMonitorCB_setTransFin(HBCI_ProgressMonitorCB *p, 
				       VoidFuncTyp transFinCB);
    extern void 
    HBCI_ProgressMonitorCB_setJobStarted(HBCI_ProgressMonitorCB *p, 
					 JobStartedFuncTyp jobStartedCB);
    extern void 
    HBCI_ProgressMonitorCB_setJobFin(HBCI_ProgressMonitorCB *p, 
				     VoidFuncTyp jobFinCB);
    extern void 
    HBCI_ProgressMonitorCB_setActStarted(HBCI_ProgressMonitorCB *p, 
					 ActStartedFuncTyp actStartedCB);
    extern void 
    HBCI_ProgressMonitorCB_setActFin(HBCI_ProgressMonitorCB *p, 
				     VoidFuncTyp actFinCB);
    extern void 
    HBCI_ProgressMonitorCB_setLogMessage(HBCI_ProgressMonitorCB *p, 
    LoggingFuncTyp logMessageCB);*/
    

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif
