#ifndef __INCLUDED_PHIDGETS_H__
#define __INCLUDED_PHIDGETS_H__

#include <stdio.h>
#include <hid.h>

#ifdef HAVE_STDBOOL_H
#  include <stdbool.h>
#else
#  define bool  _Bool
#  define true  1
#  define false 0
#endif

#include <phidgets/constants.h>

typedef enum phidget_return {
  PHIDGET_RET_SUCCESS = 0,
  PHIDGET_RET_INVALID_PARAMETER,
  PHIDGET_RET_ALREADY_INITIALISED,
  PHIDGET_RET_NOT_INITIALISED,
  PHIDGET_RET_HID_ERROR,
  PHIDGET_RET_DEVICE_ALREADY_OPENED,
  PHIDGET_RET_DEVICE_NOT_OPENED,
  PHIDGET_RET_TIMEOUT
} phidget_return;

typedef struct Phidget_t {
  HIDInterface* hid_iface;
  hid_return hid_error;
  char id[32];
} Phidget;

typedef enum PhidgetDebugLevel_t {
  PHIDGET_DEBUG_NONE = 0x0,
  PHIDGET_DEBUG_ERRORS = 0x1,
  PHIDGET_DEBUG_WARNINGS = 0x2,
  PHIDGET_DEBUG_NOTICES = 0x4,
  PHIDGET_DEBUG_TRACES = 0x8,
  PHIDGET_DEBUG_ASSERTS = 0x10,
  PHIDGET_DEBUG_NOTRACES = PHIDGET_DEBUG_ERRORS | PHIDGET_DEBUG_WARNINGS | PHIDGET_DEBUG_NOTICES | PHIDGET_DEBUG_ASSERTS,
  PHIDGET_DEBUG_ALL = PHIDGET_DEBUG_ERRORS | PHIDGET_DEBUG_WARNINGS | PHIDGET_DEBUG_NOTICES | PHIDGET_DEBUG_TRACES | PHIDGET_DEBUG_ASSERTS
} PhidgetDebugLevel;
  
#ifdef __cplusplus
extern "C" {
#endif

void phidget_set_debug(PhidgetDebugLevel const level);

void phidget_set_debug_stream(FILE* outstream);

Phidget* phidget_new_Phidget();

void phidget_reset_Phidget(Phidget* const phid);

void phidget_delete_Phidget(Phidget** const phid);

phidget_return phidget_init();

phidget_return phidget_cleanup();

bool phidget_is_initialised();

phidget_return phidget_open(Phidget* const phid, int const interface,
    HIDInterfaceMatcher* const matcher, unsigned int serial,
    unsigned short retries);

phidget_return phidget_close(Phidget* const phid);

bool phidget_is_opened(Phidget const* const phid);

#ifdef __cplusplus
}
#endif

#endif /* __INCLUDED_PHIDGETS_H__ */

/* COPYRIGHT --
 *
 * This file is part of libphidgets, a user-space library for phidgets.
 * libphidgets is (c) 2003-2005 Martin F. Krafft <krafft@ailab.ch>
 * and distributed under the terms of the Artistic Licence.
 * See the ./COPYING file in the source tree root for more information.
 *
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
 * OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
