/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef LIBPOLYXMASS_MONOMERSPEC_H
#define LIBPOLYXMASS_MONOMERSPEC_H


#include "libpolyxmass-globals.h"



typedef struct _PxmMonomerSpec PxmMonomerSpec;


enum
  {
    ERR_MNMSPEC_NOERR,
    ERR_MNMSPEC_NO_CODE,
    ERR_MNMSPEC_NO_VECTOR_FILE,
    ERR_MNMSPEC_NO_RASTER_FILE,
    ERR_MNMSPEC_NO_VECTOR_NOR_RASTER_FILES
  };





struct _PxmMonomerSpec
{
  /* 
     Name of the monomer to which the graphic file is associated.
   */
  gchar *name;

  /* 
     Code of the monomer to which the graphic file is associated.
   */
  gchar *code;

  /* 
     Full path+name of the raster graphic file (png or jpg, for
     example),

     /usr/share/polyxmass/polchem-defs/protein/glycine.png
  */
  gchar *raster;
  
  /* 
     Full path+name of the vector graphic file (svg), like for example,

     /usr/share/polyxmass/polchem-defs/protein/glycine.svg
   */
  gchar *vector;

  /* Full path+name of the sound file that contains the vocalized
     monomer/modif name depending on the object for which this spec is
     created.
  */
  gchar *name_sound;
  
  /* Full path+name of the sound file that contains the vocalized
     monomer code.
  */
  gchar *code_sound;
};





/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmMonomerSpec *
libpolyxmass_monomerspec_new (void);

gboolean
libpolyxmass_monomerspec_set_raster (PxmMonomerSpec *ms, gchar *file);

gboolean
libpolyxmass_monomerspec_set_vector (PxmMonomerSpec *ms, gchar *file);

gboolean
libpolyxmass_monomerspec_set_name (PxmMonomerSpec *ms, gchar *name);

gboolean
libpolyxmass_monomerspec_set_code (PxmMonomerSpec *ms, gchar *code);

gboolean
libpolyxmass_monomerspec_set_action (PxmMonomerSpec *ms, gchar *action);

gboolean
libpolyxmass_monomerspec_set_name_sound (PxmMonomerSpec *ms, 
					 gchar *name);

gboolean
libpolyxmass_monomerspec_set_code_sound (PxmMonomerSpec *ms, 
					 gchar *code);






/*  LOCATING FUNCTIONS
 */
gint
libpolyxmass_monomerspec_get_index_by_code (GPtrArray *GPA, 
					    gchar *code);

gint
libpolyxmass_monomerspec_get_index_top_by_code (GPtrArray *GPA, 
						gchar *code);

gint
libpolyxmass_monomerspec_get_index_bottom_by_code (GPtrArray *GPA, 
						   gchar *code);

PxmMonomerSpec *
libpolyxmass_monomerspec_get_ptr_by_code (GPtrArray *GPA, gchar *code);


PxmMonomerSpec *
libpolyxmass_monomerspec_get_ptr_top_by_code (GPtrArray *GPA, gchar *code);


PxmMonomerSpec *
libpolyxmass_monomerspec_get_ptr_bottom_by_code (GPtrArray *GPA, 
						 gchar *code);





/* UTILITY FUNCTIONS
 */
gboolean
libpolyxmass_monomerspec_reset (PxmMonomerSpec *ms);

/* 
   The monicons.dic file.
*/
PxmMonomerSpec *
libpolyxmass_monomerspec_init_from_monicons_dic_line (gchar *line, 
						      gchar *dir);


gint
libpolyxmass_monomerspec_parse_monicons_dic_file (gchar *file,
						  GPtrArray *GPA);

/* 
   The sounds/sounds.dic file.
*/
PxmMonomerSpec *
libpolyxmass_monomerspec_init_from_sounds_dic_line (gchar *line, 
						    gchar *dir);


gint
libpolyxmass_monomerspec_parse_sounds_dic_file (gchar *file,
						GPtrArray *GPA);




/* FREE'ING FUNCTIONS
 */
gint
libpolyxmass_monomerspec_free (PxmMonomerSpec *ms);





/* GPtrArray-RELATED FUNCTIONS
 */
gint
libpolyxmass_monomerspec_GPA_empty (GPtrArray *GPA);

gint
libpolyxmass_monomerspec_GPA_free (GPtrArray *GPA);
















#endif
/*
  #ifndef LIBPOLYXMASS_MONOMERSPEC_H
*/



