/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "libpolyxmass-userspec.h"
#include "libpolyxmass-prop.h"



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */

PxmUserSpec *
libpolyxmass_userspec_new (void)
{
  PxmUserSpec *userspec = NULL;
  
  userspec = g_malloc0 (sizeof (PxmUserSpec));

  userspec->propGPA = g_ptr_array_new ();
  
  return userspec;
}


PxmUserSpec *
libpolyxmass_userspec_dup (PxmUserSpec *userspec, gint how_dup)
{
  PxmUserSpec *userspec_new = NULL;
  PxmUserSpecDup how = (PxmUserSpecDup) how_dup;
  
  g_assert (userspec != NULL);
  
  userspec_new = libpolyxmass_userspec_new ();

  if (userspec->username != NULL)
    userspec_new->username =  g_strdup (userspec->username);

  if (userspec->configdir != NULL)
    userspec_new->configdir = g_strdup (userspec->configdir);

  if (userspec->gladedir != NULL)
    userspec_new->gladedir = g_strdup (userspec->gladedir);

  if (userspec->workdir != NULL)
    userspec_new->workdir = g_strdup (userspec->workdir);
  
  if (userspec->datadir != NULL)
    userspec_new->datadir = g_strdup (userspec->datadir);
  
  if (how == PXM_USERSPEC_DUP_DEEP_YES)
    {
      if (userspec->propGPA != NULL)
	userspec_new->propGPA = 
	  libpolyxmass_prop_GPA_dup (userspec->propGPA,
				     how);
    }
  
  return userspec_new;
}


gboolean
libpolyxmass_userspec_set_username (PxmUserSpec *userspec, gchar *username)
{
  g_assert (userspec != NULL);
  g_assert (username != NULL);
  
  if (userspec->username != NULL)
    g_free (userspec->username);
  
  userspec->username = g_strdup (username);
  
  return TRUE;
}


gchar *
libpolyxmass_userspec_get_username (PxmUserSpec *userspec)
{
  g_assert (userspec != NULL);

  /* Sanity check.
   */
  g_assert (userspec->username != NULL);
 
  return userspec->username;
}


gboolean
libpolyxmass_userspec_set_configdir (PxmUserSpec *userspec, gchar *dir)
{
  g_assert (userspec != NULL);
  g_assert (dir != NULL);
  
  if (userspec->configdir != NULL)
    g_free (userspec->configdir);
  
  userspec->configdir = g_strdup (dir);
  
  return TRUE;
}


gchar *
libpolyxmass_userspec_get_configdir (PxmUserSpec *userspec)
{
  g_assert (userspec != NULL);

  /* Sanity check.
   */
  g_assert (userspec->configdir != NULL);
 
  return userspec->configdir;
}


gboolean
libpolyxmass_userspec_set_gladedir (PxmUserSpec *userspec, gchar *dir)
{
  g_assert (userspec != NULL);
  g_assert (dir != NULL);
  
  if (userspec->gladedir != NULL)
    g_free (userspec->gladedir);
  
  userspec->gladedir = g_strdup (dir);
  
  return TRUE;
}


gchar *
libpolyxmass_userspec_get_gladedir (PxmUserSpec *userspec)
{
  g_assert (userspec != NULL);

  /* Sanity check.
   */
  g_assert (userspec->gladedir != NULL);
 
  return userspec->gladedir;
}


gboolean
libpolyxmass_userspec_set_workdir (PxmUserSpec *userspec, gchar *dir)
{
  g_assert (userspec != NULL);
  g_assert (dir != NULL);
  
  if (userspec->workdir != NULL)
    g_free (userspec->workdir);
  
  userspec->workdir = g_strdup (dir);
  
  return TRUE;
}


gchar *
libpolyxmass_userspec_get_workdir (PxmUserSpec *userspec)
{
  g_assert (userspec != NULL);

  /* Sanity check.
   */
  g_assert (userspec->workdir != NULL);
 
  return userspec->workdir;
}


gboolean
libpolyxmass_userspec_set_datadir (PxmUserSpec *userspec, gchar *dir)
{
  g_assert (userspec != NULL);
  g_assert (dir != NULL);
  
  if (userspec->datadir != NULL)
    g_free (userspec->datadir);
  
  userspec->datadir = g_strdup (dir);
  
  return TRUE;
}


gchar *
libpolyxmass_userspec_get_datadir (PxmUserSpec *userspec)
{
  g_assert (userspec != NULL);

  /* Sanity check.
   */
  g_assert (userspec->datadir != NULL);
 
  return userspec->datadir;
}





/* UTILITY FUNCTIONS
 */




/* FREE'ING FUNCTIONS
 */
gboolean
libpolyxmass_userspec_free (PxmUserSpec *userspec)
{
  g_assert (userspec != NULL);
  
  /* Free inner material first.
   */
  if (userspec->propGPA != NULL)
    libpolyxmass_prop_GPA_free (userspec->propGPA);

  if (userspec->username != NULL)
  g_free (userspec->username);
  
  if (userspec->configdir != NULL)
    g_free (userspec->configdir);
  
  if (userspec->gladedir != NULL)
    g_free (userspec->gladedir);
  
  if (userspec->workdir != NULL)
    g_free (userspec->workdir);
  
  if (userspec->datadir != NULL)
    g_free (userspec->datadir);
  
  g_free (userspec);
  
  return TRUE;
}


