/*
  imho_spannish.pike v0.1 for IMHO v0.95.2
  
  Copyright  
  Manuel J. Galan Moreno <manolow@step.es> 1999
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.


*/

// Messages
//
//login
#define M_LOGIN 1
#define M_PASSWORD 2
#define M_NOLOGIN 3
#define M_IMAPERROR 10
// page header
#define M_NEWMAIL 50
#define M_MAILBOX 51
#define M_MAILBOXES 52
#define M_FILES 53
#define M_PREFS 54
#define M_LOGOUT 55
// compose
#define M_SEND 100
#define M_CANCELSEND 101
#define M_SENDMOREFILES 102
#define M_COMPOSEMAIL 103
#define M_SPELLCHECK 104
#define M_DONTSAVEMAIL 105
#define M_ADDFILEASATTACHMENT 106
#define M_NOATTACHMENTS 107
#define M_ADDATTACHMENT 108
#define M_REMOVEMARKEDATTACHMENTS 109
#define M_UPLOADATTACHMENT 110
#define M_ADDMARKEDTOATTACHMENTS 111
#define M_UPLOADTOATTACHMENTS 112
#define M_BACKTOCOMPOSE 113
#define M_NOATTACHFILES 114
#define M_ATTACHMENTSHEADER 115
// mailindex
#define M_DELETEMARKED 200
#define M_MOVEMARKED 201
#define M_SELECTMBOX 202
#define M_CHECKNEWMAIL 203
#define M_MAILSHOWN 204
#define M_BACKN 205
#define M_FORWARDN 206
#define M_NUMBER 207
#define M_DELETEMARKEDP 208
#define M_DELETEMARKEDNONE 209
#define M_CHANGESORTORDER 210
#define M_MOVETOTRASH 211
#define M_DELETEALLTRASH 212
#define M_NOMAILS 213
// mailboxlist
#define M_MBOXNAME 300
#define M_DELETEMARKEDMBOX 301
#define M_CREATEMBOX 302
#define M_NEWMBOXNAME 303
#define M_MBOXREMOVEP 350
#define M_MBOXMARKONE 351
#define M_NEWMBOXNONAME 352
#define M_CREATEMBOXERROR 353
// files
#define M_FILENAME 400
#define M_SIZE 401
#define M_MIMETYPE 402
#define M_DELETEMARKEDFILES 403
#define M_UPLOAD 404
#define M_AVAILSPACE 405
#define M_WINDOWSBUG 406
#define M_NOFILES 407
// preferences
#define M_PNAME 500
#define M_PMAILADDRESS 501
#define M_PMAILPATH 502
#define M_PINCLUDEMAIL 503
#define M_PQUOTEPREFIX 504
#define M_PSIGNATURE 505
#define M_PINACTIVELOGOUT 506
#define M_PSAVEANDUSE 550
#define M_PVISIBLEMESSAGES 507
#define M_PSORTORDER 508
#define M_PSORTORDERS 509
#define M_PTRASHFOLDER 510
#define M_PSENTFOLDER 511
#define M_PDEFAULTBCC 512
#define M_PSAVEATTACHMENTS 513
#define M_PLANGUAGE 514
// logout
#define M_LOGOUTMSG 600
#define M_LOGGEDOUT 601
// dialog
#define M_QUESTION 700
#define M_INFO 701
// readmail
#define M_REPLY 800
#define M_READPREV 801
#define M_READNEXT 802
#define M_ATTACHMENTLINK 803
#define M_MAILMISSING 804
#define M_MAILMISSINGBACK 805
#define M_DELETE 806
#define M_FORWARD 807
//spellcheck
#define M_SPELLDONE 900
#define M_SPELLPREV 901
#define M_SPELLNEXT 902
#define M_SPELLCHANGETO 903
#define M_SPELLSUGGESTIONS 904
// mailheaders
#define M_FROM 1000
#define M_TO 1001
#define M_CC 1002
#define M_BCC 1003
#define M_SUBJECT 1004
#define M_ATTACHMENTS 1005
#define M_TIME 1006
#define M_DATE 1007
// table heads
#define M_MARKFLAG 1100
#define M_NEWFLAG 1101
#define M_ANSWEREDFLAG 1102
// address book
#define M_ADDRESSBOOKTITLE 1200
#define M_ADDRESSBOOK 1201
#define M_INDEXNAMERECIPIENT 1202
#define M_INDEXNAMEEDIT 1203
#define M_ADDRESS 1204
#define M_NOADDRESSES 1205
#define M_NEWADDRESS 1206
#define M_EDITADDRESS 1207
#define M_ADDADDRESS 1208
#define M_INDEXNAME 1209
#define M_ADDRESSFORMAT 1210
#define M_SAVEADDRESS 1211
#define M_DELETEADDRESS 1212
#define M_CANCELADDRESS 1213
#define M_CANNOTIMPORT 1214
#define M_IMPORTADDRESSBOOKTITLE 1215
#define M_UPLOADADDRESSBOOK 1216
#define M_PINELOCATION 1217
#define M_UPLOADANDIMPORT 1218
#define M_IMPORTADDRESSBOOK 1219
// general
#define M_YES 2000
#define M_NO 2001
#define M_DIALOGOK 2002
#define M_DIALOGCANCEL 2003

string imho_lang() {
  return "espaol";
}


string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Usuario:";
  case M_PASSWORD:
    //return "Password:";
    return "Clave:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>No se pudo acceder:</b> Nombre de usuario o clave incorrecta. Intntelo de nuevo. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Ha habido un problema en la comunicacin con el servidor IMAP. Por favor, contacte con el administrador";
    
  case M_NEWMAIL:
    //return "New mail";
    return "Nuevo correo";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Carpeta: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Carpetas";
  case M_FILES:
    //return "Files";
    return "Archivos";
  case M_PREFS:
    //return "Preferences";
    return "Preferencias";
  case M_LOGOUT:
    //return "Logout";
    return "Salir";

  case M_FROM:
    //return "From";
    return "De";
  case M_TO:
    //return "To";
    return "A";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Ccc";
  case M_SUBJECT:
    //return "Subject";
    return "Asunto";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Adjuntos";
  case M_TIME:
    //return "Time";
    return "Hora";
  case M_DATE:
    //return "Date";
    return "Fecha";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "R";
    
    
  case M_SEND:
    //return "Send";
    return "Enviar";
  case M_CANCELSEND:
    //return "Cancel";
    return "Cancelar";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Seleccione los archivos a enviar. Pulse 'Ctrl' para (des)selecionar varios archivos.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Componer mensaje";
  case M_SPELLCHECK:
    return "Ortografa";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "No guardar este mensaje.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Aadir fichero como adjunto";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Sin adjuntos";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Aadir adjunto...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Eliminar adjuntos marcados";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Cargar (upload) adjunto";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Aadir los marcados a adjuntos";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Cargar (upload) a adjuntos";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Volver a Composicin de mensajes";
  case M_NOATTACHFILES:
    //return "No files";
    return "No hay ficheros";
  case  M_ATTACHMENTSHEADER:
    //return "Attachments";
    return "Adjuntos";
    
  case M_DELETEMARKED:
    //return "Delete marked";
    return "Borrar marcados";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Mover marcados a";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Seleccione carpeta)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Comprobar nuevo correo";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Mensaje %d-%d de %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Anteriores %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Siguientes %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("Est Vd. seguro de que desea eliminar los %d mensajes marcados?", 
	      @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Por favor, marque algunos mensajes primero.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Cambiar la ordenacin";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Mover mensajes marcados a la Papelera";
  case M_DELETEALLTRASH:
    //return "Delete all Trash";
    return "Vaciar la Papelera";
  case M_NOMAILS:
    // return "[No mails]";
    return "[No hay mensajes]";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Carpeta";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Borrar marcados";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Crear una nueva carpeta";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Nombre)";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Est Vd. seguro de que desea eliminar las siguientes carpetas?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Marque al menos una carpeta.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Teclee un nombre primero.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Fallo en la creacin de carpeta. Motivos: nombre ilegal o carpeta ya existente.";
	
  case M_FILENAME:
    //return "Filename";
    return "Fichero";
  case M_SIZE:
    //return "Size";
    return "Tamao";
  case M_MIMETYPE:
    //return "Type";
    return "Tipo";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Borrar marcados";
  case M_UPLOAD:
    //return "Upload";
    return "Cargar (upload)";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Vd. tiene %d Kbytes disponibles para cargar (upload).",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Atencin usuarios de Windows: Debido a un error en algunos visualizadores WEB, los nombres de fichero pueden aparecer recortados. Para evitarlo, puede sustituir el ltimo '\\' por '\\\\' antes de pulsar 'Cargar (upload)'.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Vd. no tiene ficheros cargados (upload).";

  case M_PNAME:
    //return "Name";
    return "Nombre";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "Direccin electrnica";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Directorio de Correo";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Incluir mensaje en respuestas";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefijo";
  case M_PSIGNATURE:
    //return "Signature";
    return "Firma";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Cierre por inactividad (minutos)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Grabar y utilizar";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Mensajes mostrados en carpeta";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Ordenacin de mensajes";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "forward": "adelante", "backward":"atrs"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Papelera";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "carpeta de mensajes enviados";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Direccin Ccc por defecto";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Guardar Adjuntos";
  case M_PLANGUAGE:
    //return "Language";
    return "Idioma";

  case M_SPELLDONE:
    //return "Done";
    return "Hecho";
  case M_SPELLPREV:
    //return "Previous";
    return "Anterior";
  case M_SPELLNEXT:
    //return "Next";
    return "Siguiente";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "Cambiar a";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Sugerencias";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mails.<br><br>Reload this page to login.";
    return "Vd. ha sido despedido del sistema. Cierre esta ventana para asegurarse de que nadie podr leer sus mensajes.<br><br>Recargue esta pgina para volver a acceder a su correo.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Despedido (logged out)";

  case M_QUESTION:
    //return "Question"; 
    return "Preguntas";
  case M_INFO:
    //return "Info"; 
    return "Informacin";

  case M_REPLY:
    //return "Reply";
    return "Responder";
  case M_READPREV:
    //return "Read previous";
    return "Leer previo";
  case M_READNEXT:
    //return "Read next";
    return "Leer siguiente";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sadjuntos del tipo %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Error:</b> Fallo al acceder a su correo. Intntelo de nuevo.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Atrs";
  case M_DELETE:
    //return "Delete";
    return "Borrar";
  case M_FORWARD:
    //return "Forward";
    return "Reenviar";

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Libro de Direcciones");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Libro de direcciones...");
  case M_INDEXNAMERECIPIENT:
    //return("Index name (click to add as recipient)");
    return("Nombre de ndice (pulse para aadir como destinatario)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Nombre de ndice (pulse para editar)");
  case M_ADDRESS:
    //return("Address");
    return("Direccin");
  case M_NOADDRESSES:
    //return("No addresses");
    return("No hay direcciones");
  case M_NEWADDRESS:
    //return("New address...");
    return("Nueva direccin...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Editar direccin");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Aadir al Libro de Direcciones");
  case M_INDEXNAME:
    //return("Index name");
    return("Nombre de ndice");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Direccin(es), separadas por comas");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Grabar y Utilizar");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Borrar direccin");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Cancelar");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("No se puede importar este Libro de Direcciones, ya que\nsu formato es desconocido.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Importar Libro de Direcciones");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Cargar un Libro de Direcciones en formato Pine o Netscape (.ldif)");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("El Libro de Direcciones bajo Pine suele estar en ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Cargar e Importar");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Importar Libro de Direcciones...");

  case M_YES:
    //return "Yes";
    return "Si";
  case M_NO:
    //return "No";
    return "No";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Cancelar";
   
  }
  return 0;
}





