/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* This module contains data structures and functions related to the generation
 * of the allomorph lexicon. */

/* Variables. ===============================================================*/

extern int_t lex_entry_line_number; 
/* Line number of lexical entry just parsed. Read only! */

extern string_t lex_entry_file_name;
/* Name of lexicon file just parsed. Read only! */

extern rule_sys_t *allo_rule_sys; /* Read only! */

/* Functions. ===============================================================*/

extern void write_lex_tree( string_t file_name );
/* Write lexicon tree to file FILE_NAME. */

extern void write_prelex_file( string_t file_name );
/* Write lexicon tree to prelex file FILE_NAME. */

extern void print_lex_tree( FILE *stream, string_t allo_format );
/* Print all lexicon entries to STREAM using format ALLO_FORMAT.
 * If ALLO_FORMAT == NULL, do line breaking. */

extern void print_lex_statistics( FILE *stream );
/* Print statistics about lexicon buffer into STREAM. */

extern void generate_allos_for_file( string_t source_name,
				     string_t prelex_name,
				     bool_t use_filter );
/* Parse a lexicon file SOURCE_NAME and a precompiled lexicon file PRELEX_NAME.
 * Generate allomorphs. Write allomorphs into lexicon buffer.
 * Don't use the output filter if USE_FILTER == FALSE. */

extern void generate_allos_for_line( string_t lexicon_name, int_t line );
/* Read line LINE in lexicon file LEXICON_NAME and generate allomorphs.
 * Write allomorphs into lexicon buffer. */

extern void generate_allos_for_string( string_t fs_string );
/* Generate allomorphs from FS_STRING, which should contain a readable feature
 * structure.  Write allomorphs into lexicon buffer. */

extern void read_lex_constants( string_t lexicon_name );
/* Read all constants in file LEXICON_NAME. */

extern void init_lex_compiler( string_t allo_rule_file );
/* Initialise the lex_compiler module.
 * Use allomorph rules from ALLO_RULE_FILE. */

extern void terminate_lex_compiler( void );
/* Free the lex_compiler module. */

/* End of file. =============================================================*/
