/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/* HACKED UP VERSION -- adapted from the ppm gui */
/* a widget to draw a ruler next to a GtkVScale widget on mixer channels */

#include <stdio.h>
#include <gtk/gtk.h>
#include "ruler_hack.h"

/* static GtkDrawingAreaClass *parent_class; */


void gtk_ppmscale_set_db_cutoff(GtkWidget* w, int new_cutoff)
{
    GtkPpmscale *scale = GTK_PPMSCALE(w);
    scale->db_cutoff = new_cutoff;
}


static gboolean
draw_stereo(GtkWidget *widget, GdkEventExpose *event)
{
    return TRUE;
}


static gboolean
draw_mono(GtkWidget *widget, GdkEventExpose *event)
{    
    GtkPpmscale *scale = GTK_PPMSCALE(widget);
    GdkColor white, black;
    int i, tmp, tmp2;
    char strg[5];
    int tw, th;
    int db_cutoff;
    static GdkFont *font;

    db_cutoff = scale->db_cutoff;

    if( !scale->leave_colors_hack )
    {
        white.pixel= ~0;
        white.red   = 65535;
        white.green = 65535;
        white.blue  = 65535;
        
        
        black.pixel = 0;
        black.red   = 0;
        black.green = 0;
        black.blue  = 0;
        
        gdk_window_clear_area (widget->window,
                               event->area.x, event->area.y,
                               event->area.width, event->area.height);
        
        gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
                                   &event->area);
        
        gdk_gc_set_foreground ( widget->style->fg_gc[widget->state], &black );
        gdk_draw_rectangle( widget->window,
                            widget->style->fg_gc[widget->state],
                            TRUE, 0, 0,
                            widget->allocation.width, widget->allocation.height
            );
        gdk_gc_set_foreground ( widget->style->fg_gc[widget->state], &white );
    }
    

    tmp = widget->allocation.height;
    tmp -= 18+19;
    tmp2= widget->allocation.width / 3;



    /* draw the thing */
    if ( !font )
    {
        font = gdk_fontset_load( REG_FONT );
    }

    th = gdk_char_height(font, '0');

    th /= 2;
    for ( i=0; i<=db_cutoff; i=i+10 )
    {
        gdk_draw_line ( widget->window, widget->style->fg_gc[GTK_STATE_NORMAL],
                        widget->allocation.width-tmp2-1, 18+(i*tmp)/db_cutoff,
                        widget->allocation.width-1, 18+(i*tmp)/db_cutoff );

        sprintf(strg, "%d", 100-i);
        tw = gdk_string_width(font, strg);
        gdk_draw_string( widget->window, font,
                         widget->style->fg_gc[GTK_STATE_NORMAL],
                         12-tw,
                         18+(i*tmp)/db_cutoff+th, strg );
    }
    


    
        
    if( !scale->leave_colors_hack )
    {
        gdk_gc_set_foreground ( widget->style->fg_gc[widget->state], &black );
    }
    
    gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state], 
                               NULL);
    
    return TRUE;
}

static gboolean
gtk_ppmscale_expose(GtkWidget *widget, GdkEventExpose *event)
{
    GtkPpmscale *scale;
    scale = GTK_PPMSCALE(widget);

    if (scale->ismono){
        draw_mono(widget, event);
    }
    else {
        draw_stereo(widget, event);
    }

    return TRUE;
}




static void
gtk_ppmscale_class_init (GtkPpmscaleClass *klass)
{
    GtkWidgetClass *widget_class;
    widget_class = (GtkWidgetClass*) klass;
    
    widget_class->expose_event = gtk_ppmscale_expose;
}


static void
gtk_ppmscale_init(GtkPpmscale *ppmscale)
{
    gtk_drawing_area_size ( GTK_DRAWING_AREA(ppmscale),
                            23, 20); /* need the width here bc it
                                        won't resize in a container...
                                        height unimportant */
}


guint
gtk_ppmscale_get_type()
{
  static guint mytype = 0;

  if (!mytype)
    {
      GtkTypeInfo lh_info =
      {
	"GtkPpmscale",
	sizeof(GtkPpmscale),
	sizeof(GtkPpmscaleClass),
	(GtkClassInitFunc) gtk_ppmscale_class_init,
        (GtkObjectInitFunc) gtk_ppmscale_init,
	 NULL,
	 NULL
      };

      mytype = gtk_type_unique (gtk_drawing_area_get_type(), &lh_info);
    }

  return mytype;
}

GtkWidget*
gtk_ppmscale_new(int db_cutoff, int opts)
{
/*     GtkRcStyle *rc_style; */
/*     GdkColor bgcolor, fgcolor; */
    
    GtkPpmscale *s = gtk_type_new (gtk_ppmscale_get_type ());

  if (opts == GTK_PPMSCALE_STEREO)
  {
      s->ismono = 0;
  }
  else 
  {
      s->ismono = 1;
  }

  s->db_cutoff = db_cutoff;

  /* HACK */
  if( opts==3 )
      s->leave_colors_hack = 1;
  else
      s->leave_colors_hack = 0;

  return GTK_WIDGET (s);
}
