/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: posix_signal_handler.c,v 1.1 2003/06/30 02:15:59 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include "signal_handler.h"
#include "mas/mas_common.h"

int mas_sig_shutdown = 0;
int mas_sig_numraised = 0;
int mas_sig_stack[128];

/* These are for systems capable of using ANSI signals. */

static void
_shutdown_signal_handler ( int signum )
{
    masc_log_message(MAS_VERBLVL_WARNING, "*** caught shutdown signal %d ***", signum);
    
    /* The "kill" signals handled by this function are special.  Raise
       "mas_sig_shutdown" if they occur. */
    mas_sig_shutdown = 1;
}

static void
_signal_handler( int signum )
{
    int numraised = mas_sig_numraised++;

    /* This really shouldn't happen. */
    if ( numraised >= sizeof mas_sig_stack )
    {
        masc_log_message(MAS_VERBLVL_WARNING, "*** ignoring signal %d!  there are %d signals on the signal stack! ***", signum, numraised );
        mas_sig_numraised--;
        return;
    }

    /* push the signal onto the signal stack */
    mas_sig_stack[numraised] = signum;
    
    masc_log_message(MAS_VERBLVL_WARNING, "*** caught signal %d ***", signum);
}

int
install_shutdown_signal_handlers( void )
{
    struct sigaction sa;

    memset( &sa, 0, sizeof sa );

    /* Catch all the "kill" signals */
    sa.sa_handler = _shutdown_signal_handler;
    sa.sa_flags = SA_RESTART;
    sigaction( SIGINT, &sa, NULL );
    sigaction( SIGQUIT, &sa, NULL );
    sigaction( SIGTERM, &sa, NULL );
    
    return 0;
}

int32
catch_signal( int signum, int handle )
{
    struct sigaction sa;

    memset( &sa, 0, sizeof sa );

    switch ( handle )
    {
    case MAS_SIGHNDL_IGNORE:
        sa.sa_handler = SIG_IGN;
        if ( sigaction( signum, &sa, NULL ) < 0 )
            return mas_error(MERR_INVALID);
        break;
    case MAS_SIGHNDL_DEFAULT:
        sa.sa_handler = SIG_DFL;
        if ( sigaction( signum, &sa, NULL ) < 0 )
            return mas_error(MERR_INVALID);
        break;
    case MAS_SIGHNDL_SHUTDOWN:
        sa.sa_handler = _shutdown_signal_handler;
	sa.sa_flags = SA_RESTART;
        if ( sigaction( signum, &sa, NULL ) < 0 )
            return mas_error(MERR_INVALID);
        break;
    case MAS_SIGHNDL_MAS:
    default:
        sa.sa_handler = _signal_handler;
	sa.sa_flags = SA_RESTART;
        if ( sigaction( signum, &sa, NULL ) < 0 )
            return mas_error(MERR_INVALID);
        break;
    }

    return 0;
}
