/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mrect.cpp,v 1.1 2000/10/09 17:55:51 jeh Exp $
 */
#define _MATH3D_EXPORT
#include <math3d/mrect.h>


/*!
 *
 */
Math3d::MRect::MRect()
{
  d_x=d_y=d_w=d_h=0;
}


/*!
 *
 */
Math3d::MRect::MRect(double x, double y, double w, double h)
{
  d_x=x;
  d_y=y;
  d_w=w;
  d_h=h;
}


/*!
 *
 */
Math3d::MRect::MRect(double v[4])
{
  d_x=v[0];
  d_y=v[1];
  d_w=v[2];
  d_h=v[3];
}


/*!
 *
 */
void 
Math3d::MRect::setRect(double x, double y, double w, double h)
{
  d_x=x;
  d_y=y;
  d_w=w;
  d_h=w;
}


/*!
 *
 */
void 
Math3d::MRect::setPos(double x, double y)
{
  d_x=x;
  d_y=y;
}


/*!
 *
 */
void 
Math3d::MRect::setSize(double w, double h)
{
  d_w=w;
  d_h=h;
}


/*!
 *
 */
void 
Math3d::MRect::setCoord(double x1, double y1, double x2, double y2)
{
  d_x=x1;
  d_y=y1;
  d_w=x2-x1;
  d_h=y2-y1;
}







