/*


 ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


 */
package com.sap.dbtech.jdbc.translators;

import java.sql.SQLException;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp00.LongDesc;

/**
 * 'Putval' base class for procedures.
 */
public abstract class AbstractProcedurePutval {

    public static final short STREAM_RESET = -2;	
    
	private DBTechTranslator translator; 
	private StructuredBytes  descriptor;
	private StructuredMem    descriptorMark;
	
	public AbstractProcedurePutval(DBTechTranslator translator)
	{	    
		this.translator = translator;
		this.descriptor = new StructuredBytes(LongDesc.Size_C);
		this.descriptor.putInt1(LongDesc.StateStream_C, LongDesc.State_O);
		this.descriptor.putInt1(LongDesc.LastPutval_C, LongDesc.Valmode_O);
		
	}

    public void updateIndex(int index)
    {
        this.descriptorMark.putInt2 (index, LongDesc.Valind_O);        
    }

    public void putDescriptor(StructuredMem memory)
    {
		memory.putInt1 (0, translator.bufpos - 1);
		memory.putBytes(descriptor.bytes(), translator.bufpos);
		this.descriptorMark = memory.getPointer(translator.bufpos);       
    }

    public abstract void transferStream(DataPart dataPart, short rowCount)
    	throws SQLException;

}
