/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.sql.Connection;
import java.sql.SQLException;

import javax.transaction.xa.Xid;

/**
 * This class bundles together the data that is needed to capture
 * on a transaction.
 */
class XATransaction
{
    public static final int STATUS_STARTED              = 0;
    public static final int STATUS_PREPARED             = 3;
    public static final int STATUS_COMMITTED            = 1;
    public static final int STATUS_ROLLED_BACK          = 2;
    
    Xid         xid;
    Connection  physicalConnection;
    int         status;
    long        timeOutTime;
    
    public XATransaction(Xid xid, Connection physicalConnection, long timeOutTime)
    {
        this.xid=xid;
        this.physicalConnection=physicalConnection;
        this.timeOutTime=timeOutTime;
        this.status=STATUS_STARTED;
    }

    public String toString()
    {
        return "xid =" + xid.toString() + " status="  + status;
    }

    public int getStatus()
    {
        return this.status;
    }
    
    public void setStatus(int status)
    {
        this.status=status;
    }
    

    public void commitRelease()
        throws SQLException
    {
        synchronized(this) {
            // tbd status check
            if(physicalConnection!=null) {
                physicalConnection.commit();
                physicalConnection.close();
                this.physicalConnection=null;
                this.status=STATUS_COMMITTED;
            }
        }
    }

    public void rollbackRelease()
        throws SQLException
    {
        synchronized(this) {
            // tbd status check
            if(physicalConnection!=null) {
                physicalConnection.rollback();
                physicalConnection.close();
                this.physicalConnection=null;
                this.status=STATUS_ROLLED_BACK;
            }
        }
    }
    
}
