# ------------------------------------------------------------------------------
#
# Pager Descriptions
#
# ------------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

#


regex(.*\.cpp$)    -except

# -------------------------------------------------------------------------------------
# Errors and messages:
# -------------------------------------------------------------------------------------

Pager_Messages.genmsg           ascii

Pager_Messages.hpp              inc=SAPDBErr_MessageList.hpp

Pager_Lock.hpp                  inc=gsp00

Pager_Lock.cpp                  inc=Pager_Lock.hpp,\
                                    hgg08.h,\
                                    heo55k.h

Pager_IRestart.hpp              inc=gsp00

Pager_ISavepoint.hpp            inc=gsp00,\
                                    ggg00,\
                                    Converter_Types.hpp,\
                                    Data_Types.hpp,\
                                    IOMan_BlockAddress.hpp,\
                                    Kernel_Common.hpp

Pager_IDump.hpp                  inc=gsp00,\
                                    Kernel_Common.hpp,\
                                    Kernel_Dump.hpp

Pager_Dump.hpp                  inc=SAPDB_Types.hpp

Pager_Controller.hpp             inc=gsp00,\
                                    ggg00,\
                                    hgg01.h,\
                                    Kernel_Common.hpp,\
                                    Container_Vector.hpp,\
                                    RTESync_NamedSpinlock.hpp,\
                                    RTESync_InterlockedCounter.hpp,\
                                    Pager_Types.hpp,\
                                    Pager_IRestart.hpp,\
                                    Pager_ISavepoint.hpp,\
                                    Pager_IDump.hpp,\
                                    Pager_Dump.hpp,\
                                    Pager_Writer.hpp


Pager_Controller.cpp             inc=Pager_Controller.hpp,\
                                    Pager_Exception.hpp,\
                                    Pager_Messages.hpp,\
                                    Pager_Lock.hpp,\
                                    RTEMem_Allocator.hpp,\
                                    Data_BasePage.hpp,\
                                    Converter_IManager.hpp,\
                                    IOMan_IDataIO.hpp,\
                                    hbd20_5.h,\
                                    hgg04.h,\
                                    gbd00,\
                                    heo00x.h,\
                                    heo56.h

Pager_Writer.hpp                inc=Kernel_Common.hpp,\
                                    ggg00,\
                                    gbd00,\
                                    hgg01.h,\
                                    RTEMem_Allocator.hpp,\
                                    IOMan_ClusterAddress.hpp,\
                                    IOMan_DataPages.hpp,\
                                    Container_Vector.hpp
                                    
Pager_Writer.cpp                inc=Pager_Writer.hpp,\
                                    Pager_Controller.hpp,\
                                    Pager_Exception.hpp,\
                                    Pager_Messages.hpp,\
                                    Pager_Types.hpp,\
                                    Kernel_IAdminRestartShutdown.hpp,\
                                    IOMan_IDataIO.hpp,\
                                    Converter_IPageIO.hpp,\
                                    FBM_IManager.hpp,\
                                    RTE_Message.hpp,\
                                    hgg04.h,\
                                    heo56.h,\
                                    hbd20_5.h

Pager_Wrapper.cpp               inc=Pager_Controller.hpp,\
                                    RTEMem_Allocator.hpp

Pager_Exception.hpp             inc=SAPDBErr_MessageList.hpp




# -------------------------------------------------------------------------------------
# Interfaces and basic types:
# -------------------------------------------------------------------------------------

Pager_Types.hpp                 inc=SAPDBTrace_Topic.hpp

&if $OSSPEC == LINUX && $MACH in [ S390X, IA64 ]
regex(\w+\.cpp) -OPT=-O2
&endif

