/*!
  \file    DBMSrvCmdSQL_SqlUpdatestatPerSystemtable.cpp
  \author  marcW
  \ingroup DBMServer commands
  \brief   

    ========== licence begin  GPL
    Copyright (C) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/

#include "DBM/Srv/Commands/SQL/DBMSrvCmdSQL_SqlUpdatestatPerSystemtable.hpp"

#include "hcn50.h"
#include "hcn80.h"

DBMSrvCmdSQL_SqlUpdatestatPerSystemtable::DBMSrvCmdSQL_SqlUpdatestatPerSystemtable()
    : DBMSrv_Command(
            DBMSrv_Command::KeySqlUpdatestatPerSystemtable,
            false,
            DBMSrvCmdSQL_SqlUpdatestatPerSystemtable::m_LongHelp ) {
}

const char* const DBMSrvCmdSQL_SqlUpdatestatPerSystemtable::m_LongHelp=
            "@command "DBMSrvCmdSQL_SqlUpdatestatPerSystemtable_CMD" This command updates the optimizer statistics "
                "for just the tables, that need such an update."
            "@preconditions You have the DBM operator authorization AccessSQL"
            "@syntax "DBMSrvCmdSQL_SqlUpdatestatPerSystemtable_CMD
            "@reply OK";

const char* const DBMSrvCmdSQL_SqlUpdatestatPerSystemtable::SQL_UPDATESTAT_SMART("UPDATE STAT AS PER SYSTEM TABLE");

tcn00_Error DBMSrvCmdSQL_SqlUpdatestatPerSystemtable::run(
        VControlDataT* vcontrol,
        CommandT* command,
        DBMSrv_Reply& theReply) {

    tcn00_Error rc(OK_CN00);
    theReply.startWithOK();

    cn50DBMUser superUser(vcontrol->dbname, cn50DBMUser::getColdUser(vcontrol->dbname));

    tin01_sql_session sqlSession;
    rc = cn80ConnectSQL(
            vcontrol->dbname,
            superUser,
            &sqlSession,
            theReply.giveData(),
            theReply.giveLength());
    theReply.adaptLength();
    if( rc != OK_CN00 )
        return rc;

    rc = cn80ExecuteSQL(
            &sqlSession,
            SQL_UPDATESTAT_SMART,
            theReply.giveData(),
            theReply.giveMaximalLength(),
            *(theReply.giveLength()));

    cn80ReleaseSQL( &sqlSession, rc==OK_CN00);
    return rc;
}

tcn00_Error DBMSrvCmdSQL_SqlUpdatestatPerSystemtable::runCommand
    ( VControlDataT * vcontrol,
      CommandT      * command,
      char          * replyData,
      int           * replyLen,
      int             replyLenMax)
{
    DBMSrv_Reply oReply(replyData, replyLen, replyLenMax);
    DBMSrvCmdSQL_SqlUpdatestatPerSystemtable commandObject;

    return commandObject.run(vcontrol, command, oReply);
}
