/*!
  @file           Proc_ServerSessionFactory.hpp
  @author         DanielD
  @brief          

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/


#ifndef PROC_SERVERSESSIONFACTORY_HPP
#define PROC_SERVERSESSIONFACTORY_HPP

#include "DBProc/Proc_IFactory.hpp"

class Proc_ServerControl;

/*!
  @class          Proc_ServerSessionFactory

 */

class Proc_ServerSessionFactory : public Proc_IFactory
{
public:
    Proc_ServerSessionFactory (const char * commandlineParm);
    virtual ~Proc_ServerSessionFactory ();
    virtual Proc_ISession * createSession (SAPDBErr_MessageList * messageList);    
    
private:
    const char * commandTemplate;
    // this simple implementation
    // - controls only one server at a time
    // - server is stopped with release of session
    Proc_ServerControl * serverControl;
};




#endif
