--TEST--
maxdb fetch char/text long 
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";
	
	ini_set("maxdb.long_readlen", "64000");

	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);

  	maxdb_query($link,"CREATE TABLE test_bind_fetch(c1 char(10), c2 long varchar)");

	$a = str_repeat("A1", 100);

	maxdb_query($link, "INSERT INTO test_bind_fetch VALUES ('1234567890', '$a')");

	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_fetch");
	maxdb_bind_result($stmt, $c1, $c2);
	maxdb_execute($stmt);
	maxdb_fetch($stmt);

	$test[] = $c1;
	$test[] = ($a == $c2) ? "32K String ok" : "32K String failed";

	var_dump($test);

	maxdb_stmt_close($stmt);
	maxdb_close($link);
	
	ini_restore("maxdb.long_readlen");
?>
--EXPECT--
array(2) {
  [0]=>
  string(10) "1234567890"
  [1]=>
  string(13) "32K String ok"
}
