/****************************************************************************/
/*!

  @file        SysView_TableSizeDetails.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "TableSizeDetails" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_TableSizeDetails.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_TableSizeDetails::Create()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_TableSizeDetails::Create", SysView_Trace, 5);

	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_OWNER, 32);
	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_TABLENAME, 32);
	m_Table->AppendCol (ITOCT_FIXED ,SV_ROOT, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_PERMANENT, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_USEDSIZE, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_USEDDATASIZE, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_TREELEVELCOUNT, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_AVGUSEDSIZEPERCENTAGEINLEAVES, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MINUSEDSIZEPERCENTAGEINLEAVES, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXUSEDSIZEPERCENTAGEINLEAVES, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_ROWCOUNT, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_AVGROWCOUNTPERLEAF, 5);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MINROWCOUNTPERLEAF, 5);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXROWCOUNTPERLEAF, 5);
	m_Table->AppendCol (ITOCT_FIXED ,SV_AVGROWLENGTH, 5);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MINROWLENGTH, 5);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXROWLENGTH, 5);
	m_Table->AppendCol (ITOCT_FIXED ,SV_DEFINEDLONGCOLUMNCOUNT, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_AVGLONGCOLUMNLENGTH, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MINLONGCOLUMNLENGTH, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXLONGCOLUMNLENGTH, 10);

}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_TableSizeDetails::GetColCount()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_TableSizeDetails::GetColCount", SysView_Trace, 5);

    return SV_CC_TABLESIZEDETAILS;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_TableSizeDetails::EstimateRows()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_TableSizeDetails::EstimateRows", SysView_Trace, 5);

    return SV_ER_TABLESIZEDETAILS;
}

/*---------------------------------------------------------------------------*/

void SysView_TableSizeDetails::Execute()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_TableSizeDetails::Execute", SysView_Trace, 5);

    m_Context.ThrowError (e_not_implemented, 1);
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
