/* @lastChanged: "1999-04-26"

  * @filename:   ggg92.h
  * @purpose:    "GG_kernel_classes"
  * @release:    7.2.0.0
  * @see:        ""
  *
  * @copyright:  (c) 1999-2004 SAP AG"


    ========== licence begin  GPL
    Copyright (c) 1999-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/

#ifndef GGG92_H
#define GGG92_H

/* ========================================================================== */
/* ==========           header file of OmsObjectId                  ========= */
/* ========================================================================== */

#include "geo00.h"
#include "ggg00.h"

#define NIL_OBJ_PAGE_NO          NIL_PAGE_NO_GG00
#define VERSION_OBJ_PAGE_NO_GG92 NIL_PAGE_NO_GG00
#define NIL_OBJ_PAGE_POS         0
#define NIL_OBJ_VERSION          0

/*----------------------------------------------------------------------------*/

typedef	struct tgg92_OmsTypeOid 
{
    teo00_Uint4 pno;
    teo00_Uint2 pagePos;
    teo00_Uint2 generation;
} tgg92_OmsTypeOid; 

/*----------------------------------------------------------------------------*/

struct tgg92_OmsOidMap2Int {
public :
  teo00_Uint4 l1;
  teo00_Uint4 l2;
  bool operator==(const tgg92_OmsOidMap2Int& oid) const {
    return ((l1 == oid.l1) && (l2 == oid.l2));
  }
  bool operator!=(const tgg92_OmsOidMap2Int& oid) const {
    return ((l1 != oid.l1) || (l2 != oid.l2));
  }
};

/*----------------------------------------------------------------------------*/

struct tgg92_OmsObjectId                // OmsObjectId header file
{
public :
  
  void setPno(unsigned int pno) {
    m_oid.pno = pno;
  }

  void setNil() { 
    setPno(NIL_OBJ_PAGE_NO);
    m_oid.pagePos     = NIL_OBJ_PAGE_POS;
    m_oid.generation  = NIL_OBJ_VERSION; 
  }
  
  bool operator==( const tgg92_OmsObjectId&r ) const { 
      return (m_2int == r.m_2int);
  }
  
  bool operator!=( const tgg92_OmsObjectId&r ) const {
      return (m_2int != r.m_2int);
  }

  void operator=(const tgg92_OmsObjectId&r) {
    m_2int.l1 = r.m_2int.l1;
    m_2int.l2 = r.m_2int.l2;
  }

  unsigned int getPno() const {
    return m_oid.pno;
  }
  unsigned short getPos() const {
    return m_oid.pagePos;
  }
  int getVersion() const {
    return m_oid.generation;
  }
 
  tgg92_OmsTypeOid* pOid() {
    return &m_oid;
  }

  bool operator< (const tgg92_OmsObjectId&r ) const {
      unsigned int pno;
      unsigned int rPno;
      pno  = getPno();
      rPno = r.getPno();
      if (pno < rPno) return true;
      else 
      {
          if (pno == rPno) return (getPos() < r.getPos());
          else return false;
      }
  }
   
  bool operator> (const tgg92_OmsObjectId&r ) const {
      unsigned int pno;
      unsigned int rPno;
      pno  = getPno();
      rPno = r.getPno();
      if (pno > rPno) return true;
      else 
      {
          if (pno == rPno) return (getPos() > r.getPos());
          else return false;
      }
  }

  bool operator! () const { 
      return ((NIL_OBJ_PAGE_NO  == getPno()  ) &&
              (NIL_OBJ_PAGE_POS == getPos()  ) && 
              (NIL_OBJ_VERSION  == getVersion())); 
  }
  
  operator bool () const {
      return ((NIL_OBJ_PAGE_NO  != getPno()  ) ||
              (NIL_OBJ_PAGE_POS != getPos()  ) || 
              (NIL_OBJ_VERSION  != getVersion())); 
  }

protected :
  union {
    tgg92_OmsTypeOid    m_oid;
    tgg92_OmsOidMap2Int m_2int;
  };

};


/* ========================================================================== */
/* ==========               header file ggg92.h                     ========= */
/* ========================================================================== */

#define NIL_OBJ_FILE_NO_GG92         0
#define MIN_OBJ_FILE_NO_GG92         1
#define MAX_OBJ_FILE_NO_GG92         MAX_INT4_SP00

#define MIN_OBJ_FRAME_VERS_GG92      1
#define MAX_OBJ_FRAME_VERS_GG92      MAX_UINT1_SP00
#define NIL_OBJ_FRAME_VERS_GG92      NIL_OBJ_VERSION

#define NIL_OBJ_PAGE_POS_GG92        NIL_OBJ_PAGE_POS


/*---------------------------------------------------------------------------*/

class tgg92_KernelOid : protected tgg92_OmsObjectId
{
public:
    
    void gg92AppendToLine (int        &LineLen,
                           tsp00_Line &Line);

    int gg92GetFrameVers() const
    {
        return getVersion();
    }
    
    bool gg92IsNilPno () const
    {
        return (getPno() == NIL_OBJ_PAGE_NO);
    }
    
    tsp00_PageNo gg92GetPno() const
    {
        return (getPno ());
    }
    
    tgg00_ObjPagePos gg92GetPos() const
    {
        return getPos();
    }
    
    bool gg92IsEqIgnoreFrameVers (const tgg92_KernelOid &r) const
    {  
        return ((m_oid.pno     == r.m_oid.pno        ) &&
                (m_oid.pagePos == r.m_oid.pagePos    ));    
    }
    
    bool gg92IsEqPnoPos (const tgg92_KernelOid &r) const
    {  
       return ((m_oid.pno     == r.m_oid.pno ) &&
               (m_oid.pagePos == r.m_oid.pagePos)); 
    }
    
    bool gg92IsNil () const
    {
        return ( ! bool (*this) );
    }
    
    bool gg92IsNilFileNo () const
    {
        return (m_oid.pagePos == NIL_OBJ_PAGE_POS);
    }

    bool gg92IsNilFrameVers () const
    {
        return (m_oid.generation == NIL_OBJ_VERSION);
    }

    bool gg92IsNilPos () const
    {
        return (m_oid.pagePos == NIL_OBJ_PAGE_POS_GG92);
    }

    void gg92Set (tsp00_PageNo     pno,
                  tgg00_ObjPagePos pos,
                  int              FrameVers)
    {
        gg92SetPno       ( pno);
        m_oid.pagePos    = pos;
        m_oid.generation = FrameVers;
    }
    

    void gg92SetFrameVers (int vers)
    {
        m_oid.generation = vers;
    }
    
    void gg92SetNil ()
    {
        setNil ();
    }
    
    void gg92SetNilFrameVers ()
    {
        m_oid.generation = NIL_OBJ_FRAME_VERS_GG92;
    }
    
    void gg92SetNilPno ()
    {
        setPno (NIL_OBJ_PAGE_NO);
    }
    
    void gg92SetNilPos ()
    {
        m_oid.pagePos = NIL_OBJ_PAGE_POS_GG92;
    }
    
    void gg92SetPno (tsp00_PageNo pno)
    {
		setPno (pno);
    }
    
    void gg92SetPos (tgg00_ObjPagePos pos)
    {
        m_oid.pagePos = pos;
    }
    
private:
    CHECK_MAPPABLE_CLASS_GIVEN_SIZE_SP00 (tgg92_KernelOid, sizeof (tgg00_OidSpace))
};

/*----------------------------------------------------------------------------*/

class tgg92_KernelOidSpace 
// designed for 'union' structures (without any ctor)
{
public:
    tgg92_KernelOid* gg92PtrOid ()
    {
        return ( REINTERPRET_CAST(tgg92_KernelOid *, this));
    }
    
private:
    tgg00_OidSpace oidSpace;

    CHECK_MAPPABLE_CLASS_GIVEN_SIZE_SP00 (tgg92_KernelOidSpace, sizeof (tgg92_KernelOid))
};

/*----------------------------------------------------------------------------*/

typedef struct tgg92_ObjHeader
{
    tgg00_ObjTransInfo ohdTransInfo_gg92;
    tgg00_ObjPagePos   ohdNextFreeObj_gg92;
    tgg00_ObjState     ohdState_gg92;
    tgg00_ObjFrameVers ohdFrameVersion_gg92;
} tgg92_ObjHeader;

#endif /* GGG92_H */
