/* @lastChanged: "1998-05-08  8:29"
 *
 * @filename:   hin29.h
 * @purpose:    "Exports for SQL package handling"
 * @release:    7.1.0.0
 * @see:        ""
 *
 * @copyright:  (c) 1997-2004 SAP AG"



    ========== licence begin  GPL
    Copyright (c) 1997-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



 */

#ifndef HIN29_H
#define HIN29_H

#include "gsp01.h"
#include "vsp001.h"
#include "vsp004.h"
#include "vsp0031.h"


//#include "gin01.h"

typedef char                tin01_byte;
typedef char                tin01_data_type;
typedef tsp00_Uint2         tin01_warningset;

typedef const char *tin01_cstr;
typedef tsp00_Bool  tin01_bool;

#define SWITCH_ERROR_DBG_MIN00(str, val)   (void) 0
#define TRACE_MIN01(level, tracer, str)    (void) 0
#define TRACEF_MIN01(level, args)          (void) 0
#define IFTRACE_MIN01(level, stmt)         (void) 0
#define IFDEBUG_MIN01(stmt)                (void) 0
#define NOT_NULL_MIN01(val)                (val != NULL)
#define MEMCPY_MIN01(target, source)       memcpy (target, source, sizeof (target))


/**\
j00 chapter sql interface
\**/

#define cin01_db_ok                    0
#define cin01_db_parse_again         (-8)
#define cin01_db_shutdown           (-71)
#define cin01_db_aborted           (-102)
#define cin01_db_illegal_rc        (-503)
#define cin01_db_dbproc_failed     (-504)
#define cin01_db_trigger_failed    (-505)
#define cin01_db_dbfunc_failed     (-506)
#define cin01_db_invalid_number    (-802)
#define cin01_db_invalid_keyword  (-3008)
#define cin01_db_missing_keyword  (-5015)
#define cin01_db_not_unicode      (-8045)
#define cin01_db_not_onebyte      (-8046)
#define cin01_db_not_accessible   (-8888)
#define cin01_db_dll_trigger_failed (-9406)
#define cin01_db_adabasic_failed   (-507)
#define cin01_db_row_not_found       100
#define cin01_db_module_not_found  16001

#define mxin1_parseid 12
typedef char    tin01_parseid[mxin1_parseid];
#define cin01_max_error_len 70
typedef char    tin01_sqlmsg[cin01_max_error_len + 1];

typedef struct tin01_sqlresult {
  /*    tsp00_int2        returnCode; */
    tsp00_Int4        returnCode;
    tsp00_WarningSet  warnings;
    tsp00_Int4        errorPos;
    tsp00_Int4        rowCount;
    tsp00_SqlState    sqlstate;
    tin01_sqlmsg      sqlmsg;
} tin01_sqlresult;

typedef struct tin01_sql_lasterr {
    tsp01_CommErr         sp_rc;
    tsp00_ErrText         errtext;
    tsp00_KnlIdentifier   errname;
    tin01_sqlresult       sqlresult;
    tin01_bool            lasterr_on;
} tin01_sql_lasterr;


typedef struct tin01_ACV tin01_ACV;

typedef struct tin01_KernelSession {
    tin01_ACV * acv;
    void (*kernelRequest) (tin01_ACV *, struct tsp1_packet *,
                            struct tsp1_packet *, tsp00_Int4, tsp01_CommErr *);
    void (*kernelReceive) (tin01_ACV *, struct tsp1_packet **);
} tin01_KernelSession;

typedef struct tin01_sql_session {
//    tsp4_xuser_record     xuser;
    tsp00_DbNamec         szDB;
    tsp00_NodeIdc         szNode;
    tsp00_KnlIdentifierc  szUser;
    tsp00_Namec           szPwd;
    tsp00_Int4            reference;
    tin01_bool            is_connected;
    tin01_bool            buildingCommand;
    tsp00_C8              senderid;
    tsp00_SwapKind        swap_kind;
    tsp00_CodeType        code_type;
    tsp1_packet          *send_packet;
    tsp1_packet          *rec_packet;
    struct tsp1_segment  *segment;
    struct tsp1_part     *part;
    int                   sqlMode;
    tin01_sql_lasterr     lasterr;
    tin01_bool            as_utility;
    tin01_bool            is_readonly;
} tin01_sql_session;

/*
 * definitions for c host variables
 */

enum tin01_c_type_Enum
{
 cin01_c_char,
 cin01_c_uchar,
 cin01_c_short,
 cin01_c_ushort,
 cin01_c_int,
 cin01_c_uint,
 cin01_c_long,
 cin01_c_ulong,
 cin01_c_float,
 cin01_c_double,
 cin01_c_charp,
 cin01_c_charpp
};
typedef ENUM_TYPE_MSP00 (tin01_c_type, tin01_c_type_Enum, cin01_c_charpp, tsp00_Uint1);

typedef struct tin01_c_hostvar {
    tsp00_Int4        len;
    tin01_c_type     c_type;
    tin01_bool       is_null;
    void           *addr;
    tsp1_param_info pinfo;
} tin01_c_hostvar;

typedef struct tin01_c_sqlca {
    tin01_bool       inUse;
    int             varCount;
    int             paramCount;
    tin01_c_hostvar *hostVar;
    tin01_parseid    pid;
} tin01_c_sqlca;



/* ------------------------------- */
/* specification public functions  */
/* ------------------------------- */

int i29utilbackuprequest (
     tin01_sql_session       * pSession,
     boolean                   bBackupState,
     tin01_cstr                szCmd );

int i29utilbackupreceive (
     tin01_sql_session       * pSession,
     tin01_c_sqlca           * pSqlca,
     boolean                 * bBackupRC,
     ... );

void i29errmsg (
     tin01_sql_session       * pSession,
     tsp00_C256c             & errbuf);

void i29initsession (
     tin01_sql_session       * pSession,
     tsp1_packet             * pPacket);

void i29pascalstring (
     char                    * target,
     int                       targetlen,
     const char              * source,
     int                       sourcelen );

tin01_sql_session * i29lasterr_on (
     tin01_sql_session       * pSession );


void i29sqllasterr (
     tin01_sql_session       * pSession,
     tsp00_ErrTextc          & errtext,
     tsp00_KnlIdentifierc    & errname,
     tsp00_Int2              * errcode,
     tsp00_Int2              * errpos );

int i29replyavailable (
     tin01_sql_session       * pSession );

int i29utility (
     tin01_sql_session       * pSession,
     tin01_cstr                szCmd );

int i29utilitynice (
     tin01_sql_session       * pSession,
     tin01_cstr                szCmd,
     char                    * pResult,
     bool                      bSessionless);

int i29utilcmd (
     tin01_sql_session       * pSession,
     tin01_c_sqlca           * pSqlca,
     tin01_cstr                szCmd,
     ... );

void i29cancel (
     tin01_sql_session       * pSession );

void i29release (
     tin01_sql_session       * pSession,
     tin01_bool                bWithCommit );

int i29selectinfo (
     tin01_sql_session       * pSession,
     tin01_cstr                szCmd,
     char                    * pResult,
     char                      cFieldSep );

int i29fetch (
     tin01_sql_session       * pSession,
     char                    * pResult,
     long                      nResultLen,
     char                      cFieldSep,
     char                      cStringDel,
     char                      cRecSep,
     bool                    & bContinue );

int i29adbs (
     tin01_sql_session       * pSession,
     tin01_cstr                szCmd );

int i29select (
     tin01_sql_session       * pSession,
     tin01_cstr                szCmd,
     char                    * pResult,
     long                      nResultLen,
     char                      cFieldSep,
     char                      cStringDel,
     char                      cRecSep,
     bool                    & bContinue );

int i29sqlcmd (
     tin01_sql_session       * pSession,
     tin01_c_sqlca           * pSqlca,
     tin01_cstr                szCmd,
     ... );

int i29fetchnice (
     tin01_sql_session       * pSession,
     char                    * pResult,
     long                      nResultLen,
     bool                    & bContinue);

int i29selectnice (
     tin01_sql_session       * pSession,
     tin01_cstr                szCmd,
     char                    * pResult,
     long                      nResultLen,
     bool                      bOneRowResult,
     bool                      bDesc,
     bool                      bDataOnly,
     bool                    & bContinue);

int i29eventwait (
     tin01_sql_session       * pSession,
     tsp31_event_description * pEvent);

void i29eventrelease (
     tin01_sql_session       * pSession);

int i29paramcount (
     tin01_sql_session       * pSession);

int i29fieldvalue (
     tin01_sql_session       * pSession,
     const tsp00_Int4          nField,
     tin01_c_hostvar         * pHostvar,
     const char                cStringQuote = 0);

char * i29fieldname (
     tin01_sql_session       * pSession,
     const tsp00_Int4          nField,
     char                    * pResult);

tsp1_param_info * i29gparaminfo (
     tin01_sql_session       * pSession,
     int                       i);

int i29record (
     tin01_sql_session       * pSession,
     tin01_cstr                szCmd);

int i29nextrecord (
     tin01_sql_session       * pSession);

tin01_cstr i29colnames (
     tin01_sql_session       * pSession);

int i29usrconnect (
     tin01_sql_session       * pSession,
     const char              * szDB,
     const char              * szNode,
     const char              * szUser,
     const char              * szPwd,
     bool                      bUnicode,
     bool                      bUtility);

int i29eventconnect (
     tin01_sql_session       * pSession,
     const char              * szDB,
     bool                      bUnicode = false);

int i29reconnect (
     tin01_sql_session       * pSession);

#endif
