#!/devtool/local/bin/perl


$| = 1; # Nur zur Sicherheit, damit das (unntige) Buffering ausgeschaltet wird.

if ($^O =~ /MSWin32/i) {
    require File::DosGlob ;
    import  File::DosGlob 'glob';
    require WinLink;
    import  WinLink;
    require Win32::TieRegistry;
    import  Win32::TieRegistry;
    require Win32::Process;
    import  Win32::Process;
    system("NET USE L: \\\\pwdfm017\\LC_POOL") unless ( -e "L:");
}

use Sys::Hostname;
use testdb;
my $hostname    = hostname();

my %options = ();
use Getopt::Long;
if (! &GetOptions(  \%options,
            'h|help|?',
            'cpc=s',
			'no_objstat',            
            'complete'   
            )) {
    print("Run inst.pl -h for help");
    exit(1);
}

if (($options{'h'})) #||(!$options{'version'}) || (!$options{'status'})) {
{
    print <<EOF;

    Usage:
inst.pl [-cpc <VERSION><STATUS>] [-complete] [-verbose] <VERSION><STATUS>

where <VERSION> can either be
    7403    (This can be a possible exception on AIX 4)
or
    7402

and <STATUS> can be
    DEV
or
    COR
or
    RAMP

-verbose      tells you a bit more of what the script is doing.
-cpc          to install an other precompiler version
-complete     install indep programs too


EOF
exit(0)
}



if ($#ARGV != 0) {
    print "Syntax $PROGRAM_NAME VersionStatus\n";
    print "e.g. $PROGRAM_NAME 7403DEV\n";
    exit(1);
}

my $version = $ARGV[0];
my $tdb;

if ($version =~ /^\d{4}(DEV|COR|RAMP)$/i) {
	if (defined ($options{'cpc'})){
	    $tdb = testdb->new({'version' => substr($version, 0, 4), 'status' => substr($version, 4, 10), 'profile' => 'workday', 'pcversion' => $options{'cpc'}, 'no_objstat' => ($options{'noobj_stat'} ? 1 : 0)} );
	}
	else {
	    $tdb = testdb->new({'version' => substr($version, 0, 4), 'status' => substr($version, 4, 10), 'profile' => 'workday', 'no_objstat' => ($options{'no_objstat'} ? 1 : 0)});
	}
    if ($tdb->{error_code}) {
        testdb::throw_err ($tdb->{error_text});
    }
}

$tdb->preClean();
if ($options{'complete'})
{
	$tdb->installLCComplete();	
}
else
{	
	$tdb->installLC();
}
$tdb->installTF();

$ENV{'MAX_CPU'} = '4';
$ENV{'MAXCPU'} = '4';

#$tdb->run_single_test("mut_long");
