/*     Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of MCL.  You can redistribute and/or modify MCL under the
 * terms of the GNU General Public License; either version 2 of the License or
 * (at your option) any later version.  You should have received a copy of the
 * GPL along with MCL, in the file COPYING.
*/

#ifndef impala_io_h
#define impala_io_h

#include <math.h>
#include <stdio.h>

#include "vector.h"
#include "matrix.h"

#include "util/io.h"
#include "util/types.h"
#include "util/ting.h"


/* TODO:
 *    Make ascii format parsing looser (not line based).
 *    The ascii parsing code is not all that great, a bit heavy-weight.
 *    How to tackle this. lex/yac !?
 *
 *    Perhaps some of the routines should be static and not available.
 *    There should be a clearer framework for rewinding streams
 *    after gathering partial information (readDomains, readDimensions).
 *    -  mclxReadDimensions resets file pointer;
 *       mclxReadDomains does not.
 *    make a design here, requirements.
 *    mclxaReadDomains is used internally; others are not.
 *
 *    ? mclxSubWrite
 *      mclxaSubWrite
 *      mclxbSubWrite
 *    hum, for what purpose? mcxsubs allows transformations on the
 *    submatrices, so no good there.
 *
 *    ?  unify xread, xaread, xbread
 *       with MCLXIO_FORMAT_EITHER, MCLXIO_FORMAT_ASCII
 *       MCLXIO_FORMAT_BINARY argument?
 *    this will lead to less repeated code (xf checking, fseek)
 *    mostly applications will not care.
 *
*/

#define mclxCookie   0x0d141831u     /* MTX1 */
#define mclvCookie   0x16050331u     /* VEC1 */


#define MCL_APP_VB_NO   2
#define MCL_APP_VB_YES  8

#define MCL_APP_WB_NO   2
#define MCL_APP_WB_YES  8

mcxbool mclxIOgetQMode        /* quad mode */
(  const char* opt
)  ;

mcxbool mclxIOsetQMode        /* quad mode */
(  const char* opt
,  unsigned long mode
)  ;


 /* *********************
*/

mclMatrix* mclxRead
(  mcxIO*      xfIn
,  mcxOnFail   ON_FAIL
)  ;

mclMatrix* mclxaRead
(  mcxIO*      xfIn
,  mcxOnFail   ON_FAIL
)  ;

mclMatrix* mclxbRead
(  mcxIO*      xfIn
,  mcxOnFail   ON_FAIL
)  ;


 /* *********************
*/

mclMatrix* mclxSubRead
(  mcxIO*      xfIn
,  mclVector*  coldom
,  mclVector*  rowdom
,  mcxOnFail   ON_FAIL
)  ;

mclMatrix* mclxaSubRead
(  mcxIO       *xf
,  mclv*       colmask
,  mclv*       rowmask
,  mcxOnFail   ON_FAIL
)  ;

mclMatrix* mclxbSubRead
(  mcxIO*      xf
,  mclVector*  colmask
,  mclVector*  rowmask
,  mcxbool     getcookie
,  mcxOnFail   ON_FAIL
)  ;


 /* *********************
*/
/*
 * Tries to read cookie, then branches of ascii or binary.
*/
mcxstatus mclxReadDomains
(  mcxIO* xf
,  mclv* dom_cols
,  mclv* dom_rows
)  ;


/* After this, xf is basically useless unless reopened or rewound.
 * The routine is used internally (hence the line (continuation) argument).
*/
mcxstatus mclxaReadDomains
(  mcxIO*      xf
,  mclv        **dom_cols
,  mclv        **dom_rows
,  mcxTing*    line
)  ;


/*
 * This damsel assumes the cookie has been read.
*/
mcxstatus mclxbReadDomains
(  mcxIO*      xf
,  mclv*       dom_cols
,  mclv*       dom_rows
,  int*        levelp
)  ;


 /* *********************
*/

mcxstatus mclxReadDimensions
(  mcxIO*      xfIn
,  long        *n_cols
,  long        *n_rows
)  ;

/*
 * Is used internally, reads single required part
*/
mcxstatus  mclxaReadDimensions
(  mcxIO       *xf
,  long        *pn_rows
,  long        *pn_cols
)  ;

/*
 * Implementation willfully dies. Implement when needed.
*/
mcxstatus  mclxbReadDimensions
(  mcxIO       *xf
,  long        *pn_rows
,  long        *pn_cols
)  ;



#define MCLXIO_VALUE_NONE    -1
#define MCLXIO_VALUE_INT      0
#define MCLXIO_VALUE_GETENV  -2

#define MCLXIO_FORMAT_ASCII   1
#define MCLXIO_FORMAT_BINARY  2
#define MCLXIO_FORMAT_GETENV  3

mcxstatus mclxWrite
(  const mclMatrix*        mx
,  mcxIO*                  xfout
,  int                     valdigits   /* only relevant for ascii writes */
,  mcxOnFail               ON_FAIL
)  ;

mcxstatus mclxaWrite
(  const mclMatrix*  mx
,  mcxIO*            xfOut
,  int               valdigits
,  mcxOnFail         ON_FAIL
)  ;

mcxstatus  mclxbWrite
(  const mclMatrix*  mtx
,  mcxIO*            xfOut
,  mcxOnFail         ON_FAIL
)  ;


enum
{  MCLXR_ENTRIES_ADD
,  MCLXR_ENTRIES_MAX
,  MCLXR_ENTRIES_MUL
,  MCLXR_ENTRIES_POP
,  MCLXR_ENTRIES_PUSH

,  MCLXR_VECTORS_ADD
,  MCLXR_VECTORS_MAX
,  MCLXR_VECTORS_MUL
,  MCLXR_VECTORS_POP
,  MCLXR_VECTORS_PUSH
}  ;


mclVector* mclvaReadRaw
(  mcxIO          *xf
,  mclpAR*        ar
,  mcxOnFail      ON_FAIL
,  int            fintok     /* e.g. '\n' or EOF or '$' */
,  mcxbits        warn_repeat
,  void (*ivpmerge)(void* ivp1, const void* ivp2)
)  ;


mcxstatus mclxaSubReadRaw
(  mcxIO          *xf
,  mclMatrix      *mx
,  mclv           *dom_cols
,  mclv           *dom_rows
,  mcxOnFail      ON_FAIL
,  int            fintok     /* e.g. EOF or ')' */
,  mcxbits        warn_repeat
,  void (*ivpmerge)(void* ivp1, const void* ivp2)
,  double (*fltbinary)(pval val1, pval val2)
)  ;



void mcxPrettyPrint
(  const mclMatrix*  mx
,  FILE*             fp
,  int               width
,  int               digits
,  const char        msg[]
)  ;


void mclFlowPrettyPrint
(  const mclMatrix*  mx
,  FILE*             fp
,  int               digits
,  const char        msg[]
)  ;


mcxstatus mclxTaggedWrite
(  const mclMatrix*  mx
,  const mclMatrix*  dom
,  mcxIO*            xfOut
,  int               valdigits
,  mcxOnFail         ON_FAIL
)  ;



void                 mclxBoolPrint
(  mclMatrix*        mx
,  int               mode
)  ;


mcxstatus mclvEmbedRead
(  mclVector*        vec
,  mcxIO*            xfIn
,  mcxOnFail         ON_FAIL
)  ;


mcxstatus mclvWrite
(  const mclVector*  vec
,  mcxIO*            xfOut
,  mcxOnFail         ON_FAIL
)  ;


mcxstatus mclvEmbedWrite
(  const mclVector*  vec
,  mcxIO*            xfOut
)  ;


void mclvaWrite
(  const mclVector*  vec
,  FILE*             fp
,  int               valdigits
)  ;


/*
 *    does *not* accept MCLXIO_VALUE_GETENV
*/
void mclvaDump
(  const mclVector*  vec
,  FILE*             fp
,  int               idxwidth
,  int               valdigits
,  mcxbool           doHeader
)  ;


mclpAR *mclpaReadRaw
(  mcxIO       *xf
,  mcxOnFail   ON_FAIL
,  int         fintok     /* e.g. EOF or '$' */
)  ;

#endif

