/*
 * mode-minimum.c
 *
 * Copyright 1998, 1999 Michael Elizabeth Chastain, <mailto:mec@shout.net>.
 * Licensed under the Gnu Public License, version 2.
 */

#include <stdio.h>
#include <stdlib.h>

#include "mconfig.h"



/*
 * Process a statement to give it a minimum answer.
 */
static void 
scb_minimum(const statement_type * statement, void *p_UNUSED)
{
	switch (statement->verb) {
	default:
		error_enum_bogus();
		break;

	case verb_MENU:
	case verb_mainmenu_name:
	case verb_comment:
	case verb_text:
		break;

	case verb_unset:
		{
			symbol_type    *symbol;

			for (symbol = statement->su_unset_list->symbol_first;
			     symbol != NULL;
			     symbol = symbol->next) {
				symbol->value = piece_empty;
				symbol->origin = origin_unset;
			}
		}
		break;

	case verb_def_bool:
	case verb_ask_hex:
	case verb_def_hex:
	case verb_dep_hex:
	case verb_ask_int:
	case verb_def_int:
	case verb_dep_int:
	case verb_ask_string:
	case verb_def_string:
	case verb_dep_string:
	case verb_def_tristate:
		{
			statement->sb_symbol->value = word_eval(statement->sb_def_value, 1);
			statement->sb_symbol->origin = origin_statement;
		}
		break;

	case verb_ask_bool:
	case verb_dep_bool:
	case verb_dep_mbool:
	case verb_ask_tristate:
	case verb_dep_tristate:
		{
			int             allowed = statement_bools_allowed(statement);

			if ((allowed & 0x01) == 0)
				error_internal("scb_minimum: 'n' not allowed");

			statement->sb_symbol->value = piece_n;
			statement->sb_symbol->origin = origin_statement;
		}
		break;

	case verb_nchoice:
		{
			symbol_type    *symbol;
			int             index = 0;

			statement->sn_choice_index = 0;

			for (symbol = statement->sn_choice_list->symbol_first;
			     symbol != NULL;
			     symbol = symbol->next) {
				symbol->value = (index-- == 0) ? piece_y : piece_n;
				symbol->origin = origin_statement;
			}
		}
		break;
	}
}



/*
 * This mode is simple because it has no user interface.
 */
void 
do_mode_minimum(const block_type * block)
{
	const char     *str_error;

	block_walk(block, 1, scb_minimum, NULL);

	if (block_output(block, &str_error) < 0) {
		fprintf(stderr, "Write failed: %s\n", str_error);
		exit(1);
	}
}
