.TH XMixer 1 "24 Aug 1995"
.UC 4
.SH NAME
xmixer \- X based volume and mixer control program
.SH SYNOPSIS
.B xmixer
[
.B -1
] [
.B -all
] [
.B -debug
] [
.B -device \<device\>
] [
.B -hide-exit
] [
.B -nopoll
] [
.B -poll
] [
.B -rate \<\mu-sec\>
] [
.B -v
] [
.B -display \<display\>
] [
.B -fn \<font\>
]
.SH DESCRIPTION
.I XMixer
is used to control your soundcard volume settings. It runs with Linux
sound drivers V2.0 and above.
This document describes all the features of
.I XMixer.
Your soundcard may or may not support everything of it, please be
sure to read your hardware manual.

.SH USAGE
.PP
The program has several sliders to control the volume of your supported sound
hardware. For ProAudioSpectrum16 owners it provides `loudness', `stereo wide'
and `mute' buttons above the sliders.
Below the sliders are buttons to select the recording source.

Options offered by
.I XMixer
are the following:
.TP 0.6i
.B -display \<display\>
Show the control window on the given display.
.TP 0.6i
.B -fn \<font\>
Use this font rather than the default. The given font should be fixed width
and about the same size like the default font. If not, the window will look
ugly.
.TP 0.6i
.B -1
This is the same as
.B -all
and is available for historical reasons.
.TP 0.6i
.B -all
Big mixer mode. Show all sliders supported by the driver. (You may enable
each slider separately with X-Resources, this switch overrides it. See below.)
.TP 0.6i
.B -debug
Enable debugging output. Will show which sliders are enabled and which of
them are actually supported by the driver.
.TP 0.6i
.B -device \<device\>
Use the given device. Default is /dev/mixer.
.TP 0.6i
.B -hide-exit
Hides the exit button, making the window smaller. Impossible if the soundcard
is a ProAudioSpectrum16. If the exit button is hidden, you can still exit
the program if your window manager supports WM_DELETE_WINDOW and provides a
button for it in the title bar (fvwm does).
.TP 0.6i
.B -poll
Poll the mixer device three times a second and update the sliders. If you use
this, changes to the settings made by other programms will show up on your
mixer window. Though this causes only a minimal system load, it keeps the
process in memory, so don't use this if you have a slow system or not
much memory.
.TP 0.6i
.B -nopoll
Don't poll the mixer. Wether -p or -np is the default depends on the *pollMixer
.I X11
resource.
.TP 0.6i
.B -rate \<\mu-sec\>
If polling is enabled, this will set the delay between each poll in
microseconds. Values below 10000 are silly and are rejected.
.TP 0.6i
.B -v
Print current version and exit.

.SH "RESOURCES"
.I XMixer
understands a large number of
.I X11
resources which are listed below. These system wide resources usually sit in
a file called
.B /usr/lib/X11/app-defaults/XMixer.
Personal resources reside either in 
.B ~/.Xdefaults
or
.B ~/.Xresources
depending on your installation. To put an
.I XMixer
resource into your personal resource file, prefix it with the word
.B xmixer.
After editing your personal file, be sure to run
.B xrdb ~/.Xresources
or
.B xrdb ~/.Xdefaults
to make them work. There is no need for a prefix or an invocation of
.I xrdb
if you change the system wide file.

.SH "STANDARD RESOURCES"
Standard
.I X11
resources with their defaults are shown here. For an explanation of the
standard resources please see the
.I X11
dcumentation.

Standard resources are:

.TP 0.6i
.B *title: XMixer
.TP 0.6i
.B *geometry: no default!
.TP 0.6i
.B *iconic: off
.TP 0.6i
.B *background: gray80
.TP 0.6i
.B *foreground: black
.TP 0.6i
.B *font: -b&h-lucida-medium-r-normal-sans-*-120-*-*-p-*-*-*
.TP 0.6i
.B *reverseVideo: off
.TP 0.6i
.B *synchronize: off


.SH "SPECIAL RESOURCES"
Special
.I XMixer
resources are:

.TP 0.6i
.B *brightBorder: gray94
.TP 0.6i
.B *darkBorder: gray40
.TP 0.6i
.B *hilightColor: gray72
These settings are responsible for the 3D-look-and-feel of the program.
Just play with the values to see what they do.
.TP 0.6i
.B *mixerDevice: /dev/mixer
Use the given device. Default is /dev/mixer.
.TP 0.6i
.B *pollMixer: off
Please see description of
.B -poll
or
.B -nopoll
commandline option above.
.TP 0.6i
.B *hideExitButton: False
Hides the exit button if true. See
.B -hide-exit
commandline parameter above.
.TP 0.6i
.B mixerMode:
This resouce is no longer supported.

.TP 0.0i
The following resources are used to enable or disable each slider separately:

.TP 0.9i
.B vol:
Enables or disables master volume control.
.TP 0.9i
.B bass:
Enables or disables low frequency control.
.TP 0.9i
.B treble:
Enables or disables high frequency control.
.TP 0.9i
.B synth:
Enables or disables FM Synthesizer control (e.g. OPL2/OPL3/OPL4 or WaveTable
aka /dev/sequencer).
.TP 0.9i
.B pcm:
Enables or disables digital audio control (aka /dev/dsp and /dev/audio).
.TP 0.9i
.B speaker:
Enables or disables PC-speaker emulation control.
.TP 0.9i
.B line:
Enables or disables line input control.
.TP 0.9i
.B mic:
Enables or disables microphone input control.
.TP 0.9i
.B cd:
Enables or disables internal cd playback control.
.TP 0.9i
.B mix:
Enables or disables monitor volume control.
.TP 0.9i
.B pcm2:
Enables or disables soundblaster emulation control (aka /dev/dsp2).
.TP 0.9i
.B rec:
Enables or disables recording level control.
.TP 0.9i
.B igain:
Enables or disables input gain level control.
.TP 0.9i
.B ogain:
Enables or disables output gain level control.
.TP 0.9i
.B line1:
Enables or disables line input 1 control.
.TP 0.9i
.B line2:
Enables or disables line input 2 control.
.TP 0.9i
.B line3:
Enables or disables line input 3 control.

.TP 0.0i
Each of the above resources enables or disables its slider. The names are
taken from the current Unix Sound System include file.
(Version 3.5.4 as of this writing.)
Not all of these resources may be supported by your hardware.
.I XMixer
checks for each requested slider whether it is really supported. If a slider
is not supported, it will be silently disabled. Use the
.B -debug -all
switches to check what is supported if in doubt.
If none of the above resources are set, they default to on. If at least one
resource is present, the other resources default to off.

There are a lot of soundcards out there with similar hardware but different
line-input mappings. That means on some soundcards you might find the cdrom
audio on `line1' instead of `cd', while another board connects it to `line3'.
This happens especially with boards based on CS4231 and similar chips.
Future versions of
.I XMixer
might include advanced mapping features to make the sliders fit more
accurately to the real hardware.


.SH "TROUBLESHOOTING"

.TP 0.4i
.B Q:
It quits with 'xmixer: Can't open /dev/mixer: No such file or directory'
.TP 0.4i
.B A:
You can use this program only if you have a soundcard. Check if the
file exists. If not, check the sound-faq on how to create the device entry.

.TP 0.4i
.B Q:
It quits with 'xmixer: Can't open /dev/mixer: No such device or address'
.TP 0.4i
.B A:
You probably don't have sound support in the kernel. Check if your
sounddriver is installed properly and if it has mixer support. Try
.B cat /dev/sndstat
and see if it prints something like
.B 1 mixer(s) installed.
If you get an error message instead, please check the sound howto.

.TP 0.4i
.B Q:
I don't have the default font, so the program always tells me an annoying
message that it uses a fixed font, how can i get rid of this?
.TP 0.4i
.B A:
Call it as 'xmixer -fn fixed' or change the font in the default file.
The default file is usually /usr/lib/X11/app-defaults/XMixer.

.TP 0.4i
.B Q:
Some buttons appear stippled gray and can't be used.
.TP 0.4i
.B A:
This is not a bug. Your sound driver or your sound hardware simply does not
support the feature this button is controlling, so the button is disabled.

.TP 0.4i
.B Q:
Older versions of XMixer had buttons for mute, enhance and loudness. What
happened to them?
.TP 0.4i
.B A:
These buttons are only supported by the kernel if you have a
ProAudioSpectrum16 soundcard. Thus, they appear only if you have such a beast.
Older versions of XMixer displayed the buttons regardless whether they were
working or not.


.SH BUGS
Some sound drivers are known not to support all possible settings. So if
nothing happens if you press a button or move a slider, this may be due to
lack of hardware support or due to a driver bug.

.SH "SEE ALSO"
xplaycd(1)

.SH AUTHOR
Olav Woelfelschneider
   (wosch@rbg.informatik.th-darmstadt.de)

.SH COPYING
Copyright (C) 1994 
 Olav Woelfelschneider
 (wosch@rbg.informatik.th-darmstadt.de)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
 This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

