##############################################################################
#
# Widget to import items from XML <Peter.Bienstman@ugent.be>
#
##############################################################################

from qt import *

from memaid_core import *
from import_frm import *



##############################################################################
#
# ImportDlg
#
##############################################################################

class ImportDlg(ImportFrm):

    ##########################################################################
    #
    # __init__
    #
    ##########################################################################

    def __init__(self,parent = None,name = None,modal = 0,fl = 0):
        
        ImportFrm.__init__(self,parent,name,modal,fl)

        self.categories.insertItem("<default>")
        for cat in get_categories():
            if cat.name != "<default>":
                self.categories.insertItem(cat.name)
        
        self.connect(self.browse_button, SIGNAL("clicked()"), self.browse)
        self.connect(self.ok_button, SIGNAL("clicked()"), self.apply)

    ##########################################################################
    #
    # browse
    #
    ##########################################################################

    def browse(self):
        
        out = unicode(QFileDialog.getOpenFileName( \
            get_config("import_dir"),"*.xml"))
        if out != "":
            self.filename.setText(out)
            
    ##########################################################################
    #
    # apply
    #
    ##########################################################################

    def apply(self):

        fname = unicode(self.filename.text())
        cat_name = unicode(self.categories.currentText())
        status = import_XML(fname, cat_name)

        if status == False:
            QMessageBox.critical(None,
                 self.trUtf8("PyQt MemAid"),
                 self.trUtf8("File doesn't appear to be in " +\
                             "the correct format."),
                 self.trUtf8("&OK"), None, None, 0, -1)
        else:
            set_config("import_dir", os.path.dirname(fname))
        
        self.close()
