/* 
 *   Creation Date: <2002/05/22 22:09:00 samuel>
 *   Time-stamp: <2003/03/29 17:46:54 samuel>
 *   
 *	<enet.h>
 *	
 *	Ethernet controller definitions
 *   
 *   Copyright (C) 2002, 2003 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_ENET
#define _H_ENET

struct packet_driver;

typedef struct {
	struct packet_driver *pd;

	int		fd;
	int		packet_pad;		/* #bytes before the eth packet */

	unsigned char	eth_addr[6];
	char		drv_name[26];
	char		iface_name[16];

	ulong		ipfilter;		/* sheep private, for save/load state only */
} enet_iface_t;

typedef struct packet_driver {
	char		*name;
	int		packet_driver_id;	/* f_xxx */

	int		(*open)			(enet_iface_t *is, char *intf_name );
	void		(*close)		(enet_iface_t *is );
	int		(*add_multicast)	(enet_iface_t *is, char *addr );
	int		(*del_multicast)	(enet_iface_t *is, char *addr );
	int		(*load_save_state)	(enet_iface_t *is, enet_iface_t *load_is, int index, int loading );
} packet_driver_t;

extern packet_driver_t *find_packet_driver( char *res_name, int index );

#define TAP_PACKET_PAD			2		/* used by read & writes */
#define MAX_PACKET_SIZE			1514
#define PACKET_BUF_SIZE			(1514 + TAP_PACKET_PAD)

#endif   /* _H_ENET */
