<?php
// Copyright 2003-2004 Won-Kyu Park <wkpark at kldp.org>
// All rights reserved. Distributable under GPL see COPYING
// a DisMol plugin for the MoniWiki
//
// $Id: chat.php,v 1.3 2003/06/13 13:30:54 wkpark Exp $

function processor_dismol($formatter,$value="") {
    if ($value[0]=='#' and $value[1]=='!')
      list($line,$value)=explode("\n",$value,2);

    $body = $value;
    $args='';

    while ($body and $body[0] == '#') {
        # extract first line
        list($line, $body) = explode("\n",$body, 2);

        # skip comments (lines with two hash marks)
        if ($line[1] == '#') continue;

        # parse the PI
        list($verb, $arg) = explode(' ',$line,2);
        $verb = strtolower($verb);
        $arg = rtrim($arg);

        if (in_array($verb,array('#sticks','#ball&stick','#wireframe','#spacefill')))
            $args.='<param name="mode" value="'.substr($verb,1).'" />';
        else if ($verb == '#rotate') {
            $args.='<param name="rotate" value="'.$arg.'" />';
        }
    }

    if (!$args)
        $args='<param name="mode" value="ball&stick" />';

    $buff=str_replace("\n","|\n",$body)."\n";
    $molstring= trim($buff);

    $pubpath = $formatter->url_prefix.'/applets/DismolPlugin';

    return <<<APP
<applet code='DisMol.class' height='200' width='200' archive='$pubpath/dismol.zip' codebase='$pubpath'>
        $args
        <param name='molstring' value='$molstring' />
    Loading a Dismol object.
</applet>
APP;
}

// vim:et:sts=4:sw=4:
?>
