#ifdef HAVE_XMLRPC
#include <xmlrpc.h>

#define HTTP_POST_TIMEOUT 30

struct xmlrpc_httpd_call {
	char *method_name;
	xmlrpc_mem_block *output;
	xmlrpc_value *param_array;
	int socket;
};

typedef void (* xmlrpc_async_handler)(struct xmlrpc_httpd_call *, xmlrpc_value *, void *userdata);

struct xmlrpc_method_handler {
	char *method_name;
	xmlrpc_async_handler handler;
	void *userdata;
};

void xmlrpc_httpd_result(xmlrpc_env *env, struct xmlrpc_httpd_call *call, xmlrpc_value *result);
void xmlrpc_httpd_method_add(char *method_name, xmlrpc_async_handler handler, void *userdata);
void xmlrpc_httpd_run(struct context *);
#endif /* HAVE_XMLRPC */
