/* read line from socket and send data to socket

   Written by Matthias Hensler
   Copyright WSPse 1999
   eMail: wsp@gmx.de

Created: 5/6/99
Updated: 20/11/99
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include "mp3creat.h"

#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#define MAX_CACHE 512        /* max. cache for receiving line */
#define SOCK_TIMEOUT 60      /* socket timeout */

extern void wuuush(int);
extern BOOL eased_char_hand;

char cache_buf[MAX_CACHE];
int cache_remain  = 0;
int cache_last_fd = -1;

int read_from_sock(char **line, int sock_fd, BOOL wait)
{
  int i, j, len;
  char *ret_line;
  int status;
  time_t start;

  if(cache_last_fd != sock_fd) cache_remain = 0;
  cache_last_fd = sock_fd;

  ret_line = NULL;
  len      = 0;

  while(1) {
    if(cache_remain > 0) {
      for(i=0;i<cache_remain;i++) {
	if(cache_buf[i] == 0) {
	  /* Wuups, whats this? */
	  for(j=i+1;j<cache_remain;j++) cache_buf[j-1] = cache_buf[j];
	  cache_remain--;
	}
  	if(cache_buf[i] == 0x0a) {
  	  ret_line = (char *) realloc(ret_line, sizeof(char) * (len + (i+2)));
  	  if(ret_line == NULL) {
  	    perror("realloc");
  	    wuuush(1);
  	  }
  	  memcpy(ret_line+len, &cache_buf, i+1);
  	  *(ret_line + i + 1 + len) = 0;
  	  for(len=0;len<=(cache_remain-i);len++) {
  	    cache_buf[len] = cache_buf[len+i+1];
  	  }
  	  cache_remain -= (i+1);
	  /* seems that there are some not printable characters :-( */
	  if(strlen(ret_line) > 2) {
	    for(i=0;i<strlen(ret_line)-2;i++) {
	      if(iscntrl(*(ret_line+i)) &&
		 (! (eased_char_hand && (   ((*(ret_line+i) > 32) && (((unsigned char) *(ret_line+i)) < 128))
					 || (((unsigned char) *(ret_line+i)) > 159))))) {
		status = strlen(ret_line);
		memmove((ret_line+i), (ret_line+i+1), (strlen(ret_line+i+1)));
		*(ret_line + status -1) = 0;
	      }
	    }
	  }
  	  *line = ret_line;
  	  return 0;
  	}
      }
      ret_line = (char *) realloc(ret_line, sizeof(char) * (len+cache_remain));
      if(ret_line == NULL) {
  	perror("realloc");
  	wuuush(1);
      }
      memcpy(ret_line+len, &cache_buf, cache_remain);
      len += cache_remain;
      cache_remain = 0;
    }

    start = time(NULL);
    while(1) {
      status = read(sock_fd, &cache_buf, MAX_CACHE);
      if((status == -1) && (errno != EAGAIN)) {
	perror("read");
      	wuuush(1);
      }
      if(time(NULL) - start > SOCK_TIMEOUT) return -1;
      if(status > 0) {
	cache_remain = status;
	break;
      }
      if(! wait) return -1;
    }
  }
}

int write_to_sock(char *buf, int len, int sock_fd)
{
  int status;
  time_t start;

  start = time(NULL);
  while(1) {
    status = write(sock_fd, buf, len);
    if((status == -1) && (errno != EAGAIN)) {
      perror("write");
      wuuush(1);
    }
    if(time(NULL) - start > SOCK_TIMEOUT) return -1;
    if(status > 0) break;
  }
  if(status != len) return -1;
  return 0;
}

int read_from_sock2(char **line, int sock_fd, BOOL wait)
{
  int code;
  int len;

  code = read_from_sock(line, sock_fd, wait);

  if(code == 0 && line) {
    len = strlen(*line) -1;
    while(len >= 0) {
      if(*(*line + len) == '\n' || *(*line + len) == '\r')
	*(*line + len) = 0;
      else break;
      len--;
    }
  }

  return code;
}

