/***************************************************************************
                          delvolume.cpp  -  description
                             -------------------
    begin                : Sat Feb 24 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "delvolume.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>

#include <klocale.h>
#include <kmessagebox.h>

DelVolume::DelVolume(MyDb* db, QWidget* parent, const char* name)
     : QDialog(parent, name, TRUE), db(db)
{

     initDialog();
     initValue();
     connect(butok, SIGNAL(clicked()), this, SLOT(slotbutok()));
     connect(butcancel, SIGNAL(clicked()), this, SLOT(slotbutcancel()));
     /*connect(volname, SIGNAL(returnPressed()), this, SLOT(slotbutok()));*/
}

void DelVolume::initDialog()
{
     setCaption(i18n("Remove Volume"));

     QGridLayout* layout = new QGridLayout (this, 2, 3, 12, 14);

     QGroupBox* group = new QGroupBox (this);
     group->setTitle(i18n("Volume Name"));
     group->setLineWidth(1);
     group->setMidLineWidth( 0 );
     layout->addMultiCellWidget(group, 0, 0, 0, 2);

     QGridLayout* layout1 = new QGridLayout (group, 1, 1, 22, 16);

     volname = new QComboBox(group);
     layout1->addWidget(volname,0,0);

     butok = new QPushButton(this);
     butok->setText(i18n("OK"));
     layout->addWidget(butok, 1, 0);

     butcancel = new QPushButton(this);
     butcancel->setText(i18n("Cancel"));
     layout->addWidget(butcancel, 1, 2);

      resize (270, 160);
    /* volname->setFocus();*/
}

void DelVolume::initValue()
{
     //MYSQL_RES* res;
     MYSQL_ROW row;
     db->getVolname();
     while ((row=db->getRow()))
          volname->insertItem(row[0]);
     db->freeRes();
}

int DelVolume::deleting()
{
     //db->delVolume(volname->currentText());
     return (db->delVolume(volname->currentText()));
}

QString DelVolume::getVolName()
{
    return (volname->currentText());
}

void DelVolume::slotbutok()
{
     if(KMessageBox::questionYesNo(this, i18n("Do you really want \n"
                                             "to delete this volume ?"))==3)
     {
          done(0);
     }
     else
          done(1);
}

void DelVolume::slotbutcancel()
{
     done(1);
}

#include "delvolume.moc"
