/***************************************************************************
                          mp3kultview.cpp  -  description
                             -------------------
    begin                : Tue Feb 13 15:23:55 /etc/localtime 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qheader.h>
#include <qfileinfo.h>

#include <kconfig.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kiconloader.h>

#include <iostream.h>
#include <stdlib.h>


// application specific includes
#include "mp3kultview.h"
#include "mp3kult.h"
#include "mp3info.h"
#include "ogginfo.h"
#include "resources.h"
#include "export.h"


Mp3KultView::Mp3KultView(MyDb *db, QWidget *parent, const char *name)
               : QWidget(parent, name), db(db), parent(parent)
{
	setBackgroundMode(PaletteBase);

	mainGrid = new QGridLayout (this, 2, 1);
	setupListView();
	readOptions();

	if (tree)
	{
		connect (listview, SIGNAL(collapsed (QListViewItem *)), this, SLOT(slotParentCloseIcon(QListViewItem *)));
		connect (listview, SIGNAL(expanded (QListViewItem *)), this, SLOT(slotParentOpenIcon(QListViewItem *)));
	}
	last=NULL;
}

Mp3KultView::~Mp3KultView()
{
}

/*Mp3KultDoc *Mp3KultView::getDocument() const
{
  Mp3KultApp *theApp=(Mp3KultApp *) parentWidget();

  return theApp->getDocument();
} */

void Mp3KultView::print(QPrinter *pPrinter)
{
	QPainter printpainter;
	printpainter.begin(pPrinter);
	
  // TODO: add your printing code here

	printpainter.end();
}

void Mp3KultView::setupListView()
{
	listview = new Mp3List (this);
	listview->addColumn(i18n("Title"), 150);
	listview->addColumn(i18n("Artist"), 150);
	listview->addColumn(i18n("Album"), 150);
	listview->addColumn(i18n("Length"), 50);
	listview->addColumn(i18n("Genre"), 45);
	listview->addColumn(i18n("Year"), 45);
	listview->addColumn(i18n("Comment"), 150);
	listview->addColumn(i18n("Volume"), 90);
	listview->addColumn(i18n("Path"), 270);
	listview->addColumn(i18n("File Name"), 200);
	listview->addColumn(i18n("Size"), 75);
	listview->addColumn(i18n("Mode"), 50);
	listview->addColumn(i18n("Kbit/s"), 40);
	listview->addColumn(i18n("KHz"), 60);
	listview->addColumn(i18n("Track"), 40);

	listview->setSelectionMode (QListView::Extended);

	listview->setAllColumnsShowFocus (true);
	listview->setColumnAlignment (ID_LENGTH, AlignHCenter);
	listview->setColumnAlignment (ID_BIT, AlignHCenter);
	listview->setColumnAlignment (ID_SAMPLE, AlignHCenter);
	listview->setColumnAlignment (ID_YEAR, AlignHCenter);
	listview->setColumnAlignment (ID_SIZE, AlignRight);
	listview->setColumnAlignment (ID_TRACK, AlignHCenter);
	listview->setShowSortIndicator(true);

	mainGrid->addWidget (listview,1,0);
}

void Mp3KultView::readOptions()
{
	KConfig* config;
	config = kapp->config();
	config->setGroup("View");

	QValueList<int> lst;
	QHeader *h = listview->header();

	lst = config->readIntListEntry("ColumnsWidth");

	for(uint i=0; i<NUMCOL; i++)
	{
		if (lst.count() > i)
		{
			//cerr << "Resize col : " << i << endl;
			h->resizeSection(i, lst[i]);
		}
	}

	lst.clear();

	lst = config->readIntListEntry("ColumnsOrder");

	for (uint i= 0; i<NUMCOL; i++)
	{
		if (lst.count() > i)
		{
			h->moveSection(i, lst[i]);
		}
	}

	lst.clear();

     // Hide the column show into config file

	lst = config->readIntListEntry("ColumnsVis");

	for (uint i= 0; i<NUMCOL; i++)
	{
		if (lst.count() > i)
		{
			if (!(lst[i]))
			{
				h->resizeSection(i, 0);
				h->setResizeEnabled(false,i);
				//h->setLabel(i,QString::null,0);
			}
		}
	}

	int sortCol = config->readNumEntry("SortCol", 0);
	bool sortAscending = config->readBoolEntry("SortAscending", true);
	listview->setMp3Sorting (sortCol, sortAscending);

	tree = config->readBoolEntry("TreeView", false);
	listview->setRootIsDecorated(tree);

	findAll = config->readBoolEntry ("FindAll", false);
	cerr << "Mp3KultView Options read" << endl;
}


void Mp3KultView::saveOptions()
{
     KConfig* config;
     config = kapp->config();
     config->setGroup("View");

     QValueList<int> lst, lst2, lst3;
     lst2 = config->readIntListEntry("ColumnsVis");
     lst3 = config->readIntListEntry("ColumnsWidth");

			//cerr << "Numero: " << lst2.count() << endl;

     QHeader *h = listview->header();
     for (uint i=0; i<NUMCOL;i++)
     {
        if ((lst2.count() <= i) || lst2[i])  // If column is hided don't save his width
				{
					//cerr << "Write : " << i << endl;
          lst << h->sectionSize(i);
				}
        else if( lst3.count() > i)
          lst << lst3[i];

     }
     config->writeEntry("ColumnsWidth", lst);

//     cerr << "Width Write \n";

     lst.clear();

     for (uint i=0; i<NUMCOL;i++)
          lst <<  h->mapToIndex(i);
     config->writeEntry("ColumnsOrder", lst);

		 config->writeEntry("SortCol", listview->getSortColumn());
		config->writeEntry("SortAscending", listview->getSortAscending());

		config->writeEntry("TreeView", tree);
		config->writeEntry("FindAll", findAll);
     cerr << "Mp3KultView Options Write" << endl;
}

void Mp3KultView::viewallmp3(KMainWindow* parent)
{
     Mp3KultApp* princ;
		Mp3ListItem* parent_item;

     princ = NULL;
		 parent_item = NULL;

     if (mp3kult)
     {
          princ = mp3kult;
          cerr << "Princ = mp3kult" << endl;
     }
     else if (parent)
     {
          princ = (Mp3KultApp*)parent;
          cerr << "Princ = parent" << endl;
     }
     else
          cerr << "There's any Pointer" << endl;

     totalmp3 = db->getAll();

     princ->initProgBar(totalmp3);
     listview->clear();
     while ((row = db->getRow()))
     {
		 		if (tree) {
		 			if ((parent_item == NULL) || (parent_item->text(0) != row[ID_DB_VOLUME]))
					{
						//cerr << "Parent_Item = NULL" << endl;
						parent_item = new Mp3ListItem(listview, 0, 0);
						parent_item->setText(0, row[ID_DB_VOLUME]);
						parent_item->setSelectable(false);
						parent_item->setPixmap(0, BarIcon("folder_green", KIcon::SizeSmall));
						//disconnect ((QObject*)parent_item);
					}
				item = new Mp3ListItem(parent_item, atoi(row[ID_DB_MP3ID]), atoi(row[ID_DB_LENGTH]));
				}
				else
				{
     		item = new Mp3ListItem(/*parent_item*/listview, atoi(row[ID_DB_MP3ID]), atoi(row[ID_DB_LENGTH]));
				}

	setValues(item, row);
         /* item->setText (ID_TITLE, row[ID_DB_TITLE]);
          item->setText (ID_ARTIST, row[ID_DB_ARTIST]);
          item->setText (ID_ALBUM, row[ID_DB_ALBUM]);
          item->setText (ID_LENGTH, elabLength(atoi(row[ID_DB_LENGTH])));
          item->setText (ID_GENRE, FileInfo::getGenre(atoi(row[ID_DB_GENRE])));
          item->setText (ID_YEAR, row[ID_DB_YEAR]);
          item->setText (ID_COMMENT, row[ID_DB_COMMENT]);
          item->setText (ID_VOLUME, row[ID_DB_VOLUME]);
          item->setText (ID_PATH, row[ID_DB_PATH]);
          item->setText (ID_FNAME, row[ID_DB_FNAME]);
          item->setText (ID_SIZE, row[ID_DB_SIZE]);
          item->setText (ID_MODE, FileInfo::getMode(atoi(row[ID_DB_MODE])));
          item->setText (ID_BIT, row[ID_DB_BIT]);
          item->setText (ID_SAMPLE, row[ID_DB_SAMPLE]);
          //cerr << "Track " << row[ID_DB_TRACK] << endl;
          item->setText (ID_TRACK, row[ID_DB_TRACK]);*/

          princ->advProgBar(1);
     }
     db->freeRes();
     cerr << "List Completed" << endl;
     emit viewallmp3Total(totalmp3);
     princ->resetProgBar();
     cerr << "Refresh View Completed" << endl;
}

void Mp3KultView::viewVolume(const char* volname)
{
	int mp3s;
Mp3ListItem* parent_item = NULL;
	mp3s = db->getVolume(volname);
     //mp3s =  db->getNumres();
	mp3kult->initProgBar(mp3s);
	if (tree)
	{

		parent_item = new Mp3ListItem(listview, 0, 0);
		parent_item->setText(0, volname);
		parent_item->setSelectable(false);
		parent_item->setPixmap(0, BarIcon("folder_green", KIcon::SizeSmall));
	}

	while ((row = db->getRow()))
	{
		if (tree)
		{
			item = new Mp3ListItem(parent_item, atoi(row[ID_DB_MP3ID]), atoi(row[ID_DB_LENGTH]));
		}
		else
		{
			item = new Mp3ListItem(listview, atoi(row[ID_DB_MP3ID]), atoi(row[ID_DB_LENGTH]));
		}
		setValues (item, row);
		mp3kult->advProgBar(1);
	}
	db->freeRes();
	cerr << "List Completed (Volume add)" << endl;
	totalmp3 += mp3s;
	emit viewallmp3Total(totalmp3);
	mp3kult->resetProgBar();
	cerr << "Volume added to list" << endl;
}

void Mp3KultView::viewmp3(MYSQL_ROW row)
{
     //MYSQL_ROW row;
	totalmp3++;
	Mp3ListItem* parent_item;
     //row = (mysql_fetch_row(res));
	if (tree)
	{
		parent_item = (Mp3ListItem*) listview->firstChild();
		while(parent_item->text(0) != row[ID_DB_VOLUME])
		{
			//cerr << "Check !" <<endl;
			parent_item = (Mp3ListItem*) parent_item->nextSibling();
		}
		item =new Mp3ListItem(parent_item, atoi(row[ID_DB_MP3ID]), atoi(row[ID_DB_LENGTH]));
	}
	else
	{
		item =new Mp3ListItem(listview, atoi(row[ID_DB_MP3ID]), atoi(row[ID_DB_LENGTH]));
	}
	setValues (item, row);

	emit viewallmp3Total(totalmp3);
}

void Mp3KultView::updateViewVolume (int del, const char* volname)
{
	Mp3ListItem *item, *tmp, *parent_item = NULL;
	int mp3s;

	mp3s = db->getVolume(volname);
	//mp3s =  db->getNumres();
	mp3kult->initProgBar(mp3s+del);

	item = (Mp3ListItem*) listview->firstChild();

	if (tree)
	{
		while (item)
		{
			if ((item->text(0)) == volname)
			{
				//listview->takeItem(item);
				delete item;
				break;
			}
			item = (Mp3ListItem*) item->nextSibling();
		}
	}
	else
	{
		while (item)
		{
			if ((item->text(ID_VOLUME)) == volname)
			{
				tmp=item;
				item = item->itemBelow();
				//listview->takeItem(tmp);
				delete tmp;
				mp3kult->advProgBar(1);
				continue;
			}
			item = item->itemBelow();
		}
	}
	totalmp3 -= del;

   // cerr<<"Total after delete : " << totalmp3 << endl;

	if (tree)
	{

		parent_item = new Mp3ListItem(listview, 0, 0);
		parent_item->setText(0, volname);
		parent_item->setSelectable(false);
		parent_item->setPixmap(0, BarIcon("folder_green", KIcon::SizeSmall));
	}

	while ((row = db->getRow()))
	{
		if (tree)
		{
			item = new Mp3ListItem(parent_item, atoi(row[ID_DB_MP3ID]), atoi(row[ID_DB_LENGTH]));
		}
		else
		{
			item = new Mp3ListItem(listview, atoi(row[ID_DB_MP3ID]), atoi(row[ID_DB_LENGTH]));
		}
		setValues (item, row);
		mp3kult->advProgBar(1);
	}

	db->freeRes();
	totalmp3 += mp3s;
	emit viewallmp3Total(totalmp3);
	mp3kult->resetProgBar();
	cerr << "Volume list updated" << endl;
}

void Mp3KultView::setValues(Mp3ListItem *item, MYSQL_ROW row)
{
	QString name (row[ID_DB_FNAME]);

	item->setText (ID_TITLE, row[ID_DB_TITLE]);
	item->setText (ID_ARTIST, row[ID_DB_ARTIST]);
	item->setText (ID_ALBUM, row[ID_DB_ALBUM]);
	item->setText (ID_LENGTH, elabLength(atoi(row[ID_DB_LENGTH])));
	item->setText (ID_GENRE, Mp3Info::getGenre(atoi(row[ID_DB_GENRE])));
	item->setText (ID_YEAR, row[ID_DB_YEAR]);
	item->setText (ID_COMMENT, row[ID_DB_COMMENT]);
	item->setText (ID_VOLUME, row[ID_DB_VOLUME]);
	item->setText (ID_PATH, row[ID_DB_PATH]);
	item->setText (ID_FNAME, row[ID_DB_FNAME]);
	item->setText (ID_SIZE, row[ID_DB_SIZE]);
	if (name.contains(".mp3", false))
		item->setText (ID_MODE, Mp3Info::getMode(atoi(row[ID_DB_MODE])));
	else
		item->setText (ID_MODE, OggInfo::getMode(atoi(row[ID_DB_MODE])));
	//item->setText (ID_BIT, (atoi(row[ID_DB_BIT]) < 0 ? QString("Vbr (")+(row[ID_DB_BIT]+1)+")" : row[ID_DB_BIT]));
	item->setText (ID_BIT, row[ID_DB_BIT]);
	item->setText (ID_SAMPLE, row[ID_DB_SAMPLE]);
	item->setText (ID_TRACK, row[ID_DB_TRACK]);
}

void Mp3KultView::updateRenamed (int num, const char* oldName, const char* newName)
{
	Mp3ListItem *item, *parent_item = NULL;

	mp3kult->initProgBar(num);

	item = (Mp3ListItem*) listview->firstChild();

	if (tree)
	{
		bool open;
		while (item)
		{
			if ((item->text(0)) == oldName)
			{
				parent_item = item;
				parent_item->setText(0, newName);
				break;
			}
			item = (Mp3ListItem*) item->nextSibling();
		}
		open = parent_item->isOpen();
		parent_item->setOpen(true);
		item = item->itemBelow();
		while (item && item->isSelectable())
		{
			item->setText(ID_VOLUME, newName);
			mp3kult->advProgBar(1);
			item = item->itemBelow();
		}
		parent_item->setOpen(open);
	}

	else
	{
		while (item)
		{
			if ((item->text(ID_VOLUME)) == oldName)
			{
				item->setText(ID_VOLUME, newName);
				mp3kult->advProgBar(1);
				continue;
			}
			item = item->itemBelow();
		}
	}

	mp3kult->resetProgBar();
	cerr << "View Renamed done" << endl;
}

void Mp3KultView::remViewVolume (const char* volname, int num)
{
	Mp3ListItem *item, *tmp;

	item = (Mp3ListItem*) listview->firstChild();

	if (tree)
	{
		while (item)
		{
			if ((item->text(0)) == volname)
			{
				//listview->takeItem(item);
				delete item;
				break;
			}
			item = (Mp3ListItem*) item->nextSibling();
		}
	}
	else
	{
		mp3kult->initProgBar(num);
		while (item)
		{
			if ((item->text(ID_VOLUME)) == volname)
			{
				tmp=item;
				item = item->itemBelow();
				//listview->takeItem(tmp);
				delete tmp;
				mp3kult->advProgBar(1);
				// cerr << "TotalMp3: " << totalmp3 << endl;
				continue;
			}
			item = item->itemBelow();
		}
		mp3kult->resetProgBar();
	}
	totalmp3 -= num;
	emit viewallmp3Total(totalmp3);
}

void Mp3KultView::decTotalMp3(int n)
{
     totalmp3 -= n;
     emit viewallmp3Total(totalmp3);
}

Mp3List* Mp3KultView::getListView() const
{
     return listview;
}


void Mp3KultView::setFont(QFont font)
{
     listview->setFont(font);
     acFont=font;
}

bool Mp3KultView::colVis(int column)
{
    if ((listview->columnWidth(column)) > 0)
        return true;
    else
        return false;
}

const char* Mp3KultView::elabLength(int len)
{
     int min, sec;
     char* lengthchar;
	char buf[6];

	min=len/60;
	sec=len%60;
	     sprintf (buf, "%d:%02d", min, sec);
	lengthchar=strdup (buf);
	return lengthchar;
}

void Mp3KultView::exportView(bool selected)
{
    QString file;
    QString type;
    int typenum=0;

    KFileDialog *dlg = new KFileDialog (QDir::homeDirPath(),QString::null,
                                         this, i18n("Export ..."), true);

  /*  file = KFileDialog::getSaveFileName(QDir::homeDirPath(), "*.htm *.html *.Html *.Htm|Html File",
                                                this, i18n("Save File..."));*/
    dlg->setFilter("*.htm *.html|Html File\n*.m3u|M3u File");
    /*dlg->setLocationLabel("Export:");*/
    dlg->exec();

    file = dlg->selectedFile();
    cerr << "File: " << file << endl;

    if((file.isEmpty ()))
       return;

    type = dlg->currentFilter();
    cerr << "Type: " << type << endl;

    delete dlg;
    /*kapp->processEvents();*/

    if (type == "*.htm *.html")
    {
        if (!(file.contains(".html", false)) || !(file.contains(".htm", false)))
            file += ".html";
        typenum = 1;
    }

    if (type == "*.m3u")
    {
        if (!(file.contains(".m3u", false)))
            file += ".m3u";
        typenum = 2;
    }

    QFileInfo info(file);
    if (info.exists())
    {
         int res = KMessageBox::warningYesNo (this, i18n("File already exists \n"
                                    "Overwrite ?"), i18n("File already exists"));

        if (res == 4) // Response = No
            return;
        else if (!(info.isWritable()))
             {
                    KMessageBox::error(mp3kult , i18n("File not writable"));
                    return;
             }

    }

    Export exp(listview, file);

    switch (typenum) {
        case 1 :
            mp3kult->setCursorBusy(true);
            exp.exportHtml(selected, tree);
            mp3kult->setCursorBusy(false);
            break;
        case 2 :
            mp3kult->setCursorBusy(true);
            exp.exportM3u(selected, tree);
            mp3kult->setCursorBusy(false);
            break;
        default :
            return;
        }

}


void Mp3KultView::slotsearch(QString findtext, bool reset)
{
	if (reset)
	{
		cerr << "!Last" << endl;
		last=NULL;
		item = (Mp3ListItem*) listview->firstChild();

		//init tree gest
		if (tree && findAll && !item->isSelectable())
		{
			parentItemFind = item;
			status = item->isOpen();
		}
		//end tree gest
		listview->clearSelection();
	// cerr << item->text(2) << endl;
	}
	else
	{
		cerr << "Item = Last" << endl;
		item = last;
		item->setSelected(FALSE);
		item->repaint();
		item= (Mp3ListItem*) item->itemBelow();
	}
	while (item)
	{
		//init tree gest
		if (tree && !(item->isSelectable()) && findAll)
		{
			cerr << "init item"<< endl;
			parentItemFind->setOpen(status);
			parentItemFind = item;
			status = item->isOpen();
			item->setOpen(true);
			item = item->itemBelow();
			continue;
		}
		//end tree gest
		/* cerr << "Ricerca \n";
		cerr << item->text(ID_TITLE) << '\n';  */
		if ((item->text(ID_TITLE)).contains(findtext, false) /*)*/ ||
				(item->text(ID_ARTIST)).contains(findtext, false)/*)*/ ||
				(item->text(ID_ALBUM)).contains(findtext, false)/*)*/ )
		{
			// cerr << "Found! \n";
			item->setSelected(TRUE);
			listview->ensureItemVisible(item);
			listview->repaintItem(item);
			/*listview->setCurrentItem(item);*/
			/* item->setSelected(TRUE);*/
			last=item;
			break;
		}
		cerr << "Prova " << item->text(ID_TITLE) << endl;
		item = (Mp3ListItem*) item->itemBelow();
	}
	if(!item && last)
	{
		if (KMessageBox::warningContinueCancel(parent, i18n("End of list reached \n"
                                                       "Continue from beginning ?"),
                                                  i18n("End of List"),
                                                  i18n("Continue")) == 5)
		{
			last->setSelected(FALSE);
			//init tree gest
			if (tree && findAll)
				parentItemFind->setOpen(status);
			//end tree gest
			slotsearch (findtext, true);
		}
		//init tree gest
		else if (tree && findAll)
			parentItemFind->setOpen(status);
		//end tree gest
	}
	else if (!item && !last)
	{
		KMessageBox::sorry(parent, i18n("Search string not found!"));
		last = (Mp3ListItem*) listview->firstChild();
		//init tree gest
		if (tree && findAll)
			parentItemFind->setOpen(status);
		//end tree gest
	}
}

void Mp3KultView::slotadvsearch(QString findtext, bool reset, const bool* options)
{
	bool found=FALSE;

	if (reset)
	{
		cerr << "!Last" << endl;
		item = (Mp3ListItem*) listview->firstChild();
		last=NULL;
		listview->clearSelection();
		//init tree gest
		if (tree && findAll && !item->isSelectable())
		{
			parentItemFind = item;
			status = item->isOpen();
		}
		//end tree gest

		//  cerr << item->text(2) << '\n';
	}
	else
	{
		cerr << "Item = Last" << endl;
		item = last;
		item->setSelected(FALSE);
		item->repaint();
		item=(Mp3ListItem*) item->itemBelow();
	}
	while (item)
	{
		//init tree gest
		if (tree && !(item->isSelectable()) && findAll)
		{
			cerr << "init item"<< endl;
			parentItemFind->setOpen(status);
			parentItemFind = item;
			status = item->isOpen();
			item->setOpen(true);
			item = item->itemBelow();
			continue;
		}
		//end tree gest

		/* cerr << "Ricerca \n";
		cerr << item->text(ID_TITLE) << '\n';   */
		if (/*colVis(ID_TITLE) &&*/ options[OP_TITLE] && (item->text(ID_TITLE)).contains(findtext, false))
			found=TRUE;
		else if (/*colVis(ID_ARTIST) &&*/ options[OP_ARTIST] && (item->text(ID_ARTIST)).contains(findtext, false))
			found=TRUE;
		else if (/*colVis(ID_ALBUM) &&*/ options[OP_ALBUM] && (item->text(ID_ALBUM)).contains(findtext, false))
			found=TRUE;
		else if (/*colVis(ID_COMMENT) &&*/ options[OP_COMMENT] && (item->text(ID_COMMENT)).contains(findtext, false))
			found=TRUE;
		else if (/*colVis(ID_FNAME) &&*/ options[OP_FNAME] && (item->text(ID_FNAME)).contains(findtext, false))
			found=TRUE;
		else if (/*colVis(ID_VOLUME) &&*/ options[OP_VOLUME] && (item->text(ID_VOLUME)).contains(findtext, false))
			found=TRUE;
		else if (/*colVis(ID_PATH) &&*/ options[OP_PATH] && (item->text(ID_PATH)).contains(findtext, false))
			found=TRUE;
		else if (/*colVis(ID_GENRE) &&*/ options[OP_GENRE] && (item->text(ID_GENRE)).contains(findtext, false))
			found=TRUE;
		if(found)
		{
			// cerr << "Found!" << endl;
			item->setSelected(TRUE);
			listview->ensureItemVisible(item);
			listview->repaintItem(item);
			/*listview->setCurrentItem(item);*/
			/* item->setSelected(TRUE);*/
			last=item;
			break;
		}
		item = (Mp3ListItem*) item->itemBelow();
	}
	if(!item && last)
	{
		if (KMessageBox::warningContinueCancel(parent, i18n("End of list reached \n"
                                                       "Continue from beginning ?"),
                                                  i18n("End of List"),
                                                  i18n("Continue")) == 5)
		{
			last->setSelected(FALSE);
			//init tree gest
			if (tree && findAll)
				parentItemFind->setOpen(status);
			//end tree gest
			slotadvsearch (findtext, TRUE, options);
		}
		//init tree gest
		if (tree && findAll)
			parentItemFind->setOpen(status);
		//end tree gest
	}
	else if (!item && !last)
	{
		KMessageBox::sorry(parent, i18n("Search string not found!"));
		last = (Mp3ListItem*) listview->firstChild();
		//init tree gest
		if (tree && findAll)
			parentItemFind->setOpen(status);
		//end tree gest
	}
	cerr << "Quit!!" << endl;
}

void Mp3KultView::slotExport()
{
    exportView(false);
}

void Mp3KultView::slotExportSelected()
{
    exportView(true);
}

void Mp3KultView::slotToggleTreeView()
{
	if (tree)
	{
		tree = false;
		listview->disconnect (SIGNAL(collapsed (QListViewItem *))/*, listview*/);
		listview->disconnect (SIGNAL(expanded (QListViewItem *))/*, listview*/);
	}
	else
	{
		tree = true;
		connect (listview, SIGNAL(collapsed (QListViewItem *)), this, SLOT(slotParentCloseIcon(QListViewItem *)));
		connect (listview, SIGNAL(expanded (QListViewItem *)), this, SLOT(slotParentOpenIcon(QListViewItem *)));
	}
	listview->setRootIsDecorated(tree);
	viewallmp3();
}

void Mp3KultView::slotToggleFindInAllTree()
{
 findAll = (findAll == true)  ? false : true;
}

void Mp3KultView::slotTreeOpenAll()
{
	Mp3ListItem* item;

	item = (Mp3ListItem*) listview->firstChild();

	while(item)
	{
		item->setOpen(true);
		item = (Mp3ListItem*) item->nextSibling();
	}
}

void Mp3KultView::slotTreeCloseAll()
{
	Mp3ListItem* item;

	item = (Mp3ListItem*) listview->firstChild();

	while(item)
	{
		item->setOpen(false);
		item = (Mp3ListItem*) item->nextSibling();
	}
}

void Mp3KultView::slotParentOpenIcon(QListViewItem *item)
{
	item->setPixmap(0, BarIcon("folder_green_open", KIcon::SizeSmall));
}

void Mp3KultView::slotParentCloseIcon(QListViewItem *item)
{
	item->setPixmap(0, BarIcon("folder_green", KIcon::SizeSmall));
}
/*
void Mp3KultView::slotSaveTreeStatus()
{
	Mp3ListItem* item;
	KConfig* config;
	QValueList<int> lst;

	config = kapp->config();
	config->setGroup("View");
	item = (Mp3ListItem*) listview->firstChild();

	while(item)
	{
		lst << item->isOpen();
		item = (Mp3ListItem*) item->nextSibling();
	}
	config->writeEntry("TreeStatus", lst);
	cerr << "Tree status saved" << endl;
}

void Mp3KultView::slotLoadTreeStatus()
{
	Mp3ListItem* item;
	KConfig* config;
	QValueList<int> lst;

	config = kapp->config();
	config->setGroup("View");
	config->readIntListEntry("TreeStatus");

	item = (Mp3ListItem*) listview->firstChild();

	while(item)
	{
		lst << item->isOpen();
		item = (Mp3ListItem*) item->nextSibling();
	}
	config->writeEntry(lst);
	cerr << "Tree status saved" << endl;
}
*/

#include "mp3kultview.moc"
