/*

    mp_msg_en.h

    English messages.

    mp - Programmer Text Editor

    Copyright (C) 1991-2000 Angel Ortega <angel@triptico.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    http://www.triptico.com

*/

#define MSG_UNNAMED	 "<unnamed>"
#define MSG_TEXTTOSEEK	 "Text to seek: "
#define MSG_TAGTOSEEK	 "Tag to seek: "
#define MSG_NOTFOUND	 "Text not found."
#define MSG_TAGNOTFOUND  "Tag(s) not found."
#define MSG_FILENAME	 "Enter file name: "
#define MSG_SAVECHANGES  "File has changed. Save changes?"
#define MSG_FILENOTFOUND "File '%s' not found."
#define MSG_CANTWRITE	 "Can't create file '%s'."
#define MSG_YESNO	 " [Y/N]"
#define MSG_ENTER	 " [ENTER]"
#define MSG_HELP	 "<help about '%s'>"
#define MSG_LOADING	 "LOADING"
#define MSG_LINETOGO	 "Line to go to: "
#define MSG_NOHELPFOR	 "No help for '%s'"
#define MSG_REPLACETHIS  "Replace text: "
#define MSG_REPLACEWITH  "Replace with: "
#define MSG_TOENDOFFILE  "To end of file?"
#define MSG_YES 	 "Y"
#define MSG_NO		 "N"
#define MSG_KEYHELP	 "<help on keys>"
#define MSG_ABOUT	 "<about Minimum Profit>"
#define MSG_EXEC	 "System command: "
#define MSG_CANTEXEC	 "Error executing command."
#define MSG_WORDWRAP	 "Word wrap on column (0, no word wrap): "
#define MSG_TABSIZE	 "Tab size: "
#define MSG_BADMODE	 "Bad mode. Available modes:"
#define MSG_TMPLNOTFOUND "Template file not found (%s)"
#define MSG_SELECTTMPL	 "Select template"
#define MSG_TAGLIST	 "Tag list"
#define MSG_OPENLIST	 "Open documents"
#define MSG_DEFAULTHINT  "^A Menu"
#define MSG_CANCELHINT	 "^N Cancel"

#define MSG_MENU10	 "&File"
#define MSG_MENU11	 "&New\tF5"
#define MSG_MENU12	 "&Open...\tF3"
#define MSG_MENU13	 "&Reopen..."
#define MSG_MENU14	 "&Save...\tF2"
#define MSG_MENU15	 "Save &As..."
#define MSG_MENU16	 "&Close\tF4"
#define MSG_MENU17	 "E&xit\tCtrl-X"

#define MSG_MENU20	 "&Edit"
#define MSG_MENU21	 "&Copy\tCtrl-D"
#define MSG_MENU22	 "Cu&t\tCtrl-T"
#define MSG_MENU23	 "&Paste\tCtrl-V"
#define MSG_MENU24	 "&Delete Line\tCtrl-Y"
#define MSG_MENU25	 "Edit &template file"
#define MSG_MENU26	 "&System command..."

#define MSG_MENU30	 "&Search"
#define MSG_MENU31	 "&Search...\tCtrl-B"
#define MSG_MENU32	 "Search &Next\tCtrl-L"
#define MSG_MENU33	 "&Replace...\tCtrl-R"
#define MSG_MENU34	 "R&eplace in all..."
#define MSG_MENU35	 "&Case Sensitive"
#define MSG_MENU36	 "Search &Tag...\tCtrl-F"

#define MSG_MENU40	 "&Go to"
#define MSG_MENU41	 "&Next\tF6"
#define MSG_MENU42	 "&Begin\tCtrl-W"
#define MSG_MENU43	 "&End\tCtrl-E"
#define MSG_MENU44	 "Be&gining of line\tHome"
#define MSG_MENU45	 "E&nd of line\tEnd"
#define MSG_MENU46	 "&go to line\tCtrl-G"
#define MSG_MENU47	 "Ne&xt word\tCtrl-K"
#define MSG_MENU48	 "&Last word\tCtrl-L"
#define MSG_MENU49	 "&Document list\tCtrl-O"

#define MSG_MENU50	 "&Options"
#define MSG_MENU51	 "&Save tabs"
#define MSG_MENU52	 "S&ave LF as CR/LF"
#define MSG_MENU53	 "Auto &Indent"
#define MSG_MENU54	 "&Mark 80th column"
#define MSG_MENU55	 "&Tab size..."
#define MSG_MENU56	 "&Word wrap..."
#define MSG_MENU57	 "&Help on keys"
#define MSG_MENU58	 "A&bout..."

#define HELP_TEXT "\
+------------------------------------------------------------------+\n\
| Minimum Profit - Keys 					   |\n\
+----------+-------------------------------------------------------+\n\
|  F1	   |   Help for word under cursor			   |\n\
|  F2	   |   Save file					   |\n\
|  F3	   |   Open file					   |\n\
|  F4	   |   Close file					   |\n\
|  F5	   |   New file 					   |\n\
|  F6	   |   Next file					   |\n\
|  F7	   |   Play macro					   |\n\
|  F8	   |   Unmark block					   |\n\
|  F9	   |   Mark beginning / end of block			   |\n\
|  F10	   |   Record macro					   |\n\
|  UP	   |   Line up						   |\n\
|  DOWN    |   Line down					   |\n\
|  LEFT    |   Character left					   |\n\
|  RIGHT   |   Character right					   |\n\
|  HOME    |   Beginning of line				   |\n\
|  END	   |   End of line					   |\n\
|  PGUP    |   Page Up						   |\n\
|  PGDN    |   Page Down					   |\n\
|  INS	   |   Toggle insert / overwrite mode			   |\n\
|  DEL	   |   Delete char over the cursor			   |\n\
|  BACKSPC |   Delete char to the left of the cursor		   |\n\
|  ESC	   |   Activate control mode				   |\n\
|  TAB	   |   Tab						   |\n\
|  F11	   |   Decrease font size (win32 only)			   |\n\
|  F12	   |   Increase font size (win32 only)			   |\n\
|  ^F12    |   Maximize window (win32 only)			   |\n\
+----------+-------------------------------------------------------+\n\
| Control mode							   |\n\
| Control mode is activated by typing ctrl+key or Alt+key	   |\n\
| simultaneously, in the environments where this works. It can be  |\n\
| also activated by typing Esc and next the key.		   |\n\
+----------+-------------------------------------------------------+\n\
|  0-9	   |   Equivalent to function keys F10-F1-F2...F9	   |\n\
|  A	   |   Drop down menu					   |\n\
|  B	   |   Search text					   |\n\
|  C	   |   Copy block					   |\n\
|  D	   |   Copy block					   |\n\
|  E	   |   Beginning of document				   |\n\
|  F	   |   Search tag					   |\n\
|  G	   |   Goto line					   |\n\
|  H	   |   Delete char to the left of the cursor		   |\n\
|  I	   |   Tab						   |\n\
|  J	   |   Word left					   |\n\
|  K	   |   Word right					   |\n\
|  L	   |   Search next					   |\n\
|  M	   |   RETURN						   |\n\
|  N	   |   Activate control mode				   |\n\
|  O	   |   Show list of open documents			   |\n\
|  P	   |   Paste block					   |\n\
|  Q	   |   Cut block					   |\n\
|  R	   |   Search and replace				   |\n\
|  S	   |   Tag completion					   |\n\
|  T	   |   Cut block					   |\n\
|  U	   |   Insert template					   |\n\
|  V	   |   Paste block					   |\n\
|  W	   |   End of document					   |\n\
|  X	   |   Exit						   |\n\
|  Y	   |   Delete line					   |\n\
|  UP	   |   Page up						   |\n\
|  DOWN    |   Page down					   |\n\
|  LEFT    |   Word left					   |\n\
|  RIGHT   |   Word right					   |\n\
|  HOME    |   Beginning of document				   |\n\
|  END	   |   End of document					   |\n\
+----------+-------------------------------------------------------+\n\
| Read line mode						   |\n\
| (file names, text to search, etc.)				   |\n\
+----------+-------------------------------------------------------+\n\
|  ENTER   |   Validate 					   |\n\
|  ESC	   |   Cancel						   |\n\
|  Ctrl-N  |   Cancel						   |\n\
|  Ctrl-U  |   Clear entry					   |\n\
|  UP	   |   Previous in history				   |\n\
|  DOWN    |   Next in history					   |\n\
|  BACKSPC |   Delete char to the left of the cursor		   |\n\
+----------+-------------------------------------------------------+"

#define USAGE_TEXT "\
Usage: mp [options] [file [file ...]]\n\
\n\
Options:\n\
\n\
 -t|--tag [tag] 	Edits the file where tag is defined\n\
 -w|--word-wrap [col]	Sets wordwrapping in column col\n\
 -ts|--tab-size [size]	Sets tab size\n\
 --alt-color		Alternative color set (more contrast)\n\
 --mouse		Activate mouse usage for cursor positioning\n\
 --col80		Marks column # 80\n\
 -hw|--hardware-cursor	Activates the use of hardware cursor\n\
 --version		Shows version\n\
 -h|--help		This help screen\n\
 -bw|--monochrome	Monochrome\n\
 -ai|--autoindent	Sets automatic indentation mode\n\
 -nt|--no-transparent	Disable transparent mode (eterm, aterm, etc.)\n\
 -m|--mode [mode]	Syntax-hilight mode. Available modes:\n\
			"

#define EMPTY_TEMPLATE "\
%%Empty template file\n\
\n\
This template file is empty. To create templates, write a name for\n\
each one (marked by two % characteres together in the beginning of\n\
the line) and a text body, delimited by the next template name\n\
or the end of file. By selecting a template from the list (popped up\n\
by Ctrl-U), it will be inserted into the current text.\n"
