/* These are the number of static items of button bar menu: change this if you
   change the menu */

#include "mgt.h"
/* define to 'x' to enable copious debug of this module */
#define d(x)  
#define rd(x) 
#define rrrd(x)
/* application preferences */
struct app_config_t app_config;
/* ======================== */

char *actions_list[]=
{
  "Shell->New Tab", "Shell->HSplit", "Shell->VSPlit", "Shell->New Window",
  "Root->New Tab", "Root->HSplit", "Root->VSplit", "Root->New Window",
  "mc->New Tab", "mc->HSplit", "mc->VSplit", "mc->New Window",
  "Switch To", "Go Right", "Go Left", "Remove Term", "Tab Right", "Tab Left", 
  "Change Title", "Search", "Search again",
  "Reset Terminal", "Reset and Clear", "New Window", 
  "Command->New Tab","Command->HSplit", "Command->VSplit", "Command->New Window",
  "New tab with...", "Split Horiz. with...", "Split Vert. with...", "View Horiz. of...",
  "View Vert. of...", "All bonded", "All unbonded", "Save Terminals",
  "Next terminal in tab", "Prev terminal in tab", "Escape Sequence", 
  "Adjust size", "New Term Menu", "Right Click Menu", "Sel. Mode Off", "Terminal Help",
  NULL
};

/* g.o */
/* this typedef has the purpose of keeping track of how many terms a tab holds
 * and what possition are they
 * */
typedef enum {
	TOP,
	BOTTOM,
	BOTH
} VPanedContents;


extern void add_tabprofiles(gpointer* moreinfo, GtkWidget* app, GSList** ptl, int *active);
extern void add_winprofiles(gpointer* moreinfo, GtkWidget* app, GSList** ptl, int *active);
extern GnomeUIInfo tab_radio_item[];
extern GnomeUIInfo win_radio_item[];
extern void save_tabs(char* prefix, GtkWidget* app);

extern char * trunc_string (char * s, int len);

extern void
terminal_config_free (struct terminal_config *cfg);
extern void
on_add_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data);
extern void
su_add_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data);


extern void
on_remove_button_clicked               (GtkButton       *button,
                                        gpointer         user_data);

extern void on_del_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data);
extern void on_chg_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data);


extern void
on_cancel_button_clicked               (GtkButton       *button,
                                        gpointer         user_data);
extern void
ec_destroy               (GtkButton       *button, gpointer user_data);

extern struct terminal_config *
terminal_config_dup (struct terminal_config *cfg);
extern void
title_changed(ZvtTerm *term, VTTITLE_TYPE type, char *newtitle);
extern void
gnome_term_set_font (ZvtTerm *term, char *font_name, char *boldfont_name,
		     const int use_bold);
extern void
terminal_kill (GtkWidget *widget, void *data);
void
term_change_pos(GtkWidget *widget);
extern int
button_press (GtkWidget *widget, GdkEventButton *event, ZvtTerm *term);
extern void
get_shell_name (char **shell, char **name, gboolean isLogin);
extern void
show_pty_error_dialog (int errcode);
extern void
set_hints (GtkWidget *widget);
extern void
configure_term_dnd (ZvtTerm *term);
#ifdef COPY_CMD
extern void
configure_term_clipboard (ZvtTerm *term);
#endif
extern void
show_shell_error_dialog (int errcode);

extern GnomeUIInfo custom_submenu_void [];

extern void
set_color_scheme (ZvtTerm *term, struct terminal_config *color_cfg);
ZvtTerm* current_term(GSList** p_term_list);

/*
extern GtkWidget*
xzvt_term_new_with_size (int cols, int rows);

#include "xzvt.h"
extern int
xzvt_term_forkpty (xZvtTerm *x_term, int do_uwtmp_log);
*/

extern char **env;
extern char **environ;

extern char **env_copy;
extern int winid_pos;
extern int term_pos;


/* A list of all the open terminals */
extern GList *terminals;
/* This is the terminal associated with the initial command, or NULL
   if there isn't one.  */
extern GtkWidget *initial_term;
extern gboolean zvt_pixmap_support;

void free_str_array(char** ptr);
extern GnomeUIInfo gnome_terminal_toolbar[];
void set_tab_label(GtkNotebook* nb, GtkWidget* pane, int state);
void set_all_undefined(GSList** ptl);
#define cd(x) 
GSList* tab_terms_list(GtkWidget* tab)
{
#if 0
  GSList *tab_terms=NULL;
  gpointer botterm, topterm;
  /* here we create a fictitious list of terms in current tab */
  topterm = gtk_object_get_data(GTK_OBJECT(tab), "top");
  botterm = gtk_object_get_data(GTK_OBJECT(tab), "bottom");
  if (topterm)
    tab_terms = g_slist_append(tab_terms, topterm); 
  if (botterm)
    tab_terms = g_slist_append(tab_terms, botterm);
   /* ======================================================*/
#endif
  return *((GSList**)gtk_object_get_data(GTK_OBJECT(tab), "tab_terms"));
}

GtkWidget* tab_of(GtkWidget* w)
{
  return GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(w), "tab"));
}
int view_is_visible(GtkWidget* focusterm, GtkWidget* curterm)
{
  GSList** view_list, *vl;
  if (!curterm)
    return 0;
  view_list = gtk_object_get_data(GTK_OBJECT(curterm), "view_list");
  if (!view_list)
    return 0;
  vl = *view_list;
  while (vl)
    {
      /* if a view of term curterm is in the tab of focusterm
       * then consider curterm visible */
      if (tab_of(GTK_WIDGET(vl->data)) == tab_of(focusterm))
	return 1;
      vl = vl->next;
    }
  return 0;
}
void update_terms_state_in_tab(GtkWidget* tab, GtkWidget* focusterm)
{
  GSList *tab_terms=NULL, *tt; 
  int focus=0, *p_cur_state, *new_out;
  
  tab_terms = tab_terms_list(tab);

  if (focusterm && (gtk_object_get_data(GTK_OBJECT(focusterm),"tab") == tab))
    focus = 1

  cd(printf("in update terms state\n"));
  if (focus)
    {
      tt = tab_terms;     
      while (tt)
	{
	  if (!ZVT_IS_TERM(tt->data))
	    {
	      tt = tt->next;
	      continue;
	    }
	  new_out = gtk_object_get_data(GTK_OBJECT(tt->data), "new_out");
	  p_cur_state = gtk_object_get_data(GTK_OBJECT(tt->data), "term_state");
	  if (*p_cur_state == CHANGING || *p_cur_state == CHANGED)
	    {
	      cd(printf("curstate: %d -> VISIBLE\n",*p_cur_state));
	      *p_cur_state = VISIBLE;
	      *new_out = FALSE;
	    }
	  tt = tt->next;
	}
      return;
    }
  cd(printf("focus= %d tt=%p\n", focus, tab_terms));
  tt = tab_terms;
  while (tt)
    {
      new_out = gtk_object_get_data(GTK_OBJECT(tt->data), "new_out");
      p_cur_state = gtk_object_get_data(GTK_OBJECT(tt->data), "term_state");
      cd(printf("TERM: %p\n", tt->data));
      if (focusterm)
	{
	  if ( (ZVT_TERM(focusterm)->bonded &&
	        ZVT_TERM(tt->data)->bonded) ||
	       (ZVT_TERM(tt->data)->view_of 
	       && ZVT_TERM(focusterm) == ZVT_TERM(ZVT_TERM(tt->data)->view_of))
	       || view_is_visible(focusterm, GTK_WIDGET(tt->data)) ||
	       view_is_visible(focusterm, ZVT_TERM(tt->data)->view_of))
	    /* last condition is true if one of the views of the viewed term,
	     * which is ZVT_TERM(tt->data)->view_of, is visible */
	    {
	      *p_cur_state = VISIBLE;  
	      *new_out = FALSE;
	      tt =tt->next;
	      continue;
	    }
	}
      if (*new_out == TRUE) 
	{
	  if (*p_cur_state != CHANGING && *p_cur_state != UNDEFINED && 
	      *p_cur_state != VISIBLE)
	    { 
	      /* If terminal is not still changing or terminal and is not just opened
		 and terminal is not just switched then 
		 don't rewrite tab label */
	      cd(printf("cur_state: %d -> CHANGING!\n", *p_cur_state));
	      *p_cur_state = CHANGING;
	    }
	  else if (*p_cur_state == UNDEFINED)
	    {
	      cd(printf("cur_state: %d -> UNCHANGED\n", *p_cur_state));
	      *p_cur_state = UNCHANGED;
	    }
	  else if (*p_cur_state == VISIBLE)
	    {
	      /* If here the terminal was visible but actually not so
		 put it in UNCHANGED state */
	      cd(printf("cur_state:%d -> UNCHANGED\n", *p_cur_state));
	      *p_cur_state = UNCHANGED;
	    }
	  *new_out = FALSE;
	}	    
      else /* if (*new_out ==TRUE)...else */ 
	{
	  if (*p_cur_state == CHANGING)
	    {
	      cd(printf("curstate:%d -> CHANGED\n", *p_cur_state));
	      *p_cur_state = CHANGED;
	    }
	  else if ((*p_cur_state != CHANGED) && (*p_cur_state != UNCHANGED) )
	    {
	      cd(printf("NOOUTPUT state:%d -> UNCHANGED\n", *p_cur_state));
	      *p_cur_state = UNCHANGED;
	    }
	}
      tt = tt->next;	
    }
}

int get_tab_state(GtkWidget* tab)
{
  GSList *tabs_terms, *tt;
  int state, *tstate;
  tabs_terms = tab_terms_list(tab);
  tt = tabs_terms;
  state = UNCHANGED;
  while (tt)
    {
      tstate = gtk_object_get_data(GTK_OBJECT(tt->data), "term_state");
      if (*tstate == CHANGED)
	{
	  state = CHANGED;
	}
      else if (*tstate == CHANGING)
	{
	  state = CHANGING;
	  break;
	}
      tt = tt->next;
    }
  return state;
}
int check_changed_buffers(gpointer data)
{
  /* check all terminal state:
     this a simply state machine */
  GtkWidget *app, *tab, *focusterm=NULL;
  GSList **tabl, *pl, **ptl, *tl;
  GList *lapp;
  int *isres;
  GtkNotebook* nb = NULL;
  static int first_times = 3;

  if (first_times > 0)
    {
      first_times--;
      return 1;
    }

  lapp = terminals;
  while (lapp)
    {
      app = GTK_WIDGET(lapp->data);
      ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
      isres = gtk_object_get_data(GTK_OBJECT(app), "is_a_resize");
      if (*isres) {
	set_all_undefined(ptl);
	*isres = FALSE;
	lapp = lapp->next;
	continue;
      }

      nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");      
      tabl = gtk_object_get_data(GTK_OBJECT(app), "tablist");
    
      tl = *ptl;
      focusterm = GTK_WIDGET(current_term(ptl));
#if 0 
      focusterm = NULL;
      while (tl)
	{
	  if (!ZVT_IS_TERM(tl->data))
	    {
	      tl = tl->next;
	      continue;
	    }
	  if (GTK_WIDGET_HAS_FOCUS(GTK_WIDGET(tl->data)))
	    {
	      focusterm = GTK_WIDGET(tl->data);
	      break;
	    }
	  tl = tl->next;
	}
#endif
      pl = *tabl;
      while (pl)
	{
	  if (pl->data)
	    {
	      tab = GTK_WIDGET(pl->data);
	      update_terms_state_in_tab(tab, focusterm);
	      set_tab_label(nb, tab, get_tab_state(tab));
	    }
	  pl = pl->next;
	}
      lapp = lapp->next;
    }
  return 1;
}

GtkStyle* tab_style[UNDEFINED+1];

GdkColor colors[] = {
        {0, 0xcf3c, 0xcf3c, 0xcf3c}, /* 0  white */
        {0, 0x0000, 0x0000, 0x0000}, /* 1  black */
        {0, 0x0000, 0x0000, 0xcccc}, /* 2  blue */
        {0, 0x0000, 0xcccc, 0x0000}, /* 3  green */
        {0, 0xdddd, 0x0000, 0x0000}, /* 4  red */
        {0, 0xaaaa, 0x0000, 0x0000}, /* 5  light red */
        {0, 0xbbbb, 0x0000, 0xbbbb}, /* 6  purple */
        {0, 0xffff, 0xaaaa, 0x0000}, /* 7  orange */
        {0, 0xeeee, 0xdddd, 0x2222}, /* 8  yellow */
        {0, 0x3333, 0xdede, 0x5555}, /* 9  green */
        {0, 0x0000, 0xcccc, 0xcccc}, /* 10 aqua */
        {0, 0x3333, 0xdddd, 0xeeee}, /* 11 light aqua */
        {0, 0x0000, 0x0000, 0xffff}, /* 12 blue */
        {0, 0xeeee, 0x2222, 0xeeee}, /* 13 light purple */
        {0, 0x7777, 0x7777, 0x7777}, /* 14 grey */
        {0, 0x9999, 0x9999, 0x9999}, /* 15 light grey */
        {0, 0xbe00, 0xbe00, 0xbe00}, /* 16 marktext Back (white) */
        {0, 0x0000, 0x0000, 0x0000}, /* 17 marktext Fore (black) */
        {0, 0xcf3c, 0xcf3c, 0xcf3c}, /* 18 foreground (white) */
        {0, 0x0000, 0x0000, 0x0000}, /* 19 background (black) */
};

void init_styles(GtkStyle* style, struct win_config* wincfg)
{
  int i;
  GdkColor c;
  for (i = 0; i < UNDEFINED + 1; i++)
    {
#ifdef DEFAULT_GTK_STYLE
      tab_style[i] = gtk_style_new();
      gdk_font_unref(tab_style[i]->font);
#else
      tab_style[i] = gtk_style_copy(style);
#endif
      if (i == CHANGING)
	{
	  c.pixel = 0;
	  c.red = wincfg->palette[0].red;
	  c.green = wincfg->palette[0].green;
	  c.blue = wincfg->palette[0].blue; 
	  tab_style[i]->fg[0] = c;/*black as default for all states!*/
	}
      else if (i == CHANGED)
	{
	   c.pixel = 0;
	   c.red = wincfg->palette[1].red;
	   c.green = wincfg->palette[1].green;
	   c.blue = wincfg->palette[1].blue; 
	   tab_style[i]->fg[0] = c;
	}
#ifdef DEFAULT_GTK_STYLE
      else
	tab_style[i]->fg[0] = style->fg[0];	
      tab_style[i]->font = style->font; 
      gdk_font_ref(tab_style[i]->font);
#endif
    }
  
}

void set_styles(struct win_config* wincfg)
{
  GdkColor c;
  c.pixel = 0;
  c.red = wincfg->palette[0].red;
  c.green = wincfg->palette[0].green;
  c.blue = wincfg->palette[0].blue; 
  tab_style[CHANGING]->fg[0] = c;/*black as default for all states!*/
  c.pixel = 0;
  c.red = wincfg->palette[1].red;
  c.green = wincfg->palette[1].green;
  c.blue = wincfg->palette[1].blue; 
  tab_style[CHANGED]->fg[0] = c;
}
#if 0
void
set_tab_color (GSList** ptl)
{
  GtkWidget* app, *label;
  GtkWidget* te, *page;
  GSList* tmp;
  GtkNotebook* nb;
  int *p_state, n, state;
  
  tmp = *ptl;
  te = GTK_WIDGET(tmp->data);
  app = gtk_widget_get_toplevel(te);
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  n = 0;
  while (tmp) 
    { 
      te = GTK_WIDGET(tmp->data);
      p_state = gtk_object_get_data(GTK_OBJECT(te), "term_state");
      page = gtk_notebook_get_nth_page(nb, n);
      label = gtk_notebook_get_tab_label(nb,page);
      printf("nb: %p label: %p *p_state: %d tab_style[*p_state].red:%d \n", 
	     nb, label, *p_state,
	     tab_style[*p_state]->fg[0].red);
      state = *p_state;
      gtk_widget_set_style(label, tab_style[state]);
      n++;
      tmp = tmp->next;
    }
}
#endif
/* FIXME: it doesn't work with g.o. patches!!!*/
void set_tab_label(GtkNotebook* nb, GtkWidget* term, int state);
void
set_tab_color (GtkWidget* term)
{
  GtkWidget *page, *label, *app;
  GtkNotebook* nb;
  int *p_state, state;
  
  app = gtk_widget_get_toplevel(term);
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  p_state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
  page = gtk_object_get_data(GTK_OBJECT(term), "pane"); 
  label = gtk_notebook_get_tab_label(nb, page);
  state = *p_state;
  /* need to go through normal style to switch to new color */
  set_tab_label(nb, page, UNCHANGED);
  set_tab_label(nb, page, state);
}

void set_tab_label(GtkNotebook *nb, GtkWidget* tab, int state)
{
  GtkWidget* label;
  
  label = gtk_notebook_get_tab_label(nb, tab);
  gtk_widget_set_style(GTK_WIDGET(label),tab_style[state]);
#if 0 
     te = current_term(ptl);
     gtk_widget_grab_focus(GTK_WIDGET(te));*/
#endif
}

/* callback for new output on terminals */
void new_output(ZvtTerm* term)
{
  GtkWidget* app, *nb;
  ZvtTerm *ct;
  GSList** ptl;
  int *p_state, *new_out;

  if (!term || !ZVT_IS_TERM(term))
    return;

  p_state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
  new_out = gtk_object_get_data(GTK_OBJECT(term), "new_out");
  
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  nb = (GtkWidget*)gtk_object_get_data(GTK_OBJECT(app), "notebook");
  ptl = (GSList**) gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
 
  ct = current_term(ptl);
  if (!ct || !ZVT_IS_TERM(ct))
    return;
  if (term == ct)
    return;
  if (*p_state != CHANGING)
    {
      /*set_tab_label(GTK_NOTEBOOK(nb), term, ptl, CHANGING);*/
    }

  *new_out = TRUE;
}

void remove_term(GtkWidget* term);

void store_backpix(GtkWidget* app, ZvtTerm* term, GdkPixmap* backpix)
{
  struct mgt_backpix *mgtbp;
  GSList *bpl;
  struct terminal_config *cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  if (!backpix)
    return;
  bpl = gtk_object_get_data(GTK_OBJECT(app), "backpix_list");
  rrrd(printf("term: %p storing: %p class:%s\n", term, backpix, cfg->class));
  mgtbp = g_malloc0(sizeof(struct mgt_backpix));
  mgtbp->class = g_strdup(cfg->class);
  mgtbp->backpix = backpix;
  bpl = g_slist_append(bpl, (gpointer)mgtbp);
  gtk_object_set_data(GTK_OBJECT(app), "backpix_list", bpl);
}

GdkPixmap* lookup_backpix(GtkWidget* app, ZvtTerm *term)
{
  GSList *bpl;
  struct mgt_backpix *mgtbp;
  struct terminal_config *cfg;
  
  bpl = gtk_object_get_data(GTK_OBJECT(app), "backpix_list");
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  
  rrrd(printf("term: %p searching backpix of class:%s bpl_len: %d", term, cfg->class,
	 g_slist_length(bpl)));
  while (bpl)
    {
      mgtbp = ((struct mgt_backpix*)(bpl->data));
      if (!strcasecmp(cfg->class, mgtbp->class))
	{
	  rrrd(printf("...FOUND %p\n", mgtbp->backpix));
	  return mgtbp->backpix;
	}
      bpl = bpl->next;
    }
  rrrd(printf("...NOT FOUND\n"));
  return NULL;
}
int backpix_in_use(GtkWidget* app, GtkWidget* tab, char* class)
{
  GSList **ptl, *l;
  GtkWidget *tabte;
  GtkWidget *te;
  struct terminal_config *tecfg; 
  /* if there isn't another terminal
   * with same class then free backpix */
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  l = *ptl;
  while (l)
    {
      te = GTK_WIDGET(l->data);
      tecfg = gtk_object_get_data(GTK_OBJECT(te), "config");
      tabte = gtk_object_get_data(GTK_OBJECT(te), "tab"); 
      if (!strcasecmp(class, tecfg->class) && (tabte != tab)) 
	{
	  rrrd(printf("backpix used!\n"));
	  return 1;
	}
      l=l->next;
    }
  rrrd(printf("back pix not in use\n"));
  return 0;  
}
int term_same_class(GtkWidget* te1, GtkWidget *te2)
{
  struct terminal_config *cfg1, *cfg2;
  cfg1 = gtk_object_get_data(GTK_OBJECT(te1), "config");
  cfg2 = gtk_object_get_data(GTK_OBJECT(te2), "config");
  if (!strcasecmp(cfg1->class, cfg2->class))
    return 1;
  else
    return 0;
}
void remove_backpix(GtkWidget *app, ZvtTerm *term, GdkPixmap* backpix)
{
  GSList *bpl, *l;
  struct mgt_backpix *mgtbp;
  struct terminal_config *cfg;

  l = bpl = gtk_object_get_data(GTK_OBJECT(app), "backpix_list");
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");

  rrrd(printf("term: %p removing: %p class:%s\n", term, backpix, cfg->class));
  while (l)
    {
      mgtbp = ((struct mgt_backpix*)(l->data));
      if (mgtbp->backpix == backpix)
	{
	  rrrd(printf("....REMOVED\n"));
	  if (mgtbp->class)
	    g_free(mgtbp->class);
	  bpl = g_slist_remove(bpl, mgtbp);
	  break;
	}
      l = l->next;
    }
    
  gtk_object_set_data(GTK_OBJECT(app), "backpix_list", bpl);
}

void destroy_pixmap(GtkWidget* app, gchar* str)
{
  GdkPixmap *pix;
  GtkWidget *pixw;
  pixw = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(app), str));
  pix = GNOME_PIXMAP(pixw)->pixmap;
  ((GdkWindowPrivate*)pix)->ref_count = 1;
  gdk_pixmap_unref(pix);
  GNOME_PIXMAP(pixw)->pixmap = NULL;
  gtk_widget_destroy(pixw);

}
extern void
win_config_free (struct win_config *wincfg);

void ok_close_app(GtkWidget* app)
{
  char **su_names, **su_paths, **su_cmds;
  preferences_t *prefs;
  GSList *tmp, **p_term_list, **tab_list, *tl, **tab_terms,
  **view_list, *vl;
  GdkPixmap *backpix;
  GtkWidget* term, *vterm, *mainmenu, *mbw, *tab;
  char* termname, *termtitle, *class;
  struct terminal_config* cfg;
  struct win_config *wincfg;
  gchar *prefix;
  GnomeUIInfo* sm;
  GnomeUIInfo* radioinfo;
  GtkItemFactory *item_factory;
  GtkItemFactoryEntry* cm;
  int x, *state, *new_out, *isres;
  struct stored_sdata* sdata;

  terminals = g_list_remove (terminals, app);
  /* FIXME: this should free the config info for the window */
  
  if (app == initial_term)
    initial_term = NULL;
 
  /* WARNING:
     Here must free all memory allocated for the current window(GnomeApp) */
  
  p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  /* remove all resources related to terminals */
  tmp= *p_term_list;
  
  /* term = GTK_WIDGET(tmp->data); */
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  prefix = g_strdup_printf("/MultiTerminal/%s/", wincfg->class);;
  if (wincfg->autosavetabs)
    save_tabs(prefix, app);
   
  g_free(prefix);
  
  win_config_free(wincfg);
  
  /* get prefs from first terminal if p_term_list */
  /*prefs =  gtk_object_get_data((GtkObject*)(*p_term_list)->data,"prefs");*/
  prefs =  gtk_object_get_data(GTK_OBJECT(app),"prefs");
  
  /* remove array containing custom commands and their (menu) names */
#if 1 
  su_names = (char**) gtk_object_get_data(GTK_OBJECT(app), "su_names");
  free_str_array(su_names);
  su_paths = (char**) gtk_object_get_data(GTK_OBJECT(app), "su_paths");
  free_str_array(su_paths);
  su_cmds = (char**) gtk_object_get_data(GTK_OBJECT(app), "su_cmds");
  free_str_array(su_cmds);
#endif
  isres = gtk_object_get_data(GTK_OBJECT(app), "is_a_resize");
  g_free(isres);

  sdata = gtk_object_get_data(GTK_OBJECT(app), "search_data");
  if (sdata)
    {
      if (sdata->text)
	g_free(sdata->text);
      g_free(sdata);
    }
  /* <<<< NEW FREE START ============================================ */
  sm = (GnomeUIInfo*) gtk_object_get_data(GTK_OBJECT(app), "custom_submenu");
  if (sm)
    {
      int x;
      x = 0;
      while (sm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  free(sm[x].user_data);
	  x++; 
	}	
      free(sm);
    }
  /* popup commands factory widget */
  mainmenu = gtk_object_get_data(GTK_OBJECT(app), "popup_factory_widget"); 
  if (mainmenu)
    item_factory = gtk_item_factory_from_widget(mainmenu);
  else
    item_factory = NULL;

  cm = gtk_object_get_data(GTK_OBJECT(app), "popup_factory");
  if (cm)
    {
      x = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), "popup_num_hardset"));
      while(cm[x].path)
	{
	  free(cm[x].path);
	  x++;
	}
      free(cm);
    }
  if (item_factory)
    gtk_object_unref(GTK_OBJECT(item_factory));

  mainmenu = gtk_object_get_data(GTK_OBJECT(app), "menubar_factory_widget"); 
  if (mainmenu)
    item_factory = gtk_item_factory_from_widget(mainmenu);
  else
    item_factory = NULL;

  cm = gtk_object_get_data(GTK_OBJECT(app), "menubar_factory");
#if 0
  if (item_factory)    
    printf("item factory ref_count:%d\n", GTK_OBJECT(item_factory)->ref_count);
  else
    printf("item factory NULL :(\n");
#endif
#if 0
  if (item_factory)
    {
#if 0
      x = 0;
      while(cm[x].path)
	x++;
      gtk_item_factory_delete_entries(item_factory, x, cm);
#else
      gtk_item_factory_delete_item(item_factory, "<main>");
#endif
    }
#endif
#if 0 
  if (mainmenu)
    gtk_widget_destroy(mainmenu);
  submenu = gtk_object_get_data(GTK_OBJECT(app), "menubar_submenu_widget");
  if (submenu)
    gtk_widget_destroy(submenu);
#endif
  if (cm)
    {
      x = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), "menu_num_hardset"));
      while(cm[x].path)
	{
	  free(cm[x].path);
	  x++;
	}
      free(cm);
    }
  if (item_factory)
    gtk_object_unref(GTK_OBJECT(item_factory));

  mbw = gtk_object_get_data(GTK_OBJECT(app), "butmenu_widget");
  if (mbw)
    item_factory = gtk_item_factory_from_widget(mbw);
  else
    item_factory = NULL;
#if 0
  if (item_factory)    
    printf("item factory ref_count:%d\n", GTK_OBJECT(item_factory)->ref_count);
  else
    printf("item factory NULL :(\n");
#endif
  cm = gtk_object_get_data(GTK_OBJECT(app), "buttonbar_menu");
#if 0
  if (item_factory)
    {
#if 0
      x = 0;
      while(cm[x].path)
	x++;
     gtk_item_factory_delete_entries(item_factory, x, cm);
#else
     gtk_item_factory_delete_item(item_factory, "<main>");
#endif

    }
#endif
  if (cm)
    {
      x = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), "but_num_hardset"));
      while(cm[x].path)
	{
	  free(cm[x].path);
	  x++;
	}
      free(cm);
    }
  if (item_factory)
    {
      gtk_object_unref(GTK_OBJECT(item_factory));
    }
  radioinfo = gtk_object_get_data(GTK_OBJECT(app), "win_radio_item");
  if (radioinfo)
    {
#if 1
      GnomeUIInfo* cm = (GnomeUIInfo*) radioinfo;
      int x = 0;
      while (cm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  g_free(cm[x].label);
	  x++;
	}
#endif
      g_free(radioinfo);
    }
  radioinfo = gtk_object_get_data(GTK_OBJECT(app), "tab_radio_item");
  if (radioinfo)
    {
#if 1
      GnomeUIInfo* cm = (GnomeUIInfo*) radioinfo;
      int x = 0;
      while (cm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  g_free(cm[x].label);
	  x++;
	}
#endif
      g_free(radioinfo);
    }
  tab_list = (GSList**) gtk_object_get_data(GTK_OBJECT(app), "tablist");
  tl = *tab_list;
  while (tl)
    {
      tab = GTK_WIDGET(tl->data);
      tab_terms = (GSList**) gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
      if (*tab_terms)
	g_slist_free(*tab_terms);
      g_free(tab_terms);  
      tl = tl->next;
    }
  if (*tab_list) 
    g_slist_free(*tab_list);
  g_free(tab_list);

  /* >>>>> NEW FREE END ================================ */ 
  tmp = *p_term_list;
  while(tmp)
    {
      term = GTK_WIDGET(tmp->data); 
      /* remove also all views of term: we need to do this! */
      view_list = gtk_object_get_data(GTK_OBJECT(term), "view_list");
      if (view_list)
	{
	  /* FIXME: *viewlist NULL causes a crash?!? */
	  vl = g_slist_copy(*view_list);
	  /* remove also all views of term which are not in the actual window */
	  while (vl)
	    {
	      if (gtk_widget_get_toplevel(GTK_WIDGET(vl->data))!=GTK_WIDGET(app))
		remove_term(GTK_WIDGET(vl->data));
	      vl = vl->next;
	    }
	  g_slist_free(*view_list);
	  g_slist_free(vl);
	  g_free(view_list);
	}
      /* if it is a view remove itself from view list of terminal viewed */
      if (ZVT_TERM(term)->view_of)
	{
	  vterm = ZVT_TERM(term)->view_of;
	  if (gtk_widget_get_toplevel(vterm) != GTK_WIDGET(app))
	    {
	      view_list = gtk_object_get_data(GTK_OBJECT(vterm), "view_list"); 
	      *view_list = g_slist_remove(*view_list, term);
	    }
	}
      cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
      terminal_config_free(cfg);
      termname = gtk_object_get_data(GTK_OBJECT(term), "mtermname"); 
      termtitle = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
      new_out = gtk_object_get_data(GTK_OBJECT(term), "new_out");
      state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
      /*zvt_term_killchild(ZVT_TERM(term), SIGKILL);
	zvt_term_closepty(ZVT_TERM(term));*/
      ZVT_TERM(term)->background.pix = NULL;
      g_free(state);
      g_free(new_out);
      g_free(termname);
      g_free(termtitle);
      tmp = tmp->next;
    }
  
  if (prefs && !terminals)
    gtk_object_destroy(GTK_OBJECT(prefs->prop_win));

  g_slist_free(*p_term_list);
  
  /* destroy pixmap if allocated */ 
  tmp = gtk_object_get_data(GTK_OBJECT(app), "backpix_list");
  while (tmp)
    {
      /*backpix = gtk_object_get_data(GTK_OBJECT(app), "backpix");*/
      backpix = ((struct mgt_backpix*)(tmp->data))->backpix;
      class = ((struct mgt_backpix*)(tmp->data))->class;
      if (class)
	g_free(class);
      if (backpix)
	{
	  ((GdkWindowPrivate*)backpix)->ref_count = 1;
	  gdk_pixmap_unref(backpix);
	}
      tmp = tmp->next;
    }
  gtk_widget_destroy (app);
  if (terminals == NULL)
    gtk_exit(0); /*gtk_main_quit ();*/
  
}
void set_destroy_data(GtkWidget* app, GtkWidget* term);

/* ask for a confirm */
void cb_conf_close_app(gint reply, gpointer app)
{
  GSList** ptl;
  GtkWidget* term;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (!reply)
    {
      set_destroy_data(GTK_WIDGET(app), GTK_WIDGET((*ptl)->data));
      ok_close_app(GTK_WIDGET(app));   
    }
  else
    {
      term = GTK_WIDGET(current_term(ptl));
      gtk_widget_grab_focus(GTK_WIDGET(term));
    }
}
static void
grab_focus (GtkWidget* app)
{
  GtkWidget* term;
  GSList** l;
  l = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  term = GTK_WIDGET(current_term(l));
  gtk_widget_grab_focus(term);
}
static void
close_app (GtkWidget *app)
{
  GtkWidget *conf_win; /* ,*te; */
  GSList** ptl;
  struct win_config *wincfg;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  
  /*te = GTK_WIDGET((*ptl)->data);*/
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  if (!wincfg->close_confirm)
    {
      set_destroy_data(app, GTK_WIDGET((*ptl)->data));
      ok_close_app(GTK_WIDGET(app));
      return;
    }
  conf_win = gnome_ok_cancel_dialog_modal
    ("Close window and all its terminals?", cb_conf_close_app, 
     (gpointer) app);
}


void
close_window_cmd (void *unused, GSList **p_term_list)

{
        GtkWidget *term;
	GtkWidget *top;
       	
	term = GTK_WIDGET((*p_term_list)->data);
	top = gtk_widget_get_toplevel (GTK_WIDGET (term));
        /* cancella la lista con tutti i terminali creati */
	close_app(top);
	/*g_slist_free(*p_term_list);*/

}
void get_arrays_from_list(GtkCList *l , char ***na, char ***pa, char ***co, char ***cl);

void save_startuptabs(GtkWidget* app, gchar* winclass, GtkCList *l)
{
  int n;
  char **su_cmds, **su_names, **su_paths, **su_classes;
  /* startup tabs are saved on a perclass basis */
  char *prefix = g_strdup_printf ("/MultiTerminal/%s/", winclass);
  gnome_config_push_prefix (prefix);

  get_arrays_from_list(l, &su_names, &su_paths, &su_cmds, &su_classes);

  n = 0;
  while(su_names[n])
    n++;
  
  gnome_config_set_vector("su_cmds", n, (const char* const*) su_cmds);
  gnome_config_set_vector("su_paths", n, (const char* const*) su_paths); 
  gnome_config_set_vector("su_names", n, (const char* const*) su_names);
  gnome_config_set_vector("su_classes", n, (const char* const*) su_classes);  
  gnome_config_sync ();
  gnome_config_pop_prefix ();

  g_free (prefix);
}	 

void save_commands(GtkWidget* app, GtkCList* l)
{
  int n, i;
  char **cmds, **cmds_names, **cmds_paths, **cmds_classes;
  char *prefix = g_strdup_printf ("/MultiTerminal/Common/");
  char hs_str[NUM_HARDSET+2];
  gnome_config_push_prefix (prefix);
  get_arrays_from_list(l, &cmds_names, &cmds_paths, &cmds, &cmds_classes);
 
  n = 0;
  while(cmds_names[n])
    n++;
  gnome_config_set_vector("cmds", n, (const char* const*) cmds);
  gnome_config_set_vector("cmds_paths", n, (const char* const*) cmds_paths); 
  gnome_config_set_vector("cmds_names", n, (const char* const*) cmds_names);
  gnome_config_set_vector("cmds_classes", n, (const char* const*) cmds_classes);
  for (i = 0; i < NUM_HARDSET+1; i++)
    {
      hs_str[i] = (app_config.hardset_entries[i])?'1':'0';
    }
  hs_str[NUM_HARDSET+1] = '\0';
  gnome_config_set_string("hardset_entries", hs_str);
  gnome_config_sync ();
  gnome_config_pop_prefix ();
g_free (prefix);
}
ZvtTerm* current_term(GSList** p_term_list)
{
  /* g.o. -> function rewriten */
  GtkWidget *term, *tab, *app, *notebook,*active;
  int i;
  term = GTK_WIDGET((*p_term_list)->data);
  if (!term || !ZVT_IS_TERM(term))
    return NULL;
  app = gtk_widget_get_toplevel (term);
  notebook= gtk_object_get_data (GTK_OBJECT(app), "notebook"); 
  i = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
  tab = gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), i);
  active = gtk_object_get_data (GTK_OBJECT (tab), "active");
  return (active && ZVT_IS_TERM(active))?ZVT_TERM(active):NULL;
}

void new_term_in_window(char** cmd, struct terminal_config *cfg_in, const gchar *geometry, int termid, GSList** p_term_list, char* nome_term, char* start_dir);
void new_shell(GSList** ptl, guint action);
void new_shell_vappend(GSList** p_term_list, guint action);
void new_shell_happend(GSList** p_term_list, guint action);
void new_root(GSList** ptl, guint action);
void new_mc(GSList** ptl, guint action);
void cb_conf_win(gint reply, gpointer data);

void tb_remove_book(GtkWidget *w, GSList** ptl)
{
  GtkNotebook* nb;
  GtkWidget *app, *term;
  GtkWidget *conf_win;

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(term);
  nb = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(app), "notebook"));
  if (g_slist_length(*ptl)==1)
    {
      close_app(app);
      return;
    }
  term = GTK_WIDGET(current_term(ptl)); 
  conf_win = gnome_ok_cancel_dialog_modal_parented
    ("Remove current term?", cb_conf_win, 
     (gpointer) term, GTK_WINDOW(app));
}

void button_next_page(GtkWidget* w);
void button_prev_page(GtkWidget* w);
/* g.o. */
/* this function sets the labels of all tabs with their correct numbers
 * an start and end index can be given if we do not need to set
 * all tabs, a value of 0 for the 'from_page' and 'to_page' parameters
 * mean that all tabs must be set
 * */
void set_titles (GtkWidget *app, int from_page, int to_page) 
{
  GtkWidget *label, *term, *tab, *nb;
  int pages, n;
  char txt[300], *tname;
  struct win_config *wincfg;
  GSList** tabl, *tmp;
  tabl = gtk_object_get_data (GTK_OBJECT(app), "tablist");
  nb = gtk_object_get_data (GTK_OBJECT (app), "notebook");
  pages = g_slist_length (*tabl) - 1;
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig"); 
  if (to_page) 
    pages = to_page;
  tmp = g_slist_nth (*tabl, from_page);
  if (from_page > pages)
    return;
  if (!wincfg){
    printf ("MGT Critical error: No wincfg in active term\n");
    gtk_exit (0);
  }
  
  for (n = from_page; n <= pages; n++)
    {
      tab = GTK_WIDGET (tmp->data);
      if (!tab){
	      printf ("MGT Critical error: No tab in tab\n");
	      gtk_exit (0);
      }
      term = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (tab), "active"));
      if (!term){
	      printf ("MGT Cristianl error: No active term\n");
	      gtk_exit (0);
      }
      if (wincfg->titled_tabs)
	{
	  tname = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
	}
      else
	tname = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
      if (wincfg->no_numprefix)
	sprintf(txt, "%s", tname);
      else
	sprintf(txt, "%d-%s", n+1, tname);
      if (wincfg->titled_tabs)
	trunc_string(txt, wincfg->maxch);

      label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(nb), GTK_WIDGET(tab));
      gtk_label_set_text(GTK_LABEL(label),txt);
      label = gtk_notebook_get_menu_label(GTK_NOTEBOOK(nb), GTK_WIDGET(tab));
      gtk_label_set_text(GTK_LABEL(label), txt);

      tmp = tmp->next;
    }
}

void move_tab_right(GtkNotebook* nb)
{
  /* g.o. this function has changed quite a bit */
  GtkWidget *term, *curvp, *app;
  GSList **tabl;	  
  int curpg, l, newpg;

  app = gtk_widget_get_toplevel(GTK_WIDGET(nb));
  tabl = gtk_object_get_data(GTK_OBJECT(app), "tablist");
  curpg  = gtk_notebook_get_current_page(nb);
  curvp = gtk_notebook_get_nth_page(nb, curpg);

  l = g_slist_length(*tabl);
  if (curpg+1>=l)
    newpg = 0;
  else
    newpg = curpg+1;

  *tabl = g_slist_remove(*tabl, curvp);
  *tabl = g_slist_insert(*tabl, curvp, newpg); 
  gtk_notebook_reorder_child(nb, curvp, newpg);

  if (newpg)
    set_titles (app, curpg, newpg);
  else
    set_titles (app, 0, 0);

  term = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (curvp), "active"));
  gtk_widget_grab_focus (term);
}

void move_tab_left(GtkNotebook* nb)
{
  /* g.o. this function has changed quite a bit */
  GtkWidget *term, *curvp, *app;
  GSList **tabl;
  int curpg, l, newpg;

  app = gtk_widget_get_toplevel(GTK_WIDGET(nb));
  tabl = gtk_object_get_data(GTK_OBJECT(app), "tablist");
  curpg  = gtk_notebook_get_current_page(nb);
  curvp = gtk_notebook_get_nth_page(nb, curpg);

  l = g_slist_length(*tabl);
  if (!curpg)
    newpg = l - 1;
  else
    newpg = curpg - 1;

  *tabl = g_slist_remove(*tabl, curvp);
  *tabl = g_slist_insert(*tabl, curvp, newpg); 
  gtk_notebook_reorder_child(nb, curvp, newpg);

  if (curpg)
    set_titles (app, newpg, curpg);
  else 
    set_titles (app, 0, 0);

  term = GTK_WIDGET (gtk_object_get_data (GTK_OBJECT (curvp), "active"));
  gtk_widget_grab_focus (term);
}


void butcb_move_left(GtkWidget* w, gpointer data)
{
  move_tab_left(GTK_NOTEBOOK(data));
}

void butcb_move_right(GtkWidget* w, gpointer data)
{
  move_tab_right(GTK_NOTEBOOK(data));
}


void tb_tab_left(GtkWidget* w, GSList** ptl)
{ 
  GtkNotebook* nb;
  GtkWidget *app, *term;

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(term);
  nb = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(app), "notebook"));

  move_tab_left(GTK_NOTEBOOK(nb));

}

void tb_tab_right(GtkWidget* w, GSList** ptl)
{ 
  GtkNotebook* nb;
  GtkWidget *app, *term;

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(term);
  nb = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(app), "notebook"));
  move_tab_right(GTK_NOTEBOOK(nb));
}

void change_title(GtkWidget* w, gpointer data);

void tb_bonded(GtkWidget *w, GSList** ptl)
{
  GSList* tl;
  gnome_app_warning(GNOME_APP(gtk_widget_get_toplevel(GTK_WIDGET((*ptl)->data))), 
		    "All input will be now sent to all terminals in current window!");
  tl =*ptl;
  while(tl)
    {
      ZVT_TERM(tl->data)->bonded = 1;
      tl = tl->next;
    }
}

void tb_unbonded(GtkWidget *w, GSList** ptl)
{
  GSList* tl;
  tl =*ptl;
  while(tl)
    {
      ZVT_TERM(tl->data)->bonded = 0;
      tl = tl->next;
    }
}


void tb_save_tabs(GtkWidget* w, GSList** ptl)
{
  gchar* prefix;
  GtkWidget* app, *term;
  struct win_config* wincfg;

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(term);
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  prefix = g_strdup_printf("/MultiTerminal/%s/", wincfg->class);
  save_tabs(prefix, app);
}
void tb_change_title(GtkWidget* w, GSList** ptl)
{ 
  gpointer nb;
  GtkWidget* app, *term;

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(term);
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  change_title(w, nb); 
}

void tb_new_shell(GtkWidget* w, GSList** ptl)
{
  new_shell(ptl, 0);
}

void tb_new_mc(GtkWidget* w, GSList** ptl)
{
  new_mc(ptl, 0);
}

void tb_new_root(GtkWidget* w, GSList** ptl)
{
  new_root(ptl, 0);
}


extern GnomeUIInfo gnome_terminal_terminal_menu [];
extern GnomeUIInfo gnome_terminal_menu[];
extern GnomeUIInfo gnome_terminal_edit[];
extern GnomeUIInfo gnome_terminal_help_menu[];
extern GnomeUIInfo gnome_terminal_settings_menu[];


#define COMMANDS_INDEX 5

void free_str_array(char** ptr)
{
  int x = 0;
  /* free both strings arrays */
  if (ptr == NULL)
    return;
  while(ptr[x])
    {
      free(ptr[x]);
      x++;
    }
  free(ptr);
}

struct menu_datas_struct {
  GtkWidget* app;
  char* name;
};
struct terminal_config * load_config (char *class);

void new_shell_with_command(GtkWidget* w, gpointer data)
{
  /* data is the name of the command to be executed in the new terminal */
  /* deve creare una nuova shell con il comando contenuto in data */
  GtkWidget* app;
  GtkWidget* term;
  char *prefix, **cmds, **cmds_names, *buf, **cmds_paths, **cmds_classes;
  /* the command string is not longer than 128 bytes so this value(256) is enough! */
  char* cmd[256];
  struct terminal_config* cfg;
  int i, x;
  struct menu_datas_struct* md;
  GSList** ptl;
  
  md = (struct menu_datas_struct*) data;
  
  app = md->app;

  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  term = GTK_WIDGET((*ptl)->data);

  cmds = app_config.cmds;
  cmds_names = app_config.cmds_names;
  cmds_paths = app_config.cmds_paths;
  cmds_classes = app_config.cmds_classes;
  
  x = 0;
  while(cmds_names[x])
    {
      if (!strcmp(cmds_names[x], md->name))
	break;
      x++;
    }
  
  if (cmds_classes[x] && strcmp(cmds_classes[x],"None"))
    {
      char *tclass;
      if (!strcasecmp(cmds_classes[x], "Default"))
	tclass = g_strdup("Config");
      else
	tclass = g_strdup_printf("Class-%s", cmds_classes[x]);
      prefix = g_strdup_printf("/MultiTerminal/%s/", tclass);
      gnome_config_push_prefix(prefix);
      cfg = load_config(tclass);
      gnome_config_pop_prefix();	      
      g_free(prefix);
      g_free(tclass);
    }
  else 
    {
      cfg = terminal_config_dup(gtk_object_get_data (GTK_OBJECT (term), "config"));
    }


  buf = malloc((strlen(cmds[x])+1)*sizeof(char));
  strcpy(buf, cmds[x]);

  cmd[0] =  strtok(buf, " ");
  i = 1;
  while ((cmd[i] = strtok(NULL, " ")))
    i++;

  new_term_in_window(cmd, cfg, NULL, 1, ptl, cmds_names[x], cmds_paths[x]);
  free(buf);

}

void set_menu_user_data(GnomeUIInfo* m, GSList** ptl)
{
  int x = 0;
  while(m[x].type != GNOME_APP_UI_ENDOFINFO)
    {  
      if (m[x].type == GNOME_APP_UI_ITEM || 
	  m[x].type == GNOME_APP_UI_TOGGLEITEM)
	m[x].user_data = ptl;
      x++;
    }      
}

void set_all_menu_user_data(GSList** ptl)
{
  /* If you change menus change this !!! */
  set_menu_user_data(gnome_terminal_terminal_menu, ptl);
  set_menu_user_data(gnome_terminal_edit, ptl);
  set_menu_user_data(gnome_terminal_settings_menu, ptl);
  set_menu_user_data(gnome_terminal_help_menu, ptl);
}

void rebuild_buttonbar_menu( GtkWidget  *window);
void destroy_toolbar(GnomeApp* app);

void vsplit_with(GSList** ptl, guint action);
void hsplit_with(GSList** ptl, guint action);
void new_tab_with(GSList** ptl, guint action);
void new_shell_window(GSList** p_term_list, guint action);
void new_hmc(GSList** p_term_list, guint action);
void new_vmc(GSList** p_term_list, guint action);
void new_wmc(GSList** p_term_list, guint action);
void new_hroot(GSList** p_term_list, guint action);
void new_vroot(GSList** p_term_list, guint action);
void new_wroot(GSList** p_term_list, guint action);
void cb_hview(GSList** ptl, guint action);
void cb_vview(GSList** ptl, guint action);

/* change this if you change the button bar menu */
GtkItemFactoryEntry menu_items[] = {
    { "/MAIN",            NULL,  NULL, 0, "<Branch>" },
    { "/MAIN/Tearoff", NULL,  NULL, 0, "<Tearoff>" },
    { "/MAIN/Shell/New Tab",    "", new_shell, 0, NULL },
    { "/MAIN/Shell/HSplit", "", new_shell_happend, 0, NULL},
    { "/MAIN/Shell/VSplit", "", new_shell_vappend, 0, NULL},
    { "/MAIN/Shell/New Window", "", new_shell_window, 0, NULL},
    { "/MAIN/Root/New Tab",    "", new_root, 0, NULL },
    { "/MAIN/Root/HSplit",     "", new_hroot, 0, NULL},
    { "/MAIN/Root/VSplit",     "", new_vroot, 0, NULL},
    { "/MAIN/Root/New Window", "", new_wroot, 0, NULL},
    { "/MAIN/mc/New Tab",    "", new_mc, 0, NULL },
    { "/MAIN/mc/HSplit",    "", new_hmc,0, NULL },
    { "/MAIN/mc/VSplit",    "", new_vmc,0, NULL },
    { "/MAIN/mc/New Window",    "", new_wmc,0, NULL },
    { "/MAIN/Split/Horizontally with...", "", hsplit_with, 0, NULL},
    { "/MAIN/Split/Vertically with...", "", vsplit_with, 0, NULL},
    { "/MAIN/View/Horizontal of...", "", cb_hview, 0, NULL},
    { "/MAIN/View/Vertical of...", "",   cb_vview, 0, NULL},
    { "/MAIN/New tab with...", "", new_tab_with, 0, NULL},
    { "/MAIN/Separator", NULL, NULL, 0, "<Separator>" }
};

static gchar* attach_data_key = "gtk-menu-attach-data";
void new_shell_with_command_bb(GSList** ptl, gint action);

void rebuild_profiles(GnomeApp *app)
{
  struct terminal_config* cfg; 
  char* prefix;
  GSList** ptl;
  GtkWidget* term;
  
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  term = (*ptl)->data;
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  prefix = g_strdup_printf("/MultiTerminal/%s/", cfg->class);
  
  if (!app) 
    return;

}
void toggle_app_items(GtkWidget* app, struct win_config* cfg);

void add_commands_items(char** cmds_names, GtkItemFactoryEntry* cm, int def, char *rstr);
GtkItemFactoryEntry* 
free_and_add_hardset (GtkWidget* app, char **cmds, GtkItemFactory *item_factory,
 int *hsitems,
 int *nmenu_items, 
 GtkItemFactoryEntry *static_menu, 
 int tearoff, char *hsitems_str, 
 char *menu_str);
void menu_radioitem_cb(GtkWidget *w, gpointer data);

void rebuild_menubar_from_arrays(GnomeApp* app)
{
  /* commands and commands names arrays */
  char **cmds_names, **cmds;
  GSList** ptl;
  /* custom submenu with commands names */
  GnomeUIInfo* sm;
  int x, nmenu_items, hsitems; 
  GnomeUIInfo end_menu = { GNOME_APP_UI_ENDOFINFO, NULL, NULL, NULL, NULL, NULL,(GnomeUIPixmapType) 0, NULL, 0,(GdkModifierType) 0, NULL };
  GtkWidget *submenu, *mainmenu;
  struct win_config *wincfg;
  GtkItemFactory *item_factory;
  GtkItemFactoryEntry* cm;
  GtkCheckMenuItem* check_item;
  GtkAccelGroup* accel_group;
  GnomeUIInfo* radioinfo;
  int win_active, tab_active;
  
  if (!app->menubar)
    return;
  
  cmds = app_config.cmds;
  cmds_names = app_config.cmds_names;
 
  x = 0;
  /* remove all menus first in app menubar */
  gnome_app_remove_menus  (GNOME_APP(app), N_("File"), 5);

  sm = (GnomeUIInfo*) gtk_object_get_data(GTK_OBJECT(app), "custom_submenu");
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  if (sm)
    {
      x = 0;
      while (sm[x].type != GNOME_APP_UI_ENDOFINFO)
	{
	  free(sm[x].user_data);
	  x++; 
	}	
      free(sm);
    }
  sm = (GnomeUIInfo*) malloc(sizeof(GnomeUIInfo));

  gtk_object_set_data(GTK_OBJECT(app), "custom_submenu", sm); 
  set_all_menu_user_data(ptl);
  memcpy(sm, &end_menu, sizeof(GnomeUIInfo));
  
  /* attach the new custom menu */
  gnome_terminal_menu[1].moreinfo = sm;
  /* insert the menu */

  radioinfo = gtk_object_get_data(GTK_OBJECT(app), "tab_radio_item");
  if (radioinfo)
      g_free(radioinfo);
  radioinfo = gtk_object_get_data(GTK_OBJECT(app), "win_radio_item");
  if (radioinfo)
      g_free(radioinfo);
  
  gtk_object_set_data(GTK_OBJECT(app), "tab_radio_item", NULL);
  gtk_object_set_data(GTK_OBJECT(app), "win_radio_item", NULL);
  add_tabprofiles(&(tab_radio_item[0].moreinfo), GTK_WIDGET(app), ptl, &tab_active);
  add_winprofiles(&(win_radio_item[0].moreinfo), GTK_WIDGET(app), ptl, &win_active);
  gnome_app_insert_menus(GNOME_APP(app), "/", gnome_terminal_menu);
  gtk_object_set_data(GTK_OBJECT(app), "tab_radio_item", tab_radio_item[0].moreinfo);
  gtk_object_set_data(GTK_OBJECT(app), "win_radio_item", win_radio_item[0].moreinfo);
  gtk_object_set_data(GTK_OBJECT(app), "toggle_toolbar",
		      gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_TOOLBAR].widget);
  gtk_object_set_data(GTK_OBJECT(app), "toggle_menubar",
		      gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_MENUBAR].widget);
  gtk_object_set_data(GTK_OBJECT(app), "toggle_buttonbar",
		      gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_BUTTONBAR].widget);

  check_item =  
    GTK_CHECK_MENU_ITEM( (((GnomeUIInfo*)(tab_radio_item[0].moreinfo))[tab_active]).widget );
  gtk_check_menu_item_set_active(check_item, TRUE);
  gtk_signal_connect(GTK_OBJECT(GTK_WIDGET(check_item)->parent), "show", menu_radioitem_cb, app);
  tab_radio_item[0].moreinfo = NULL;
  check_item =  
    GTK_CHECK_MENU_ITEM( (((GnomeUIInfo*)(win_radio_item[0].moreinfo))[win_active]).widget );
  gtk_check_menu_item_set_active(check_item, TRUE);
  win_radio_item[0].moreinfo = NULL;

  /* sm[0].widget is created by gtk_menu_item_new() */
  mainmenu = gtk_object_get_data(GTK_OBJECT(app), "menubar_factory_widget"); 
  if (mainmenu)
    {
      item_factory = gtk_item_factory_from_widget(mainmenu);
    }  
  else
    {
      accel_group = gtk_accel_group_new ();
      item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
					   accel_group);
    }
 
  cm = free_and_add_hardset(GTK_WIDGET(app), cmds_names, item_factory,
			    &hsitems, &nmenu_items,
			    menu_items, 1, "menu_num_hardset", "menubar_factory");

  add_commands_items(cmds_names, cm, hsitems, "/MAIN/");

  gtk_item_factory_create_items (item_factory, nmenu_items, cm, ptl);
  submenu = gtk_item_factory_get_widget (item_factory, "/MAIN");
  mainmenu =gtk_item_factory_get_widget (item_factory, "<main>");
  gtk_object_set_data(GTK_OBJECT(app), "menubar_factory_widget", mainmenu);  
  gtk_object_set_data(GTK_OBJECT(app), "menubar_submenu_widget", submenu);

  /* this is a trick to avoid a warning due to the fact that 
     the submenu is already attached to gtkmenu created by factory widget
   */
  gtk_object_remove_data (GTK_OBJECT (submenu), attach_data_key);

  gtk_menu_item_set_submenu(GTK_MENU_ITEM(gnome_terminal_menu[1].widget), 
					  submenu); 
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  if (wincfg)
    toggle_app_items(GTK_WIDGET(app), wincfg);
}

int nr;

void get_arrays_from_list(GtkCList *l , char ***na, char ***pa, char ***co,
			  char ***cl)
{
  char *name, *cmd, *path, *class;
  int r, nr;
  
  /* Get the number of rows in the clist object */
  r = 0;
  while(gtk_clist_get_text(l, r, 0, &name))
    {
      r++;
    }

  nr = r + 1;
  *na = malloc(sizeof(char*)*nr);
  *co = malloc(sizeof(char*)*nr);  
  *pa = malloc(sizeof(char*)*nr);
  *cl = malloc(sizeof(char*)*nr); 
  /* Set arrays using clist datas */  
  r = 0;
  while(gtk_clist_get_text(l, r, 0, &name))
    {
      gtk_clist_get_text(l, r, 1, &path);
      gtk_clist_get_text(l, r, 2, &cmd);
      gtk_clist_get_text(l, r, 3, &class);
      (*na)[r] = (char *) malloc ((strlen(name)+1)*sizeof(char));
      (*co)[r] = (char *) malloc ((strlen(cmd)+1)*sizeof(char));
      (*pa)[r] = (char* ) malloc ((strlen(path)+1)*sizeof(char));
      (*cl)[r] = (char* ) malloc ((strlen(class)+1)*sizeof(char));
      strcpy((*na)[r], name);
      strcpy((*co)[r], cmd);
      strcpy((*pa)[r], path);
      strcpy((*cl)[r], class);
      r++;
    }
  (*na)[r] = NULL;
  (*co)[r] = NULL;
  (*pa)[r] = NULL;
  (*cl)[r] = NULL;
}
void get_menus_arrays(GtkWidget* app, GtkCList* l)
{
  char **cmds_names, **cmds, **cmds_paths, **cmds_classes;
  /* cmds e cmds_names must initialized at window (app) creation */
  cmds_names = app_config.cmds_names;
  cmds = app_config.cmds;
  cmds_paths = app_config.cmds_paths;
  cmds_classes = app_config.cmds_classes;

  /* remove old arrays */ 
  free_str_array(cmds_names);
  free_str_array(cmds);
  free_str_array(cmds_paths);
  free_str_array(cmds_classes);
  get_arrays_from_list(l, &cmds_names, &cmds_paths, &cmds, &cmds_classes);

  app_config.cmds_names = cmds_names;
  app_config.cmds =  cmds;
  app_config.cmds_paths = cmds_paths;
  app_config.cmds_classes = cmds_classes;
}

void get_su_tabs(GtkWidget* app, GtkCList* l)
{
  char **su_names, **su_cmds, **su_paths, **su_classes;

  /* cmds e cmds_names must initialized at window (app) creation */
  su_names = (char**) gtk_object_get_data(GTK_OBJECT(app), "su_names");
  su_cmds = (char**) gtk_object_get_data(GTK_OBJECT(app), "su_cmds");
  su_paths = (char**) gtk_object_get_data(GTK_OBJECT(app), "su_paths");
  su_classes =(char**) gtk_object_get_data(GTK_OBJECT(app), "su_classes");
  /* remove old arrays */ 
  free_str_array(su_names);
  free_str_array(su_cmds);
  free_str_array(su_paths);
  free_str_array(su_classes);
  get_arrays_from_list(l, &su_names, &su_paths, &su_cmds, &su_classes);

  gtk_object_set_data(GTK_OBJECT(app), "su_names", su_names);
  gtk_object_set_data(GTK_OBJECT(app), "su_cmds", su_cmds);
  gtk_object_set_data(GTK_OBJECT(app), "su_paths", su_paths);
  gtk_object_set_data(GTK_OBJECT(app), "su_classes", su_classes);
}

void ec_apply_changes(GtkWidget* app, gboolean nosutabs, GtkCList* startup, char* tclass)
{
  GSList** ptl;
  struct win_config *wincfg;

  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  if (strcasecmp(wincfg->class, tclass))
    return;
  get_su_tabs(app, startup);
  wincfg->no_startuptabs = nosutabs;
}


void ec_apply_to_all_wins(GtkCList* cmds_menu, GtkCList* startup, GtkWidget* cb,
			  char* tclass)
{
  GList* all_app;
  GtkWidget* oapp;
  
  /* apply to all windows */
  all_app = terminals;
  while (all_app)
    {
      oapp = GTK_WIDGET(all_app->data);
      get_menus_arrays(GTK_WIDGET(oapp), cmds_menu);
      rebuild_menubar_from_arrays(GNOME_APP(oapp));
      rebuild_buttonbar_menu(GTK_WIDGET(oapp));
      ec_apply_changes(GTK_WIDGET(oapp),  GTK_TOGGLE_BUTTON(cb)->active, startup,
		       tclass);
      all_app = all_app->next;
    }
}

void save_su_config(GtkWidget* term, GtkCList* l, GtkCList* lsu,
		    GtkWidget* button, GtkWidget* cb, GtkWidget *app)
{
  char *ctxt, *winclass;
  GtkWidget* cmb;
  char *prefix;
  
  cmb = gtk_object_get_data(GTK_OBJECT(button), "cmb-class");
  ctxt = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmb)->entry));
  if (!strcasecmp(ctxt, "Default"))
    winclass = g_strdup("Win-Config");
  else
    winclass = g_strdup_printf("Win-Class-%s", ctxt);

  save_startuptabs(app, winclass, lsu);
  ec_apply_to_all_wins(l, lsu, cb, winclass);

  prefix = g_strdup_printf("/MultiTerminal/%s/", winclass);
  gnome_config_push_prefix(prefix);
  gnome_config_set_bool("nosutabs", GTK_TOGGLE_BUTTON(cb)->active);
  gnome_config_sync();
  gnome_config_pop_prefix();

  g_free(prefix);
  g_free(winclass);

}

void update_hardset(GtkWidget** chk_hardset)
{
  int i;

  for (i = 0; i < NUM_HARDSET+1; i++)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (chk_hardset[i]),
				app_config.hardset_entries[i]);
    }
}

void
on_ok_button_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win, *term, *cb;
  GtkCList *l, *lsu;
  GSList** ptl;
  int i;
  GtkWidget **chkhs;
  l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));
  lsu = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_sutabs"));
  cb = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "chk_suopen"));
  win = gtk_widget_get_toplevel(GTK_WIDGET(button));

  chkhs = gtk_object_get_data(GTK_OBJECT(win), "chk_hardset");
  for (i=0; i < NUM_HARDSET+1; i++)
    {
      app_config.hardset_entries[i] = GTK_TOGGLE_BUTTON(chkhs[i])->active;
    }

  ptl = gtk_object_get_data(GTK_OBJECT(user_data), "ptermlist");
  term = GTK_WIDGET((*ptl)->data);
  save_commands(GTK_WIDGET(user_data), l);
  save_su_config(term, l, lsu, GTK_WIDGET(button), cb, GTK_WIDGET(user_data));
  gtk_widget_destroy(win);
}

void
on_apply_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkCList *l, *lsu;
  GSList** ptl;
  GtkWidget *term, *cb, *win;
  GtkWidget **chkhs;
  int i;
  l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_cmd"));
  lsu = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "lista_sutabs"));
  cb = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "chk_suopen"));
  win = gtk_widget_get_toplevel(GTK_WIDGET(button));

  chkhs = gtk_object_get_data(GTK_OBJECT(win), "chk_hardset");
  for (i=0; i < NUM_HARDSET+1; i++)
    {
      app_config.hardset_entries[i] = GTK_TOGGLE_BUTTON(chkhs[i])->active;
    }

  ptl = gtk_object_get_data(GTK_OBJECT(user_data), "ptermlist");
  term = GTK_WIDGET((*ptl)->data);
  save_commands(GTK_WIDGET(user_data), l);
  save_su_config(term, l, lsu, GTK_WIDGET(button), cb, GTK_WIDGET(user_data));
}

void human_keybind(GSList* keybind)
{
/* DO WE NEED THIS? */
}
struct keyb_atom
{
  GdkEventType type;
  guint state;
  guint keyval;
  guint button;
};


#define kd(x)  
struct keyb_atom* parse_a_key(char* atom)
{
  char** quarks;
  int x, nq;
  struct keyb_atom *ev;
  kd(printf("atom: %s \n", atom));
  quarks = g_strsplit(atom, "-", 0);
  ev = g_new0(struct keyb_atom, 1);
  x = 0;
  while (quarks[x])
    {
      x++;
    }
  /* nq-1 is the key and all quarks with index less than nq are modifiers */
  nq = x;
  x = 0;
  ev->type = GDK_KEY_PRESS;
  ev->state = 0;
  while (x < nq-1)
    {
      if (!strcmp(quarks[x], "C" ))
	{
	  ev->state |= GDK_CONTROL_MASK;
	}
      else if (!strcmp(quarks[x],"S"))
	{
	  ev->state |= GDK_SHIFT_MASK;
	}
      else if (!strcmp(quarks[x], "A"))
	{
	  ev->state |= GDK_MOD1_MASK;
	}
      /*
	 else if (!strcmp(quarks[x],"AGr"))
	 {
	 ev->state |= GDK_MOD2_MASK;
	 }*/
      else 
	{/*ERROR*/}
      x++;
    }
  ev->keyval = gdk_keyval_from_name(quarks[nq-1]);
  kd(printf ("quarks[nq-1]:%s [%d] mod:%d\n", quarks[nq-1], ev->keyval, ev->state));
  g_strfreev(quarks);
  return ev;
}

void parse_keybind(void)
{
  int x=0, xx=0;
  char **split_str;
  struct keyb_atom* ev;
  GSList *kbinds_list, *kbind=NULL;

  kbinds_list = app_config.kbinds_list;
  if (kbinds_list)
    {
      while (kbinds_list)
	{
	  /* 
	     [kbinds_list]

	     keybinding -> atom -> atom -> <END>         [kbind]
	     |
	     v
	     keybinding -> atom -> atom -> atom -> <END> [kbind]
	     |
	     v
	     <END>
	   */
	  
	  kbind = (GSList*) kbinds_list->data;
	  while (kbind)
	    {
	      g_free(kbind->data);
	      kbind->data = NULL;
	      kbind = kbind->next;
	    }
	  g_slist_free(kbind);
	  kbinds_list = kbinds_list->next;
	}
      g_slist_free(kbinds_list);
    }
  kbinds_list = NULL;
  while(app_config.keybinds[x])
    {
      kbind = NULL;
      split_str = g_strsplit(app_config.keybinds[x], " ", 0);    
      xx = 0;
      while (split_str[xx])
	{
	  ev = parse_a_key(split_str[xx]); 
	  kbind = g_slist_append(kbind, ev);
	  xx++;
	}
      kbinds_list = g_slist_append(kbinds_list, kbind);
      g_strfreev(split_str);
      x++;
    }
  app_config.kbinds_reload = 1;
  app_config.kbinds_list = kbinds_list;
}

void build_vect(GtkWidget* l)
{
  int r, nr;
  char *action, *string, *keybind;
  /* Get the number of rows in the clist object */

  free_str_array(app_config.actions);
  free_str_array(app_config.strings);
  free_str_array(app_config.keybinds);

  r = 0;
  while(gtk_clist_get_text(GTK_CLIST(l), r, 0, &action))
    {
      r++;
    }

  nr = r + 1;
  app_config.actions = malloc(sizeof(char*)*nr);
  app_config.strings = malloc(sizeof(char*)*nr);  
  app_config.keybinds = malloc(sizeof(char*)*nr);

  /* Set arrays using clist datas */  
  r = 0;
  while(gtk_clist_get_text(GTK_CLIST(l), r, 0, &action))
    {
      gtk_clist_get_text(GTK_CLIST(l), r, 1, &string);
      gtk_clist_get_text(GTK_CLIST(l), r, 2, &keybind);
      app_config.actions[r] = (char *) malloc((strlen(action)+1)*sizeof(char));
      app_config.strings[r] = (char *) malloc((strlen(string)+1)*sizeof(char));
      app_config.keybinds[r] = (char *) malloc((strlen(keybind)+1)*sizeof(char));
      strcpy(app_config.actions[r], action);
      strcpy(app_config.strings[r], string);
      strcpy(app_config.keybinds[r], keybind);
      r++;
    }
  app_config.actions[r] = NULL;
  app_config.strings[r] = NULL;
  app_config.keybinds[r] = NULL;

}

char* popupmods[] = {"Control", "Shift", "Alt", NULL};
void safe_cmd_vector(char*** no, char ***pa, char***co, char ***cl, int n)
{
  int x = 0;

  if (*no == NULL)
    {
      *no = malloc(sizeof(char*));
      if (*pa)
	free_str_array(*pa);
      *pa = malloc(sizeof(char*));
      if (*co)
	free_str_array(*co);
      *co = malloc(sizeof(char*));
      if (*cl)
	free_str_array(*cl);
      *cl = malloc(sizeof(char*));
      (*cl)[0] = (*no)[0] = (*pa)[0] = (*co)[0] = NULL;
    }
  else
    {
      if (n == 1 && strlen((*no)[0])==0)
	{
	  if (*pa == NULL)
    	    *pa = malloc(sizeof(char*));
	  if (*co == NULL)
	    *co = malloc(sizeof(char*));
	  if (*cl == NULL)
	    *cl = malloc(sizeof(char*));
	  (*cl)[0] = (*no)[0] = (*pa)[0] = (*co)[0] = NULL;
  	}
      else
	{
	  if (*pa == NULL)
	    {
	      *pa = malloc(sizeof(char*)*(n+1));
	      for (x = 0; x < n+1; x++)
		  (*pa)[x] = NULL;
	    }
	  if (*co == NULL)
	    {
	      *co = malloc(sizeof(char*)*(n+1));
	      for (x = 0; x < n+1; x++)
	      	(*co)[x] = NULL;
	    }
	  if (*cl == NULL)
	    {
	      *cl = malloc(sizeof(char*)*(n+1));
	      for (x = 0; x < n+1; x++)
	      	(*cl)[x] = NULL;
	    }
	  x = 0;
	  while((*no)[x])
	    {
	      if ((*pa)[x] == NULL)
		{
		  (*pa)[x] = malloc(sizeof(char)*5);
		  strcpy((*pa)[x],"None"); 
		}
	      if ((*co)[x] == NULL)
		{
		  (*co)[x] = malloc(sizeof(char)*5);
		  strcpy((*co)[x], "bash");
		}
	      if ((*cl)[x] == NULL)
		{
		  (*cl)[x] = malloc(sizeof(char)*5);
		  strcpy((*cl)[x], "None");
		}
	      x++;
	    }	    
	}
    }
  x = 0;
  while ((*pa)[x])
    {
      if (strlen((*pa)[x])==0)
	{
	   (*pa)[x] = malloc(sizeof(char)*5);
	   strcpy((*pa)[x],"None"); 
	}
      if (strlen((*cl)[x])==0)
	{
	   (*cl)[x] = malloc(sizeof(char)*5);
	   strcpy((*cl)[x],"None"); 
	}
      x++;
    }

}

void safe_vector(char*** no, char ***pa, char***co, int n)
{
  int x = 0;

  if (*no == NULL)
    {
      *no = malloc(sizeof(char*));
      if (*pa)
	free_str_array(*pa);
      *pa = malloc(sizeof(char*));
      if (*co)
	free_str_array(*co);
      *co = malloc(sizeof(char*));
      (*no)[0] = (*pa)[0] = (*co)[0] = NULL;
    }
  else
    {
      if (n == 1 && strlen((*no)[0])==0)
	{
	  if (*pa == NULL)
    	    *pa = malloc(sizeof(char*));
	  if (*co == NULL)
	    *co = malloc(sizeof(char*));
	  (*no)[0] = (*pa)[0] = (*co)[0] = NULL;
  	}
      else
	{
	  if (*pa == NULL)
	    {
	      *pa = malloc(sizeof(char*)*(n+1));
	      for (x = 0; x < n+1; x++)
		  (*pa)[x] = NULL;
	    }
	  if (*co == NULL)
	    {
	      *co = malloc(sizeof(char*)*(n+1));
	      for (x = 0; x < n+1; x++)
	      	(*co)[x] = NULL;
	    }
	  x = 0;
	  while((*no)[x])
	    {
	      if ((*pa)[x] == NULL)
		{
		  (*pa)[x] = malloc(sizeof(char)*5);
		  strcpy((*pa)[x],"None"); 
		}
	      if ((*co)[x] == NULL)
		{
		  (*co)[x] = malloc(sizeof(char)*5);
		  strcpy((*co)[x], "bash");
		}
	      x++;
	    }	    
	}
    }
  x = 0;
  while ((*pa)[x])
    {
      if (strlen((*pa)[x])==0)
	{
	   (*pa)[x] = malloc(sizeof(char)*5);
	   strcpy((*pa)[x],"None"); 
	}
      x++;
    }

}
char* def_list[][3]=
{
    {"Shell->New Tab", "", "C-l n"},
    {"Root->New Tab",  "", "C-l r"},
    {"mc->New Tab", "", "C-l m"},
    {"Next terminal in tab", "", "C-l ISO_Left_Tab"},
    {"Prev terminal in tab", "", "C-l p"},
    {"Go Right", "", "S-Right"},
    {"Go Left",  "", "S-Left"},
    {"Remove Term", "", "C-F5"},
    {"Tab Right", "", "S-ISO_Left_Tab"},
    /*{"Tab Left",  "", ""},*/
    {"Change Title", "", "C-F2"},
    {"Reset Terminal", "", "C-F3"},
    {"Reset and Clear", "", "C-F4"},
    {"New Window", "", "C-F6"},
    {NULL, NULL, NULL}
};


void load_appconfig(void)
{
  int n, n1, x, def_len, i;
  gchar* hs_str;
  int kb_disable, num_cmds, num_cmds2;
  char *pm_str;  
  char *prefix = g_strdup_printf ("/MultiTerminal/Common/");

  gnome_config_push_prefix (prefix);
  gnome_config_get_vector ("cmds", &num_cmds2, &app_config.cmds);
  gnome_config_get_vector ("cmds_names", &num_cmds, &app_config.cmds_names);
  gnome_config_get_vector ("cmds_paths", &num_cmds2, &app_config.cmds_paths);
  gnome_config_get_vector ("cmds_classes", &num_cmds2, &app_config.cmds_classes);
  safe_cmd_vector(&app_config.cmds_names, &app_config.cmds_paths, 
		  &app_config.cmds, &app_config.cmds_classes, num_cmds);

  gnome_config_get_vector("kb_actions", &n1, &app_config.actions);
  gnome_config_get_vector("kb_strings", &n, &app_config.strings);
  gnome_config_get_vector("kb_keybinds", &n, &app_config.keybinds);
  safe_vector(&app_config.actions, &app_config.strings, &app_config.keybinds, n1);
 
  n = 0; 
  while (app_config.strings[n])
    {
      if (!strcmp(app_config.strings[n],"None"))
	app_config.strings[n] = g_strdup("");
      n++;
    } 
  if (n == 0)
    {
      /* set defaults keybindings if there are no keybs in config file */
      x = 0;
      while (def_list[x][0])
	  x++;
      def_len = x;
      x = 0;
      app_config.actions = malloc((def_len+11)*sizeof(char*));
      app_config.strings = malloc((def_len+11)*sizeof(char*));
      app_config.keybinds= malloc((def_len+11)*sizeof(char*));

      while (def_list[x][0])
	{
           app_config.actions[x] = g_strdup(def_list[x][0]);
	   app_config.strings[x] = g_strdup(def_list[x][1]);
	   app_config.keybinds[x] = g_strdup(def_list[x][2]);
	   x++;
	}
      /* and now add switch to shortcuts */
      for (x = 1; x < 10; x++)  
	{
	  app_config.actions[def_len+x] = g_strdup(actions_list[MGT_SWITCH_TO]);
	  app_config.strings [def_len+x] = g_strdup_printf("%d", x);
	  app_config.keybinds[def_len+x] = g_strdup_printf("C-%d", x);
	}
      app_config.actions[def_len]  = g_strdup(actions_list[MGT_SWITCH_TO]);
      app_config.strings[def_len]  = g_strdup("10"); 
      app_config.keybinds[def_len] = g_strdup("C-0");
      app_config.actions[def_len+10] = NULL;
      app_config.strings[def_len+10] = NULL;
      app_config.keybinds[def_len+10] = NULL;
    }
  
  kb_disable = gnome_config_get_bool("kb_disable=false");
  app_config.disable_keybind = kb_disable;

  pm_str = gnome_config_get_string("popup_mod=Control");
  n = 0;
  while (popupmods[n])
    {
      if (!strcmp(popupmods[n], pm_str))
	{
	  app_config.popupmod = n;
  	  break;
	}
      n++;
    }
  /* HARDSET ITEMS */
  hs_str = gnome_config_get_string("hardset_entries=1111110");  
  for (i=0; i < NUM_HARDSET+1; i++)
    {
       app_config.hardset_entries[i] = (hs_str[i]=='1')?1:0;     
    }
  gnome_config_pop_prefix ();
  g_free (prefix);
}

void save_shortcuts(void)
{
  int n;
  char *prefix = g_strdup_printf ("/MultiTerminal/Common/");
  
  gnome_config_push_prefix (prefix);
  
  n = 0;
  while(app_config.actions[n])
    n++;
  n = 0; 
  while (app_config.strings[n])
    {
      if (!strcmp(app_config.strings[n],""))
	app_config.strings[n] = g_strdup("None");
      n++;
    } 
  gnome_config_set_vector("kb_actions", n, (const char* const*) app_config.actions);
  gnome_config_set_vector("kb_strings", n, (const char* const*) app_config.strings);
  gnome_config_set_vector("kb_keybinds", n, (const char* const*) app_config.keybinds);
  gnome_config_set_bool("kb_disable", app_config.disable_keybind);
  
  gnome_config_set_string("popup_mod", popupmods[app_config.popupmod]);
  gnome_config_sync ();
  /* save also New Term Menu */
  gnome_config_pop_prefix ();
  g_free (prefix);
}

void kb_apply_changes(GtkWidget* app, gboolean disable)
{
  app_config.disable_keybind = disable;
}

void kb_apply_to_all_wins(GtkWidget* kb_list, 
			  GtkWidget* kb_disable, int popupmod )
{
  GList* all_app;
  all_app = terminals;
  app_config.disable_keybind = GTK_CHECK_BUTTON(kb_disable)->toggle_button.active;
  app_config.popupmod = popupmod;
  build_vect(kb_list);
  parse_keybind();
}
gint action_menu_get_history (GtkOptionMenu *option_menu);
void
kb_ok_button_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* kb_list, *kb_disable, *popup_mod;
  int pm;
   
  /* HAVE TO CREATE THE KB LIST AND STORE IT */
  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  popup_mod = gtk_object_get_data(GTK_OBJECT(win), "popup_mod"); 
  kb_list = gtk_object_get_data(GTK_OBJECT(win), "kb_list");
  kb_disable = gtk_object_get_data(GTK_OBJECT(win), "kb_disable");
  pm = action_menu_get_history(GTK_OPTION_MENU (popup_mod));
  kb_apply_to_all_wins(kb_list, kb_disable, pm);

  save_shortcuts();
  
  gtk_widget_destroy(win);
}

void
kb_apply_button_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  GtkWidget* kb_list, *kb_disable, *popup_mod;
  int pm;
  
  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  kb_list = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(win), "kb_list"));
  kb_disable = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(win), "kb_disable"));
  popup_mod  = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(win), "popup_mod"));
  
  pm = action_menu_get_history(GTK_OPTION_MENU (popup_mod));
  
  kb_apply_to_all_wins(kb_list, kb_disable, pm);

  save_shortcuts();
  
}

void
kb_cancel_button_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* win;
  win = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(win);
}

static
void dummy_combo_popup_button_press (GtkWidget        *button,
                              GdkEventButton   *event,
                              GtkCombo         *combo)
{
  /* combo list must be filled only when 'commands' is selected:
     actually this trick doesn't work :( */
  return;
}

struct kb_def_struct
{
  GtkCList* kb_list;
  char** cmds_names;
};


void on_set_def_clicked_ok(GtkButton       *button,
			gpointer         user_data)
{
  GtkCList* l;
  struct kb_def_struct* d = (struct kb_def_struct*) user_data;
  int x = 0;
  char* riga[3];
  char** cn;
  l = d->kb_list;
  cn = d->cmds_names;
  gtk_clist_clear(l); 
  while (def_list[x][0])
    {
      gtk_clist_append(l, def_list[x]);   
      x++;
    }
  /* and now add commnds shortcuts */
  x = 0;
  riga[0] = actions_list[MGT_SWITCH_TO];
  riga[2] = g_malloc(sizeof(char)*32);
  riga[1] = g_malloc(sizeof(char)*32);
  for (x = 1; x < 10; x++)  
    {
      g_snprintf(riga[1], 32, "%d", x);
      g_snprintf(riga[2], 32, "C-%d", x);
      gtk_clist_append(l, riga);
    }
  g_free(riga[2]);
  g_free(riga[1]);
  riga[1] = "10";
  riga[2] = "C-0";
  gtk_clist_append(l, riga);
  g_free(d);
}

void on_switch_def_clicked_ok(GtkButton       *button,
	     		   gpointer         user_data)
{
  GtkCList* l;
  int x = 0;
  struct kb_def_struct* d = (struct kb_def_struct*) user_data;
  char* riga[3];
  char* txt;
  char** cn;
  /* FIXME: button set as NULL on calling this func! */
  /*l = gtk_object_get_data(GTK_OBJECT(app), "kb_list");
  cn = gtk_object_get_data(GTK_OBJECT(app), "cmds_names");
   */
  
  l = d->kb_list;
  cn = d->cmds_names;

  /* remove all commands keybindings first */
  x = 0;
  while(gtk_clist_get_text(l, x, 0, &txt))
    {
      if (!strcmp(txt, actions_list[MGT_SWITCH_TO]))
	{
	  gtk_clist_remove(l, x);	
	  x--;
	}
      x++;
    } 
  
  /* and now add commnds shortcuts */
  x = 0;
  riga[0] = actions_list[MGT_SWITCH_TO];
  riga[1] = g_malloc(sizeof(char)*32);
  riga[2] = g_malloc(sizeof(char)*32);
  for (x = 1; x < 10; x++)   
    {
      g_snprintf(riga[1], 32, "%d", x);
      g_snprintf(riga[2], 32, "C-%d", x);
      gtk_clist_append(l, riga);
    }
  g_free(riga[2]);
  g_free(riga[1]);
  riga[1] = "10";
  riga[2] = "C-0";
  gtk_clist_append(l, riga);
  g_free(d);
}

void cb_def_switch(gint reply, gpointer data)
{
  if (reply)
    {
      return;
    }
  else
    {
      on_switch_def_clicked_ok(NULL, data);
    }

}

void on_switch_def_clicked(GtkWidget* button, gpointer user_data)
{
  GtkWidget* conf_win;
  struct kb_def_struct* d;

  d = malloc(sizeof(struct kb_def_struct));
  d->kb_list =gtk_object_get_data(GTK_OBJECT(button), "kb_list");
  d->cmds_names = app_config.cmds_names;
  
  conf_win = gnome_ok_cancel_dialog_modal
    ("Set default keybindings for switching tags?", cb_def_switch, 
     (gpointer) d);
  
}

void cb_set_def(gint reply, gpointer data)
{
  if (reply)
    {
      return;
    }
  else
    {
      on_set_def_clicked_ok(NULL, data);
    }

}
int clist_selrow(GtkCList* l)
{
  GList* sl;
  sl = l->selection;
  if (!sl)
    return -1;

  return GPOINTER_TO_INT(sl->data);

}

void on_set_def_clicked(GtkWidget* button, gpointer user_data)
{
  GtkWidget* conf_win;
  struct kb_def_struct* d;

  d = malloc(sizeof(struct kb_def_struct));
  d->kb_list =gtk_object_get_data(GTK_OBJECT(button), "kb_list");
  d->cmds_names = app_config.cmds_names;
  
  conf_win = gnome_ok_cancel_dialog_modal
    ("Set default keybindings?", cb_set_def, 
     (gpointer) d);
}


void kb_remove_clicked(GtkButton       *button,
	 	       gpointer         user_data)
{
  int cr;
  GtkCList* l;

  l = gtk_object_get_data(GTK_OBJECT(button), "kb_list");
  if ((cr = clist_selrow(l))==-1)
    return;

  gtk_clist_remove(l, cr);

}
#define	ROW_ELEMENT(clist, row)	(((row) == (clist)->rows - 1) ? \
				 (clist)->row_list_end : \
				 g_list_nth ((clist)->row_list, (row)))

void kb_edit_clicked(GtkButton       *button,
	 	       gpointer         user_data)
{
  GtkEntry *keyb, *string;
  GtkCombo* cmb_string;
  GtkCombo* action;
  GtkCList* l;
  GtkCListRow* lrow;
  int row, x;
  char *newstring,*newkeybind;

  l = gtk_object_get_data(GTK_OBJECT(button), "kb_list");
  if ((row = clist_selrow(l))==-1)
    return;
  lrow = ROW_ELEMENT(l,row)->data;

  if (lrow)
    {
      cmb_string = GTK_COMBO(gtk_object_get_data(GTK_OBJECT(button), "string"));
      string = GTK_ENTRY(cmb_string->entry);
      action = GTK_COMBO(gtk_object_get_data(GTK_OBJECT(button), "action"));
      keyb   = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "keybind"));   
      /* here I could use gtk_clist_get_text why not? */
      newstring = GTK_CELL_TEXT(lrow->cell[1])->text;
      newkeybind = GTK_CELL_TEXT(lrow->cell[2])->text;     
      /* TODO: here set the action also */
      x = 0;
      while (actions_list[x])
	{
	  if (!strcmp(actions_list[x],GTK_CELL_TEXT(lrow->cell[0])->text))
	    break;
	 x++; 
	}
      /* FIXME: check here if right! */
      gtk_entry_set_text(GTK_ENTRY(action->entry),actions_list[x]);
      gtk_entry_set_text(string, newstring);
      gtk_entry_set_text(keyb, newkeybind);
     /*gtk_clist_select_row(GTK_CLIST(l), x, 0);*/
    }
}

void kb_clear_clicked(GtkButton* button,
		      gpointer user_data)
{
  GtkEntry *keyb;
  keyb = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "keybind"));
  gtk_entry_set_text(keyb, "");
  gtk_widget_grab_focus(GTK_WIDGET(keyb));
}

void kb_clrstr_clicked(GtkButton* button,
		      gpointer user_data)
{
  GtkCombo* cmb_string;
  cmb_string = GTK_COMBO(gtk_object_get_data(GTK_OBJECT(button), "string"));
  gtk_entry_set_text(GTK_ENTRY(cmb_string->entry), "");
  gtk_widget_grab_focus(GTK_WIDGET(cmb_string->entry));
}

void kb_upd_clicked(GtkButton       *button,
		    gpointer         user_data)
{
  GtkEntry *string, *keyb;
  GtkCombo* cmb_string;
  GtkCombo* action;
  char *riga[3], *txt;
  GtkCList *l;
  int row;
  int nact;

  cmb_string = GTK_COMBO(gtk_object_get_data(GTK_OBJECT(button), "string"));
  string = GTK_ENTRY(cmb_string->entry);
  keyb = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "keybind"));
  action = GTK_COMBO(gtk_object_get_data(GTK_OBJECT(button), "action"));

  riga[1] = gtk_entry_get_text(string);
  riga[2] = gtk_entry_get_text(keyb);
  
  nact = 0;
  txt = gtk_entry_get_text(GTK_ENTRY(action->entry));
  while (actions_list[nact])
    {
      if (!strcmp(actions_list[nact], txt))
	break;
      nact++;
    }
  
  riga[0] = actions_list[nact];
 
  /* Get the number of rows in the clist object */
  
  if (!strlen(riga[0]) || !strlen(riga[2]))
    return;
 
  l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "kb_list"));
  if ((row = clist_selrow(l))==-1)
    return;

  gtk_clist_freeze(l);
  gtk_clist_remove(l, row);
  gtk_clist_insert(l, row, riga);
  gtk_clist_thaw(l);

}


/* This really should be in GTK+
 */
gint action_menu_get_history (GtkOptionMenu *option_menu)
{
	GtkWidget *active_widget;
	
	g_return_val_if_fail (GTK_IS_OPTION_MENU (option_menu), -1);
	
	active_widget = gtk_menu_get_active (GTK_MENU (option_menu->menu));

	if (active_widget)
		return g_list_index (GTK_MENU_SHELL (option_menu->menu)->children,
				     active_widget);
	else
		return -1;
}


void kb_add_clicked(GtkButton       *button,
      		    gpointer         user_data)
{
  GtkEntry *string, *keyb;
  GtkCombo* cmb_string;
  GtkCombo* action;
  GtkCList* l;
  char *riga[3], *txt;
  int nact;

  cmb_string = GTK_COMBO(gtk_object_get_data(GTK_OBJECT(button), "string"));
  string = GTK_ENTRY(cmb_string->entry);
  keyb = GTK_ENTRY(gtk_object_get_data(GTK_OBJECT(button), "keybind"));
  action = GTK_COMBO(gtk_object_get_data(GTK_OBJECT(button), "action"));

  riga[1] = gtk_entry_get_text(string);
  riga[2] = gtk_entry_get_text(keyb);
  
  nact = 0;
  txt = gtk_entry_get_text(GTK_ENTRY(action->entry));
  while (actions_list[nact])
    {
      if (!strcmp(actions_list[nact], txt))
	break;
      nact++;
    }
  riga[0] = actions_list[nact];
 
  /* Get the number of rows in the clist object */

  if (!strlen(riga[0]) || !strlen(riga[2]))
    return;
  l = GTK_CLIST(gtk_object_get_data(GTK_OBJECT(button), "kb_list"));

  gtk_clist_append(l, riga);
}

void fill_combo(GtkCombo* cmb_string, char** cmds_names)
{
  int x;
  GList* combo_cmds = NULL;
  x = 0;
  while (cmds_names[x])
    {
      combo_cmds = g_list_append(combo_cmds, cmds_names[x]);
      x++;
    }
  gtk_combo_set_popdown_strings(GTK_COMBO(cmb_string), combo_cmds); 
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_string)->entry), "");
}

void empty_combo(GtkCombo* cmb_string)
{
  GtkWidget *list = cmb_string->list;
  gtk_list_clear_items(GTK_LIST(list), 0, -1);
}

void kb_action_select(GtkWidget* w, gpointer data)
{
  char* txt, **cmds_names;
  GtkWidget* win, *cmb_string;
  GtkEntry *entry;
  
  win = gtk_object_get_data(GTK_OBJECT(w), "win");
  /*printf("w: %p app: %p\n", w, app);*/
  
  cmb_string = (GtkWidget*)gtk_object_get_data(GTK_OBJECT(win), "cmb_string");
  cmds_names =app_config.cmds_names;
  txt = gtk_entry_get_text(GTK_ENTRY(w));
  if (!cmb_string)
    return;
  entry =  GTK_ENTRY(GTK_COMBO(cmb_string)->entry);
  if (!strncmp(txt, "Command", 7))
    {
      fill_combo(GTK_COMBO(cmb_string), cmds_names);
      gtk_entry_set_editable(entry, FALSE);
    }
  else if (!strcmp(txt, "Escape Sequence"))
    {
      empty_combo(GTK_COMBO(cmb_string));
      /* combo list should be void and text item editable */
      gtk_entry_set_editable(entry, TRUE);
    }
  else if (!strcmp(txt, "Switch To"))
    {
      empty_combo(GTK_COMBO(cmb_string)); 
      gtk_entry_set_editable(entry, TRUE);
    }
  else
    {
      /* combo list must be void and text item locked */
      empty_combo(GTK_COMBO(cmb_string));
      gtk_entry_set_editable(entry, FALSE);
    } 
}

static void
create_action_menu(GtkWidget *cmb,
	  	   char **menu_list)
{
  GList* l = NULL;
  
  while (*menu_list)
    {
      l = g_list_append (l, *menu_list);
      menu_list++;
    }
  gtk_combo_set_popdown_strings (GTK_COMBO (cmb), l);

#if 0  
  gtk_signal_connect_full (GTK_OBJECT (menu), 
				 "deactivate",
				 GTK_SIGNAL_FUNC (kb_set_active), NULL,
				 NULL, (GtkDestroyNotify)g_free,
				 FALSE, FALSE);
#endif
}

void append_modifier(GtkWidget*w, guint state)
{
  if (state & GDK_CONTROL_MASK)
    {
      gtk_entry_append_text(GTK_ENTRY(w), "C-");
    }
  if (state & GDK_MOD1_MASK)
    {
      gtk_entry_append_text(GTK_ENTRY(w), "A-");
    }
   /* 
  if (state & GDK_MOD2_MASK)
    {
      gtk_entry_append_text(GTK_ENTRY(w), "AGr-");
    }
    */
  if (state & GDK_SHIFT_MASK)
    {
      gtk_entry_append_text(GTK_ENTRY(w), "S-");
    }
}


void out_but(GtkWidget* w, guint button, guint state)
{
  /* for the moment do nothing here: we do not want to handle
     mouse buttone press event */
#if 0   
  append_modifier(w, state);

#endif
}

void out_key(GtkWidget* w, guint keyval, guint state)
{
  append_modifier(w, state);
  gtk_entry_append_text(GTK_ENTRY(w), gdk_keyval_name(keyval));
  gtk_entry_append_text(GTK_ENTRY(w), " ");
}

gboolean entrykb_keypress_event(GtkWidget* w, GdkEventKey* ev_key, gpointer data)
{
  guint kv;
  
  kv = ev_key->keyval;
  /* all modifiers should not be accepted as valid keys */
  if (kv == GDK_Control_L || kv == GDK_Control_R ||
      kv == GDK_Shift_L || kv == GDK_Shift_R || 
      kv == GDK_Meta_L || kv == GDK_Meta_R || 
      kv == GDK_Alt_L || kv == GDK_Alt_L ||
      kv == GDK_Shift_Lock || kv == GDK_Caps_Lock ||
      kv == GDK_Super_L || kv == GDK_Super_R ||
      kv == GDK_Hyper_L || kv == GDK_Hyper_R ||
      kv == GDK_Mode_switch
      
      )
    {
      return FALSE;
    }

  gtk_signal_handler_block_by_func(GTK_OBJECT(w), 
				   GTK_SIGNAL_FUNC(entrykb_keypress_event),
				   data);
  out_key (w, ev_key->keyval, ev_key->state); 
  gtk_signal_handler_unblock_by_func(GTK_OBJECT(w), 
				     GTK_SIGNAL_FUNC(entrykb_keypress_event),
				     data);
  gtk_signal_emit_stop_by_name(GTK_OBJECT(w), "key-press-event");
  return TRUE;
}
extern void
kb_lista_cmd_select_row                (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);
void kb_destroy(GtkWidget* win, gpointer data)
{
  gtk_object_set_data(GTK_OBJECT(data), "keybs_win", NULL);
}

gboolean pref_open(void)
{
  /*
   * check whether on window ha the preferences window open 
   * */
  GList* lapp; 
  lapp = terminals;
  /* Is a property window for this terminal already running? */
  if (gtk_object_get_data (GTK_OBJECT (lapp->data), "prefs"))
    return TRUE;
  else
    return FALSE;
}

void edit_keybindings(GtkWidget* w, gpointer data)
{
  /* SHORTCUTS, KEYBINDINGS */
  gchar *glade_file;
  char **cmds, **cmds_names;
  GtkWidget *app;
  GladeXML *gui;
  GSList* kbinds, **ptl;
  GtkWidget* win, *entry_kbind, *kb_list,
  *set_defaults, *switch_defaults;
  struct terminal_config* cfg;
  GtkWidget *but_clrstr, *but_clear, *edit_button, *cmb_action, *cmb_string, *upd_button;
  GtkWidget *add_button, *remove_button;
  GtkWidget *ok_button, *apply_button, *cancel_button, *popup_mod, *kb_disable;
  int x=0;
  char* riga[3], **vkeybinds, **vactions, **vstrings;
  
  glade_file = GNOME_TERMINAL_GLADEDIR "/win_keys.glade";
  app = gtk_widget_get_toplevel( GTK_WIDGET((*((GSList**) data))->data) );
  
  if (gtk_object_get_data(GTK_OBJECT(app), "keybs_win") || pref_open())
      return; /* keybs or pref window already opened */
  
  cmds = app_config.cmds;
  cmds_names = app_config.cmds_names;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  /* NOTE: we assume same config for all terms here!!! */
  cfg = gtk_object_get_data(GTK_OBJECT((*ptl)->data), "config");

  kbinds = gtk_object_get_data(GTK_OBJECT(app), "kbinds_list");  
  gui = glade_xml_new(glade_file, "win_keybind");
  if (!gui) {
    g_warning ("Error loading `%s'", glade_file);
    return;
  }
  win = glade_xml_get_widget(gui, "win_keybind");
  gtk_object_set_data(GTK_OBJECT(app), "keybs_win", win);

  /*gtk_widget_set_usize(win, 800, 600);*/
  gtk_window_set_modal(GTK_WINDOW(win), TRUE);

  cmb_string =  glade_xml_get_widget(gui, "cmb_string");

  cmb_action = glade_xml_get_widget(gui, "cmb_action");
  create_action_menu (cmb_action, actions_list);
  gtk_signal_connect (GTK_OBJECT(GTK_COMBO(cmb_action)->entry), "changed",
		      (GtkSignalFunc)kb_action_select, cmb_action);
  gtk_object_set_data(GTK_OBJECT(GTK_COMBO(cmb_action)->entry), "win", win);

  entry_kbind = glade_xml_get_widget(gui, "entry_kbind");
  kb_list = glade_xml_get_widget(gui, "kb_list");
  gtk_clist_set_reorderable(GTK_CLIST(kb_list), TRUE);
  gtk_clist_set_selection_mode(GTK_CLIST(kb_list), GTK_SELECTION_SINGLE);
  
  gtk_object_set_data(GTK_OBJECT(win), "kb_list", kb_list);

  vactions = app_config.actions;
  vstrings = app_config.strings;
  vkeybinds = app_config.keybinds; 
  if (vactions)
    {
      x = 0;
      while (vactions[x])
	{
	  riga[0] = vactions[x];
	  riga[1] = vstrings[x];
	  riga[2] = vkeybinds[x];
	  gtk_clist_append(GTK_CLIST(kb_list), riga);
	  x++;
	}
    }
  
  gtk_clist_columns_autosize(GTK_CLIST(kb_list)); 
  set_defaults = glade_xml_get_widget(gui, "but_defaults");
  gtk_signal_connect (GTK_OBJECT(set_defaults), "clicked", 
	 	      (GtkSignalFunc) on_set_def_clicked, app);
  switch_defaults = glade_xml_get_widget(gui, "but_setswdef");
  gtk_signal_connect (GTK_OBJECT(switch_defaults), "clicked", 
	 	      (GtkSignalFunc) on_switch_def_clicked, app);
  add_button = glade_xml_get_widget(gui, "but_add");
  remove_button = glade_xml_get_widget(gui, "but_rmv");
  upd_button = glade_xml_get_widget(gui, "but_upd");
  edit_button = glade_xml_get_widget(gui, "but_edit");
  popup_mod = glade_xml_get_widget(gui, "popup_mod");
  kb_disable = glade_xml_get_widget(gui, "kb_disable");
  gtk_object_set_data(GTK_OBJECT(win), "popup_mod", popup_mod);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (kb_disable),
				      app_config.disable_keybind? 1 : 0);
  gtk_object_set_data(GTK_OBJECT(win), "kb_disable", kb_disable);
  
  gtk_option_menu_set_history(GTK_OPTION_MENU(popup_mod), app_config.popupmod);
  
  but_clear = glade_xml_get_widget(gui, "but_clear");
  gtk_signal_connect(GTK_OBJECT(but_clear), "clicked", 
		     (GtkSignalFunc) kb_clear_clicked,
		     NULL);
  gtk_object_set_data(GTK_OBJECT(but_clear), "keybind", (gpointer) entry_kbind);
  gtk_object_set_data(GTK_OBJECT(but_clear),"action", (gpointer) cmb_action);

  but_clrstr = glade_xml_get_widget(gui, "but_clrstr");
  gtk_signal_connect(GTK_OBJECT(but_clrstr), "clicked", 
		     (GtkSignalFunc) kb_clrstr_clicked,
		     NULL);
  gtk_object_set_data(GTK_OBJECT(but_clrstr),"string", (gpointer) cmb_string);
  gtk_object_set_data(GTK_OBJECT(but_clrstr),"action", (gpointer) cmb_action);


  gtk_signal_connect (GTK_OBJECT(add_button), "clicked", 
	 	      (GtkSignalFunc) kb_add_clicked, NULL);
  gtk_signal_connect (GTK_OBJECT(remove_button), "clicked",
	 	      (GtkSignalFunc)kb_remove_clicked, NULL);
  gtk_signal_connect (GTK_OBJECT(upd_button), "clicked",
  		      (GtkSignalFunc) kb_upd_clicked, (gpointer)kb_list);
  gtk_signal_connect (GTK_OBJECT(edit_button), "clicked", (GtkSignalFunc) kb_edit_clicked,
		      kb_list);
  
  /* add button attributes */
  gtk_object_set_data(GTK_OBJECT(add_button),"action", (gpointer) cmb_action);
  gtk_object_set_data(GTK_OBJECT(add_button),"string", (gpointer) cmb_string);
  gtk_object_set_data(GTK_OBJECT(add_button),"keybind", (gpointer) entry_kbind);
  gtk_object_set_data(GTK_OBJECT(add_button), "kb_list", (gpointer) kb_list);  

  /* remove button attributes */
  gtk_object_set_data(GTK_OBJECT(remove_button), "kb_list", (gpointer) kb_list);  
  gtk_object_set_data(GTK_OBJECT(switch_defaults), "kb_list", (gpointer) kb_list);  
  gtk_object_set_data(GTK_OBJECT(set_defaults), "kb_list", (gpointer) kb_list);  

  /* update button attributes */
  gtk_object_set_data(GTK_OBJECT(upd_button),"action", (gpointer) cmb_action);
  gtk_object_set_data(GTK_OBJECT(upd_button),"string", (gpointer) cmb_string);
  gtk_object_set_data(GTK_OBJECT(upd_button),"keybind", (gpointer) entry_kbind);
  gtk_object_set_data(GTK_OBJECT(upd_button), "kb_list", (gpointer) kb_list);  

  gtk_object_set_data(GTK_OBJECT(edit_button),"action", (gpointer) cmb_action);
  gtk_object_set_data(GTK_OBJECT(edit_button),"string", (gpointer) cmb_string);
  gtk_object_set_data(GTK_OBJECT(edit_button),"keybind", (gpointer) entry_kbind);
  gtk_object_set_data(GTK_OBJECT(edit_button), "kb_list", (gpointer) kb_list);  

  ok_button = glade_xml_get_widget(gui, "ok_button");
  cancel_button = glade_xml_get_widget(gui, "cancel_button");
  apply_button = glade_xml_get_widget(gui, "apply_button");
  gtk_signal_connect (GTK_OBJECT(ok_button), "clicked",
		      (GtkSignalFunc) kb_ok_button_clicked, app);
  gtk_signal_connect (GTK_OBJECT(apply_button), "clicked",
		      (GtkSignalFunc) kb_apply_button_clicked, app);
  gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
		     (GtkSignalFunc) kb_cancel_button_clicked, NULL);
  gtk_signal_connect(GTK_OBJECT(win), "destroy", (GtkSignalFunc) kb_destroy, app);

  glade_xml_signal_autoconnect(gui);
  /*win = glade_xml_get_widget(gui, "win_keybind");*/
  /*gtk_widget_set_usize(win, 500, 400);*/
  /*gtk_window_set_modal(GTK_WINDOW(win), TRUE);*/
  
  gtk_combo_disable_activate(GTK_COMBO(cmb_string));
  gtk_object_set_data(GTK_OBJECT(win), "cmb_string", cmb_string);
  gtk_object_set_data(GTK_OBJECT(win), "cmds_names", cmds_names);
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_string)->entry), "");

  gtk_signal_connect(GTK_OBJECT(entry_kbind), "key-press-event", (GtkSignalFunc) entrykb_keypress_event, data);
  gtk_object_unref(GTK_OBJECT(gui));

}

extern void on_clear_button_clicked   (GtkButton       *button,
	  			       gpointer         user_data);
extern void on_edit_button_clicked   (GtkButton       *button,
		 		      gpointer         user_data);
extern void on_cancel_button_clicked               (GtkButton       *button,
                                        gpointer         user_data);

extern void on_su_get_clicked(GtkButton *button, 
		       gpointer user_data);
extern void on_update_button_clicked (GtkButton       *button,
	       			      gpointer         user_data);
extern void su_update_button_clicked (GtkButton       *button,
	       			      gpointer         user_data);
extern void load_su_tabs(GtkWidget* app, char* prefix);
void ec_build_list(GtkWidget* l, 
		   char** n, char** p, char** c, char **cl)
{
  int x;
  char *riga[4];

  x = 0;
  gtk_clist_clear(GTK_CLIST(l));
  while (n[x])
    {  
      riga[0] = n[x];
      riga[1] = p[x];
      riga[2] = c[x];
      riga[3] = cl[x];
      gtk_clist_append(GTK_CLIST(l), riga);
      x++;
    }
}


void  ec_cmb_list_select(GtkEditable *l,  gpointer data)
{
  GtkWidget *cmb = (GtkWidget*)data, *app, *cb;
  gchar* prefix;
  gchar *winclass, *cur_class, **n, **p, **c, **cl;
  GtkWidget* sul;
  int cb_state;

  if (!strcasecmp (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cmb)->entry)),
	       _("Default")))
    winclass = g_strdup ("Win-Config");
  else
    winclass = g_strconcat ("Win-Class-", 
			 gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (cmb)->entry)), NULL);

  prefix = g_strdup_printf("/MultiTerminal/%s/", winclass);
  cur_class = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmb)->entry));
  app = gtk_object_get_data(GTK_OBJECT(cmb), "app");
  sul = gtk_object_get_data(GTK_OBJECT(cmb), "su_list");
  cb =  gtk_object_get_data(GTK_OBJECT(cmb), "check_button");   
  if (cur_class && strcasecmp(winclass, cur_class))
    {
      load_su_tabs(app, prefix);
      n = gtk_object_get_data(GTK_OBJECT(app), "su_names");
      p = gtk_object_get_data(GTK_OBJECT(app), "su_paths");
      c = gtk_object_get_data(GTK_OBJECT(app), "su_cmds");
      cl =gtk_object_get_data(GTK_OBJECT(app), "su_classes");
      gnome_config_push_prefix(prefix);
      cb_state = gnome_config_get_bool("nosutabs=true");
      gnome_config_pop_prefix();
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), cb_state);    
      ec_build_list(sul, n, p, c, cl);
    }
  g_free(prefix);
  g_free(winclass);
}
void free_classlist(GList *cl)
{
  GList *l;
  l=cl;
  while (l)
    {
      g_free(l->data);
      l = l->next;
    }
  g_list_free(cl);
}

GList *tabclass_search(gchar * class, int *num)
{
  int nc=0;
  void *iter;
  char *some_class;
  GList *cl = NULL;
  iter = gnome_config_init_iterator_sections ("/MultiTerminal");
  while (gnome_config_iterator_next (iter, &some_class, NULL)){
    if (!strcmp (some_class, "Config") || !strncmp (some_class, "Class-", 6)){
      if (class && !strcasecmp(some_class, class))
	{
	  if (num)
	    *num = nc;
	}
      if (!strcmp (some_class, "Config")) 
	{
	  g_free(some_class);
	  some_class = g_strdup(_("Default"));
	}
      else
	{
	  char *oc = some_class;
	  some_class = g_strdup(oc+6);
	  g_free(oc);
	}
      /*printf("some_class: %s\n", some_class);*/
      cl = g_list_append (cl, some_class);
      nc++;
    }
  }
  if (!cl)
    {
      cl = g_list_append(cl, g_strdup(_("Default")));
      if (num)
	*num = 0;
    }

  return cl;
}
GList *tabclass_list(void)
{
  return tabclass_search(NULL, NULL);
}

GList *winclass_list(void)
{
  void *iter;
  char *some_class;
  GList *cl = NULL;

  iter = gnome_config_init_iterator_sections ("/MultiTerminal");
  while (gnome_config_iterator_next (iter, &some_class, NULL)){
    if (!strcmp (some_class, "Win-Config") || !strncmp (some_class, "Win-Class-", 10)){
      if (!strcmp (some_class, "Win-Config")) 
	{
	  g_free(some_class);
	  some_class = g_strdup(_("Default"));
	}
      else
	{
	  char *oc = some_class;
	  some_class = g_strdup(oc+10);
	  g_free(oc);
	}
      /*printf("some_class: %s\n", some_class);*/
      cl = g_list_append (cl, some_class);
    }
  }
  if (!cl)
    {
      cl = g_list_append(cl, g_strdup(_("Default")));
    }
 return cl;
}
void edit_commands(GtkWidget* w, gpointer data)
{
  gchar *glade_file;
  GtkWidget *app;
  GSList** ptl;
  GList* class_list = NULL;
  GladeXML *gui;
  struct terminal_config* cfg;
  struct win_config *wincfg;
  GtkWidget **wchk_hardset;
  GtkWidget* win, *txt_name, *txt_command, *lista_cmd, *add_button, *remove_button;
  GtkWidget *edit_button, *del_button, *apply_button, *cancel_button, *ok_button;
  GtkWidget *upd_button, *clear_button;
  GtkWidget *su_edit, *su_add, *su_update, *su_remove, *su_get, *lista_sutabs, *su_chk,
   *txt_path, *txt_class;
  GtkWidget *cmb_class, *cmb_tabclass;
  char** cmds, **cmds_names, **cmds_paths, **su_cmds, **su_paths, **su_names,
  **su_classes, **cmds_classes;
  char *some_class;
  glade_file = GNOME_TERMINAL_GLADEDIR "/edit_cmd.glade";
  app = gtk_widget_get_toplevel( GTK_WIDGET((*((GSList**) data))->data) );
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  cfg = gtk_object_get_data(GTK_OBJECT((*ptl)->data), "config");
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");

  if (gtk_object_get_data(GTK_OBJECT(app), "tabs_win") || pref_open())
    return; /* search window already opened */
   
  cmds = app_config.cmds;  
  cmds_names = app_config.cmds_names;
  cmds_paths = app_config.cmds_paths;
  cmds_classes = app_config.cmds_classes;
  su_cmds = gtk_object_get_data(GTK_OBJECT(app), "su_cmds");  
  su_names = gtk_object_get_data(GTK_OBJECT(app), "su_names");
  su_paths = gtk_object_get_data(GTK_OBJECT(app), "su_paths");
  su_classes = gtk_object_get_data(GTK_OBJECT(app), "su_classes");
  gui = glade_xml_new(glade_file, "edit_cmd");
  if (!gui) {
    g_warning ("Error loading `%s'", glade_file);
    return;
  }

  glade_xml_signal_autoconnect(gui);
  win = glade_xml_get_widget(gui, "edit_cmd");
  gtk_object_set_data(GTK_OBJECT(app), "tabs_win", win);
  /*gtk_widget_set_usize(win, 800, 600);*/
  gtk_window_set_modal(GTK_WINDOW(win), TRUE);
  txt_name = glade_xml_get_widget(gui, "txt_name");
  /* buttons for menu tabs */
  add_button = glade_xml_get_widget(gui, "add_button");
  remove_button = glade_xml_get_widget(gui, "remove_button");
  clear_button = glade_xml_get_widget(gui, "clear_button");
  edit_button = glade_xml_get_widget(gui, "edit_button");
  upd_button =  glade_xml_get_widget(gui, "upd_button");

  /* button related to startup tabs */
  su_add = glade_xml_get_widget(gui, "su_add");
  su_remove = glade_xml_get_widget(gui, "su_remove");
  su_get = glade_xml_get_widget(gui, "su_get");
  su_edit = glade_xml_get_widget(gui, "su_edit");
  su_update =  glade_xml_get_widget(gui, "su_update");
  su_get = glade_xml_get_widget(gui, "su_get");
  su_chk = glade_xml_get_widget(gui, "chk_suopen");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (su_chk),
				wincfg->no_startuptabs ? 1 : 0);
  del_button = glade_xml_get_widget(gui, "su_del"); 
  ok_button = glade_xml_get_widget(gui, "ok_button");
  cancel_button = glade_xml_get_widget(gui, "cancel_button");
  apply_button = glade_xml_get_widget(gui, "apply_button");
  
  txt_command = glade_xml_get_widget(gui, "txt_command");
  txt_path = glade_xml_get_widget(gui, "txt_path");
  txt_class= glade_xml_get_widget(gui, "entry-tabclass");
  cmb_tabclass = glade_xml_get_widget(gui, "cmb-tabclass");

  lista_cmd = glade_xml_get_widget(gui, "lista_cmd");
  gtk_clist_set_reorderable(GTK_CLIST(lista_cmd), TRUE);
  /*gtk_clist_set_column_auto_resize(GTK_CLIST(lista_cmd), 0, TRUE);
  gtk_clist_set_column_auto_resize(GTK_CLIST(lista_cmd), 1, TRUE);
  gtk_clist_set_column_auto_resize(GTK_CLIST(lista_cmd), 2, TRUE);*/
  lista_sutabs = glade_xml_get_widget(gui, "lista_sutabs"); 
  gtk_clist_set_reorderable(GTK_CLIST(lista_sutabs), TRUE);
  ec_build_list(lista_cmd, cmds_names, cmds_paths, cmds, cmds_classes);
  ec_build_list(lista_sutabs, su_names, su_paths, su_cmds, su_classes);
 
  /* get hardset entries */
  wchk_hardset = g_malloc0(sizeof(GtkWidget*)*(NUM_HARDSET+1));
  wchk_hardset[0] = glade_xml_get_widget (gui, "hschk_shell");
  wchk_hardset[1] = glade_xml_get_widget (gui, "hschk_root");
  wchk_hardset[2] = glade_xml_get_widget (gui, "hschk_mc");
  wchk_hardset[3] = glade_xml_get_widget (gui, "hschk_split");
  wchk_hardset[4] = glade_xml_get_widget (gui, "hschk_view");
  wchk_hardset[5] = glade_xml_get_widget (gui, "hschk_newtab");
  wchk_hardset[6] = glade_xml_get_widget (gui, "hschk_hideall");

  gtk_clist_set_selection_mode(GTK_CLIST(lista_cmd), GTK_SELECTION_SINGLE);
  gtk_clist_set_selection_mode(GTK_CLIST(lista_sutabs), GTK_SELECTION_SINGLE);

  cmb_class = glade_xml_get_widget(gui, "cmb-class");
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cmb_class)->entry), FALSE);
  gtk_object_set_data(GTK_OBJECT(cmb_class), "app", app);
  gtk_object_set_data(GTK_OBJECT(cmb_class), "config", cfg);
  gtk_object_set_data(GTK_OBJECT(cmb_class), "su_list", lista_sutabs);
  gtk_object_set_data(GTK_OBJECT(cmb_class), "check_button", su_chk);
  /* win class */
  class_list = winclass_list(); 
  if(class_list)
    gtk_combo_set_popdown_strings (GTK_COMBO (cmb_class), class_list);
  gtk_signal_connect (GTK_OBJECT(GTK_COMBO(cmb_class)->entry), "changed",
		      (GtkSignalFunc)ec_cmb_list_select, cmb_class);
  
  if (!strcmp (wincfg->class, "Win-Config")) 
    some_class = _("Default");
  else
    some_class = wincfg->class + 10;
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(cmb_class)->entry), some_class);
  free_classlist(class_list); 
  /* tab class */
  class_list = tabclass_list();
  class_list = g_list_prepend(class_list, g_strdup("None"));
  if(class_list)
    gtk_combo_set_popdown_strings (GTK_COMBO (cmb_tabclass), class_list);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cmb_tabclass)->entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(cmb_tabclass)->entry), "None");
  free_classlist(class_list); 
  /* ====================================== */

  gtk_signal_connect (GTK_OBJECT(add_button), "clicked", 
	 	      (GtkSignalFunc) on_add_button_clicked, (gpointer)lista_cmd);
  gtk_signal_connect (GTK_OBJECT(upd_button), "clicked", 
	 	      (GtkSignalFunc) on_update_button_clicked, (gpointer)lista_cmd);
  gtk_signal_connect (GTK_OBJECT(remove_button), "clicked",
	 	      (GtkSignalFunc)on_remove_button_clicked, (gpointer)lista_cmd);
  gtk_signal_connect (GTK_OBJECT(clear_button), "clicked",
  		      (GtkSignalFunc) on_clear_button_clicked, (gpointer)lista_cmd);
  gtk_signal_connect (GTK_OBJECT(edit_button), "clicked",
		      (GtkSignalFunc) on_edit_button_clicked, (gpointer)lista_cmd);
  
  gtk_signal_connect (GTK_OBJECT(su_add), "clicked", 
	 	      (GtkSignalFunc) su_add_button_clicked, (gpointer) lista_sutabs);
  gtk_signal_connect (GTK_OBJECT(su_remove), "clicked",
	 	      (GtkSignalFunc)on_remove_button_clicked, (gpointer) lista_sutabs);
  gtk_signal_connect (GTK_OBJECT(su_edit), "clicked",
		      (GtkSignalFunc) on_edit_button_clicked, (gpointer)lista_sutabs);
  gtk_signal_connect (GTK_OBJECT(su_update), "clicked",
		      (GtkSignalFunc) su_update_button_clicked, (gpointer)lista_sutabs);
  gtk_signal_connect (GTK_OBJECT(su_get), "clicked", (GtkSignalFunc) on_su_get_clicked, 
		      (gpointer) lista_sutabs); 
  gtk_signal_connect (GTK_OBJECT(ok_button), "clicked",
		      (GtkSignalFunc) on_ok_button_clicked, app);
  gtk_signal_connect (GTK_OBJECT(apply_button), "clicked",
		      (GtkSignalFunc) on_apply_button_clicked, app);
  gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
		     (GtkSignalFunc) on_cancel_button_clicked, NULL);
  gtk_signal_connect(GTK_OBJECT(win), "destroy", (GtkSignalFunc)ec_destroy, app);

  gtk_object_set_data(GTK_OBJECT(add_button),"txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(add_button),"txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(add_button),"txt_path", (gpointer) txt_path);
  gtk_object_set_data(GTK_OBJECT(add_button),"txt_class", (gpointer) txt_class);
  gtk_object_set_data(GTK_OBJECT(add_button),"lista_cmd", (gpointer) lista_cmd);
  gtk_object_set_data(GTK_OBJECT(su_add),"txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(su_add),"txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(su_add),"txt_path", (gpointer) txt_path);
  gtk_object_set_data(GTK_OBJECT(su_add),"txt_class", (gpointer) txt_class);
  gtk_object_set_data(GTK_OBJECT(su_add),"lista_sutabs", (gpointer) lista_sutabs);
  gtk_object_set_data(GTK_OBJECT(su_get), "lista_cmd", (gpointer) lista_cmd);

  gtk_object_set_data(GTK_OBJECT(remove_button), "lista_cmd", (gpointer) lista_cmd);  
  gtk_object_set_data(GTK_OBJECT(su_remove), "lista_sutabs", (gpointer) lista_sutabs);  

  
  gtk_object_set_data(GTK_OBJECT(clear_button), "txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(clear_button), "txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(clear_button),"txt_path", (gpointer) txt_path);
  gtk_object_set_data(GTK_OBJECT(clear_button),"txt_class", (gpointer) txt_class);
  gtk_object_set_data(GTK_OBJECT(clear_button), "txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(clear_button), "txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(clear_button),"txt_path", (gpointer) txt_path);
  gtk_object_set_data(GTK_OBJECT(clear_button),"txt_class", (gpointer) txt_class);
  
  gtk_object_set_data(GTK_OBJECT(edit_button), "txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(edit_button), "txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(edit_button),"txt_path", (gpointer) txt_path);
  gtk_object_set_data(GTK_OBJECT(edit_button),"txt_class", (gpointer) txt_class);
  gtk_object_set_data(GTK_OBJECT(su_edit), "txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(su_edit), "txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(su_edit),"txt_path", (gpointer) txt_path);
  gtk_object_set_data(GTK_OBJECT(su_edit),"txt_class", (gpointer) txt_class);
  gtk_object_set_data(GTK_OBJECT(upd_button), "txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(upd_button), "txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(upd_button),"txt_path", (gpointer) txt_path);
  gtk_object_set_data(GTK_OBJECT(upd_button),"txt_class", (gpointer) txt_class);
  gtk_object_set_data(GTK_OBJECT(su_update), "txt_command", (gpointer) txt_command);
  gtk_object_set_data(GTK_OBJECT(su_update), "txt_name", (gpointer) txt_name);
  gtk_object_set_data(GTK_OBJECT(su_update),"txt_path", (gpointer) txt_path);
  gtk_object_set_data(GTK_OBJECT(su_update),"txt_class", (gpointer) txt_class);

  gtk_object_set_data(GTK_OBJECT(ok_button), "lista_cmd", (gpointer) lista_cmd);
  gtk_object_set_data(GTK_OBJECT(ok_button), "lista_sutabs", (gpointer) lista_sutabs);
  gtk_object_set_data(GTK_OBJECT(ok_button), "chk_suopen", (gpointer) su_chk);
  gtk_object_set_data(GTK_OBJECT(ok_button), "cmb-class", cmb_class);

  gtk_object_set_data(GTK_OBJECT(apply_button), "lista_cmd", (gpointer) lista_cmd);
  gtk_object_set_data(GTK_OBJECT(apply_button), "lista_sutabs", (gpointer) lista_sutabs);
  gtk_object_set_data(GTK_OBJECT(apply_button), "chk_suopen", (gpointer) su_chk);
  gtk_object_set_data(GTK_OBJECT(apply_button), "cmb-class", cmb_class);
  
  gtk_object_set_data(GTK_OBJECT(win), "lista_cmd", (gpointer) lista_cmd);
  gtk_object_set_data(GTK_OBJECT(win), "lista_sutabs", (gpointer) lista_sutabs);
  gtk_object_set_data_full(GTK_OBJECT(win), "chk_hardset", (gpointer) wchk_hardset,
			   g_free);
  update_hardset(wchk_hardset);
  gtk_clist_columns_autosize(GTK_CLIST(lista_cmd)); 
  gtk_clist_columns_autosize(GTK_CLIST(lista_sutabs)); 

  gtk_object_unref(GTK_OBJECT(gui));
}
void gtk_flush_all_events(void);
/* point to the other tables */
extern gushort *scheme_red[]; 
extern gushort *scheme_blue[]; 
extern gushort *scheme_green[]; 


void set_parent(GtkWidget* w, GtkWidget *pane)
{
  GtkWidget* parent = gtk_object_get_data(GTK_OBJECT(pane), "parent");
  GtkWidget* term, *c1, *c2;
  if (GTK_IS_HBOX(w))
    {
      term = gtk_object_get_data(GTK_OBJECT(w), "term");
      gtk_object_set_data(GTK_OBJECT(term), "parent", parent);
      gtk_object_set_data(GTK_OBJECT(term), "pane", pane);
    }
  else if (GTK_IS_PANED(w))
    {
      gtk_object_set_data(GTK_OBJECT(w), "parent", pane);
      c1 = GTK_PANED(w)->child1;
      if (c1 && GTK_IS_HBOX(c1))
	{
	  term = gtk_object_get_data(GTK_OBJECT(c1), "term");
	  gtk_object_set_data(GTK_OBJECT(term), "parent", pane);
	  gtk_widget_queue_resize(term);
	}

      c2 = GTK_PANED(w)->child2;
      if (c2 && GTK_IS_HBOX(c2))
	{
	  term = gtk_object_get_data(GTK_OBJECT(c2), "term");
	  gtk_object_set_data(GTK_OBJECT(term), "parent", pane);
	  gtk_widget_queue_resize(term);
	}
    }
}
void
queue_color_scheme (ZvtTerm *term, struct terminal_config *color_cfg) 
{
  gushort red[20],green[20],blue[20];
  int i;
  gushort *r, *b, *g;

  switch (color_cfg->color_type){
  default:		/* and 0 */
    color_cfg->color_type = 0;
  case PALETTE_LINUX:
  case PALETTE_XTERM:
  case PALETTE_RXVT:
    r = scheme_red[color_cfg->color_type];
    g = scheme_green[color_cfg->color_type];
    b = scheme_blue[color_cfg->color_type];
    for (i=0;i<18;i++) {
      red[i] = r[i];
      green[i] = g[i];
      blue[i] = b[i];
    }
    break;
  case PALETTE_CUSTOM:
    for (i=0;i<18;i++) {
      red[i] = color_cfg->palette[i].red;
      green[i] = color_cfg->palette[i].green;
      blue[i] = color_cfg->palette[i].blue;
    }
    break;
  }

  switch (color_cfg->color_set){
    /* White on black */
  case COLORS_WHITE_ON_BLACK:
    red   [16] = red [7];
    blue  [16] = blue [7];
    green [16] = green [7];
    red   [17] = red [0];
    blue  [17] = blue [0];
    green [17] = green [0];
    break;

    /* black on white */
  case COLORS_BLACK_ON_WHITE:
    red   [16] = red [0];
    blue  [16] = blue [0];
    green [16] = green [0];
    red   [17] = red [7];
    blue  [17] = blue [7];
    green [17] = green [7];
    break;

    /* Green on black */
  case COLORS_GREEN_ON_BLACK:
    red   [17] = 0;
    green [17] = 0;
    blue  [17] = 0;
    red   [16] = 0;
    green [16] = 0xffff;
    blue  [16] = 0;
    break;

    /* Black on light yellow */
  case COLORS_BLACK_ON_LIGHT_YELLOW:
    red   [16] = 0;
    green [16] = 0;
    blue  [16] = 0;
    red   [17] = 0xffff;
    green [17] = 0xffff;
    blue  [17] = 0xdddd;
    break;

    /* Custom foreground, custom background */
  case COLORS_CUSTOM:
    for (i=16;i<18;i++) {
      red[i] = color_cfg->palette[i].red;
      green[i] = color_cfg->palette[i].green;
      blue[i] = color_cfg->palette[i].blue;
    }
    break;
  }
  /* text shadow */ 
  red[18]   = color_cfg->palette[18].red;
  green[18] = color_cfg->palette[18].green;
  blue[18]  = color_cfg->palette[18].blue;
  /* bold color */ 
  red[19]   = color_cfg->palette[19].red;
  green[19] = color_cfg->palette[19].green;
  blue[19]  = color_cfg->palette[19].blue;


  zvt_term_set_color_scheme (term, red, green, blue);
}
void fix_terms(GtkWidget* pane, struct terminal_config* cfg)
{
  GtkWidget* c1, *c2;
  ZvtTerm* term;
  /* if terms are unrealized doing a zvt_term_color_scheme
   * zvtterm store RBG colors as private date and it will use them
   * when it will be realized again, with this trick we got no more
   * black chars removing and adding a terminal */

  if (GTK_IS_HBOX(pane))
    {
      term = ZVT_TERM(gtk_object_get_data(GTK_OBJECT(pane), "term"));
      queue_color_scheme(term, cfg);
      ZVT_TERM(term)->force_resize=1;
      /*ZVT_TERM(term)->force_paint=1;*/
      gtk_widget_queue_resize(GTK_WIDGET(term));
      gtk_widget_queue_draw(GTK_WIDGET(term));
      return;
    }
  if (!GTK_IS_PANED(pane))
    {
      printf("MGT Warning: mmm bad things...not a paned nor hbox what then?\n");
      return;
    }
  c1 = GTK_PANED(pane)->child1;
  c2 = GTK_PANED(pane)->child2;
  if (c1 && (GTK_IS_HBOX(c1) || GTK_IS_PANED(c1)))
    {
      fix_terms(c1, cfg);
    }
  if (c2 && (GTK_IS_HBOX(c2) || GTK_IS_PANED(c2)))
    {
      fix_terms(c2, cfg);
    }
}

GtkWidget* set_new_active(GtkWidget* pane, GtkWidget* tab)
{
  GtkWidget* c1, *c2;
  GtkWidget* term;
  
  if (GTK_IS_HBOX(pane))
    {
      term = gtk_object_get_data(GTK_OBJECT(pane), "term");
      gtk_object_set_data(GTK_OBJECT(tab), "active", term); 
      return term;
    }

  c1 = GTK_PANED(pane)->child1;
  c2 = GTK_PANED(pane)->child2;
  if (c1 && (GTK_IS_HBOX(c1) || GTK_IS_PANED(c1)))
    {
      if ((term = set_new_active(c1, tab)))
	return term;
    }
  if (c2 && (GTK_IS_HBOX(c2) || GTK_IS_PANED(c2)))
    {
      if ((term = set_new_active(c2, tab)))
	return term;
    }
  return NULL;
}
void remove_term(GtkWidget* term);
#if 1
static void
widget_allocate_callback (GtkWidget *widget, GdkEvent *event, gint *flag)
{
  *flag = TRUE;
  gtk_signal_disconnect_by_data (GTK_OBJECT (widget), flag);
}

void
do_allocate (GtkWidget *widget)
{
  gint flag = FALSE;
  
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_WIDGET (widget));

  /* make sure we will get event */
  gtk_signal_connect (GTK_OBJECT (widget), "size-allocate",
		      GTK_SIGNAL_FUNC (widget_allocate_callback), 
		      &flag);
  
  while (!flag)
    gtk_main_iteration();

}
#endif

void set_destroy_data(GtkWidget* app, GtkWidget* term)
{
  struct terminal_config* cfg;
  GtkWidget* prefs_win;

  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");	    
  gtk_object_set_data(GTK_OBJECT(app), "config", terminal_config_dup(cfg));
  prefs_win = gtk_object_get_data(GTK_OBJECT(term), "prefs");
  gtk_object_set_data(GTK_OBJECT(app), "prefs", prefs_win);
}

/* g.o. - this function has been deeply changed */
void detach_term(GtkWidget* term, int preserve)
{
  /* remove a certain term from the notebook */
  GSList **ptl, **tabl, **tab_terms, **view_list, *vl; 
  GtkWidget *nb, *ochild, *app, *hbox, *tab, *pane, *parent, *aterm;
  int *new_out, *state, index, aw, ah, w, h, cs, pw = 0, ph = 0, child;
  char *sdir, *ttit, *nt, *scmd;
  struct terminal_config *rcfg;
  app = gtk_widget_get_toplevel(term);
  tab = gtk_object_get_data (GTK_OBJECT (term), "tab");
  /* first of all remove all views if term */
  if (!preserve)
    {
      view_list = gtk_object_get_data(GTK_OBJECT(term), "view_list");
      if (view_list)
	{
	  vl = g_slist_copy(*view_list);
	  /* remove also all views of term */
	  while (vl)
	    {
	      remove_term(GTK_WIDGET(vl->data));
	      vl = vl->next;
	    }
	  g_slist_free(*view_list);
	  g_slist_free(vl);
	  g_free(view_list);
	}
      /* if it is a view remove itself from view list of terminal viewed */
      if (ZVT_TERM(term)->view_of)
	{
	  GtkWidget* vterm = ZVT_TERM(term)->view_of;
	  view_list = gtk_object_get_data(GTK_OBJECT(vterm), "view_list"); 
	  *view_list = g_slist_remove(*view_list, term);
	}
    }

  gtk_object_set_data(GTK_OBJECT(tab), "active", NULL);

  tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
  pane = gtk_object_get_data(GTK_OBJECT(term), "pane");
  w = pane->allocation.width;
  h = pane->allocation.height;
  aw = app->allocation.width;
  ah = app->allocation.height;
  rd(printf("dimensions: %d, %d\n", w / ZVT_TERM(term)->charwidth, ZVT_TERM(term)->charheight ));
  parent = gtk_object_get_data(GTK_OBJECT(term), "parent");
  if (parent)
    {
      pw = parent->allocation.width;
      ph = parent->allocation.height;
      cs = GTK_PANED(parent)->child1_size;
    }
  hbox =   gtk_object_get_data(GTK_OBJECT(term), "hbox");
  if (!pane)
    printf("MGT Warning: term without pane!\n");
  tabl = gtk_object_get_data (GTK_OBJECT(app), "tablist");
  index = g_slist_index (*tabl, (gpointer) tab);
  ptl = gtk_object_get_data (GTK_OBJECT(app), "ptermlist");
  if (g_slist_length(*ptl) == 1)
    {
      set_destroy_data(app, term);
      if (preserve)
	{
	  *ptl = g_slist_remove(*ptl, term);
	  *tab_terms = g_slist_remove(*tab_terms, term);
	  gtk_widget_ref(hbox);
	  gtk_container_remove(GTK_CONTAINER(pane), hbox);
	}
      ok_close_app(app);
      return;
    }

  rcfg = gtk_object_get_data(GTK_OBJECT(term), "config");
 
  *ptl = g_slist_remove(*ptl, term);
  /* Free bytes allocated for termname */
  nt = (char *) gtk_object_get_data(GTK_OBJECT(term), "mtermname");
  state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
  new_out = gtk_object_get_data(GTK_OBJECT(term), "new_out");
  ttit = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
  sdir = gtk_object_get_data(GTK_OBJECT(term), "startpath");
  scmd = gtk_object_get_data(GTK_OBJECT(term), "start_cmd");

  if (g_slist_length(*tab_terms)>1)
   {
     if (GTK_PANED(pane)->child1 == hbox)
       {
	 child = 2; 
	 ochild = GTK_PANED(pane)->child2;
       }
     else if (GTK_PANED(pane)->child2 == hbox)
       {
	 child = 1;
	 ochild = GTK_PANED(pane)->child1;
       }
     else
       {
	 printf("MGT Warning: pane has no hbox child!\n");
	 ochild = NULL;
       }
     *tab_terms = g_slist_remove(*tab_terms, term);
     if (ochild)
       {
	 gtk_widget_ref(ochild);
	 gtk_container_remove(GTK_CONTAINER(pane), ochild);
       }
     /*gtk_container_remove(GTK_CONTAINER(parent), pane);*/
     if (preserve)
       {
	 gtk_widget_ref(hbox);
	 gtk_container_remove(GTK_CONTAINER(pane), hbox);
       }
     gtk_widget_destroy(pane);
     fix_terms(ochild, rcfg);
     
     if (ochild)
       {
	 gtk_container_add(GTK_CONTAINER(parent), ochild);
	 gtk_widget_unref(ochild);
	 set_parent(ochild, parent);
	 /* FIXME: if there is some resize problem here we have to check */
	 gtk_widget_set_usize(ochild, pw, ph);
       }
     if (!(aterm = set_new_active(parent, tab)))
       {
	 rd(printf("parent: %p not found active term??? guess one...\n", parent));
	 aterm = GTK_WIDGET((*tab_terms)->data);
	 gtk_object_set_data(GTK_OBJECT (tab), "active", (*tab_terms)->data);
       }
     set_titles (app, index, index);
     XSync(GDK_DISPLAY(), False);
     gtk_widget_queue_resize(GTK_WIDGET(app));
#if 0
     nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
     gtk_notebook_set_page(GTK_NOTEBOOK(nb), 
			   gtk_notebook_get_current_page(GTK_NOTEBOOK(nb)));
#endif
     /*if (!preserve)
       gtk_flush_all_events();*/
     if (!preserve && GTK_WIDGET_DRAWABLE(aterm))
       {
	 gtk_widget_grab_focus(aterm);
       }
   }
 else
   {
     int create_pg, last_pg, newpg;
     GtkWidget* newtab;
     nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
     /*gtk_container_remove(GTK_CONTAINER(parent), pane);*/
     rd(printf("qui\n"));
     /* here we choose a different page */
     last_pg = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), "last_pg"));
     create_pg  = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), "new_pg"));
     if (last_pg && create_pg && (create_pg-1) == index) 
       {
	 /* NOTE: last_pg starts from 1...*/
	 newpg = last_pg - 1;  
	 if (newpg < 0 || newpg >= g_slist_length(*tabl))
	   {
	     if (index-1>=0)
    	       newpg = index -1;
    	     else
    	       newpg = index + 1;
	   }
       }
     else
       {
	 if (index-1>=0)
	   newpg = index -1;
	 else
	   newpg = index + 1;
       }
     gtk_object_set_data(GTK_OBJECT(app), "last_pg", GINT_TO_POINTER(0));
     gtk_object_set_data(GTK_OBJECT(app), "new_pg", GINT_TO_POINTER(0));
     rd(printf("curpg: %d newpg :%d\n", index, newpg));
     rd(printf("REMOVING PAGE No. %d\n", index));
     gtk_container_set_resize_mode(GTK_CONTAINER(app), GTK_RESIZE_IMMEDIATE);
     newtab = gtk_notebook_get_nth_page(GTK_NOTEBOOK(nb), newpg);
     gtk_notebook_set_page(GTK_NOTEBOOK(nb), newpg);
     if (preserve)
       {
	 gtk_widget_ref(hbox);
	 gtk_container_remove(GTK_CONTAINER(pane), hbox);
       }
#if 0
     else
       {
	 gtk_widget_destroy(GTK_WIDGET(term));
	 gtk_widget_destroy(GTK_WIDGET(hbox));
       }
#endif
     rd(printf("newapp size (%d,%d)\n", aw, ah));
     gtk_notebook_remove_page (GTK_NOTEBOOK (nb), index);
     gtk_container_set_resize_mode(GTK_CONTAINER(app), GTK_RESIZE_QUEUE);
     *ptl = g_slist_remove(*ptl, term);
     g_slist_free(*tab_terms);
     g_free(tab_terms);
     *tabl = g_slist_remove(*tabl, (gpointer) tab);
     rd(printf("<<<<REMOVED tab %p removed\n", tab));
     gtk_widget_set_usize(app, aw, ah);
     set_titles (app, index, 0);
   }
 if (!preserve)	
   {
     terminal_config_free(rcfg);
     g_free(new_out);
     g_free(state);
     g_free(ttit);
     g_free(nt);
     if (sdir)
       g_free(sdir);
     if (scmd)
       g_free(scmd);
   }

}

void remove_term(GtkWidget* term)
{
  /* detach term term without preserving it */
  detach_term(term, 0); 
}


void cb_conf_win(gint reply, gpointer data)
{
  GtkWidget* term;
  GtkWidget *app;
  GSList **p_term_list;
  app = gtk_widget_get_toplevel(GTK_WIDGET(data));
    
  p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (reply)
    {
      gtk_widget_grab_focus(GTK_WIDGET(data));
      return;
    }
  else
    {
      remove_term(GTK_WIDGET(data));
      if ((term = GTK_WIDGET(current_term(p_term_list)))) 
	gtk_widget_grab_focus(GTK_WIDGET(term));
    }
}
void new_tab(GtkButton* button,
	     gpointer data)
{
  GtkWidget* app = gtk_widget_get_toplevel(GTK_WIDGET(button));
  GtkWidget* submenu = gtk_object_get_data(GTK_OBJECT(app), "submenu");
  GSList** ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist"); 
  gnome_popup_menu_do_popup_modal (submenu, NULL, NULL, NULL, data);

  /*gtk_flush_all_events();*/
  gtk_widget_grab_focus(GTK_WIDGET(current_term(ptl)));
}

/* Remove a tab from the notebook */
void remove_book( GtkButton   *button,
	       	  gpointer data )
{
    GtkWidget *app, *ct;
    GtkWidget *conf_win;
    GtkNotebook* notebook;
    GSList** ptl;

    notebook = GTK_NOTEBOOK(data);
    app = gtk_widget_get_toplevel(GTK_WIDGET(notebook));
    
    ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
    if (g_slist_length(*ptl)==1)
      {
       	close_app(app);
	return;
      }
    ct = GTK_WIDGET(current_term(ptl));
    /* NOTE: Only if the button is calling this function then ask for a confirmation */
    if (button) 
     conf_win = gnome_ok_cancel_dialog_modal_parented
       ("Remove current term?", cb_conf_win, 
	(gpointer) ct, GTK_WINDOW(app));
    else
      {
       	remove_term(ct);
	gtk_widget_grab_focus(GTK_WIDGET(current_term(ptl)));
      }
}
 
extern void gtk_flush_all_events(void);
void new_shell(GSList** p_term_list, guint action)
{
  /* WARNING;
     This prototype works but it's different from one in the gtk docs...bah! */
  struct terminal_config *cfg;
  ZvtTerm* term;
#if 0
  GSList* last;
  last = g_slist_last(*p_term_list);
  term = ZVT_TERM(last->data);
#endif
  term = current_term(p_term_list);

  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  new_term_in_window(NULL , cfg, NULL, 1, p_term_list, "Shell", NULL);
}
void new_root(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  GtkWidget *app;
  struct win_config *wincfg;
  /*GSList* last;*/
  char* cmd[3] = {"su", "-", NULL};
#if 0
  last = g_slist_last(*p_term_list);
  term = ZVT_TERM(last->data);
#endif
  term = current_term(p_term_list);
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  if (!wincfg->login_shell)
    cmd[1] = NULL;

  new_term_in_window(cmd , cfg, NULL, 1, p_term_list, "Root", NULL);
}

#define MC_WRAPAROUND
/* NOTE:
   if one starts mc and changes page going back then to mc, mouse doesn't work,
   so defining MC_WRAPAOUND some lines of codes solve this problem */
void new_mc(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
#ifdef MC_WRAPAROUND
  GtkWidget* app, *nb;
  int cp, lp;
#endif
  /*GSList* last;*/
  char* cmd[3] = {"mc", "-x", NULL};
#if 0
  last = g_slist_last(*p_term_list);
  term = ZVT_TERM(last->data);
#endif
  term = current_term(p_term_list);

  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  new_term_in_window(cmd , cfg, NULL, 1, p_term_list, "mc", NULL);
  
#ifdef MC_WRAPAROUND
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  nb = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(app),"notebook"));
 
  cp = gtk_notebook_get_current_page(GTK_NOTEBOOK(nb));
  lp = g_slist_length(*p_term_list) - 1;
  
  if (cp == 0)
   gtk_notebook_set_page(GTK_NOTEBOOK(nb), lp);
  else 
   gtk_notebook_prev_page(GTK_NOTEBOOK(nb));

  term = ZVT_TERM(current_term(p_term_list));
 
  gtk_notebook_set_page(GTK_NOTEBOOK(nb), cp);

#endif  
}

struct splitw_t {
  GtkWidget* term_to_split;
  int type;  
} splitw;

GtkWidget* term_selected_for_split = NULL;
void hsplit_with(GSList** ptl, guint action)
{
  splitw.term_to_split = GTK_WIDGET(current_term(ptl));
  splitw.type = 1;
}

void vsplit_with(GSList** ptl, guint action)
{
  splitw.term_to_split = GTK_WIDGET(current_term(ptl));
  splitw.type = 0;
}

void cb_hview(GSList** ptl, guint action)
{
  splitw.term_to_split = GTK_WIDGET(current_term(ptl));
  splitw.type = 3; /*3 means hview */

}
void cb_vview(GSList** ptl, guint action)
{
  splitw.term_to_split = GTK_WIDGET(current_term(ptl));
  splitw.type = 4; /*4 means vview */
}


void new_tab_with(GSList** ptl, guint action)
{
  GtkWidget *tab, *app; 
  GtkWidget *term; 
  GSList** tab_terms;
  
  term = GTK_WIDGET(current_term(ptl));
  tab = gtk_object_get_data(GTK_OBJECT(term), "tab");
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
  /*if (g_slist_length(*tab_terms)==1)
    return;*/
  splitw.term_to_split = app;
  splitw.type = 2;
}
gboolean
parse_path( gchar          *str,
	    gchar         **item);
void
new_term_in_tab(char** cmd, struct terminal_config *cfg_in, const gchar *geometry, int termid, GSList** p_term_list, char* nome_term, char* start_dir, int split_type);

GtkWidget* 
vt_new_window(ZvtTerm* term, char *name, char *path, char *cmd, char* tclass,
	      char *wclass);

void new_shell_with_command_bb(GSList** ptl, gint action)
{
  GtkWidget* app;
  GtkWidget* term;
  char *item, **cmds, **cmds_names, *buf, **cmds_paths, *prefix, **cmds_classes;
  /* the command string is not longer than 128 bytes so this value(256) is enough! */
  char* cmd[256];
  struct terminal_config* cfg;
  int i, term_type;

  term = GTK_WIDGET(current_term(ptl));

  rd(printf("cb: %d type: %d action:%d\n", action, action%4,action/4));
  term_type = action % 4;
  action = action / 4;
  app = gtk_widget_get_toplevel(term);
  cmds = app_config.cmds;
  cmds_names = app_config.cmds_names;
  cmds_paths = app_config.cmds_paths;
  cmds_classes = app_config.cmds_classes;
  
  buf = malloc((strlen(cmds[action])+1)*sizeof(char));
  strcpy(buf, cmds[action]);
  rd(printf("cmds_paths[action]: %s\n", cmds_paths[action]));
  cmd[0] =  strtok(buf, " ");
  i = 1;
  while ((cmd[i] = strtok(NULL, " ")))
    i++;
  
  if (cmds_classes[action] && strcmp(cmds_classes[action],"None"))
    {
      char *tclass;
      if (!strcasecmp(cmds_classes[action], "Default"))
	tclass =g_strdup("Config");
      else
	tclass = g_strdup_printf("Class-%s", cmds_classes[action]);
      prefix = g_strdup_printf("/MultiTerminal/%s/", tclass);
      gnome_config_push_prefix(prefix);
      cfg = load_config(tclass);
      gnome_config_pop_prefix();
      g_free(tclass);
      g_free(prefix);
    }
  else 
    {
      cfg = terminal_config_dup(gtk_object_get_data (GTK_OBJECT (term), "config"));
    }

  if (!parse_path(cmds_names[action], &item))
    item = g_strdup(cmds_names[action]);

    switch (term_type)
    {
    case 0:
      new_term_in_window(cmd, cfg, NULL, 1, ptl, item, cmds_paths[action]);
      break;
    case 1:
      new_term_in_tab(cmd, cfg, NULL, 1, ptl, item, 
		      cmds_paths[action], MGT_HORIZ_SPLIT);
      break;
    case 2:
      new_term_in_tab(cmd , cfg, NULL, 1, ptl, item, 
		      cmds_paths[action], MGT_VERT_SPLIT);
      break;
    case 3:
      vt_new_window(current_term(ptl), item, cmds_paths[action], cmds[action], NULL,
		    NULL);
      break;  
    }
  g_free(item);
  free(buf);
}

void get_main_menu( GtkWidget  *window,
		    GtkWidget **menubar, GSList** p_term_list )

{
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  GtkItemFactoryEntry* cm;

  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
  
  accel_group = gtk_accel_group_new ();

  cm = malloc(sizeof(GtkItemFactoryEntry)*(nmenu_items+1));
  gtk_object_set_data(GTK_OBJECT(window), "buttonbar_menu", cm);
  memcpy(cm, menu_items, sizeof(GtkItemFactoryEntry)*DEFAULT_BUTTONBAR_ITEMS);
  cm[DEFAULT_BUTTONBAR_ITEMS].path = NULL;
  gtk_object_set_data(GTK_OBJECT(window), "but_num_hardset", 
  GINT_TO_POINTER(DEFAULT_BUTTONBAR_ITEMS));

  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
				       accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items, cm, p_term_list);
  
  /* Attach the new accelerator group to the window. */
  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
 
  if (menubar)
    *menubar = gtk_item_factory_get_widget (item_factory, "<main>");
}

char *new_tab_str="/MAIN/";
char *new_tab_str_main = "/MAIN";

char *new_terms_types[4] = { "New Tab", "HSplit", "VSplit", "New Window"};

void add_commands_items(char** cmds_names, GtkItemFactoryEntry* cm, int defis, char *rstr)
{
  int x, i, ii;
  char str[256];
  /* and now we build the custom part */
  x = 0;
  while (cmds_names[x])
    {
      i = 4*x + defis;
#if 0
      strcpy(str,new_tab_str);
      strcat(str,cmds_names[x]);
      cm[i].path = malloc((strlen(str)+1)*sizeof(char));
      strcpy(cm[i].path, str);
      cm[i].accelerator = NULL;
      cm[i].callback = new_shell_with_command_bb;
      cm[i].callback_action = x;
      cm[i].item_type = NULL;
#endif
      for (ii=0; ii < 4; ii++)
	{
	  strcpy(str, rstr);
	  strcat(str, cmds_names[x]);
	  strcat(str, "/");
	  strcat(str, new_terms_types[ii]);
	  cm[i+ii].path = g_malloc((strlen(str)+1)*sizeof(char));
	  strcpy(cm[i+ii].path, str);
	  cm[i+ii].accelerator = NULL;
    	  cm[i+ii].callback = new_shell_with_command_bb;
	  cm[i+ii].callback_action = i+ii - defis; 
	  cm[i+ii].item_type = NULL;
	}
      x++;
    }

  cm[x*4+defis].path = NULL; 


}

GtkItemFactoryEntry* free_and_add_hardset (GtkWidget* app, char **cmds,
					   GtkItemFactory *item_factory,
					   int *hsitems,
					   int *nmenu_items, 
					   GtkItemFactoryEntry *static_menu, 
					   int tearoff, char *hsitems_str, 
					   char *menu_str)
{
  int x, xx, ncmds, nit_source, nit_dest;  
  gint old_hsitems;
  const int mgt_numperentry[6] = {4, 4, 4, 2, 2, 1};
  GtkItemFactoryEntry* cm;
  /* This function generates the menu items. Pass the item factory,
     the number of items in the array, the array itself, and any
     callback data for the the menu items. */
  x = 0;
  while(cmds[x])
    x++;
  /* 4 are the default items */
 
  ncmds = x;
  *nmenu_items = 1;
  if (!app_config.hardset_entries[6])
    {
      if (tearoff)
	*nmenu_items += 2;
      else
	*nmenu_items += 1;
      for (x = 0; x < 7; x++)
	*nmenu_items += app_config.hardset_entries[x]?mgt_numperentry[x]:0;
    }
  *hsitems = *nmenu_items;

  *nmenu_items += 4*ncmds;
  cm = gtk_object_get_data(GTK_OBJECT(app), menu_str);/*"buttonbar_menu");*/
  old_hsitems = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(app), 
						    hsitems_str));
  /*"but_num_hardset"));*/
  
  gtk_object_set_data(GTK_OBJECT(app), hsitems_str, GINT_TO_POINTER(*hsitems));

  if (cm)
    {
      x = 0;
      while(cm[x].path)
	x++;
      gtk_item_factory_delete_entries(item_factory, x, cm);
    }
  if (cm)
    {
      x = old_hsitems;

      while(cm[x].path)
	{
	  free(cm[x].path);
	  x++;
	}
      free(cm);
    }
  
  cm = g_malloc0(sizeof(GtkItemFactoryEntry)*(*nmenu_items+1));
  gtk_object_set_data(GTK_OBJECT(app), menu_str, cm);

  /* add root */
  memcpy(&(cm[0]), &(static_menu[0]), sizeof(GtkItemFactoryEntry));
  /* tearoff */
  if (tearoff)
    {
      memcpy(&(cm[1]), &(static_menu[1]), sizeof(GtkItemFactoryEntry));
      nit_dest = nit_source = 2;
    }
  else
    {
      nit_dest = 1;
      nit_source = 2;
    }

  if (!app_config.hardset_entries[6])
    {
      for (x = 0; x < 6; x++)
	{
	  if (app_config.hardset_entries[x])
	    {
	      for (xx = 0; xx < mgt_numperentry[x]; xx++)
		{
		  memcpy(&cm[nit_dest], &static_menu[nit_source],
			 sizeof(GtkItemFactoryEntry));
		  nit_dest++;
		  nit_source++;
		}
	    }
	  else
	    nit_source += mgt_numperentry[x];
	}
      memcpy(&(cm[nit_dest]), &(static_menu[nit_source]), sizeof(GtkItemFactoryEntry));
    }
  return cm;
}

void rebuild_buttonbar_menu( GtkWidget  *window)
{
  GtkItemFactory *item_factory;
  GtkWidget* mbw, *butbar, *submenu;
  GtkItemFactoryEntry* cm;
  GSList** p_term_list;
  char** cmds, **cmds_names;
  gint nmenu_items, hsitems;

  butbar = gtk_object_get_data(GTK_OBJECT(window), "buttonbar");
  if (butbar == NULL)
    return;

  cmds = app_config.cmds;
  cmds_names = app_config.cmds_names; 
  p_term_list = gtk_object_get_data(GTK_OBJECT(window), "ptermlist");
  /*memcpy(cm, menu_items, sizeof(GtkItemFactoryEntry)*DEFAULT_BUTTONBAR_ITEMS);*/

  mbw = gtk_object_get_data(GTK_OBJECT(window), "butmenu_widget");
  item_factory = gtk_item_factory_from_widget(mbw);
  cm = free_and_add_hardset(GTK_WIDGET(window), cmds_names, item_factory,
			    &hsitems, &nmenu_items,
			    menu_items, 1, "but_num_hardset", "buttonbar_menu");
  add_commands_items(cmds_names, cm, hsitems, new_tab_str);
  gtk_item_factory_create_items (item_factory, nmenu_items, cm, p_term_list);

  mbw = gtk_item_factory_get_widget (item_factory, "<main>");
  submenu = gtk_item_factory_get_widget (item_factory, new_tab_str_main);
  gtk_object_set_data(GTK_OBJECT(window), "submenu", submenu);
  gtk_object_set_data(GTK_OBJECT(window), "butmenu_widget", mbw);
}

GtkWidget* add_dir_tree(GtkWidget* widget, GtkWidget* app);
GtkWidget *create_pane(GtkWidget* new_term, GtkWidget* old_term, 
		       GtkWidget *old_pane, GtkWidget *tab,
		       int scroll_pos, int pane_type);

#define MAX_OPEN_TERMS 500
ZvtTerm* create_term(int w, int h, struct terminal_config* cfg, char** env, 
		     int first_tab);

extern int flush_disabled;
void
new_term_in_window(char** cmd, struct terminal_config *cfg_in, const gchar *geometry, int termid, 
	GSList** p_term_list, char* nome_term, char* start_dir)
{
  int last_pg, nopg, i, cmdindex, scrollbacklines, login_shell;/* ,c;*/
  char txt[128], tmp1[256];
  char buffer[60], *strcmd;/*, **p;*/
  GtkWidget *lblmenu, *tt, *app, *term, *label, *tab;
  /* g.o. */
  GtkWidget *pane;
  GSList** tablist, **tab_terms;
  GtkNotebook *notebook;
  preferences_t* prefs;
  struct terminal_config *cfg;
  struct win_config *wincfg;
  int width, height, aw, ah;
  int xpos, ypos, tw, th;
  char *sdir, *tetitle, *shell, *name, *noterm, *section;
  login_shell = 0;
  cmdindex = 0;
  scrollbacklines = 50;
  /* set up terminal environment */
  env = environ;
  
  cfg = terminal_config_dup (cfg_in); 
  
  if (!env_copy){
    char **p;

    for (p = env; *p; p++)
      ;
    i = p - env;
    env_copy = (char **) g_malloc (sizeof (char *) * (i + 1 + EXTRA));
    for (i = 0, p = env; *p; p++){
      if ((strncmp (*p, "COLUMNS=", 8) == 0)
	  || (strncmp (*p, "LINES=", 6) == 0)
	  || (strncmp(*p, "WINDOWID=", 9) == 0)
	  || (strncmp (*p, "TERM=", 5) == 0)
	  || (strncmp (*p, "GNOME_DESKTOP_ICON=", 19) == 0)) {
	/* nothing: do not copy those */
      } else
	env_copy [i++] = *p;
    }
    term_pos = i++;
    env_copy [term_pos] = "";
    env_copy [i++] = "COLORTERM=gnome-terminal";
    winid_pos = i++;
    env_copy [winid_pos] = "TEST";
    env_copy [i] = NULL;
  }
 
  section = g_strconcat("/MultiTerminal/",cfg->class,"/",NULL);
  if (!gnome_config_has_section(section))
    {
      terminal_config_free(cfg);
      gnome_config_push_prefix("/MultiTerminal/Config/");
      cfg = load_config("Config");
      gnome_config_pop_prefix();
#if 0 
     gnome_config_push_prefix(section);
      gnome_config_set_bool("dummy_entry",1);
      gnome_config_sync();
      gnome_config_pop_prefix();
#endif
    }
  g_free(section);
  if (geometry) {
    gnome_parse_geometry (geometry, &xpos, &ypos, &width, &height);
    if (width == -1 || height == -1) {
      width=80;
      height=24;
    }
    /* Only the first window gets --geometry treatment for now */
    /*geometry = NULL;*/
  }
  else
    {
      int th, tw, cw, ch;
      GtkWidget* etab, *ete;
      ete = (*p_term_list)->data;
      etab = gtk_object_get_data(GTK_OBJECT(ete), "tab");
      cw = ZVT_TERM(ete)->charwidth;
      ch = ZVT_TERM(ete)->charheight;
      tw = etab->allocation.width;
      th = etab->allocation.height;
      if (cfg->scrollbar_position!=SCROLLBAR_HIDDEN);
	{
	  GtkWidget* sb = gtk_object_get_data(GTK_OBJECT(ete), "scrollbar");
	  tw -= sb->allocation.width; 
	}
      width = MAX(tw / cw, 1);
      height = MAX(th / ch, 1);
      /* height = ZVT_TERM((*p_term_list)->data)->vx->vt.height;*/
    }
  /* create terminal */
  term = GTK_WIDGET(create_term(width, height, cfg, env_copy, 1));
  rd(printf("created: %p\n", term));
  app = gtk_widget_get_toplevel(GTK_WIDGET((*p_term_list)->data));
  notebook = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(app), "notebook"));
  last_pg = gtk_notebook_get_current_page(notebook)+1;
  /* g.o. */
  tablist = (GSList **) gtk_object_get_data (GTK_OBJECT (app), "tablist");
  aw = app->allocation.width;
  ah = app->allocation.height;
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  tt = GTK_WIDGET((*p_term_list)->data);
  prefs = gtk_object_get_data(GTK_OBJECT(tt), "prefs");
  gtk_object_set_data(GTK_OBJECT(term), "prefs", prefs);

  *p_term_list = g_slist_append(*p_term_list, (gpointer) term); 
 
  gtk_widget_show (term);
  
  configure_term_dnd (ZVT_TERM(term));
#ifdef COPY_CMD
  configure_term_clipboard (ZVT_TERM(term));
#endif

  get_shell_name (&shell, &name, wincfg->login_shell);
  errno = 0;
  if(!strlen(shell) > 0) {
    show_shell_error_dialog(errno);
    g_free (shell);
    g_free (name);
    
    return;
  }

#ifdef GT_DIR_TREE
  /*add_dir_tree(hbox, app);*/
#endif
  /* g.o */
  tab = gtk_hbox_new(0,0);
  gtk_container_set_border_width(GTK_CONTAINER(tab), 0);
  pane = create_pane(term, NULL, NULL, tab, cfg->scrollbar_position, MGT_HORIZ_SPLIT);
  gtk_object_set_data (GTK_OBJECT(tab), "active", term);
  gtk_box_pack_start (GTK_BOX (tab), GTK_WIDGET (pane), 1, 1, 0);
  gtk_object_set_data (GTK_OBJECT(tab), "root_pane", pane);

  rd(printf("NEW_TERM_IN_WINDOW tab: %p root_pane: %p\n", tab, pane));

  tw = GTK_WIDGET((*tablist)->data)->allocation.width;
  th = GTK_WIDGET((*tablist)->data)->allocation.height;
  
  *tablist = g_slist_append(*tablist, (gpointer) tab); 
  
  tab_terms = (GSList**) malloc(sizeof(GSList*));
  *tab_terms = g_slist_append(NULL, term);
  gtk_object_set_data(GTK_OBJECT(tab), "tab_terms", tab_terms);

  gtk_widget_show (pane);
  gtk_widget_show(tab);
  nopg = g_slist_length(*tablist);
  
  if (!nome_term)
    nome_term = "None";

  noterm = g_malloc0(sizeof(char)*33);/* max 32 chars for termname!!!*/
  strncpy(noterm, nome_term, 32);
  if (wincfg->no_numprefix)
    sprintf(txt, "%s", noterm);
  else
    sprintf(txt, "%d-%s", nopg, noterm); 
  label = gtk_label_new (txt);
  lblmenu = gtk_label_new(txt);
  
  gtk_object_set_data(GTK_OBJECT(term), "mtermname", noterm);
  tetitle = malloc(sizeof(char)*260);
  strcpy(tetitle, noterm);

  if (wincfg->no_numprefix)	
    sprintf(tmp1, "%s - [ %s ]", wincfg->window_title, noterm);
  else 
    sprintf(tmp1, "%s - [ %d-%s ]", wincfg->window_title, nopg, noterm); 
  gtk_window_set_title(GTK_WINDOW(app), tmp1);

  gtk_object_set_data(GTK_OBJECT(term), "termtitle", tetitle);
  if (start_dir)
    sdir = g_strdup(start_dir);
  else
    sdir = g_strdup("None");
  gtk_object_set_data(GTK_OBJECT(term), "startpath", sdir);

  /* the frame is now inside of the GtkVPaned */
  gtk_notebook_append_page_menu (GTK_NOTEBOOK (notebook), tab, label, lblmenu);
  gtk_widget_realize(GTK_WIDGET(term));
  gtk_notebook_set_page(GTK_NOTEBOOK(notebook), nopg-1);
  gtk_object_set_data(GTK_OBJECT(app), "last_pg",
		      GINT_TO_POINTER(last_pg));
  gtk_object_set_data(GTK_OBJECT(app), "new_pg",
		      GINT_TO_POINTER(nopg));

  gnome_term_set_font (ZVT_TERM(term), cfg->font, cfg->boldfont, cfg->use_bold);
  set_color_scheme (ZVT_TERM(term), cfg);
  zvt_term_set_open_im (ZVT_TERM(term), cfg->use_im);
  XSync(GDK_DISPLAY(), False);
  gtk_widget_grab_focus(GTK_WIDGET(term));
  /*gtk_widget_set_usize(GTK_WIDGET(tab), tw, th);*/
  gtk_widget_set_usize(app, aw, ah);
  errno = 0;
  /* Create a bunch of buttons */
  /* fork the shell/program */
  if (cmd)
    {
      strcmd = g_strjoinv(" ",cmd);
      gtk_object_set_data(GTK_OBJECT(term),"start_cmd", strcmd);
    }
  else
    {
      gtk_object_set_data(GTK_OBJECT(term),"start_cmd", NULL);
    }
  switch (zvt_term_forkpty(ZVT_TERM (term), cfg->update_records))
    {
    case -1:
      show_pty_error_dialog(errno);
      g_free (shell);
      g_free (name);
      return ;
      
    case 0: {
	      int open_max = sysconf (_SC_OPEN_MAX);
	      if (start_dir)
	      	{
	 	  if (strcmp(start_dir,"None"))
		    chdir(start_dir);
		  /*printf("start_dir: %s\n", start_dir);*/
		}

	      for (i = 3; i < open_max; i++)
		fcntl (i, F_SETFD, 1);
	      
    	      /* set delayed env variables */
	      g_snprintf (buffer, sizeof (buffer),
		     	  "WINDOWID=%d",
			  (int) GDK_WINDOW_XWINDOW(GTK_WIDGET(term)->window));
	      
    	      env_copy [winid_pos] = buffer;
	      
    	      if (cfg->termname && cfg->termname [0])
		env_copy [term_pos] = cfg->termname;
	      else
		env_copy [term_pos] = "TERM=xterm";

	      if (cmd){
		environ = env_copy;
		execvp (cmd[0], cmd);

	      } else
		{
		  execle (shell, name, NULL, env_copy);
		}
	      perror ("Could not exec\n");
    	      _exit (127);
		  
	    }
	  
    default:
	  break;
	  
	  
    }
   g_free (shell);
   g_free (name);
}
#undef GT_DIR_TREE

#ifdef GT_DIR_TREE
#include <dirent.h>
#include <sys/types.h>


void gtk_myctree_class_init (GtkCTreeClass *klass);

static void
gtk_myctree_init (GtkCTree *ctree)
{
  
  GtkCList *clist;
#if 0
  GTK_CLIST_SET_FLAG (ctree, CLIST_DRAW_DRAG_RECT);
  GTK_CLIST_SET_FLAG (ctree, CLIST_DRAW_DRAG_LINE);

  clist = GTK_CLIST (ctree);

  ctree->tree_indent    = 20;
  ctree->tree_spacing   = 5;
  ctree->tree_column    = 0;
  ctree->line_style     = GTK_CTREE_LINES_SOLID;
  ctree->expander_style = GTK_CTREE_EXPANDER_SQUARE;
  ctree->drag_compare   = NULL;
  ctree->show_stub      = TRUE;

  clist->button_actions[0] |= GTK_BUTTON_EXPANDS;
#endif
  clist = GTK_CLIST(ctree);
  clist->button_actions[0] |= GTK_BUTTON_EXPANDS;
  clist->button_actions[1] = GTK_BUTTON_IGNORED;
  clist->button_actions[2] = GTK_BUTTON_SELECTS;
}


GtkType gtk_myctree_get_type (void)
{
  static GtkType myctree_type = 0;

  if (!myctree_type)
    {
      static const GtkTypeInfo myctree_info =
      {
        "GtkMyCTree",
        sizeof (GtkCTree),
        sizeof (GtkCTreeClass),
        (GtkClassInitFunc) gtk_myctree_class_init,
        (GtkObjectInitFunc) gtk_myctree_init,
        /* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      myctree_type = gtk_type_unique (GTK_TYPE_CTREE, &myctree_info);
    }

  return myctree_type;
}

static GtkCListClass *parent_class = NULL;

static gboolean
ctree_is_hot_spot (GtkCTree     *ctree,
                   GtkCTreeNode *node,
                   gint          row,
                   gint          x,
                   gint          y)
{
  GtkCTreeRow *tree_row;
  GtkCList *clist;
  GtkCellPixText *cell;
  gint xl;
  gint yu;

  g_return_val_if_fail (ctree != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_CTREE (ctree), FALSE);
  g_return_val_if_fail (node != NULL, FALSE);

  clist = GTK_CLIST (ctree);

  if (!clist->column[ctree->tree_column].visible ||
      ctree->expander_style == GTK_CTREE_EXPANDER_NONE)
    return FALSE;


  tree_row = GTK_CTREE_ROW (node);

  cell = GTK_CELL_PIXTEXT(tree_row->row.cell[ctree->tree_column]);

  yu = (ROW_TOP_YPIXEL (clist, row) + (clist->row_height - PM_SIZE) / 2 -
        (clist->row_height - 1) % 2);

  if (clist->column[ctree->tree_column].justification == GTK_JUSTIFY_RIGHT)
    xl = (clist->column[ctree->tree_column].area.x +
          clist->column[ctree->tree_column].area.width - 1 + clist->hoffset -
          (tree_row->level - 1) * ctree->tree_indent - PM_SIZE -
          (ctree->line_style == GTK_CTREE_LINES_TABBED) * 3);
  else
    xl = (clist->column[ctree->tree_column].area.x + clist->hoffset +
          (tree_row->level - 1) * ctree->tree_indent +
          (ctree->line_style == GTK_CTREE_LINES_TABBED) * 3);

  return (x >= xl && x <= xl + PM_SIZE && y >= yu && y <= yu + PM_SIZE);
}
void cb_select_row(GtkCTree* ctree, GtkCTreeNode* node, gint column,  gpointer app);

static gint
gtk_myctree_button_press (GtkWidget      *widget,
                        GdkEventButton *event)
{
  GtkCTree *ctree;
  GtkCList *clist;
  gint button_actions;
  GtkWidget* app;
  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_CTREE (widget), FALSE);
  g_return_val_if_fail (event != NULL, FALSE);

  ctree = GTK_CTREE (widget);
  clist = GTK_CLIST (widget);

  button_actions = clist->button_actions[event->button - 1];

  
  if (button_actions == GTK_BUTTON_IGNORED)
    return FALSE;

  if (event->window == clist->clist_window)
    {
      GtkCTreeNode *work;
      gint x;
      gint y;

      gint row;
      gint column;

      x = event->x;
      y = event->y;

      if (!gtk_clist_get_selection_info (clist, x, y, &row, &column))
        return FALSE;

      rd(printf("event->button: %d\n", event->button));
      work = GTK_CTREE_NODE (g_list_nth (clist->row_list, row));
      if (event->type == GDK_BUTTON_PRESS && event->button == 3)
	{
	  app = gtk_widget_get_toplevel(widget);
	  cb_select_row(ctree, work, 0, app);	  
	  return GTK_WIDGET_CLASS (parent_class)->button_press_event (widget, event);

	}

      if (button_actions & GTK_BUTTON_EXPANDS &&
          (GTK_CTREE_ROW (work)->children && !GTK_CTREE_ROW (work)->is_leaf  &&
           (event->type == GDK_2BUTTON_PRESS  ||
	    ctree_is_hot_spot (ctree, work, row, x, y))))
        {
	     if (GTK_CTREE_ROW (work)->expanded)
	       gtk_ctree_collapse (ctree, work);
	     else
	       gtk_ctree_expand (ctree, work);
          return FALSE;
        }
    }
  return GTK_WIDGET_CLASS (parent_class)->button_press_event (widget, event);
}

static void
gtk_myctree_class_init (GtkCTreeClass *klass)
{
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkCListClass *clist_class;
  
  object_class = (GtkObjectClass *) klass;
  widget_class = (GtkWidgetClass *) klass;
  clist_class = (GtkCListClass *) klass;

  parent_class = gtk_type_class (GTK_TYPE_CTREE);

  widget_class->button_press_event = gtk_myctree_button_press;
}

GtkWidget *
gtk_myctree_new_with_titles (gint         columns,
                           gint         tree_column,
                           gchar       *titles[])
{
  GtkWidget *widget;

  g_return_val_if_fail (columns > 0, NULL);
  g_return_val_if_fail (tree_column >= 0 && tree_column < columns, NULL);

  widget = gtk_type_new (GTK_TYPE_MYCTREE);
  gtk_ctree_construct (GTK_CTREE (widget), columns, tree_column, titles);

  return widget;
}

GtkWidget *
gtk_myctree_new (gint columns,
               gint tree_column)
{
  return gtk_myctree_new_with_titles (columns, tree_column, NULL);
}


#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
/* PRE-ALPHA CODE: building directory tree */
int is_a_dir(char* p, char* sp)
{
  int ret;
  struct stat sbuf;
  
  if (!strcmp(sp, ".") || !strcmp(sp, ".."))
    return 1;
  
  ret = stat(p, &sbuf);
  if (S_ISDIR(sbuf.st_mode))
    {
      return 1;
    }
  else if (S_ISREG(sbuf.st_mode))
    {
      return 0;
    }
  else
    {
      return 0;
    }
}

void my_ctree_node_get_text(GtkCTree* ctree, GtkCTreeNode* node, int column, char** text)
{
  *text = GTK_CELL_TEXT (GTK_CTREE_ROW (node)->row.cell[column])->text;
}

int there_are_subdirs(char* path)
{
  DIR* dir;
  struct dirent* d;
  int ret = 0;
  dir = opendir(path);
  if (dir==NULL)
    {
      return 0;
    }
  d = readdir(dir);
  if (d)
    ret = 1;
  closedir(dir);
  return ret;
}

void insert_dirs(char* path, GtkCTree* ctree, GtkCTreeNode* node, GnomePixmap* pixmap_open, GnomePixmap* pixmap_close)
{
  struct dirent *pod;  
  DIR* pdir;
  int whis;
  char subdir_path[1024];
  char* cols_text[1];
  GtkCTreeNode* cnode, *sn;
  gboolean is_a_leaf;
  char *text;
  char node_name[32];
  char pnt[] = ".";
  pdir = opendir(path);
  if (pdir == NULL)
    {
      return;
    }

  gtk_clist_freeze(GTK_CLIST(ctree));
  gtk_clist_set_column_auto_resize (GTK_CLIST(ctree), 0, FALSE);
  while ( (pod = readdir(pdir)) )
    {
      strcpy(subdir_path, path);
      strcat(subdir_path, pod->d_name);
      /*strcat(subdir_path,"/");
	cols_text[0] = malloc(sizeof(char)*256);
	strcpy(cols_text[0],pod->d_name);*/
      strcpy(node_name, pod->d_name);     
      cols_text[0] = node_name;
  
      if ((whis = is_a_dir(subdir_path, pod->d_name)))
      
	{
	  /*if (there_are_subdirs(subdir_path))
	    is_a_leaf = FALSE;
	    else
	    is_a_leaf = TRUE; */
	  if (whis==1)
  	    is_a_leaf=FALSE;
	  else
	    is_a_leaf=TRUE;
	  if (whis == 1)
  	    cnode = gtk_ctree_insert_node(ctree, node, NULL, cols_text, 2, 
  					  pixmap_open->pixmap, pixmap_open->mask, 
  					  pixmap_close->pixmap, pixmap_close->mask,
  					  is_a_leaf, FALSE);
	  else 
	    cnode = gtk_ctree_insert_node(ctree, node, NULL, cols_text, 2, 
					  NULL, NULL, 
					  NULL, NULL,
  					  is_a_leaf, FALSE);
	
	    gtk_ctree_node_get_text(ctree, cnode, 0, &text);
	  
	  if ((is_a_leaf == FALSE) && strcmp(node_name,".") && strcmp(node_name, ".."))
	    {
	      cols_text[0] = pnt;
	
    	      sn =gtk_ctree_insert_node(ctree, cnode, NULL, cols_text, 2, 
					pixmap_open->pixmap,
    					pixmap_open->mask, pixmap_close->pixmap, 
    					pixmap_close->mask, TRUE, FALSE);
	      my_ctree_node_get_text(ctree, sn, 0, &text);
	      
	    }
	}
    }
  gtk_clist_set_column_auto_resize (GTK_CLIST(ctree), 0, TRUE);
  gtk_clist_thaw(GTK_CLIST(ctree));
  closedir(pdir);
}


GnomePixmap* pixmap_open, *pixmap_close;

void build_tree(GtkCTree* ctree)
{ 
 GtkCTreeNode* node;
  char* cols_text[1];
  char text[2];
  int cw;
  /* insert root node */

  strcpy(text, "/"); 
  cols_text[0] = text;
  

  if (pixmap_close == NULL)  
    pixmap_close = pixmap_open = GNOME_PIXMAP(gnome_pixmap_new_from_file_at_size 
					      (GNOME_ICONDIR "/mgt/panel-folder.png",22,22));
  
  node = gtk_ctree_insert_node(ctree, NULL, NULL, cols_text, 2, pixmap_open->pixmap, pixmap_open->mask, pixmap_close->pixmap, pixmap_close->mask, 
			       FALSE, TRUE);
  
  insert_dirs("/", ctree, node, pixmap_open, pixmap_close);

  cw = gtk_clist_optimal_column_width(GTK_CLIST(ctree), 0);
  gtk_clist_set_column_width(GTK_CLIST(ctree),0, cw);

}


void build_path(GtkCTree* ctree, GtkCTreeNode* node, char** path)
{
  GtkCTreeRow* row;
  GtkCTreeNode* n;
  gchar* entry;
  char path_tmp[1024];
  int cc;
  n = node; 
  row = GTK_CTREE_ROW(n);
  my_ctree_node_get_text(ctree, n, 0, &entry);
  rd(printf("entry: %s\n", entry)); 
  strcpy(*path, entry);
  strcat(*path, "/");
  cc = 0;
  while ( (n = GTK_CTREE_ROW(n)->parent) )
    {
      my_ctree_node_get_text(ctree, n, 0, &entry);
      strcpy(path_tmp, entry);
      if (strcmp(entry, "/"))
	strcat(path_tmp, "/");
      strcat(path_tmp, *path);
      strcpy(*path, path_tmp);
      cc++;
    }
}

void cb_collapse_branch(GtkCTree* ctree, GtkCTreeNode* node, gpointer data)
{
  char *text, string[256];
  GtkCTreeNode *sn, *n, *to_remove;
  int cw;

  sn = GTK_CTREE_ROW(node)->children;
  if (sn==NULL)
    return;
  n = GTK_CTREE_ROW(sn)->sibling;
  if (n==NULL)
    return;
  my_ctree_node_get_text(ctree, n, 0, &text);
  gtk_clist_freeze(GTK_CLIST(ctree));
  while(n)
    {
      to_remove = n;
      n = GTK_CTREE_ROW(n)->sibling;
      gtk_ctree_remove_node(ctree, to_remove);
    }
  gtk_clist_thaw(GTK_CLIST(ctree));
  return;
}

void cb_build_branch(GtkCTree* ctree, GtkCTreeNode* node, gpointer data);

char cmd[1024];
/* ============================ >>> selectrow <<< ================================= */
void cb_select_row(GtkCTree* ctree, GtkCTreeNode* node, gint column,  gpointer app)
{
  char *path;
  GSList** ptl;
  ZvtTerm* term;
  char *text, string[256];
  char *cols_text[1];
  char pnt[] = ".";
  GtkCTreeNode *n, *p, *to_remove, *pp, *ntu;
  path = malloc(sizeof(char)*1024);
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  my_ctree_node_get_text(ctree, node, 0, &text);

  if (!strcmp(text, "."))
    {
      gtk_clist_freeze(GTK_CLIST(ctree));
      /* rebuild this branch */
      p = GTK_CTREE_ROW(node)->parent;
      my_ctree_node_get_text(ctree, p, 0, &text);
      strcpy(string, text);
      build_path(ctree, p, &path);
      n = GTK_CTREE_NODE_NEXT(node);
      my_ctree_node_get_text(ctree, n, 0, &text);
      gtk_signal_emit_stop_by_name(GTK_OBJECT(ctree), "tree_select_row");
      while(n)
	{
	  
	  to_remove = n;
 	  n = GTK_CTREE_ROW(n)->sibling;
  	  gtk_ctree_remove_node(ctree, to_remove);
	}
      
      if (pixmap_open == NULL)
	 pixmap_close = pixmap_open = GNOME_PIXMAP(gnome_pixmap_new_from_file_at_size 
			  			  (GNOME_ICONDIR "/mgt/panel-folder.png",22,22));


#if 0
      cols_text[0] = string;
      p = gtk_ctree_insert_node(ctree, pp, NULL, cols_text, 2, 
				pixmap_open->pixmap, pixmap_open->mask, 
				pixmap_close->pixmap, pixmap_close->mask,
				FALSE, TRUE);
	

      insert_dirs(path, ctree, p, pixmap_open, pixmap_close);     
#endif
      gtk_ctree_collapse(ctree, p);
      cb_build_branch(ctree, p, NULL); 
      gtk_ctree_expand(ctree, p);
      /*my_ctree_node_get_text(ctree, ntu, 0, &text);
	printf("mmah: %s\n", text);*/
      gtk_clist_thaw(GTK_CLIST(ctree));
      gtk_signal_emit_stop_by_name(GTK_OBJECT(ctree), "tree_select_row");
      gtk_ctree_select(ctree, GTK_CTREE_NODE_NEXT(p));
      free(path);
      return;
    }

  term = current_term(ptl);
  if (!strcmp(text, ".."))
    {
      strcpy(cmd, "cd ..\r\n");
    }
  else
    {
      build_path(ctree, node, &path);
      strcpy(cmd, "cd ");
      strcat(cmd, path);
      /* see zvtterm.c: 2477 */
      strcat(cmd, "\r");
    }
  write(term->vx->vt.keyfd, cmd, strlen(cmd));
  gtk_widget_grab_focus(GTK_WIDGET(term));
  free(path);
}
void cb_build_branch(GtkCTree* ctree, GtkCTreeNode* node, gpointer data)
{
  GtkCTreeNode* n, *subnode;
  GtkCTreeRow* row;
  char* path;
  int cw;
  DIR* pdir;
  gchar* text;

  my_ctree_node_get_text(ctree, node, 0, &text);
  if (!strcmp(text, ".") || !strcmp(text, ".."))
      return;
  subnode = GTK_CTREE_ROW(node)->children;
  if (subnode == NULL)
    return;
  my_ctree_node_get_text(ctree, subnode, 0, &text);
  rd(printf("next subnode: %p text:%s\n", GTK_CTREE_NODE_NEXT(subnode), text));
  if (strcmp(text,".") || (GTK_CTREE_NODE_NEXT(subnode) != NULL))
    return;
  path = malloc(sizeof(char)*1024);
  build_path(ctree, node, &path);
  rd(printf("build branch path: %s\n", path));
  gtk_ctree_remove_node(ctree, subnode);
  if (pixmap_open == NULL)
    pixmap_close = pixmap_open = GNOME_PIXMAP(gnome_pixmap_new_from_file_at_size 
			  		      (GNOME_ICONDIR "/mgt/panel-folder.png",22,22));
  gtk_clist_freeze(GTK_CLIST(ctree));
  insert_dirs(path, ctree, node, pixmap_open, pixmap_close);
  gtk_clist_thaw(GTK_CLIST(ctree));

  cw = gtk_clist_optimal_column_width(GTK_CLIST(ctree), 0);
  gtk_clist_set_column_width(GTK_CLIST(ctree),0, cw);

  free(path);
}
/* <<<PRE-ALPHA CODE >>> dir tree */
GtkWidget* add_dir_tree(GtkWidget* widget, GtkWidget* app)
{
  GtkWidget* scroll_win, *ctree;
  GtkWidget* frame_sw;

  scroll_win = gtk_scrolled_window_new(NULL, NULL);
  
  gtk_scrolled_window_set_policy  (GTK_SCROLLED_WINDOW(scroll_win),
				   GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  ctree = gtk_myctree_new(1, 0);
  gtk_clist_set_auto_sort(GTK_CLIST(ctree), FALSE);
  gtk_clist_set_selection_mode(GTK_CLIST(ctree), GTK_SELECTION_SINGLE);
  gtk_clist_set_column_auto_resize (GTK_CLIST(ctree), 0, TRUE);
  gtk_clist_set_column_resizeable(GTK_CLIST(ctree), 0, FALSE);
  gtk_ctree_set_expander_style(GTK_CTREE(ctree),GTK_CTREE_EXPANDER_TRIANGLE);
  gtk_ctree_set_show_stub(GTK_CTREE(ctree), FALSE);
  gtk_ctree_set_reorderable(GTK_CTREE(ctree), FALSE);
  gtk_clist_set_use_drag_icons    (GTK_CLIST(ctree), FALSE);
  GTK_WIDGET_UNSET_FLAGS (ctree, GTK_CAN_FOCUS);


  build_tree(GTK_CTREE(ctree));
  gtk_widget_show(ctree);
  gtk_signal_connect(GTK_OBJECT(ctree), "tree-expand", cb_build_branch, NULL);
  /*gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll_win), ctree);*/
  gtk_signal_connect(GTK_OBJECT(ctree), "tree-collapse", cb_collapse_branch, NULL);
  /*gtk_signal_connect(GTK_OBJECT(ctree), "tree-select-row", cb_select_row, 
		     (gpointer)app);*/
  gtk_widget_set_usize(GTK_WIDGET(ctree), 150, -1);
  gtk_container_add(GTK_CONTAINER(scroll_win), ctree);
  gtk_widget_show(scroll_win);
  frame_sw = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame_sw), GTK_SHADOW_IN);
  gtk_widget_show(GTK_WIDGET(frame_sw));
  gtk_container_add(GTK_CONTAINER(frame_sw), GTK_WIDGET(scroll_win));
  gtk_widget_set_usize(frame_sw, 150, 0);
  gtk_paned_pack1 (GTK_PANED (widget), GTK_WIDGET (frame_sw), TRUE, TRUE);
  return frame_sw;
}
#endif

void change_title(GtkWidget* widget, gpointer data);
void button_prev_page(GtkWidget* w);
void button_next_page(GtkWidget* w);

extern void paste_cmd(GtkWidget* widget, GSList** p_term_list);

char *special_seq[]   = {"\\n", "\\t",  "\\e", "\\033", "<Esc>", "\\b", "\\r", "\\f", NULL};
int  special_seq_len[] ={    2,     2,      2,       4,       5,     2,     2,    2,     0};       
char special_char[] = { '\n',  '\t', '\033',  '\033',  '\033',  '\b',  '\r',  '\f', 0};
gchar* convert_escape(gchar* str)
{
  /* in string str, you entered in keybindings win,
   * you can use '<Esc>' or '\033' as escape and here
   * we convert such chars to real escape */
  gboolean matched = FALSE;
  int i, num;
  gchar* ret, *retI;
  retI = ret = malloc((strlen(str)+1)*sizeof(char*));
  
  while (*str)
    {
      i = 0;
      matched = FALSE;
      while (special_seq[i])
	{
#if 0
	  if (special_seq_len[i]>strlen(str))
	    {
	      i++;
	      continue;
	    }
#endif
	  if (!strncmp(str, special_seq[i], special_seq_len[i]))
	    {
	      *ret = special_char[i];
	      ret++;
	      str += special_seq_len[i];
	      matched = TRUE;
	      break;
	    }
	  i++;
	}
      if (!matched)
	{
	  if (*str == '\\')
	    {
	      str++;
	      if (*str == '\\')
		{
		  *ret = '\\';
		  ret++;
		  str++;
		}
	      else
		{
		  num = 0;
		  while (*str && *str >= '0' && *str <= '9')
		    {
		      num = 8*num + (*str - '0'); 
		      str++;
		    }
		  /* discard null chars: a char should be of the form \XXX */
		  if (num)
		    {
		      *ret = num;
		      ret++;
		    }
		}
	    }
	  else  
	    {
	      *ret = *str;
	      d(printf ("%c", *ret));
	      ret++;
	      str++;
	    }
	}
    }
  d(printf("\n"));
  *(ret++) = '\0';
  return retI;
}
void search_cmd(GtkWidget* widget, GSList** p_term_list);
void search_again_cmd(GtkWidget* widget, GSList** p_term_list);
void
reset_terminal_soft_cmd (GtkWidget *widget, GSList **p_term_list);
  void
reset_terminal_hard_cmd (GtkWidget *widget, GSList **p_term_list);
GtkWidget *
new_terminal (GtkWidget *widget, GSList **p_term_list);
extern void adjust_app_size(GtkWidget *w, gpointer data);

int kb_get_cmd_num(char** cmds_names, char* str)
{
  int n;
  n = 0;
  
  /* must convert a string to a number which
     is the tab to switch to */
  while(cmds_names[n])
    {
      if (!strcmp(cmds_names[n], str))
	break;
      n++;
    }
  if (!cmds_names[n])
    return -1;
  else
    return n;
  /* keybinding match so do the related action here */
}

void build_popup_commands(GdkEventButton *event, GSList** ptl, ZvtTerm* term);
void right_click_menu(GdkEventButton *event, GSList **p_term_list, ZvtTerm *term);
int selection_mode_off(ZvtTerm* term);
void terminal_help_cb(GtkWidget* w, gpointer data);

void kb_do_action(GtkWidget* app, GtkNotebook* nb, GSList** ptl, int act, char* str)
{
  struct _vtx *vx;
  ZvtTerm* term;
  int pgno, n, pg_num, ti, llen;
  char **cmds_names;
  char* cstr;
  GSList** tab_terms, *tl;
  GtkWidget* tab, *focusterm;

  term = ZVT_TERM (current_term(ptl));
  vx = term->vx;
  cmds_names = app_config.cmds_names;

  switch(act)
    {
    case MGT_SHELL_NEWTAB:
      new_shell(ptl, 0);    
      break;
    case MGT_SHELL_HSPLIT:
      new_shell_happend(ptl, 0);
      break;
    case MGT_SHELL_VSPLIT:
      new_shell_vappend(ptl, 0);
      break;
    case MGT_SHELL_NEWWINDOW:
      new_shell_window(ptl, 0);
      break;
    case MGT_ROOT_NEWTAB:
      new_root(ptl, 0);
      break;
    case MGT_ROOT_HSPLIT:
      new_hroot(ptl, 0); 
      break;
    case MGT_ROOT_VSPLIT:
      new_vroot(ptl, 0);
      break;
    case MGT_ROOT_NEWWINDOW:
      new_wroot(ptl, 0);
      break;
    case MGT_MC_NEWTAB:
      new_mc(ptl, 0);
      break;
    case MGT_MC_HSPLIT:
      new_hmc(ptl, 0);
      break;
    case MGT_MC_VSPLIT:
      new_vmc(ptl, 0);
      break;
    case MGT_MC_NEWWINDOW:
      new_wmc(ptl, 0);
      break;
    case MGT_GO_RIGHT:
      button_next_page(GTK_WIDGET(nb));
      break;
    case MGT_GO_LEFT:
      button_prev_page(GTK_WIDGET(nb));
      break;
    case MGT_REMOVE_TERM:
      remove_book(NULL, (gpointer)nb); 
      break;
      break;
    case MGT_TAB_RIGHT:
      move_tab_right(nb);
      break;
    case MGT_TAB_LEFT:
      move_tab_left(nb);
      break;
    case MGT_CHANGE_TITLE:
      change_title(NULL, nb);
      break;
    case MGT_SEARCH:
      search_cmd(NULL, ptl);
      break;
    case MGT_SEARCH_AGAIN:
      search_again_cmd(NULL, ptl);
      break;
    case MGT_RESET_TERMINAL:
      reset_terminal_soft_cmd(NULL, ptl); 
      break;
    case  MGT_RESET_AND_CLEAR:
      reset_terminal_hard_cmd (NULL, ptl);
      break;
    case MGT_NEW_WINDOW:
      new_terminal(NULL, ptl);
      break;
    case MGT_SWITCH_TO:
      pg_num = atoi(str)-1;
      d(printf("act: %d pg_num: %d str: %s\n", act, pg_num, str));
      gtk_notebook_set_page(GTK_NOTEBOOK(nb), pg_num);
      break;
    case MGT_COMMAND_NEWTAB:
      n = kb_get_cmd_num(cmds_names, str); 
      if (n!=-1)
	new_shell_with_command_bb(ptl, n*4);
      break;
    case MGT_COMMAND_HSPLIT:
      n = kb_get_cmd_num(cmds_names, str); 
      if (n!=-1)
	new_shell_with_command_bb(ptl, n*4+1);
      break;
    case MGT_COMMAND_VSPLIT:
      n = kb_get_cmd_num(cmds_names, str); 
      if (n!=-1)
	new_shell_with_command_bb(ptl, n*4+2);
      break;
    case MGT_COMMAND_NEWWINDOW:
      n = kb_get_cmd_num(cmds_names, str); 
      if (n!=-1)
	new_shell_with_command_bb(ptl, n*4+3);
      break;
    case MGT_NEWTAB_WITH:
      /* the second arg is a dummy one */
      new_tab_with(ptl, 0);
      break;
    case MGT_HSPLIT_WITH:
      hsplit_with(ptl, 0);
      break;
    case MGT_VSPLIT_WITH:
      vsplit_with(ptl, 0);
      break;
    case MGT_HVIEW_OF:
      cb_hview(ptl, 0);
      break;
    case MGT_VVIEW_OF:
      cb_vview(ptl,0);
      break;
    case MGT_ALL_BONDED:
      tb_bonded(NULL, ptl); 
      break;
    case MGT_ALL_UNBONDED:
      tb_unbonded(NULL, ptl);
      break;
    case MGT_SAVE_TERMINALS:
      tb_save_tabs(NULL, ptl);
      break;
    case MGT_NEXT_TERM_IN_TAB:
      tab = gtk_object_get_data(GTK_OBJECT(term), "tab");
      tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
      tl = g_slist_find(*tab_terms, term);
      if (!tl)
	return;
      if (tl->next)
	focusterm = GTK_WIDGET(tl->next->data);
      else
	focusterm = GTK_WIDGET(g_slist_nth_data(*tab_terms, 0));
      gtk_widget_grab_focus(focusterm);
      pgno = gtk_notebook_page_num (GTK_NOTEBOOK (nb), tab);
      set_titles (app, pgno, pgno);
      gtk_object_set_data(GTK_OBJECT(tab), "active", focusterm);
     break;
     case MGT_PREV_TERM_IN_TAB:
      tab = gtk_object_get_data(GTK_OBJECT(term), "tab");
      tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
      ti = g_slist_index(*tab_terms, term);
      llen = g_slist_length(*tab_terms);
      if (ti==-1)
	return;
      if (ti-1 >= 0)
	focusterm = GTK_WIDGET(g_slist_nth_data(*tab_terms, ti-1));
      else
	focusterm = GTK_WIDGET(g_slist_nth_data(*tab_terms, llen-1));
      gtk_widget_grab_focus(focusterm);
      pgno = gtk_notebook_page_num (GTK_NOTEBOOK (nb), tab);
      set_titles (app, pgno, pgno);
      gtk_object_set_data(GTK_OBJECT(tab), "active", focusterm);
     break;
    case MGT_ESCAPE_SEQUENCE:
      /* write string to terminal */
      cstr = convert_escape(str);
      vt_writechild(&vx->vt, cstr, strlen(cstr));
      g_free(cstr);
      break;
      break;
    case MGT_ADJUST_SIZE:
      adjust_app_size(NULL, ptl);
      break;
    case MGT_CMDMENU:
      build_popup_commands(NULL, ptl, term);
      break;
    case MGT_RCMENU:
      right_click_menu (NULL, ptl, term);
      break;
    case MGT_SMOFF:
      selection_mode_off(term);
      break;
    case MGT_HELP:
      terminal_help_cb(NULL, NULL);
      break;
    default:       
      printf("MGT Warning: ...oops invalid action!\n");
      /* ...oops unknown action */
    }
}
#define EVENT_STATE_MASK (GDK_SHIFT_MASK | GDK_MOD1_MASK | GDK_CONTROL_MASK)
#define kkd(x) x
/* ========================================================== */
/* Function to handle keybindings */
gint snooper_func(GtkWidget* widget, GdkEventKey *event, gpointer data)
{
  GtkNotebook* nb;
  GSList** ptl;
  int x, kv;
  GtkWidget* app;
  static int kb_num = 0;
  static GSList *kb_subset = NULL, *kb_subact = NULL, *kb_substr = NULL;
  GSList *lt;
  gboolean match;
  GSList *l, *kbc, *actl, *strl, *lf , *actlf, *strlf;
  struct keyb_atom* ev;
  char **kb_actions, **kb_strings; 
  app = gtk_widget_get_toplevel(GTK_WIDGET(widget));
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (!app || !nb || !ptl)
    {
      kkd(printf("rrrreturn...\n"));
      return 0;
    }
  kb_actions = app_config.actions;
  kb_strings = app_config.strings;
   
  if (app_config.disable_keybind)
    return 0;
  
  kv = event->keyval;

  /* all modifiers should not be accepted as valid keys */
  if (kv == GDK_Control_L || kv == GDK_Control_R ||
      kv == GDK_Shift_L || kv == GDK_Shift_R || 
      kv == GDK_Meta_L || kv == GDK_Meta_R || 
      kv == GDK_Alt_L || kv == GDK_Alt_L ||
      kv == GDK_Shift_Lock || kv == GDK_Caps_Lock ||
      kv == GDK_Super_L || kv == GDK_Super_R ||
      kv == GDK_Hyper_L || kv == GDK_Hyper_R ||
      kv == GDK_Mode_switch
      
      )
    {
      return FALSE;
    }

  if (kb_subset && app_config.kbinds_reload)
    {
      kkd(printf("kbinds reloaded...free lists!!!\n"));
      kb_num = 0;
      g_slist_free(kb_subset);
      kb_subset = NULL;
      g_slist_free(kb_subact);
      kb_subact = NULL;
      g_slist_free(kb_substr);
      kb_substr = NULL;
    }
  app_config.kbinds_reload = 0;

  if (!kb_subset) 
    { 
      kkd(printf("subset is whole list!\n"));
      lt = app_config.kbinds_list;
      l = g_slist_copy(lt);
      actl = NULL;
      x = 0;
      while (lt)
	{
	 actl = g_slist_append(actl, kb_actions[x]);
	 x++;
	 lt = lt->next;
	}
      strl = NULL;
      lt = l;
      x = 0;
      while (lt)
	{
	 strl = g_slist_append(strl, kb_strings[x]);
	 x++;
	 lt = lt->next;
	}
    }
  else
    {
      kkd(printf ("Copying subset...\n"));
      l = g_slist_copy(kb_subset);
      actl = g_slist_copy(kb_subact);
      strl = g_slist_copy(kb_substr);
      g_slist_free(kb_subact);
      g_slist_free(kb_subset);
      g_slist_free(kb_substr);
      kb_subset = NULL;
      kb_subact = NULL;
      kb_substr = NULL;
    }
  lf = l;
  actlf = actl;
  strlf = strl;

  match = FALSE;

  kkd(printf("event->keyval: %d, event->state:%d\n", event->keyval, event->state));
  while (l)
    {
      kbc = (GSList*) l->data;
      ev = g_slist_nth_data(kbc, kb_num);
      /*kd(printf("l->data: %p ev->type: %d, ev->keyval: %d ev->state: %d event->keyval: %d event->state: %d\n", 
      l->data, ev->type, ev->keyval, ev->state, event->keyval, event->state));*/
      if ( ev && ev->type == GDK_KEY_PRESS &&
	   ev->keyval == event->keyval && 
	   ev->state == (event->state & EVENT_STATE_MASK))
	{
	  kbc = g_slist_nth(kbc, kb_num+1);
	  if (kbc)
	    {
	      kkd(printf("Matching but not complete!\n"));
	      /* next element exists so not complete keybindings yet */
	      match = TRUE;
	      kb_subset = g_slist_append(kb_subset, l->data);
	      kb_subact = g_slist_append(kb_subact, actl->data); 
	      kb_substr = g_slist_append(kb_substr, strl->data);
	    }	   
	  else
	    {
	      kkd(printf("MATCHING KEYB!!!!\n"));
	      /* keybinding matches! */
	      x = 0;
	      while (actions_list[x])
		{
		  if (!strcmp(actions_list[x],(char*)actl->data))
		    break;
		    x++;
		}
	      /* here we have to find the right action to do!!! */
	      kb_do_action(app, nb, ptl, x, (char *)strl->data);
	      if (kb_subset)
		{
		  g_slist_free(kb_subset);
		  g_slist_free(kb_subact);
		  g_slist_free(kb_substr);
		  kb_subset = kb_subact = kb_substr = NULL;
		}
	      g_slist_free(lf);
	      g_slist_free(actlf);
	      g_slist_free(strlf);
	      kb_num = 0;
	      return 1;
	    } 
	}

      l = l->next;
      actl = actl->next;
      strl = strl->next;
    }

  g_slist_free(lf);
  g_slist_free(actlf);
  g_slist_free(strlf);
  if (!match)
    {
      kb_num = 0;
      g_slist_free(kb_subset);
      kb_subset = NULL;
      g_slist_free(kb_subact);
      kb_subact = NULL;
      g_slist_free(kb_substr);
      kb_substr = NULL;
      kkd(printf("Not mathced\n"));
    } 
  else
    {
      kb_num++;
      kkd(printf("Incremented kb_num: %d\n", kb_num));
    }

  return (match?1:0);
} 

struct chg_struct {
GtkNotebook* nb;
ZvtTerm* term;
int page;
};

gboolean
parse_path( gchar          *str,
	    gchar         **item)
{
  gchar *translation;
  gchar *p, *q;
  gchar *path, *parent_path;
  
  path = g_strdup (str);

  p = q = path;
  while (*p)
    {
      if (*p != '_')
        {
          *q++ = *p;
        }
      p++;
    }
  *q = 0;

  translation = str;
  parent_path = g_strdup (path);
  p = strrchr (parent_path, '/');
  if (!p)
    {
      /*g_warning ("invalid entry path `%s'", str);*/
      return FALSE;
    }
  *p = 0;

  p = strrchr (translation, '/');
  if (p)
    p++;
  else
    p = translation;

  g_free(path);
  g_free(parent_path);
  
  *item = g_strdup (p);
  return TRUE;
}


/* ====================== >>> changed_txt <<< ================================= */
void changed_txt(char* string, gpointer data)
{
  int cp;
  GtkWidget *app, *child, *label;
  GtkNotebook* nb;
  ZvtTerm* term;
  GSList** ptl;
  struct chg_struct* pcs;
  struct terminal_config* cfg;
  struct win_config *wincfg;
  char tmp3[550], txt[300], *ttitle, *tname;
#if 0  
  nb = GTK_NOTEBOOK(data);
  cp = gtk_notebook_get_current_page(nb);
#endif
  pcs = (struct chg_struct*) data;
  nb = pcs->nb;
  cp = pcs->page;
  term = pcs->term;
  free(pcs);
  app = gtk_widget_get_toplevel(GTK_WIDGET(nb));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
#if 0
  term = current_term(ptl);
#endif
  
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  
  if (string == NULL) 
    {
      gtk_widget_grab_focus(GTK_WIDGET(term));
      return;
    }
  child = gtk_notebook_get_nth_page(nb, cp);
  tname = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
  ttitle = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
  /*if (!strcmp(ttitle, tname))
    {*/
  /* if ttitle == tname then change also the window title
     otherwise leave it unchanged */
  if (wincfg->titled_tabs)
    {
      strcpy(ttitle, string);
      if (wincfg->no_numprefix)
	sprintf(tmp3, "%s - [ %s ]", wincfg->window_title, string);
      else
	sprintf(tmp3, "%s - [ %d-%s ]", wincfg->window_title, cp+1, string);
      gtk_window_set_title (GTK_WINDOW(app), tmp3);
    }
  if (!wincfg->titled_tabs)
    strcpy(tname, string);
  /* change both! */

  if (wincfg->no_numprefix)
    sprintf(txt, "%s", string);
  else 
    sprintf(txt, "%d-%s", cp+1, string);

  if (wincfg->titled_tabs)
    trunc_string(txt, wincfg->maxch);

  label = gtk_notebook_get_tab_label(nb,child);
  gtk_label_set_text(GTK_LABEL(label),txt);

  label = gtk_notebook_get_menu_label(nb, child);
  gtk_label_set_text(GTK_LABEL(label), txt);

  /*gtk_notebook_set_menu_label_text(nb, child, txt);*/
  gtk_widget_grab_focus(GTK_WIDGET(term));
  
 
}

typedef struct {
  gpointer function;
  gpointer data;
  GtkEntry * entry;
} callback_info;

static void
dialog_string_callback (GnomeMessageBox * mbox, gint button, callback_info * data)
{
  gchar * s = NULL;
  gchar * tmp;
  GnomeStringCallback func = (GnomeStringCallback)data->function;
  
  if (button == 0) {
    tmp = gtk_entry_get_text (data->entry);
    if (tmp) s = g_strdup(tmp);
  }

  (* func)(s, data->data);
}

static GtkWidget *
MGT_request_dialog (const gchar * request, const gchar * default_text, const guint16 max_length,
                GnomeStringCallback callback, gpointer data,
                gboolean password,
                GtkWindow * parent)
{
  GtkWidget * mbox;
  callback_info * info;
  GtkWidget * entry;

  mbox = gnome_message_box_new ( request, GNOME_MESSAGE_BOX_QUESTION,
                                 GNOME_STOCK_BUTTON_OK,
                                 GNOME_STOCK_BUTTON_CANCEL,
                                 NULL );
  gnome_dialog_set_default ( GNOME_DIALOG(mbox), 0 );

  /* set up text entry widget */
  entry = gtk_entry_new();
  if (password) gtk_entry_set_visibility (GTK_ENTRY(entry), FALSE);
  if ((default_text != NULL) && (*default_text))
    gtk_entry_set_text(GTK_ENTRY(entry), default_text);
  if (max_length > 0)
    gtk_entry_set_max_length(GTK_ENTRY(entry), max_length);
 
  gtk_editable_select_region(GTK_EDITABLE(entry), 0, -1);

  gtk_box_pack_end ( GTK_BOX(GNOME_DIALOG(mbox)->vbox),
                     entry, FALSE, FALSE, GNOME_PAD_SMALL );

  /* If Return is pressed in the text entry, propagate to the buttons */
  gnome_dialog_editable_enters(GNOME_DIALOG(mbox), GTK_EDITABLE(entry));

  info = g_new(callback_info, 1);

  info->function = callback;
  info->data = data;
  info->entry = GTK_ENTRY(entry);

  gtk_signal_connect_full(GTK_OBJECT(mbox), "clicked",
                          GTK_SIGNAL_FUNC(dialog_string_callback),
                          NULL,
                          info,
                          (GtkDestroyNotify)g_free,
                          FALSE, FALSE);

  if (parent != NULL) {
    gnome_dialog_set_parent(GNOME_DIALOG(mbox),parent);
  }

  gtk_widget_grab_focus (entry);
  gtk_widget_show (entry);
  gtk_widget_show (mbox);
  return mbox;
}

GtkWidget *
MGT_gnome_request_dialog (gboolean password, const gchar * prompt,
                      const gchar * default_text, const guint16 max_length,
                      GnomeStringCallback callback, gpointer data,
                      GtkWindow * parent)
{
  return MGT_request_dialog (prompt, default_text, max_length,
                         callback, data, password, parent);


}

/* ===================== >>> change_title <<< =================================== */
void change_title_page(GtkWidget* widget, gpointer data, int page)
{
  char lbltxt[256];
  gchar* txt = NULL;
  int cp, len;
  GtkWidget* chgtxt;
  GtkNotebook* nb;
  struct chg_struct *pcs;
  GtkWidget *app, *tab; 
  GSList **ptl, **tl;
  ZvtTerm* term;
  struct terminal_config* cfg;
  struct win_config *wincfg;
  nb = GTK_NOTEBOOK(data);
  
  if (page < 0)
    cp = gtk_notebook_get_current_page(nb);
  else 
    cp = page;

  app = gtk_widget_get_toplevel(GTK_WIDGET(nb));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig"); 
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  tl = gtk_object_get_data(GTK_OBJECT(app), "tablist");
  if (page < 0)
    term = current_term(ptl);
  else
    {
      tab = g_slist_nth_data(*tl, page);
      term = ZVT_TERM(gtk_object_get_data(GTK_OBJECT(tab), "active"));
    }
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  
  sprintf(lbltxt, "Change title of active terminal in tab #%d", cp+1);
  
  /*child = gtk_notebook_get_nth_page(nb, cp);*/
  if (wincfg->titled_tabs)
    {
      txt = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
      len = 256;
    }
  else
    {
      txt = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
      len = 32;
    }

  pcs = malloc(sizeof(struct chg_struct));
  pcs->nb = nb;
  pcs->page = cp;
  pcs->term = term;
  chgtxt = MGT_gnome_request_dialog(FALSE, lbltxt, txt, len, 
				changed_txt, (gpointer) pcs, GTK_WINDOW(app));
  gtk_window_set_modal(GTK_WINDOW(chgtxt), TRUE);
}

void change_title(GtkWidget* widget, gpointer data)
{
  change_title_page(widget, data, -1);
}

void button_prev_page(GtkWidget* w)
{
  GtkWidget *app, *term;
  GSList **tabl, ** ptl;
  int cp, lp;

  app = gtk_widget_get_toplevel(w);
  ptl = gtk_object_get_data(GTK_OBJECT(app),"ptermlist");
  tabl = gtk_object_get_data(GTK_OBJECT(app),"tablist");

  cp = gtk_notebook_get_current_page(GTK_NOTEBOOK(w));
  lp = g_slist_length(*tabl) - 1;

  if (cp == 0)
   gtk_notebook_set_page(GTK_NOTEBOOK(w), lp);
  else 
   gtk_notebook_prev_page(GTK_NOTEBOOK(w));
    term = GTK_WIDGET(current_term(ptl));
  gtk_widget_grab_focus(term);
}

void button_next_page(GtkWidget* w)
{
  GtkWidget *app, *term;
  GSList **tabl, ** ptl;
  int cp, lp;
  app = gtk_widget_get_toplevel(w);
  ptl = gtk_object_get_data(GTK_OBJECT(app),"ptermlist");
  tabl = gtk_object_get_data(GTK_OBJECT(app),"tablist");

  cp = gtk_notebook_get_current_page(GTK_NOTEBOOK(w));
  lp = g_slist_length(*tabl) - 1;

  if (cp == lp)
    gtk_notebook_set_page(GTK_NOTEBOOK(w), 0);
  else 
    gtk_notebook_next_page(GTK_NOTEBOOK(w));
  
  term = GTK_WIDGET(current_term(ptl));
  gtk_widget_grab_focus(term);

}

void create_toolbar(GnomeApp *app)
{
  GSList** ptl;
  char* path = NULL;
  int buflen;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  buflen = 0;
  do
    {
      buflen += 512;
      path = realloc(path, sizeof(char)*buflen);
    } 
  while (!getcwd(path, buflen));
  d(printf("path: %s\n", path));
  chdir(GNOME_ICONDIR);
  gnome_app_create_toolbar_with_data(GNOME_APP(app), gnome_terminal_toolbar,
				     ptl);
  chdir(path);
}

GtkWidget  *create_buttonbar(GtkWidget* app, GtkWidget* notebook)
{
  GtkWidget *button,*table, *hbox_but, *pixmap, *menubar2;
  GSList** p_term_list;
  p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  get_main_menu (GTK_WIDGET(app), &menubar2, p_term_list);
  /*gtk_widget_show (menubar2);*/

  gtk_object_set_data(GTK_OBJECT(app), "butmenu_widget", menubar2);

  hbox_but = gtk_hbox_new (0, 3);
  gtk_object_set_data(GTK_OBJECT(app), "buttonbar", hbox_but);
  rebuild_buttonbar_menu(GTK_WIDGET(app));

  table = gtk_table_new(1, 5, TRUE);
  gtk_table_set_col_spacings(GTK_TABLE(table), 1);

  pixmap = gnome_pixmap_new_from_file(GNOME_ICONDIR "/MGT_bb_newshell.png");
  button = gnome_pixmap_button(pixmap,N_("New Term")); 
  GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC(new_tab),
		      p_term_list);
  /*gtk_box_pack_start (GTK_BOX (hbox_but), button, FALSE, TRUE, 0)*/;
  gtk_table_attach_defaults(GTK_TABLE(table), button, 0, 1, 0, 1);
  gtk_widget_show(button);
  /* button = gtk_button_new_with_label ("    Next   "); */
  pixmap = gnome_pixmap_new_from_file(GNOME_ICONDIR "/MGT_bb_remove.png");
  button = gnome_pixmap_button(pixmap,N_("Remove")); 
  GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);
 /*button = gnome_stock_button(GNOME_STOCK_PIXMAP_REMOVE);*/
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC(remove_book),
		      GTK_OBJECT(notebook));

  gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4, 0,1);
  gtk_widget_show(button);

  /*pixmap = gnome_stock_new_with_icon(GNOME_STOCK_MENU_PREF);*/
  pixmap = gnome_pixmap_new_from_file(GNOME_ICONDIR "/MGT_bb_title.png");
  button = gnome_pixmap_button(pixmap, N_("Title"));

  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC(change_title),
		      GTK_OBJECT(notebook));
  GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);
  gtk_widget_show(button);

  gtk_table_attach_defaults(GTK_TABLE(table), button, 4, 5,0,1);
  /*pixmap = gnome_stock_new_with_icon(GNOME_STOCK_BUTTON_PREV);
  button = gnome_pixmap_button(pixmap, N_("Tab Left"));*/
  pixmap = gnome_pixmap_new_from_file(GNOME_ICONDIR "/MGT_bb_back.png");
  button = gnome_pixmap_button(pixmap,N_("Tab Left")); 

  GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      (GtkSignalFunc) butcb_move_left,
		      GTK_OBJECT(notebook));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 1, 2,0,1);

  /*pixmap = gnome_stock_new_with_icon(GNOME_STOCK_BUTTON_NEXT);
  button = gnome_pixmap_button(pixmap, N_("Tab Right"));*/
  pixmap = gnome_pixmap_new_from_file(GNOME_ICONDIR "/MGT_bb_forward.png");
  button = gnome_pixmap_button(pixmap,N_("Tab Right")); 
  GTK_WIDGET_UNSET_FLAGS (button, GTK_CAN_FOCUS);

  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      (GtkSignalFunc) butcb_move_right,
		      GTK_OBJECT(notebook));
  gtk_widget_show(button);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3,0,1);

  gtk_widget_show(table);

  gtk_box_pack_start(GTK_BOX(hbox_but), table, 0, 1, 0);
  return hbox_but;

}
void tab_profile_cb(GtkWidget* widget, gpointer data);
void win_profile_cb(GtkWidget* widget, gpointer data);
void create_menubar(GnomeApp* app)
{
  GSList** ptl;
  int active;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  tab_radio_item[0].moreinfo = NULL;
  win_radio_item[0].moreinfo = NULL;
  
  add_tabprofiles(&(tab_radio_item[0].moreinfo), GTK_WIDGET(app), ptl, &active); 
  add_winprofiles(&(win_radio_item[0].moreinfo), GTK_WIDGET(app), ptl, &active);

  /*printf("active: %d\n", active);*/
  gnome_app_create_menus_with_data (GNOME_APP (app), 
				    gnome_terminal_menu, ptl);

  gtk_object_set_data(GTK_OBJECT(app), "tab_radio_item", tab_radio_item[0].moreinfo);
  gtk_object_set_data(GTK_OBJECT(app), "win_radio_item", win_radio_item[0].moreinfo);
  
  gtk_object_set_data(GTK_OBJECT(app), "toggle_toolbar",
		      gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_TOOLBAR].widget);
  gtk_object_set_data(GTK_OBJECT(app), "toggle_menubar",
		      gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_MENUBAR].widget);
  gtk_object_set_data(GTK_OBJECT(app), "toggle_buttonbar",
		      gnome_terminal_terminal_menu[FILE_MENU_TOGGLE_INDEX_BUTTONBAR].widget);
  tab_radio_item[0].moreinfo = NULL;
  win_radio_item[0].moreinfo = NULL;
  rebuild_menubar_from_arrays(GNOME_APP(app));
}
void mgt_do_resize(GtkWidget*app);
void hide_buttonbar(GnomeApp* app, gboolean hbb)
{
  GtkWidget* vbox, *hbox_but, *notebook;
  GtkCheckMenuItem *toggle_item;
  int aw, ah;
  vbox = gtk_object_get_data(GTK_OBJECT(app), "appvbox");
  hbox_but = gtk_object_get_data(GTK_OBJECT(app), "buttonbar");
  notebook = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  aw = GTK_WIDGET(app)->allocation.width;
  ah = GTK_WIDGET(app)->allocation.height;
  if (!hbox_but)
    {
      hbox_but = create_buttonbar(GTK_WIDGET(app), GTK_WIDGET(notebook));
      /*gtk_object_set_data(GTK_OBJECT(app), "buttonbar", hbox_but);*/
      gtk_box_pack_start(GTK_BOX(vbox), hbox_but, 0, 1, 0); 
    } 

  if (hbb == TRUE)
    {
      gtk_widget_hide(GTK_WIDGET(hbox_but));      
    }
  else
    {
      gtk_widget_show(GTK_WIDGET(hbox_but));    
    }
  if (GTK_IS_MENU_ITEM (gtk_object_get_data(GTK_OBJECT(app), "toggle_buttonbar"))) 
    {
      /* update menu */
      toggle_item = GTK_CHECK_MENU_ITEM (gtk_object_get_data(GTK_OBJECT(app), "toggle_buttonbar"));
      toggle_item->active = !hbb;
    }
  gtk_widget_set_usize(GTK_WIDGET(app), aw, ah);

  mgt_do_resize(GTK_WIDGET(app));
}

void hide_menubar(GnomeApp* app, gboolean hmb)
{
  GtkCheckMenuItem *toggle_item;
  int aw, ah;

  if (!app->menubar)
    {
      create_menubar(app);
    }
  aw = GTK_WIDGET(app)->allocation.width;
  ah = GTK_WIDGET(app)->allocation.height;

  if (hmb)
    gtk_widget_hide (app->menubar->parent);
  else
    gtk_widget_show (app->menubar->parent);
  if (GTK_IS_MENU_ITEM (gtk_object_get_data(GTK_OBJECT(app), "toggle_menubar"))) 
    {
      /* update menu */
      toggle_item = GTK_CHECK_MENU_ITEM (gtk_object_get_data(GTK_OBJECT(app), "toggle_menubar"));
      toggle_item->active = !hmb;
    }
  gtk_widget_set_usize(GTK_WIDGET(app), aw, ah);

  mgt_do_resize(GTK_WIDGET(app));
}

void hide_toolbar(GnomeApp* app, gboolean htb)
  {
  GnomeDockItem* dock_item;
  GnomeDockLayoutItem* dock_layout_item;
  GnomeDockPlacement dock_plac;
  guint num_band_return, band_position_return, offset_return; 
  GtkCheckMenuItem *toggle_item;
  int aw, ah;
  aw = GTK_WIDGET(app)->allocation.width;
  ah = GTK_WIDGET(app)->allocation.height;
  if (app->layout)
    {
      dock_layout_item = gnome_dock_layout_get_item_by_name(app->layout, 
		    					    GNOME_APP_TOOLBAR_NAME);
       if (!dock_layout_item)
	{
	  create_toolbar(app);
	  dock_layout_item = gnome_dock_layout_get_item_by_name(app->layout, 
	    							GNOME_APP_TOOLBAR_NAME);
	}
       if (htb == TRUE)
	 gtk_widget_hide(GTK_WIDGET(dock_layout_item));      
       else
	 gtk_widget_show(GTK_WIDGET(dock_layout_item));    
    }
  else
    {
      dock_item = gnome_dock_get_item_by_name  (GNOME_DOCK(app->dock),
                                               GNOME_APP_TOOLBAR_NAME,
					       &dock_plac,
					       &num_band_return,
					       &band_position_return,
					       &offset_return);
      if (!dock_item)
	{
	  create_toolbar(app);
	  dock_item = gnome_dock_get_item_by_name  (GNOME_DOCK(app->dock),
	      					    GNOME_APP_TOOLBAR_NAME,
	     					    &dock_plac,
	     					    &num_band_return,
	     					    &band_position_return,
	     					    &offset_return);
	}       
 
      if (htb == TRUE)
	gtk_widget_hide(GTK_WIDGET(dock_item));      
      else
	gtk_widget_show(GTK_WIDGET(dock_item));    
    }
    
   if (GTK_IS_MENU_ITEM (gtk_object_get_data(GTK_OBJECT(app), "toggle_toolbar"))) 
     {
       /* update menu */
       toggle_item = GTK_CHECK_MENU_ITEM (gtk_object_get_data(GTK_OBJECT(app), "toggle_toolbar"));
       toggle_item->active = !htb;
     }
   gtk_widget_set_usize(GTK_WIDGET(app), aw, ah);

   mgt_do_resize(GTK_WIDGET(app));
}

char** vector_dup(char** v)
{
  int x = 0;
  char** rp;
  while(v[x])
    x++;
  
  rp = malloc(sizeof(char*)*(x+1));
  x = 0;
  while(v[x])
    {
      rp[x] = malloc(sizeof(char)*(strlen(v[x])+1));
      strcpy(rp[x], v[x]);
      x++;
    }
  
  rp[x] = NULL;
  return rp;
}
void menu_radioitem_cb(GtkWidget *w, gpointer data)
{
  GtkWidget *app;
#if 1
  int nclass, ntab;
  GtkWidget *tab, *nb;
  GtkWidget *term;
  GtkCheckMenuItem *check_item;
  struct terminal_config *cfg;
  GnomeUIInfo *radioinfo;
  g_return_if_fail (data != NULL);
  g_return_if_fail (GTK_WIDGET (data));
  app = GTK_WIDGET(data);
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  ntab = gtk_notebook_get_current_page(GTK_NOTEBOOK(nb));
  tab = gtk_notebook_get_nth_page(GTK_NOTEBOOK(nb), ntab);
  term = gtk_object_get_data(GTK_OBJECT(tab), "active");
  g_return_if_fail (term != NULL);
  g_return_if_fail (ZVT_IS_TERM (term));
  cfg = gtk_object_get_data(GTK_OBJECT(term), "config");
  tabclass_search(cfg->class, &nclass);      
  radioinfo = gtk_object_get_data(GTK_OBJECT(app), "tab_radio_item");
  if (radioinfo)
    {
      check_item =  
	GTK_CHECK_MENU_ITEM( (((GnomeUIInfo*)(radioinfo))[nclass]).widget );
      if (check_item)
	gtk_check_menu_item_set_active(check_item, TRUE);
    }
#endif
}
void nb_switch_pg (GtkNotebook * notebook, GtkNotebookPage * page,
                      gint page_num, gpointer user_data)
{
  /* g.o. - function hacked to work with the new widget layout */
  GtkWidget *app, *tab;
  GtkWidget* term;
  gchar tmp3[512];
  GSList** tabl;
  char *ttitle;
  struct win_config *wincfg;
  struct stored_sdata* sapp;

  app = gtk_widget_get_toplevel(GTK_WIDGET(notebook));
  tabl = gtk_object_get_data(GTK_OBJECT(app), "tablist");
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  sapp = gtk_object_get_data(GTK_OBJECT(app), "store_search_data");
  if (sapp)
    {
      sapp->start_line = -1;
      sapp->start_x = -1;
    }
  /*
     tmp = gtk_notebook_get_tab_label (GTK_NOTEBOOK(notebook),
     gtk_notebook_get_nth_page (GTK_NOTEBOOK(notebook),
     						       page_num));
  */
  if (!tabl)
    return;
      
  if (!(*tabl))
    return;

  /* ================= */
  tab = GTK_WIDGET (g_slist_nth_data (*tabl, page_num));
  term = gtk_object_get_data (GTK_OBJECT (tab), "active");
  /*if (!term || !ZVT_IS_TERM(term))
    return;*/
  /* update current tab class */
  /* ======================== */
  ttitle = gtk_object_get_data(GTK_OBJECT(term), "termtitle");
  gtk_object_set_data(GTK_OBJECT(app), "page_switched", GINT_TO_POINTER(1));
#if 0
  ZVT_TERM(term)->pg_switched = 1;
#endif
  if (wincfg->no_numprefix)
    sprintf(tmp3, "%s - [ %s ]", wincfg->window_title, ttitle);
  else
    sprintf(tmp3, "%s - [ %d-%s ]", wincfg->window_title, page_num+1, ttitle);
#if 1 
  gtk_object_set_data(GTK_OBJECT(app), "last_pg", GINT_TO_POINTER(0));
  gtk_object_set_data(GTK_OBJECT(app), "new_pg", GINT_TO_POINTER(0));
#endif 
  gtk_window_set_title (GTK_WINDOW(app), tmp3);
  if (GTK_WIDGET_DRAWABLE(GTK_WIDGET(term)))
    gtk_widget_grab_focus(GTK_WIDGET(term));
}
extern void unref_all_pixmaps(ZvtTerm *term);
void check_resize(GtkContainer* app, gpointer data)
{
  int *resize;
  ZvtTerm* te;
  GtkWidget* tab;
  
  if (!data)
    return;
  
  te = current_term((GSList**)data); 
  if (!te || !ZVT_IS_TERM(te))
    return;
  tab = gtk_object_get_data(GTK_OBJECT(te), "tab");
  rd(printf("tab: %p in resize: %dx%d\n", tab, tab->allocation.width, tab->allocation.height));
#if 1 
  if (!gtk_object_get_data(GTK_OBJECT(app), "page_switched"))
    {
      GSList *tl, **ptl;
      ZvtTerm* ot;
      /*tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");*/
      ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
      /* tl = *tab_terms; */
      tl = *ptl;
      while (tl)
	{
	  ot = ZVT_TERM(tl->data);
	  /*ot->force_paint = 1;*/
	  unref_all_pixmaps(ot);
	  gtk_widget_queue_draw(GTK_WIDGET(ot));
	  tl = tl->next;
	}
    }
  else
    {
      gtk_object_set_data(GTK_OBJECT(app), "page_switched", GINT_TO_POINTER(0));
      /*     te->pg_switched = 0; */
    }
#endif   
  /* NOTE: probably it's better to put this under the condition
     that it isn't a tab switch i.e. I can put this after te->force_paint=1 */
  resize = gtk_object_get_data(GTK_OBJECT(app), "is_a_resize");
  *resize = TRUE;
}

/* This function is called when user set a new theme for example 
   and it sets correctly all tabs styles */


void cb_style_set(GtkWidget* w, GtkStyle* ps, gpointer data)
{
  GSList **ptl, *tmp;
  GtkWidget* term, *child, *label, *app;
  GtkStyle* rcstyle;
  GtkNotebook* nb;
  int i, *p_state;
  GtkStyle* old_style[UNDEFINED+1];
  struct  win_config* wincfg;

  ptl = gtk_object_get_data(GTK_OBJECT(w), "ptermlist");

  term = GTK_WIDGET((*ptl)->data);
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  nb = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(w), "notebook"));
  
  child = gtk_notebook_get_nth_page(nb, 0);
  label = gtk_notebook_get_tab_label(nb, child);

  rcstyle = gtk_rc_get_style(label);
  if (!rcstyle)
    rcstyle = gtk_widget_get_style(label);

  for (i = 0; i < UNDEFINED + 1; i++)
   old_style[i]= tab_style[i];

  init_styles(rcstyle, wincfg);
  
  /* e qui deve settare lo stile di tutti i tab!!! */
  tmp = *ptl;
  i = 0;
  while(tmp)
    {
      term = GTK_WIDGET(tmp->data);
      child = gtk_notebook_get_nth_page(nb, i);
      label = gtk_notebook_get_tab_label(nb, child);
      p_state = gtk_object_get_data(GTK_OBJECT(term), "term_state");
      gtk_widget_set_style(label, tab_style[UNCHANGED]);
      gtk_widget_set_style(GTK_WIDGET(label), tab_style[*p_state]);
      tmp = tmp->next;
      i++;
    }
  
  for (i = 0; i < UNDEFINED + 1; i++)
    gtk_style_unref(old_style[i]);

}

ZvtTerm* create_term(int w, int h, struct terminal_config* cfg, char** env,
		     int first_tab)
{
  int *pts;
  ZvtTerm* term;
#ifdef  SHADING
  GdkImlibColorModifier mod, rmod, gmod, bmod;
#endif
  if (!w || !h) 
    term = (ZvtTerm *)zvt_term_new();
  else
    {
      term = (ZvtTerm *)zvt_term_new_with_size(w, h);
    }
  /*gnome_term_set_font (ZVT_TERM(term), cfg->font, cfg->boldfont, cfg->use_bold);*/

  gtk_signal_connect(GTK_OBJECT(term), "new_output", new_output, NULL);
  pts = malloc(sizeof(int));
  *pts = UNDEFINED;
  gtk_object_set_data(GTK_OBJECT(term), "term_state", pts);
  pts = malloc(sizeof(int));
  *pts = FALSE;
  gtk_object_set_data(GTK_OBJECT(term), "new_out", pts);
  gtk_object_set_data (GTK_OBJECT (term), "config", cfg);
  
  if ((zvt_term_get_capabilities (term) & ZVT_TERM_PIXMAP_SUPPORT) != 0){
    zvt_pixmap_support = TRUE;
  }
  zvt_term_set_scrollback (term, cfg->scrollback);
  zvt_term_set_wordclass  (term, (guchar *)cfg->wordclass);
  zvt_term_set_bell  (term, !cfg->bell);
  zvt_term_set_blink (term, cfg->blink);
  zvt_term_set_scroll_on_keystroke (term, cfg->scroll_key);
  zvt_term_set_scroll_on_output (term, cfg->scroll_out);
  zvt_term_set_del_key_swap (term, cfg->swap_keys);
#ifdef HAVE_ZVT_DEL_IS_DEL
  zvt_term_set_del_is_del (term, cfg->del_is_del);
#endif
  gtk_signal_connect (GTK_OBJECT (term), "child_died",
		      GTK_SIGNAL_FUNC (terminal_kill), term);

  gtk_signal_connect (GTK_OBJECT (term), "title_changed",
		      (GtkSignalFunc) title_changed, term);
  gtk_signal_connect (GTK_OBJECT (term), "button_press_event",
		      GTK_SIGNAL_FUNC (button_press), term);
#ifdef ZVT_TERM_MATCH_SUPPORT
  zvt_term_match_add( ZVT_TERM(term), "(~/|/|\\./)([-A-Za-z0-9_\\$\\.\\+\\!\\*\\(\\),;:@&=\\?/~\\#\\%]|\\\\ )+", VTATTR_UNDERLINE, "file");
  zvt_term_match_add( ZVT_TERM(term), "\\<((mailto:)|)[-A-Za-z0-9\\.]+@[-A-Za-z0-9\\.]+", VTATTR_UNDERLINE, "email address");
#if 0
  zvt_term_match_add( ZVT_TERM(term), "(((news|telnet|nttp|file|http|ftp|https)://)|(www|ftp)[-A-Za-z0-9]*\\.)[-A-Za-z0-9\\.]+(:[0-9]*)?", VTATTR_UNDERLINE, "host only url");
  zvt_term_match_add( ZVT_TERM(term), "(((news|telnet|nttp|file|http|ftp|https)://)|(www|ftp)[-A-Za-z0-9]*\\.)[-A-Za-z0-9\\.]+(:[0-9]*)?/[-A-Za-z0-9_\\$\\.\\+\\!\\*\\(\\),;:@&=\\?/~\\#\\%]*[^]'\\.}>\\) ,\\\"]", VTATTR_UNDERLINE, "full url");
#else
  zvt_term_match_add( ZVT_TERM(term), "([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}|(((news|telnet|nttp|file|http|ftp|https)://)|(www|ftp)[-A-Za-z0-9]*\\.)[-A-Za-z0-9\\.]+)(:[0-9]*)?/[-A-Za-z0-9_\\$\\.\\+\\!\\*\\(\\),;:@&=\\?/~\\#\\%]*[^]'\\.}>\\),\\\"]", VTATTR_UNDERLINE, "full url");
  zvt_term_match_add( ZVT_TERM(term), "([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}|(((news|telnet|nttp|file|http|ftp|https)://)|(www|ftp)[-A-Za-z0-9]*\\.)[-A-Za-z0-9\\.]+)(:[0-9]*)?", VTATTR_UNDERLINE, "host only url");
#endif
#endif
  gtk_object_set_data(GTK_OBJECT(term), "env_copy", env);
  
  /*frame = gtk_frame_new(NULL);
  gtk_object_set_data (GTK_OBJECT (term), "frame", frame);*/
  if (!cfg->no_border)
    zvt_term_set_shadow_type(term, GTK_SHADOW_IN);
   /*gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);*/
  else
    zvt_term_set_shadow_type(term, GTK_SHADOW_NONE);
   /*gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_NONE);*/
  if (cfg->font_shadow)
    term->font_shadow = 1;
  else
    term->font_shadow = 0;
  /* g.o */
  term->bold_color = cfg->bold_color?1:0;
  term->bonded = 0;
#ifdef SHADING
  term->tintback = cfg->tintback;
  term->adj_contrast = cfg->adj_contrast;
  term->gamma_correction = cfg->gamma_correction;
  mod.contrast = cfg->contrast;
  mod.gamma = cfg->gamma;
  mod.brightness = cfg->shading;
  rmod.contrast = rmod.gamma = 256;
  gmod.contrast = gmod.gamma = 256;
  bmod.contrast = bmod.gamma = 256;
  rmod.brightness = cfg->rtint;
  gmod.brightness = cfg->gtint;
  bmod.brightness = cfg->btint;
  zvt_term_set_image_mode(term, cfg->image_mode);
  
  zvt_term_set_shading(term, mod, rmod, gmod, bmod);
#endif	
  if (zvt_pixmap_support && cfg->background_pixmap) {
    int flags;
#ifdef ZVT_BACKGROUND_SCROLL
    flags = cfg->shaded?ZVT_BACKGROUND_SHADED:0;
    flags |= cfg->scroll_background?ZVT_BACKGROUND_SCROLL:0;
#else
    flags = cfg->shaded;
#endif
    zvt_term_set_background (term,
			     cfg->pixmap_file,
			     cfg->transparent, flags, first_tab);
  } else if (zvt_pixmap_support && cfg->transparent)
    zvt_term_set_background (term, NULL,
			     cfg->transparent, cfg->shaded, first_tab);
  else
    zvt_term_set_background (term, NULL, 0, 0, first_tab);

  return term;
}

GtkWidget* create_hbox(GtkWidget *term, int scrollpos)
{
  GtkWidget* hbox, *scrollbar;
  
  hbox = gtk_hbox_new (0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 0);
  /* gtk_container_set_border_width (GTK_CONTAINER (hbox), 2); */
  gtk_box_set_spacing (GTK_BOX (hbox), 0);
  scrollbar = gtk_vscrollbar_new (GTK_ADJUSTMENT (ZVT_TERM(term)->adjustment));
  gtk_object_set_data (GTK_OBJECT (term), "scrollbar", scrollbar);
  gtk_object_set_data (GTK_OBJECT (term), "hbox", hbox);
  gtk_object_set_data (GTK_OBJECT (hbox), "term", term);
  GTK_WIDGET_UNSET_FLAGS (scrollbar, GTK_CAN_FOCUS);

  if (scrollpos == SCROLLBAR_LEFT)
    gtk_box_pack_start (GTK_BOX (hbox), scrollbar, 0, 1, 0);
  else
    gtk_box_pack_end (GTK_BOX (hbox), scrollbar, 0, 1, 0);
  if (scrollpos != SCROLLBAR_HIDDEN)
    gtk_widget_show (scrollbar);
  gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET(term), 1, 1, 0);

  return hbox; 
}


static void
add_pane (GtkPaned *paned,
  	  GtkWidget    *widget)
{
  g_return_if_fail (paned != NULL);
  g_return_if_fail (GTK_IS_PANED (paned));
  g_return_if_fail (widget != NULL);

  if (!paned->child1)
    gtk_paned_add1 (paned, widget);
  else if (!paned->child2)
    gtk_paned_add2 (paned, widget);
}


GtkWidget *create_pane_with_hbox(GtkWidget* hbox, GtkWidget *old_term, GtkWidget *old_pane,
			GtkWidget* tab,
			int scrollpos, int pane_type)
{
  GtkWidget *new_pane, *old_hbox = NULL, *new_hbox, *new_term;
  if (old_term)
    old_hbox = gtk_object_get_data(GTK_OBJECT(old_term), "hbox");
  if (old_pane && old_term)
    {
      gtk_widget_ref(GTK_WIDGET(old_hbox));
      gtk_container_remove(GTK_CONTAINER(old_pane), old_hbox); 
      /* queue actual colors, being old_term unrealized actually */
      fix_terms(old_hbox, gtk_object_get_data(GTK_OBJECT(old_term),"config"));
    }
  new_term = gtk_object_get_data(GTK_OBJECT(hbox), "term");   
  switch (pane_type)
    {
    case MGT_VERT_SPLIT:
      new_pane = gtk_hpaned_new();
      break;
    case MGT_HORIZ_SPLIT:
    default:
      new_pane = gtk_vpaned_new();
    }
  gtk_container_set_border_width(GTK_CONTAINER(new_pane), 0);
  gtk_paned_set_gutter_size (GTK_PANED (new_pane), 0);
  gtk_paned_set_handle_size (GTK_PANED (new_pane), 0);
  new_hbox = hbox; 
  if (old_pane && old_term)
    {
      add_pane (GTK_PANED(new_pane), GTK_WIDGET(old_hbox));      
      gtk_widget_unref(old_hbox);
    }
  
  add_pane (GTK_PANED(new_pane), GTK_WIDGET(new_hbox));
  gtk_object_set_data (GTK_OBJECT(new_term), "pane", new_pane);
  if (old_term)
    gtk_object_set_data (GTK_OBJECT(old_term), "pane", new_pane);
  gtk_object_set_data (GTK_OBJECT(new_term), "tab", tab);
  gtk_object_set_data (GTK_OBJECT(new_term), "parent", old_pane);
  if (old_term)
    {
      gtk_object_set_data (GTK_OBJECT(old_term), "parent", old_pane);
    }
  //gtk_object_set_data (GTK_OBJECT(new_pane), "term", new_term);
  gtk_object_set_data (GTK_OBJECT(new_pane), "parent", old_pane);
  if (old_pane)
    gtk_container_add (GTK_CONTAINER(old_pane), new_pane);
  return new_pane;
}


GtkWidget *create_pane(GtkWidget* new_term, GtkWidget *old_term, GtkWidget *old_pane,
			GtkWidget* tab,
			int scrollpos, int pane_type)
{
  GtkWidget *new_pane, *old_hbox = NULL, *new_hbox;
  if (old_term)
    old_hbox = gtk_object_get_data(GTK_OBJECT(old_term), "hbox");
  if (old_pane && old_term)
    {
      gtk_widget_ref(GTK_WIDGET(old_hbox));
      gtk_container_remove(GTK_CONTAINER(old_pane), old_hbox); 
      /* queue actual colors, being old_term unrealized actually */
      fix_terms(old_hbox, gtk_object_get_data(GTK_OBJECT(old_term),"config"));
    }
  switch (pane_type)
    {
    case MGT_VERT_SPLIT:
      new_pane = gtk_hpaned_new();
      break;
    case MGT_HORIZ_SPLIT:
    default:
      new_pane = gtk_vpaned_new();
    }
  gtk_container_set_border_width(GTK_CONTAINER(new_pane), 0);
  gtk_paned_set_gutter_size (GTK_PANED (new_pane), 0);
  gtk_paned_set_handle_size (GTK_PANED (new_pane), 0);
  new_hbox =  create_hbox(new_term, scrollpos); 
  gtk_widget_show(new_hbox);
  if (old_pane && old_term)
    {
      add_pane (GTK_PANED(new_pane), GTK_WIDGET(old_hbox));      
      gtk_widget_unref(old_hbox);
    }
  
  add_pane (GTK_PANED(new_pane), GTK_WIDGET(new_hbox));
  gtk_object_set_data (GTK_OBJECT(new_term), "pane", new_pane);
  if (old_term)
    gtk_object_set_data (GTK_OBJECT(old_term), "pane", new_pane);
  gtk_object_set_data (GTK_OBJECT(new_term), "tab", tab);
  gtk_object_set_data (GTK_OBJECT(new_term), "parent", old_pane);
  if (old_term)
    {
      gtk_object_set_data (GTK_OBJECT(old_term), "parent", old_pane);
    }
  //gtk_object_set_data (GTK_OBJECT(new_pane), "term", new_term);
  gtk_object_set_data (GTK_OBJECT(new_pane), "parent", old_pane);
  if (old_pane)
    gtk_container_add (GTK_CONTAINER(old_pane), new_pane);
  return new_pane;
}

void app_set_hints(GtkWidget* app)
{
  GtkWidget* tab;
  GtkWidget* nb;
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  tab = gtk_notebook_get_nth_page(GTK_NOTEBOOK(nb),
	      			  gtk_notebook_get_current_page(GTK_NOTEBOOK(nb)));

  set_hints(tab);

}
extern  struct win_config *
win_config_dup (struct win_config *wincfg);
struct win_config * 
load_winconfig (char *class);

GtkWidget *
new_window (char **cmd, struct terminal_config *cfg_in, struct win_config *wincfg_in,
	    const gchar *geometry, 
  	    int termid, char** su_names_in, 
	    char** su_paths_in, char** su_cmds_in, 
	    char** su_classes_in,
	    char* nome_term, char* start_dir)

{
  /* p_term_list is a pointer to the list of all terminals in the current window
  */
  GSList** p_term_list, **tablist, **tab_terms;
  char **su_names = NULL, **su_paths = NULL, **su_cmds = NULL, **su_classes = NULL;
  GtkWidget *notebook;
  GtkWidget *lblmenu, *app, *vbox, *hbox_but, *label;
  char *section;
  /* g.o. */
  GtkWidget *tab, *pane;
  GtkStyle* rcstyle;
#ifdef GT_DIR_TREE
  GtkWidget* hpaned, *frame_sw, *ctree;
#endif	
  ZvtTerm   *term;
  static gint snoop_id = 0;
  char buffer [40];
  char nb_txt[128];
  char wmclass_class [64], wmclass_name[64];
  char *shell, *name;
  int i = 0;
  struct terminal_config *cfg;
  struct win_config *wincfg;
  int width, height, *isres;
  int xpos, ypos;
  char *sdir, *noterm, *tetitle, tmp1[256];
  char *strcmd ;
  /* FIXME: is seems like a lot of this stuff should be done by apply_changes instead */

  cfg = terminal_config_dup (cfg_in);
  wincfg = win_config_dup (wincfg_in);
  if (su_cmds_in)
    {
      su_cmds = vector_dup(su_cmds_in);
      su_paths = vector_dup(su_paths_in);
      su_names = vector_dup(su_names_in);
      su_classes = vector_dup(su_classes_in);
    }
  gnome_terminal_menu[1].moreinfo = custom_submenu_void;
  wincfg->window_id = termid;

  /* Setup the environment for the gnome-terminals:
   *
   * TERM is set to xterm (which is what zvt emulates)
   * COLORTERM is set for slang-based applications to auto-detect color
   * WINDOWID spot is reserved for the xterm compatible variable.
   * COLS is removed
   * LINES is removed
   */
  if (!env_copy){
    char **p;

    for (p = env; *p; p++)
      ;
    i = p - env;
    env_copy = (char **) g_malloc (sizeof (char *) * (i + 1 + EXTRA));
    for (i = 0, p = env; *p; p++){
      if ((strncmp (*p, "COLUMNS=", 8) == 0)
	  || (strncmp (*p, "LINES=", 6) == 0)
	  || (strncmp(*p, "WINDOWID=", 9) == 0)
	  || (strncmp (*p, "TERM=", 5) == 0)
	  || (strncmp (*p, "GNOME_DESKTOP_ICON=", 19) == 0)) {
	/* nothing: do not copy those */
      } else
	env_copy [i++] = *p;
    }
    term_pos = i++;
    env_copy [term_pos] = "";
    env_copy [i++] = "COLORTERM=gnome-terminal";
    winid_pos = i++;
    env_copy [winid_pos] = "TEST";
    env_copy [i] = NULL;
  }

  app = gnome_app_new ("MultiTerminal", _("Multi Gnome Terminal"));
  /* it creates a new class it doesn't exist, this is the case
   * if one supplies a --tclass command line options and uses
   * a non existant class name */
  section = g_strconcat("/MultiTerminal/",cfg->class,"/",NULL);
  if (!gnome_config_has_section(section))
    {
      terminal_config_free(cfg);
      gnome_config_push_prefix("/MultiTerminal/Config/");
      cfg = load_config("Config");
      gnome_config_pop_prefix();
#if 0
     gnome_config_push_prefix(section);
      gnome_config_set_bool("dummy_entry",1);
      gnome_config_sync();
      gnome_config_pop_prefix();
#endif
    }
  gnome_config_drop_all();
  g_free(section);
  section = g_strconcat("/MultiTerminal/",wincfg->class,"/",NULL);
  if (!gnome_config_has_section(section))
    {
      win_config_free(wincfg);
      gnome_config_push_prefix("/MultiTerminal/Win-Config/");
      wincfg = load_winconfig("Win-Config");
      gnome_config_pop_prefix();
#if 0
      gnome_config_push_prefix(section);
      gnome_config_set_bool("dummy_entry",1);
      gnome_config_sync();
      gnome_config_pop_prefix();
#endif
    }
  gnome_config_drop_all();
  g_free(section);
 

  isres = malloc(sizeof(int));
  *isres = FALSE;
  gtk_object_set_data(GTK_OBJECT(app), "is_a_resize", isres);

  gtk_container_set_resize_mode(GTK_CONTAINER(app), GTK_RESIZE_QUEUE);
  /* override the title if it was in the config */
  if (wincfg->window_title) {
    gtk_window_set_title(GTK_WINDOW(app), wincfg->window_title);
  }
  else
    wincfg->window_title = g_strdup("MGT");

  /* override the icon if it was in the config */
  if (wincfg->window_icon) {
    gnome_window_icon_set_from_file (GTK_WINDOW(app), wincfg->window_icon);
  }
  g_snprintf (wmclass_name, sizeof (wmclass_name), "%s", 
	      GTK_WINDOW(app)->wmclass_name);
  g_snprintf (wmclass_class, sizeof(wmclass_class), "%s",
	      GTK_WINDOW(app)->wmclass_class); 
  gtk_window_set_wmclass (GTK_WINDOW (app), wmclass_name, wmclass_class);

  gtk_window_set_policy(GTK_WINDOW (app), TRUE, TRUE, TRUE);
  /*gtk_window_set_policy(GTK_WINDOW (app), FALSE, TRUE, FALSE);*/

  if (cmd != NULL)
    initial_term = app;

  /* FIXME: hope it's not needed!: gtk_widget_realize (app); */
#define USE_SNOOPER
#ifdef USE_SNOOPER	
  if (!snoop_id)
    snoop_id = gtk_key_snooper_install(snooper_func, NULL);
#else
  gtk_signal_connect(GTK_OBJECT(app), "key-press-event", 
		     GTK_SIGNAL_FUNC(snooper_func), NULL);
#endif	
  
  if (terminals)
    {
      GtkWidget* exapp;
      preferences_t* prefs;
      winprefs_t *winprefs;
      exapp = GTK_WIDGET(terminals->data);
      prefs = gtk_object_get_data(GTK_OBJECT(exapp), "prefs");
      winprefs = gtk_object_get_data(GTK_OBJECT(exapp), "winprefs");
      gtk_object_set_data(GTK_OBJECT(app), "prefs", prefs);
      gtk_object_set_data(GTK_OBJECT(app), "winprefs", winprefs);
    }
  terminals = g_list_append (terminals, app);
  /*
   * Handle geometry specification; height and width are in
   * terminal rows and columns
   */

  width=80;
  height=24;
  xpos=-1;
  ypos=-1;
  if (geometry) {
    gnome_parse_geometry (geometry, &xpos, &ypos, &width, &height);
    if (width == -1 || height == -1) {
      width=80;
      height=24;
    }
    /* Only the first window gets --geometry treatment for now */
    /*geometry = NULL;*/
  }

  term = create_term(width, height, cfg, env_copy, 1);

  if (xpos != -1 && ypos != -1)
    gtk_widget_set_uposition (GTK_WIDGET (app), xpos, ypos);

  gtk_object_set_data(GTK_OBJECT(app), "term", term);

  gtk_widget_show (GTK_WIDGET (term));

  gtk_signal_connect_object(GTK_OBJECT(app),"configure_event",
			    GTK_SIGNAL_FUNC(term_change_pos),
			    GTK_OBJECT(app));

 
  gtk_signal_connect (GTK_OBJECT (app), "delete_event",
		      GTK_SIGNAL_FUNC (close_app), term);
  gtk_signal_connect (GTK_OBJECT (app), "grab_focus",
		      GTK_SIGNAL_FUNC(grab_focus), term);
  gtk_signal_connect (GTK_OBJECT (term), "button_press_event",
		      GTK_SIGNAL_FUNC (button_press), term);
  
  p_term_list = (GSList**) malloc(sizeof(GSList*));
  *p_term_list = g_slist_append(NULL, (gpointer) term);
  gtk_signal_connect(GTK_OBJECT(app), "check-resize", check_resize, p_term_list);
  /*gtk_signal_connect(GTK_OBJECT(app), "check-resize", app_set_hints, NULL);*/
  /* Disable tear off of menubar and of toolbar which cause the app to die */
  gnome_preferences_set_menubar_detachable(TRUE);
  gnome_preferences_set_toolbar_detachable(TRUE);

  gtk_object_set_data(GTK_OBJECT(app), "ptermlist", p_term_list);
  gtk_object_set_data(GTK_OBJECT(app), "su_names", su_names);
  gtk_object_set_data(GTK_OBJECT(app), "su_cmds", su_cmds);
  gtk_object_set_data(GTK_OBJECT(app), "su_paths", su_paths);
  gtk_object_set_data(GTK_OBJECT(app), "su_classes", su_classes);

  parse_keybind();
  gtk_object_set_data(GTK_OBJECT(app), "custom_submenu", NULL);
  gtk_object_set_data(GTK_OBJECT(app), "buttonbar_menu", NULL);
  gtk_object_set_data(GTK_OBJECT(app), "buttonbar", NULL);

  if (!wincfg->toolbar_hidden)
    {
      create_toolbar(GNOME_APP(app));
    }

  /*gnome_terminal_edit[0].user_data = (gpointer) p_term_list;*/

  gtk_object_set_data (GTK_OBJECT (term), "config", cfg);
  gtk_object_set_data (GTK_OBJECT (app), "winconfig", wincfg);
    /* Decorations */
  vbox = gtk_vbox_new(0,0);
  /* added show of vbox */
  gtk_widget_show (vbox);

  get_shell_name (&shell, &name, wincfg->login_shell);
  errno = 0;
  if(!strlen(shell) > 0) {
    show_shell_error_dialog(errno);
    g_free (shell);
    g_free (name);
    
    return NULL;
  }
  
  tab = gtk_hbox_new(0, 0);
  gtk_container_set_border_width(GTK_CONTAINER(tab), 0);

  pane = create_pane(GTK_WIDGET(term), NULL, NULL, tab, cfg->scrollbar_position,
		       MGT_HORIZ_SPLIT);
  gtk_object_set_data (GTK_OBJECT(tab), "active", term);
  gtk_object_set_data (GTK_OBJECT(tab), "root_pane", pane);
  rd(printf("NEW_WINDOW tab: %p root_pane: %p\n", tab, pane));
  gtk_box_pack_start (GTK_BOX (tab), GTK_WIDGET (pane), 1, 1, 0);

  tablist = (GSList**) malloc(sizeof(GSList*));
  *tablist = g_slist_append(NULL, (gpointer) tab);
  gtk_object_set_data(GTK_OBJECT(app), "tablist", tablist);
 
  tab_terms =  (GSList**) malloc(sizeof(GSList*));
  *tab_terms = g_slist_append(NULL, term);
  gtk_object_set_data(GTK_OBJECT(tab), "tab_terms", tab_terms);

  /*gtk_widget_show(frame);*/
  gtk_widget_show(pane);
  gtk_widget_show(tab);
#ifdef GT_DIR_TREE
  hpaned = gtk_hpaned_new();
  gtk_container_add(GTK_CONTAINER(frame), GTK_WIDGET(hbox)); 
  frame_sw = add_dir_tree(GTK_WIDGET(hpaned), GTK_WIDGET(app));
  /* g.o. */
  /* gtk_paned_pack2(GTK_PANED(hpaned), GTK_WIDGET(frame), TRUE, TRUE); */
  gtk_paned_pack2(GTK_PANED(hpaned), GTK_WIDGET(pane), TRUE, TRUE);
  gtk_widget_show(GTK_WIDGET(hpaned));
#endif

  notebook = gtk_notebook_new();
  GTK_WIDGET_UNSET_FLAGS (notebook, GTK_CAN_FOCUS);
  gtk_container_set_resize_mode(GTK_CONTAINER(notebook), GTK_RESIZE_QUEUE);

  gtk_container_set_border_width(GTK_CONTAINER(notebook), 0);
  gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);
  gtk_notebook_popup_enable (GTK_NOTEBOOK(notebook));
  gtk_object_set_data(GTK_OBJECT(app), "notebook", notebook);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
  gtk_notebook_set_show_border(GTK_NOTEBOOK(notebook),0); 
  if (!wincfg->no_nbborder)
    GTK_NOTEBOOK(notebook)->style_border = TRUE;
  else
    GTK_NOTEBOOK(notebook)->style_border = FALSE;

  if  (!nome_term)
    nome_term = "None";
  
  noterm = g_malloc0(sizeof(char)*33);/* max 32 chars for termname!!!*/

  strncpy(noterm, nome_term, 32);
  gtk_object_set_data(GTK_OBJECT(term), "mtermname", noterm);
  tetitle = malloc(sizeof(char)*260);
  strcpy(tetitle, noterm);

  if (wincfg->no_numprefix)
    sprintf(tmp1, "%s - [ %s ]", wincfg->window_title, noterm); 
  else
    sprintf(tmp1, "%s - [ 1-%s ]", wincfg->window_title, noterm); 

  gtk_window_set_title(GTK_WINDOW(app), tmp1);
  if (wincfg->no_numprefix)
    sprintf(nb_txt, "%s", noterm);
  else
    sprintf(nb_txt, "1-%s", noterm);
  label = gtk_label_new(nb_txt);

  gtk_object_set_data(GTK_OBJECT(term), "termtitle", tetitle);
  if (start_dir)
    sdir = g_strdup(start_dir);
  else
    sdir = g_strdup("None");
  gtk_object_set_data(GTK_OBJECT(term), "startpath", sdir);
  lblmenu = gtk_label_new(nb_txt);
#ifdef DEFAULT_GTK_STYLE	
  init_styles(gtk_widget_get_style(label), cfg);
#else
  rcstyle = gtk_rc_get_style(label);
  if (!rcstyle)
    rcstyle = gtk_widget_get_style(label);
  init_styles(rcstyle, wincfg);

  gtk_signal_connect(GTK_OBJECT(app), "style-set", cb_style_set, NULL);
#endif
  /* hbox -> frame now each terminal is sorrounded by a frame! */
#ifdef GT_DIR_TREE
  gtk_notebook_append_page_menu (GTK_NOTEBOOK (notebook), hpaned, label, lblmenu);
#else
  /* g.o. */
  gtk_notebook_append_page_menu (GTK_NOTEBOOK (notebook), tab, label, lblmenu);
#endif
  gtk_notebook_set_page (GTK_NOTEBOOK(notebook), 0);

  if (wincfg->tab_hidden)
    {
      gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), FALSE);
    }

  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), wincfg->tab_position);
  gtk_widget_show(notebook);

  /* Create a bunch of buttons */
  gtk_signal_connect(GTK_OBJECT(notebook), "switch-page", nb_switch_pg, 
		     p_term_list);

  gtk_box_pack_start(GTK_BOX(vbox), notebook, 1, 1, 0); 
  if (!wincfg->buttonbar_hidden)
    {  
      hbox_but = create_buttonbar(GTK_WIDGET(app), notebook);
      gtk_box_pack_start(GTK_BOX(vbox), hbox_but, 0, 1, 0); 
      gtk_widget_show(hbox_but);
    }
  else
    hbox_but= NULL;
  gtk_object_set_data(GTK_OBJECT(app), "appvbox", vbox);
  gtk_object_set_data(GTK_OBJECT(app), "buttonbar", hbox_but);

  gnome_app_set_contents (GNOME_APP (app), vbox);
  configure_term_dnd (term);
  if (!wincfg->menubar_hidden)
    {
      create_menubar(GNOME_APP(app));
    }

#ifdef COPY_CMD
  configure_term_clipboard (term);
#endif
   
  gnome_term_set_font (ZVT_TERM(term), cfg->font, cfg->boldfont, cfg->use_bold); 
  gtk_widget_show (app);
  set_color_scheme (term, cfg);
  zvt_term_set_open_im (term, cfg->use_im);
  /*gtk_widget_realize(GTK_WIDGET(term));*/
  XSync(GDK_DISPLAY(), False);
  gtk_widget_grab_focus(GTK_WIDGET(term));
  gtk_widget_set_usize(app, app->allocation.width, app->allocation.height);
  /*gtk_widget_queue_resize(GTK_WIDGET(app));*/
  errno = 0;
  if (cmd)
    {
      strcmd = g_strjoinv(" ",cmd);
      gtk_object_set_data(GTK_OBJECT(term),"start_cmd",strcmd);
    }
  else
    {
      gtk_object_set_data(GTK_OBJECT(term),"start_cmd", NULL);
    }
  switch (zvt_term_forkpty (ZVT_TERM(term), cfg->update_records)){
  case -1:
    show_pty_error_dialog(errno);
    g_free (shell);
    g_free (name);

    /* should we exit maybe? */
    return NULL;

  case 0: {
	    int open_max = sysconf (_SC_OPEN_MAX);

	    for (i = 3; i < open_max; i++)
	      fcntl (i, F_SETFD, 1);
	    if (start_dir)
	      {
		d(printf("start_dir: %s\n", start_dir));
		if (strcmp(start_dir,"None"))
		  {
		    chdir(start_dir);	
		  }
	      }


	    /* set delayed env variables */
	    g_snprintf (buffer, sizeof (buffer),
			"WINDOWID=%d",(int) GDK_WINDOW_XWINDOW(GTK_WIDGET(term)->window));
	    env_copy [winid_pos] = buffer;

	    if (cfg->termname && cfg->termname [0])
	      env_copy [term_pos] = cfg->termname;
	    else
	      env_copy [term_pos] = "TERM=xterm";

	    if (cmd){
	      environ = env_copy;
	      execvp (cmd[0], cmd);
	    } else
	      {
		execle (shell, name, NULL, env_copy);
		/* NULL means standard bash */ 
	      }
	    perror ("Could not exec\n");
	    _exit (127);
	  }
  }
  /* term->p_term_list */
  g_free (shell);
  g_free (name);
  return app;
}

extern gint
zvt_term_motion_notify (GtkWidget      *widget,
			GdkEventMotion *event);
#if 0
void view_size(GtkWidget* actterm, GtkWidget* term)
{
  int w, h, wo, ho;
  wo = ZVT_TERM(actterm)->grid_width;
  ho = ZVT_TERM(actterm)->grid_height;
  printf("wo: %d ho: %d\n", wo, ho);
  printf("woa: %d hoa: %d\n", 
	 actterm->allocation.width/ZVT_TERM(actterm)->charwidth,
	     actterm->allocation.height/ZVT_TERM(actterm)->charheight); 
  w = ZVT_TERM(term)->grid_width;
  h = ZVT_TERM(term)->grid_height;
  printf("w: %d h: %d\n", w, h);
  printf("wa: %d ha: %d\n", 
	 term->allocation.width/ZVT_TERM(term)->charwidth,
	 term->allocation.height/ZVT_TERM(term)->charheight); 
}
#endif
#define MGT_GTK_WIDGET(x) (x)?GTK_WIDGET((x)):NULL
extern  int
apply_changes (ZvtTerm *term, struct terminal_config *newcfg);

void to_new_tab(GtkWidget* term)
{
#if 1
  char txt[128],tmp1[256], *noterm;
  GtkWidget *tab, *actterm, *app, *new_pane, *nb,
  *hbox_got, *label, *lblmenu;
  GSList** tablist, **tab_terms, **ptl;
  struct terminal_config* cfg;
  struct win_config* wincfg;
  int nopg, w, h;
  
  app = splitw.term_to_split;
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  actterm = GTK_WIDGET((*ptl)->data);
  cfg = gtk_object_get_data(GTK_OBJECT(actterm), "config");
  tablist = (GSList **) gtk_object_get_data (GTK_OBJECT (app),"tablist");
  splitw.term_to_split = NULL;
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");

  hbox_got = gtk_object_get_data(GTK_OBJECT(term), "hbox");
  /* g.o */
  tab = gtk_hbox_new(0,0);
  gtk_container_set_border_width(GTK_CONTAINER(tab), 0);

  fix_terms(hbox_got, cfg);
  new_pane = create_pane_with_hbox
    (hbox_got, NULL, NULL, tab, cfg->scrollbar_position, MGT_HORIZ_SPLIT); 
  gtk_widget_unref(hbox_got);
  *tablist = g_slist_append(*tablist, tab);
  *ptl = g_slist_append(*ptl, term);
  tab_terms = (GSList**) malloc(sizeof(GSList*));
  *tab_terms = g_slist_append(NULL, term);
  gtk_object_set_data(GTK_OBJECT(tab), "tab_terms", tab_terms);
  nopg = g_slist_length(*tablist);

  gtk_widget_show(new_pane);
  gtk_widget_show(tab);
  gtk_object_set_data (GTK_OBJECT(tab), "active", term);
  gtk_box_pack_start (GTK_BOX (tab), GTK_WIDGET (new_pane), 1, 1, 0);
  gtk_object_set_data (GTK_OBJECT(tab), "root_pane", new_pane);

  noterm = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
  if (wincfg->no_numprefix)
    sprintf(txt, "%s", noterm);
  else
    sprintf(txt, "%d-%s", nopg, noterm); 
  label = gtk_label_new (txt);
  lblmenu = gtk_label_new(txt);
  
  if (wincfg->no_numprefix)	
    sprintf(tmp1, "%s - [ %s ]", wincfg->window_title, noterm);
  else 
    sprintf(tmp1, "%s - [ %d-%s ]", wincfg->window_title, nopg, noterm); 
  gtk_window_set_title(GTK_WINDOW(app), tmp1);
  
  gtk_notebook_append_page_menu (GTK_NOTEBOOK (nb), tab, label, lblmenu);
  gtk_widget_realize(term);
  /*gtk_widget_show_now(term);*/
  gtk_notebook_set_page(GTK_NOTEBOOK(nb), nopg-1);
  /*gtk_widget_queue_resize(GTK_WIDGET(tab));*/
  XSync(GDK_DISPLAY(), False);
  w = ZVT_TERM(term)->vx->vt.width;
  h = ZVT_TERM(term)->vx->vt.height;
  apply_changes(ZVT_TERM(term), cfg);
  zvt_term_set_size(ZVT_TERM(term), w, h);
 #endif
}
void set_paned_position(GtkWidget* pane, int x, int y, int split_type)
{
  switch (split_type)
    {
    case MGT_VERT_SPLIT:
      gtk_paned_set_position(GTK_PANED(pane), (x-8)/2);
      break;
    default:
    case MGT_HORIZ_SPLIT:
      gtk_paned_set_position(GTK_PANED(pane), (y-8)/2);
      break;
    }
}

int calculate_split_dim(GtkWidget* actterm, GtkWidget* hbox, GtkWidget* scrollbar, 
			 int *x, int *y, int *atx, int *aty, int split_type, 
			 int scroll_pos)
{
  int sx, xp, yp;

  /* if father pane void and is attached horizontally then...*/
  *x = hbox->allocation.width;
  *y = hbox->allocation.height;
  if (scroll_pos!=SCROLLBAR_HIDDEN)
    sx = scrollbar->allocation.width;
  else
    sx = 0;
  /* PADDING assumed to be 2 here*/
  xp = (GTK_WIDGET (actterm)->style->klass->xthickness * 2) + 
    2*ZVT_TERM(actterm)->XPADDING,
  yp = GTK_WIDGET (actterm)->style->klass->ythickness * 2 + 
    2* ZVT_TERM(actterm)->YPADDING;
  switch (split_type)  {
  case MGT_VERT_SPLIT:
    *atx = ( (*x - 2*sx - 8 - 2*xp) / 2 )/ ZVT_TERM(actterm)->charwidth;
    *aty = (*y - yp) / ZVT_TERM(actterm)->charheight;
    break;
  case MGT_HORIZ_SPLIT:
  default:
    *atx = (*x - sx - xp) / ZVT_TERM(actterm)->charwidth;
    *aty = ( (*y - 8 - 2*yp) / 2 ) / ZVT_TERM(actterm)->charheight;
  }

  if ( (*atx<=4 && split_type==MGT_VERT_SPLIT)
      || (*aty<=4 &&split_type==MGT_HORIZ_SPLIT))
    {
      /* it makes no sense to split term smaller than 1 char */
      return 0;
    }

  return 1;
}

void fix_geometry(GtkWidget* pane, GtkWidget* term, int x, int y, int aw, int ah)
{
  /*GtkWidget* tab = gtk_object_get_data(GTK_OBJECT(term), "tab");*/
  GtkWidget* app = gtk_widget_get_toplevel(term);
  gtk_widget_realize(term);
  gtk_widget_realize(pane);
  /*gtk_widget_realize(tab);*/
  gtk_widget_set_usize(pane, x, y);
  gtk_widget_set_usize(app, aw, ah);
}

void attach_term(GtkWidget* term, int split_type)
{
  char tmp1[256], *noterm;
  GtkWidget *tab, *actterm, *app, *hbox, *scrollbar, *new_pane, *pane, *nb,
  *hbox_got;
  struct _vtx *vx;
  GSList** tablist, **tab_terms, **ptl;
  struct terminal_config* cfg;
  struct win_config *wincfg;
  int atpos, nopg, aw, ah, page_num, atx, aty, w, h, x, y; 
  actterm = splitw.term_to_split;
  splitw.term_to_split = NULL;
  cfg = gtk_object_get_data(GTK_OBJECT(actterm), "config");
  app = gtk_widget_get_toplevel(actterm);
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");

  tab = gtk_object_get_data(GTK_OBJECT(actterm), "tab");
  aw = app->allocation.width;
  ah = app->allocation.height;
  vx = ZVT_TERM(actterm)->vx;
  ZVT_TERM(actterm)->vx->selectiontype = VT_SELTYPE_NONE;
  hbox = gtk_object_get_data(GTK_OBJECT(actterm), "hbox");
  hbox_got = gtk_object_get_data(GTK_OBJECT(term), "hbox");
  
  scrollbar=gtk_object_get_data(GTK_OBJECT(actterm), "scrollbar"); 
  pane = gtk_object_get_data(GTK_OBJECT(actterm), "pane");
  page_num = gtk_notebook_page_num(GTK_NOTEBOOK(nb), tab);
  gtk_notebook_set_page(GTK_NOTEBOOK(nb), page_num);
  if (!calculate_split_dim(actterm, hbox, scrollbar, &x, &y, &atx, &aty, 
			   split_type, cfg->scrollbar_position))
    return;
  rd(printf("atx:%d aty:%d\n", atx, aty));
  zvt_term_set_size(ZVT_TERM(actterm), atx, aty);

  /* g.o. */
  tablist = (GSList **) gtk_object_get_data (GTK_OBJECT (app), "tablist");
 
  new_pane = create_pane_with_hbox
    (hbox_got, actterm, pane, tab, cfg->scrollbar_position, split_type); 
  gtk_widget_unref(hbox_got);

  gtk_paned_set_gutter_size (GTK_PANED (new_pane), 4);
  gtk_paned_set_handle_size (GTK_PANED (new_pane), 8);
  tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
  atpos = g_slist_index(*tab_terms, (gpointer)actterm); 
  *tab_terms = g_slist_insert(*tab_terms, term, atpos+1);
  *ptl = g_slist_append(*ptl, term);

  nopg = g_slist_index(*tablist, tab);
  noterm = gtk_object_get_data(GTK_OBJECT(term), "mtermname");
  if (wincfg->no_numprefix)	
    sprintf(tmp1, "%s - [ %s ]", wincfg->window_title, noterm);
  else 
    sprintf(tmp1, "%s - [ %d-%s ]", wincfg->window_title, nopg + 1, noterm); 
  gtk_window_set_title(GTK_WINDOW(app), tmp1);
  
  gtk_widget_show(new_pane);
#if 1 
  set_paned_position(new_pane, x, y, split_type);
#endif
  XSync(GDK_DISPLAY(), False);
  w = ZVT_TERM(term)->vx->vt.width;
  h = ZVT_TERM(term)->vx->vt.height;
  apply_changes(ZVT_TERM(term), cfg);
  zvt_term_set_size(ZVT_TERM(term), w, h);
  fix_geometry(new_pane, term, x, y, aw, ah);
}
#if 1
extern struct vt_line *vt_newline(struct vt_em *vt);
struct vt_listnode *vt_list_addtail(struct vt_list *l, struct vt_listnode *n);

void copy_lines(struct vt_em *vt_to, struct vt_em *vt_from, struct vt_line *head)
{
  int i;
  struct vt_line *wn, *vnl;
  i = 0;
  wn = head;
  while (wn)
    {
      vnl = vt_newline(vt_to); 
      vnl->line = i;
      vt_list_addtail(&vt_to->lines, (struct vt_listnode*) vnl);
      memcpy(vnl->data, wn->data, wn->width*sizeof(uint32));
      memcpy(vnl->attrx, wn->attrx, wn->width*sizeof(Char));
      wn = wn->next;
      i++;
    }

}
#endif
void get_buffers(ZvtTerm* view, ZvtTerm* term)
{
#if 0
  struct _vtx *vx_view, *vx_term;
  struct vt_em *vt_view, *vt_term;

  vx_view = view->vx;
  vx_term = term->vx;
  vt_view = &view->vx->vt;
  vt_term = &term->vx->vt;
 
  copy_lines(vt_view, vt_term, (struct vt_line*) vt_term->lines.head);
  copy_lines(vt_view, vt_term, (struct vt_line*) vt_term->lines_back.head);
  copy_lines(vt_view, vt_term, (struct vt_line*) vt_term->lines_alt.head);
  copy_lines(vt_view, vt_term, (struct vt_line*) vt_term->scrollback.head);
  vt_view->width = vt_term->width;
  vt_view->height = vt_term->height;
  vt_view->scrolltop = vt_term->scrolltop;
  vt_view->scrollbottom = vt_term->scrollbottom;
  vt_view->cursorx = vt_term->cursorx;
  vt_view->cursory = vt_term->cursory;
  /* copy now all vt fields */
  vt_view->attr = vt_term->attr;
  vt_view->attrx = vt_term->attrx;
  vt_view->protected_mode = vt_term->protected_mode;
  vt_view->mode = vt_term->mode;
  vt_view->remaptable = vt_term->remaptable;
  vt_view->Gx = vt_term->Gx;
  vt_view->G[0] = vt_term->G[0];
  vt_view->G[1] = vt_term->G[1];
  vt_view->G[2] = vt_term->G[2];
  vt_view->G[3] = vt_term->G[3];
  vt_view->scrollbackoffset = vt_term->scrollbackoffset;
#endif
}
/* g.o. - this function is new, it's purpose is to add a new
 *        term to the current tab
 */
void
create_view(GtkWidget* term_to_view, int split_type)
{
  int nopg, x, y, atx, aty;
  int aw, ah, atpos; 
  char tmp1[256];
  GtkWidget *term, *tt, *app, *actterm, *scrollbar;
  GtkWidget *pane, *tab, *hbox;
  GtkWidget *new_pane, *nb;
  struct _vtx *vx;
  GSList** tablist, **tab_terms, **p_term_list, **view_list;
  struct terminal_config *cfg, *cfg_in;
  struct win_config *wincfg;
  char *tetitle, *noterm, *nome_term = NULL;
  /* set up terminal environment */
  actterm = splitw.term_to_split;
  splitw.term_to_split = NULL;
  
  /* if term_to_view is already a view we don't create a view
   * because a view of a view makes no sense to me :) */
  if (ZVT_TERM(term_to_view)->view_of)
    return;
    
  cfg_in = gtk_object_get_data(GTK_OBJECT(actterm), "config");
  cfg = terminal_config_dup(cfg_in);

  app = gtk_widget_get_toplevel(actterm);
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook");
  p_term_list = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  tab = gtk_object_get_data(GTK_OBJECT(actterm), "tab");
  nopg = gtk_notebook_page_num(GTK_NOTEBOOK(nb), tab);
  gtk_notebook_set_page(GTK_NOTEBOOK(nb), nopg);
  aw = app->allocation.width;
  ah = app->allocation.height;
  vx = ZVT_TERM(actterm)->vx;
  ZVT_TERM(actterm)->vx->selectiontype = VT_SELTYPE_NONE;
  hbox = gtk_object_get_data(GTK_OBJECT(actterm), "hbox");
  scrollbar = gtk_object_get_data(GTK_OBJECT(actterm), "scrollbar"); 
  pane = gtk_object_get_data(GTK_OBJECT(actterm), "pane");
  /* if father pane void and is attached horizontally then...*/
  if (!calculate_split_dim(actterm, hbox, scrollbar, &x, &y, &atx, &aty, 
			   split_type, cfg->scrollbar_position))
    return;
#if 1
  rd(printf("atx:%d aty:%d\n", atx, aty));
  term = GTK_WIDGET(create_term(atx, aty, cfg, env_copy, 0));
  zvt_term_set_size(ZVT_TERM(actterm), atx, aty);
#else
  term = GTK_WIDGET(create_term(1, 1, cfg, env_copy, 0));
#endif
  /* g.o. */
  tablist = (GSList **) gtk_object_get_data (GTK_OBJECT (app), "tablist");
   
  gtk_object_set_data(GTK_OBJECT(tab), "active", term);
  gtk_widget_grab_focus(GTK_WIDGET(term));
  tt = GTK_WIDGET((*p_term_list)->data);

  *p_term_list = g_slist_append(*p_term_list, (gpointer) term); 
  view_list = gtk_object_get_data(GTK_OBJECT(term_to_view), "view_list");
  if (!view_list)
    {
      view_list = (GSList**)g_malloc0(sizeof(GSList*));
      gtk_object_set_data(GTK_OBJECT(term_to_view), "view_list", view_list);
    }
  *view_list = g_slist_append(*view_list, term);
  ZVT_TERM(term)->view_of = term_to_view;

  gtk_widget_show (term);
  
  configure_term_dnd (ZVT_TERM(term));
#ifdef COPY_CMD
  configure_term_clipboard (ZVT_TERM(term));
#endif


#ifdef GT_DIR_TREE
  /*add_dir_tree(hbox, app);*/
#endif
  new_pane = create_pane(term, actterm, pane, tab, cfg->scrollbar_position, split_type); 
  gtk_paned_set_gutter_size (GTK_PANED (new_pane), 4);
  gtk_paned_set_handle_size (GTK_PANED (new_pane), 8);
  tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
  atpos = g_slist_index(*tab_terms, (gpointer)actterm); 
  *tab_terms = g_slist_insert(*tab_terms, term, atpos+1);
  /* *tab_terms = g_slist_append(*tab_terms, term); */
  nopg = g_slist_index(*tablist, tab);
  nome_term = gtk_object_get_data(GTK_OBJECT(term_to_view), "mtermname");

  noterm = g_strdup_printf("%s[V]", nome_term);/* max 32 chars for termname!!!*/
  gtk_object_set_data(GTK_OBJECT(term), "mtermname", trunc_string(noterm,32));
  tetitle = malloc(sizeof(char)*260);
  strcpy(tetitle, noterm);

  if (wincfg->no_numprefix)	
    sprintf(tmp1, "%s - [ %s ]", wincfg->window_title, noterm);
  else 
    sprintf(tmp1, "%s - [ %d-%s ]", wincfg->window_title, nopg + 1, noterm); 
  gtk_window_set_title(GTK_WINDOW(app), tmp1);

  gtk_object_set_data(GTK_OBJECT(term), "termtitle", tetitle);
  gtk_widget_show(new_pane);
   /* g.o */
  set_titles (app, nopg, nopg);
  gnome_term_set_font (ZVT_TERM(term), cfg->font, cfg->boldfont, cfg->use_bold);
  set_color_scheme (ZVT_TERM(term), cfg);
  zvt_term_set_open_im (ZVT_TERM(term), cfg->use_im);
#if 1 
  set_paned_position(new_pane, x, y, split_type);
#endif
  XSync(GDK_DISPLAY(), False);
  fix_geometry(new_pane, term, x, y, aw, ah);
  get_buffers(ZVT_TERM(term), ZVT_TERM(term_to_view));
  gtk_widget_grab_focus(term);
}

/* g.o. - this function is new, it's purpose is to add a new
 *        term to the current tab
 */
void
new_term_in_tab(char** cmd, struct terminal_config *cfg_in, const gchar *geometry, int termid, GSList** p_term_list, char* nome_term, char* start_dir, int split_type)
{
  int nopg, i, cmdindex, scrollbacklines, login_shell, curpage, x, y, atx, aty;
  int aw, ah, atpos; 
  char tmp1[256];
  char buffer[60], *strcmd;
  GtkWidget *tt, *app, *term, *actterm, *scrollbar;
  GtkWidget *pane, *tab, *hbox ;
  GtkWidget *new_pane;
  struct _vtx *vx;
  GSList** tablist, **tab_terms;
  GtkNotebook *notebook;
  preferences_t* prefs;
  struct terminal_config *cfg;
  struct win_config *wincfg;
  char *sdir, *tetitle, *shell, *name, *noterm;
  login_shell = 0;
  cmdindex = 0;
  scrollbacklines = 50;
  /* set up terminal environment */
  env = environ;
  
  cfg = terminal_config_dup (cfg_in); 

  if (!env_copy){
    char **p;

    for (p = env; *p; p++)
      ;
    i = p - env;
    env_copy = (char **) g_malloc (sizeof (char *) * (i + 1 + EXTRA));
    for (i = 0, p = env; *p; p++){
      if ((strncmp (*p, "COLUMNS=", 8) == 0)
	  || (strncmp (*p, "LINES=", 6) == 0)
	  || (strncmp(*p, "WINDOWID=", 9) == 0)
	  || (strncmp (*p, "TERM=", 5) == 0)
	  || (strncmp (*p, "GNOME_DESKTOP_ICON=", 19) == 0)) {
	/* nothing: do not copy those */
      } else
	env_copy [i++] = *p;
    }
    term_pos = i++;
    env_copy [term_pos] = "";
    env_copy [i++] = "COLORTERM=gnome-terminal";
    winid_pos = i++;
    env_copy [winid_pos] = "TEST";
    env_copy [i] = NULL;
  }
  app = gtk_widget_get_toplevel(GTK_WIDGET((*p_term_list)->data));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  notebook = GTK_NOTEBOOK(gtk_object_get_data(GTK_OBJECT(app), "notebook"));
  curpage = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
  tab = gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), curpage);
  aw = app->allocation.width;
  ah = app->allocation.height;
  actterm = gtk_object_get_data(GTK_OBJECT(tab), "active");
  rd(printf("active term in term in tab: %p\n", actterm));
  vx = ZVT_TERM(actterm)->vx;
  ZVT_TERM(actterm)->vx->selectiontype = VT_SELTYPE_NONE;
  hbox = gtk_object_get_data(GTK_OBJECT(actterm), "hbox");
  scrollbar=gtk_object_get_data(GTK_OBJECT(actterm), "scrollbar"); 
  pane = gtk_object_get_data(GTK_OBJECT(actterm), "pane");
  calculate_split_dim(actterm, hbox, scrollbar, &x, &y, &atx, &aty, 
		      split_type, cfg->scrollbar_position);
  rd(printf("atx:%d aty:%d\n", atx, aty));
  term = GTK_WIDGET(create_term(atx, aty, cfg, env_copy, 0));
  zvt_term_set_size(ZVT_TERM(actterm), atx, aty);
  /* g.o. */
  tablist = (GSList **) gtk_object_get_data (GTK_OBJECT (app), "tablist");
   
  gtk_object_set_data(GTK_OBJECT(tab), "active", term);
  gtk_widget_grab_focus(GTK_WIDGET(term));
  tt = GTK_WIDGET((*p_term_list)->data);
  prefs = gtk_object_get_data(GTK_OBJECT(tt), "prefs");
  gtk_object_set_data(GTK_OBJECT(term), "prefs", prefs);

  *p_term_list = g_slist_append(*p_term_list, (gpointer) term); 
 
  gtk_widget_show (term);
  
  configure_term_dnd (ZVT_TERM(term));
#ifdef COPY_CMD
  configure_term_clipboard (ZVT_TERM(term));
#endif

  get_shell_name (&shell, &name, wincfg->login_shell);
#ifdef GT_DIR_TREE
  /*add_dir_tree(hbox, app);*/
#endif
  new_pane = create_pane(term, actterm, pane, tab, cfg->scrollbar_position, split_type); 
  gtk_paned_set_gutter_size (GTK_PANED (new_pane), 4);
  gtk_paned_set_handle_size (GTK_PANED (new_pane), 8);
  tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
  atpos = g_slist_index(*tab_terms, (gpointer)actterm); 
  *tab_terms = g_slist_insert(*tab_terms, term, atpos+1);
  /* *tab_terms = g_slist_append(*tab_terms, term);*/
  nopg = g_slist_index(*tablist, tab);
  if  (!nome_term)
    nome_term = "None";

  noterm = malloc(sizeof(char)*33);/* max 32 chars for termname!!!*/
  strncpy(noterm, nome_term, 32);

  gtk_object_set_data(GTK_OBJECT(term), "mtermname", noterm);
  tetitle = malloc(sizeof(char)*260);
  strcpy(tetitle, noterm);

  if (wincfg->no_numprefix)	
    sprintf(tmp1, "%s - [ %s ]", wincfg->window_title, noterm);
  else 
    sprintf(tmp1, "%s - [ %d-%s ]", wincfg->window_title, nopg + 1, noterm); 
  gtk_window_set_title(GTK_WINDOW(app), tmp1);

  gtk_object_set_data(GTK_OBJECT(term), "termtitle", tetitle);
  if (start_dir)
    sdir = g_strdup(start_dir);
  else
    sdir = g_strdup("None");
  gtk_object_set_data(GTK_OBJECT(term), "startpath", sdir);

  gtk_widget_show(new_pane);
   /* g.o */
  /*gtk_notebook_set_page(GTK_NOTEBOOK(notebook), nopg);*/
  errno = 0;
  /* fork the shell/program */
  if (start_dir)
     {
       if (strcmp(start_dir,"None"))
	 chdir(start_dir);
     }

  if (cmd)
    {
      strcmd = g_strjoinv(" ",cmd);
      gtk_object_set_data(GTK_OBJECT(term), "start_cmd",strcmd);
    }
  else
    {
      gtk_object_set_data(GTK_OBJECT(term), "start_cmd", NULL);
    }
  set_titles (app, nopg, nopg);
  gnome_term_set_font (ZVT_TERM(term), cfg->font, cfg->boldfont, cfg->use_bold);
  set_color_scheme (ZVT_TERM(term), cfg);
  zvt_term_set_open_im (ZVT_TERM(term), cfg->use_im);
#if 1 
  set_paned_position(new_pane, x, y, split_type);
#endif
  /*gtk_widget_queue_resize(GTK_WIDGET(tab));*/
  XSync(GDK_DISPLAY(), False);
  fix_geometry(new_pane, term, x, y, aw, ah);
  gtk_widget_grab_focus(term);
  switch (zvt_term_forkpty(ZVT_TERM (term), cfg->update_records))
    {
    case -1:
      show_pty_error_dialog(errno);
      g_free (shell);
      g_free (name);
      return ;

    case 0: {
	      int open_max = sysconf (_SC_OPEN_MAX);

	      for (i = 3; i < open_max; i++)
		fcntl (i, F_SETFD, 1);

	      /* set delayed env variables */
	      g_snprintf (buffer, sizeof (buffer),
			  "WINDOWID=%d",
			  (int) GDK_WINDOW_XWINDOW(GTK_WIDGET(term)->window));

	      env_copy [winid_pos] = buffer;

	      if (cfg->termname && cfg->termname [0])
		env_copy [term_pos] = cfg->termname;
	      else
		env_copy [term_pos] = "TERM=xterm";

	      if (cmd){
		environ = env_copy;
		execvp (cmd[0], cmd);

	      } else
		{
		  execle (shell, name, NULL, env_copy);
		}
	      perror ("Could not exec\n");
	      _exit (127);

	    }

    default:
	  break;


    }
  g_free (shell);
  g_free (name);
}

void new_shell_happend(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  term = ZVT_TERM(current_term(p_term_list));
   
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  new_term_in_tab(NULL , cfg, NULL, 1, p_term_list, "Shell", NULL, MGT_HORIZ_SPLIT);
}
void new_shell_window(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  /*
     GSList* last;
  last = g_slist_last(*p_term_list);*/
  term = ZVT_TERM(current_term(p_term_list));
   
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  vt_new_window(term , "Shell", " ", NULL, NULL, NULL);
}
void new_hroot(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  GtkWidget *app;
  struct win_config *wincfg;
  char* cmd[3] = {"su", "-", NULL};
  term = ZVT_TERM(current_term(p_term_list));
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");

  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  if (!wincfg->login_shell)
    cmd[1] = NULL;

  new_term_in_tab(cmd , cfg, NULL, 1, p_term_list, "Root", NULL, MGT_HORIZ_SPLIT);
}
void new_vroot(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  GtkWidget *app;
  struct win_config *wincfg;
  char* cmd[3] = {"su", "-", NULL};
  term = ZVT_TERM(current_term(p_term_list));
  
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  if (!wincfg->login_shell)
    cmd[1] = NULL;

  new_term_in_tab(cmd , cfg, NULL, 1, p_term_list, "Root", NULL, MGT_VERT_SPLIT);
}
void new_wroot(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  GtkWidget *app;
  struct win_config *wincfg;
  char* cmd;
  term = ZVT_TERM(current_term(p_term_list));
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  wincfg = gtk_object_get_data(GTK_OBJECT(app), "winconfig");
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  if (!wincfg->login_shell)
    cmd = "su";
  else
    cmd ="su -";

  vt_new_window(term, "Root", " ", cmd, NULL, NULL);
}
void new_hmc(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  char* cmd[3] = {"mc", "-x", NULL};
  /*last = g_slist_last(*p_term_list);*/
  term = ZVT_TERM(current_term(p_term_list));

  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  new_term_in_tab(cmd , cfg, NULL, 1, p_term_list, "Root", NULL, MGT_HORIZ_SPLIT);
}
void new_vmc(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  char* cmd[3] = {"mc", "-x", NULL};
  term = ZVT_TERM(current_term(p_term_list));

  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  new_term_in_tab(cmd , cfg, NULL, 1, p_term_list, "Root", NULL, MGT_VERT_SPLIT);
}
void new_wmc(GSList** p_term_list, guint action)
{
  ZvtTerm* term;
  term = ZVT_TERM(current_term(p_term_list));
  vt_new_window(term, "mc", " ", "mc", NULL, NULL);
}

void new_shell_vappend(GSList** p_term_list, guint action)
{
  struct terminal_config *cfg;
  ZvtTerm* term;
  term = ZVT_TERM(current_term(p_term_list));
   
  cfg = gtk_object_get_data (GTK_OBJECT (term), "config");
  new_term_in_tab(NULL , cfg, NULL, 1, p_term_list, "Shell", NULL, MGT_VERT_SPLIT);
}
extern struct terminal_config * load_config (char *class);
extern char *initial_global_geometry;

void mgt_do_resize(GtkWidget*app)
{
  IRES(app);
  gtk_widget_queue_resize(app);
  QRES(app);
}
void vt_tnext(ZvtTerm* term)
{
  GtkWidget* tab, *focusterm, *app, *actterm;
  GSList** tab_terms, *tl, **ptl;

  if (!ZVT_IS_TERM(term))
    return;
   if (!(app = gtk_object_get_data(GTK_OBJECT(term), "cl_last_app")))
    app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  
  if (!app)
    return;
    
  ptl  = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (!ptl)
    return;
    
  actterm = GTK_WIDGET(current_term(ptl));
  tab = gtk_object_get_data(GTK_OBJECT(actterm), "tab");
  if (!tab)
    return;
  tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
  if (!tab_terms)
    return;
  tl = g_slist_find(*tab_terms, actterm);
  if (!tl)
    return;
  if (tl->next)
	focusterm = GTK_WIDGET(tl->next->data);
  else
    focusterm = GTK_WIDGET(g_slist_nth_data(*tab_terms, 0));
  if (GTK_WIDGET_DRAWABLE(focusterm))
    gtk_widget_grab_focus(focusterm);
  gtk_object_set_data(GTK_OBJECT(tab), "active", focusterm);
}
void vt_tprev(ZvtTerm* term)
{
  GtkWidget* tab, *focusterm, *app, *actterm;
  GSList** tab_terms, **ptl;
  int ti, llen;

  if (!ZVT_IS_TERM(term))
    return;
    
  if (!(app = gtk_object_get_data(GTK_OBJECT(term), "cl_last_app")))
    app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  if (!app)
    return;
  ptl  = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (!ptl)
    return;
  actterm = GTK_WIDGET(current_term(ptl));
  tab = gtk_object_get_data(GTK_OBJECT(actterm), "tab");
  tab_terms = gtk_object_get_data(GTK_OBJECT(tab), "tab_terms");
  ti = g_slist_index(*tab_terms, actterm);
  llen = g_slist_length(*tab_terms);
  if (ti==-1)
    return;
  if (ti-1 >= 0)
    focusterm = GTK_WIDGET(g_slist_nth_data(*tab_terms, ti-1));
  else
    focusterm = GTK_WIDGET(g_slist_nth_data(*tab_terms, llen-1));
  if (GTK_WIDGET_DRAWABLE(focusterm))
    gtk_widget_grab_focus(focusterm);
  gtk_object_set_data(GTK_OBJECT(tab), "active", focusterm);
}
extern struct win_config * 
load_winconfig (char *class);

extern GtkWidget* load_tabs(gchar *prefix, 
		     char **cmd, struct terminal_config *cfg, 
		     struct win_config *wincfg, 
		     const gchar *geometry, int termid);

GtkWidget* vt_new_window_wt(ZvtTerm* term, char *name, char *path, char *cmd, 
			    char *tclass, char *wclass)
{
  GtkWidget* app;
  char **ncmd;
  struct terminal_config* cfg;
  struct win_config *wincfg;
  char *prefix;

  if (!ZVT_IS_TERM(term))
    return NULL;
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  if (!app)
    return NULL;
    
  if (tclass && strcmp(tclass," "))
    {
      prefix = g_strdup_printf("/MultiTerminal/%s/", tclass);
      gnome_config_push_prefix(prefix);
      cfg = load_config(tclass);
      gnome_config_pop_prefix();
    }
  else 
    {
      cfg = terminal_config_dup(gtk_object_get_data (GTK_OBJECT (term), "config"));
    }
  if (wclass && strcmp(wclass," "))
    {
      prefix = g_strdup_printf("/MultiTerminal/%s/", wclass);
      gnome_config_push_prefix(prefix);
      wincfg = load_winconfig(wclass);
      gnome_config_pop_prefix();
    }
  else 
    {
      wincfg = win_config_dup(gtk_object_get_data(GTK_OBJECT(app), "winconfig"));
    }
      
  if (cmd && strcmp(cmd," ") && strlen(cmd)>0)
    ncmd = g_strsplit(cmd, " ", 0);
  else
    ncmd = NULL;
  
  prefix = g_strdup_printf("/MultiTerminal/%s/", wincfg->class);
  app = load_tabs(prefix, ncmd, cfg, wincfg,
		  (initial_global_geometry)
		    ? initial_global_geometry : "80x24", 1);
  g_free(prefix);
  if (ncmd)
    g_strfreev(ncmd);
  /* set toggle items */
  if (!wincfg->menubar_hidden) 
    toggle_app_items(GTK_WIDGET(app), wincfg);

  /*do_allocate(app);*/
  gtk_flush_all_events();
  terminal_config_free(cfg);
  win_config_free(wincfg);
  return app;
}


GtkWidget* vt_new_window(ZvtTerm* term, char *name, char *path, char *cmd, char* tclass,
			 char *wclass)
{
  GtkWidget* app;
  char **ncmd, **su_names, **su_cmds, **su_paths, **su_classes;
  struct terminal_config* cfg;
  struct win_config *wincfg; 
  char *prefix;
  int num_su, num_su2;

  if (!ZVT_IS_TERM(term))
    return NULL;
  app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  if (!app)
    return NULL;
    
  if (tclass && strcmp(tclass," "))
    {
      prefix = g_strdup_printf("/MultiTerminal/%s/", tclass);
      gnome_config_push_prefix(prefix);
      cfg = load_config(tclass);
      gnome_config_pop_prefix();
      g_free(prefix);
    }
  else 
    {
      cfg = terminal_config_dup(gtk_object_get_data (GTK_OBJECT (term), "config"));
    }

  if (wclass && strcmp(wclass," "))
    {
      prefix = g_strdup_printf("/MultiTerminal/%s/", wclass);
      gnome_config_push_prefix(prefix);
      wincfg = load_winconfig(wclass);
      gnome_config_get_vector("su_cmds", &num_su2, &su_cmds);
      gnome_config_get_vector("su_names", &num_su, &su_names);
      gnome_config_get_vector("su_paths", &num_su2, &su_paths); 
      gnome_config_get_vector("su_classes", &num_su2, &su_classes);
      safe_cmd_vector(&su_names, &su_paths, &su_cmds, &su_classes, num_su);
      gnome_config_pop_prefix();
    }
  else 
    {
      wincfg = win_config_dup(gtk_object_get_data(GTK_OBJECT(app), "winconfig"));
      su_cmds = gtk_object_get_data(GTK_OBJECT(app), "su_cmds");  
      su_names = gtk_object_get_data(GTK_OBJECT(app), "su_names");
      su_paths = gtk_object_get_data(GTK_OBJECT(app), "su_paths");
      su_classes = gtk_object_get_data(GTK_OBJECT(app), "su_classes");
    }

  if (cmd && strcmp(cmd," ") && strlen(cmd)>0)
    ncmd = g_strsplit(cmd, " ", 0);
  else
    ncmd = NULL;
  app = new_window(ncmd, cfg, wincfg, (initial_global_geometry)
		    ? initial_global_geometry : "80x24", 1, 
		   su_names, su_paths, su_cmds, su_classes,
		   name, (path==NULL||!strcmp(path," "))?NULL:path);
  if (ncmd)
    g_strfreev(ncmd);
  /* set toggle items */
  if (!wincfg->menubar_hidden) 
    toggle_app_items(GTK_WIDGET(app), wincfg);

  /*do_allocate(app);*/
  gtk_flush_all_events();
  terminal_config_free(cfg);
  win_config_free(wincfg);
  return app;
}


void vt_new_tab(ZvtTerm* term, char *name, char *path, char *cmd, char *tclass)
{
  struct terminal_config *cfg;
  GSList** ptl;
  char **ncmd, *prefix;
  GtkWidget* app, *nb;
  int aw, ah;
  
  if (!ZVT_IS_TERM(term))
    return;
   if (!(app = gtk_object_get_data(GTK_OBJECT(term), "cl_last_app")))
    app = gtk_widget_get_toplevel(GTK_WIDGET(term));

  if (!app)
    return;
  
    nb = gtk_object_get_data(GTK_OBJECT(app), "notebook"); 
  aw = app->allocation.width;
  ah = app->allocation.height; 
  ptl = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (!ptl)
    return;
  
  if (tclass && strcmp(tclass," "))
    {
      prefix = g_strdup_printf("/MultiTerminal/%s/", tclass);
      gnome_config_push_prefix(prefix);
      cfg = load_config(tclass);
      gnome_config_pop_prefix();
      g_free(prefix);
    }
  else 
    {
      cfg = terminal_config_dup(gtk_object_get_data (GTK_OBJECT (term), "config"));
    }

  if (strcmp(cmd," ") && strlen(cmd) > 0)
    ncmd = g_strsplit(cmd, " ", 0);
  else
    ncmd = NULL;
  
  new_term_in_window(ncmd, cfg, 
		   NULL, 1, ptl, name,
		   (path==NULL||!strcmp(path," "))?NULL:path);
  if (ncmd)
    g_strfreev(ncmd);
#if 0
  IRES(nb);
  gtk_widget_set_usize(app, aw, ah);
  QRES(nb);
#else
  mgt_do_resize(nb);
  /*gtk_widget_set_usize(app, aw, ah);*/
#endif
}


void vt_hsplit(ZvtTerm *term, char *name, char *path, char *cmd)
{
  struct terminal_config *cfg;
  GtkWidget* app, *nb;
  char **ncmd;
  int aw, ah;
  GSList **ptl;
  if (!ZVT_IS_TERM(term))
    return;
   if (!(app = gtk_object_get_data(GTK_OBJECT(term), "cl_last_app")))
    app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  
  if (!app)
    return;
  ptl  = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (!ptl)
    return;
  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook"); 
  if (strcmp(cmd," ") && strlen(cmd) > 0)
    ncmd = g_strsplit(cmd, " ", 0);
  else
    ncmd = NULL;
   
  cfg = gtk_object_get_data (GTK_OBJECT ((*ptl)->data), "config");
  if (!cfg)
    return;
  aw = app->allocation.width;
  ah = app->allocation.height; 
  new_term_in_tab(ncmd , cfg, NULL, 1, ptl, name, (path==NULL||!strcmp(path," "))?NULL:path, MGT_HORIZ_SPLIT);
#if 0
  IRES(nb);
  gtk_widget_set_usize(app, aw, ah);
  QRES(nb);
#else  
  mgt_do_resize(nb);
  /*gtk_widget_set_usize(app, aw, ah);*/
#endif
/*gtk_flush_all_events();*/
}

void vt_vsplit(ZvtTerm *term, char *name, char *path, char *cmd)
{
  struct terminal_config *cfg;
  GtkWidget* app, *nb;
  int aw, ah;
  char **ncmd;
  GSList **ptl;
  if (!ZVT_IS_TERM(term))
    return;
   if (!(app = gtk_object_get_data(GTK_OBJECT(term), "cl_last_app")))
    app = gtk_widget_get_toplevel(GTK_WIDGET(term));
  if (!app)
    return;

  ptl  = gtk_object_get_data(GTK_OBJECT(app), "ptermlist");
  if (!ptl)
    return;

  nb = gtk_object_get_data(GTK_OBJECT(app), "notebook"); 
  if (strcmp(cmd," ") && strlen(cmd) > 0)
    ncmd = g_strsplit(cmd, " ", 0);
  else
    ncmd = NULL;
   
  cfg = gtk_object_get_data (GTK_OBJECT ((*ptl)->data), "config");
  if (!cfg)
    return;
  aw = app->allocation.width;
  ah = app->allocation.height; 
  new_term_in_tab(ncmd , cfg, NULL, 1, ptl, name, (path==NULL||!strcmp(path," "))?NULL:path, MGT_VERT_SPLIT);
#if 0
  IRES(nb);
  gtk_widget_set_usize(app, aw, ah);
  QRES(nb);
#else
  mgt_do_resize(nb);
  /*gtk_flush_all_events();*/
  /*gtk_widget_set_usize(app, aw, ah);*/
#endif
  /*gtk_flush_all_events();*/
}
