//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: alsaaudio.h,v 1.1.1.1 2003/10/29 10:06:12 wschweer Exp $
//  (C) Copyright 2002 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __ALSAAUDIO_H__
#define __ALSAAUDIO_H__

#include <alsa/asoundlib.h>
#include "audiodev.h"
#include "thread.h"

//---------------------------------------------------------
//   AlsaAudioDevice
//---------------------------------------------------------

class AlsaAudioDevice : public AudioDevice, public Thread {
      struct AlsaPort {
            int card, dev;
            int flags;
            QString name;
            AlsaPort(int c, int d, const QString& s, int f) {
                  card = c;
                  dev  = d;
                  name = s;
                  flags = f;
                  }
            };
      std::list<AlsaPort*> portList;

      snd_pcm_t* captureHandle;
      snd_pcm_t* playbackHandle;
      snd_pcm_sframes_t samplesWritten;

      int inPorts;
      int outPorts;
      float** readBuffer;
      virtual void threadStart(void*);

   public:
      AlsaAudioDevice();
      virtual ~AlsaAudioDevice();

      void readCallback();

      bool init();
      virtual void read(int, unsigned long, float**);
      virtual void write(int, unsigned long, float**);
      virtual void start();
      virtual void stop ();
      virtual void activate(bool);
      virtual int curPlayPos() const;

      virtual std::list<QString> outputPorts();
      virtual std::list<QString> inputPorts();

      virtual void setInputPort(const QString&);
      virtual void setOutputPort(const QString&);
      };

extern AlsaAudioDevice* alsaAudioDevice;

#endif

