//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: seq.h,v 1.1.1.1 2003/10/29 10:05:00 wschweer Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SEQ_H__
#define __SEQ_H__

#include <qobject.h>
#include <pthread.h>
#include <qstring.h>
#include <unistd.h>
#include "mtc.h"
#include "value.h"
#include "tempo.h"

class Xml;
class AudioPort;
class EventList;
class SEventList;
class MidiEvent;

class SndFile;

//---------------------------------------------------------
//   Sequencer
//---------------------------------------------------------

class Sequencer : public QObject {
      // recording values
      int recStartTick;
      int nextClick;

      Q_OBJECT;
      void loadConfigMetronom(Xml& xml);
      void readConfigAudioPort(Xml& xml);
      void readConfigAudioGroup(Xml& xml);
      void readConfigAudioMaster(Xml& xml);
      void readConfigAudioInput(Xml& xml);
      void readConfigMidiPort(Xml& xml);
      void readMixdown(Xml& xml);
      bool notify();
      pthread_t watchdogThread;

   public:
      Sequencer();
      ~Sequencer();

      void start();
      void stop();
      bool isRunning();

      void writeConfiguration(int, Xml&);
      void readConfiguration(Xml&);
      };
extern Sequencer* seq;
extern Sequencer* seq;
#endif

