/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 messages.cpp  -  Message functions for mutella client, for message events.
 
    begin                : Mon Jan 28 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/
 
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
#include "messages.h"

CString GetMessageString(int nMessageID)
{
	switch (nMessageID)
	{
		case MSG_DOWNLOAD_COMPLETED: return "Download completed";
		case MSG_DOWNLOAD_FILE_MOVE_FAILED: return "Failed to move completed file to the download directory";
		case MSG_DOWNLOAD_FILE_MOVED: return "Successfuly moved completed file to the download directory";
		case MSG_DOWNLOAD_FILE_ERROR: return "File error in download";
		case MSG_DOWNLOAD_FILE_MISSMATCH: return "Remote file and local part do not match, ignoring the host";
		case MSG_DOWNLOAD_STORAGE_DENIED: return "File storage denied";
		case MSG_DOWNLOAD_STORE_WHILE_CLOSE_FAILED: return "Storing data while closing the transfer failed";
		case MSG_SHARE_SCANNED: return "Finished scanning shared directories";
		case MSG_AUTOGET: return "Auto-getting file";
		case MSG_DOWNLOAD_TO_AUTOGET: return "Downloading failed, adding auto-get search";
		case MSG_FAILED_TO_LISTEN: return "Failed to switch socket to the listen mode";
		case MSG_FAILED_TO_CREATE_LISTEN_SOCKET: return "Failed to create a listening socket";
	}
	CString s;
	s.format("Unknown message with ID = %d", nMessageID);
	return s;
}

