// graph.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Base class for objects representing the area of window upon which the graph
// lines representing the waveform or values of the associated Data object.
// At least one instance of its subclasses is contained within each DataView
// subclass instance.

#ifndef GRAPH_H
#ifdef __GNUG__
#pragma interface
#endif
#define GRAPH_H

#include "scaledarea.h"

class Perspective;
class Controller;
class Data;
class Scale;
class Range;

const int defaultGraphWidth = 500;
const int defaultGraphHeight = 100;

class Graph : public ScaledArea {
	typedef ScaledArea Super;
public:
	Graph(Controller *c, Data *data, const Range& vertRange);
	virtual ~Graph();
	// redefined methods
	redefined void Reconfig();
	redefined void Adjust(Perspective &);
	redefined void Handle(Event &);
	redefined void Update();
	// new methods
	virtual boolean handleEvent(Event &);
	virtual void setInsertPoint(int)=0;
	virtual void setEditRegion(const Range&)=0;
	virtual const char* getTitle();
	virtual const char* verticalScaleLabel()=0;
	virtual boolean selected() { return false; }
	virtual void togglePlotMode() {}
	virtual void unSelect()=0;
	void setReferenceRange(const Range &r) {	// to avoid hiding
		Super::setReferenceRange(r);
	}
protected:
	// redefined InterViews methods
	redefined void Resize();

	redefined void doAdjust();
	// new to this subclass
	virtual void select()=0;
	virtual void selectAll()=0;
	virtual void selectAllVisible()=0;
	virtual void grab(Event &)=0;
	virtual void track(Event &)=0;
	virtual void processKeyEvent(Event &)=0;
	virtual void setInsertCoord(Coord loc=0) {}
	virtual void setRegionCoords(const Range &) {}
	virtual void displayDataValue(boolean) {}
	virtual boolean isConfigured() { return configured; }
	virtual boolean isViewChanged(Perspective &np)=0;
	virtual void setViewPerspective(Perspective *p);
	virtual void checkViewPerspective();
	virtual void setReferenceRange()=0;
	virtual void setShape() {}
protected:
	friend class DataView;
	Data *graphData;			// pointer to associated data
	Perspective* view;			// pointer to master perspective
	Controller *controller;		// data - view coordinator
	boolean viewIsChanged;
	boolean configured;			// set to true after Reconfig()
private:
	void Init();
	// these next are always redefined by the graph subclasses
	virtual void doResize()=0;
	virtual void createPlot()=0;
	virtual void loadPlot()=0;
	virtual void doPlot()=0;
};

#endif
