// proport_dac.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Converter subclass for the S56X DSP device driver

#ifndef PROPORT_DAC_H
#ifdef __GNUG__
#pragma interface
#endif
#define PROPORT_DAC_H

#include "converter.h"

struct drp;
typedef struct drp Drp;

class ProportConverter : public RealConverter {
	typedef RealConverter Super;
public:
	ProportConverter();
	virtual ~ProportConverter();
	redefined int stop();
	redefined DataType bestPlayableType() { return ShortData; }
protected:
	redefined boolean isPlayableFormat(enum DataType);
	redefined int checkSampleRate(int rate);
	redefined int checkChannels(int chans);
	redefined int doConfigure();
	redefined int doConversion(ProgressAction* askedToStop);
	redefined int doRecording(ProgressAction* askedToStop);
	redefined void fail();
private:
	boolean initialize();
	void close();
	int bufferSize() { return 16384; }
private:
	Drp* drp;
};

#endif
