/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc.h 
 * @brief Base configuration header. Here most of the platform specific switches are kept.
 * 
 */

#ifndef __GC_H__
#define __GC_H__

#ifdef _WINDOWS
  #define  WIN32_LEAN_AND_MEAN
  #include <windows.h>

  #ifdef MAKEDLL
    #define GENERIC_CANVAS_API  __declspec(dllexport)
  #else
    #define GENERIC_CANVAS_API  __declspec(dllimport)
  #endif

  #pragma warning(disable: 4251) // Disable warning about DLL interface for template classes.

  #include <GL/gl.h>
  #include <GL/glu.h>
#else
  #define GENERIC_CANVAS_API 
  #define __cdecl

#ifdef __APPLE__
    #include <OpenGL/gl.h>
    #include <OpenGL/glu.h>
  #else
    #include <GL/gl.h>
    #include <GL/glu.h>
    #include <GL/glx.h>
#endif
#endif // #fidef _WINDOWS

#define _USE_MATH_DEFINES
#include <math.h>

#endif // #ifndef __GC_H__