/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef myx_grt_gc_h
#define myx_grt_gc_h

#include <myx_public_interface.h>
#include <myx_grt_public_interface.h>
#include <myx_grt_private.h>
#include <myx_grt_gc_public_interface.h>

#define DBUG(msg) if (getenv("DEBUG_GRT_GC")) g_message("%s", msg)

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Module Functions
 */

MYX_GRT_VALUE *grt_gc_value_get(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *grt_gc_value_set(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *grt_gc_list_size(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *grt_gc_list_item_get(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *grt_gc_list_item_add(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *grt_gc_list_item_remove(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *grt_gc_dict_item_get(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *grt_gc_dict_item_set(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *grt_gc_dict_item_count(MYX_GRT_VALUE *param, void *data);
MYX_GRT_VALUE *grt_gc_dict_item_key(MYX_GRT_VALUE *param, void *data);

/*
 * Structs and Enums
 */

static MYX_GRT_BUILTIN_FUNCTION functions_grt_gc_bridge[]= {
  {"_valueGet::", grt_gc_value_get },
  {"_valueSet::", grt_gc_value_set },
  {"_listSize::", grt_gc_list_size },
  {"_listItemGet::", grt_gc_list_item_get },
  {"_listItemAdd::", grt_gc_list_item_add },
  {"_listItemRemove::", grt_gc_list_item_remove },
  {"_dictItemGet::", grt_gc_dict_item_get },
  {"_dictItemSet::", grt_gc_dict_item_set },
  {"_dictItemCount::", grt_gc_dict_item_count },
  {"_dictItemKey::", grt_gc_dict_item_key },
};

static MYX_GRT_BUILTIN_MODULE grt_module_grt_gc= {
  "_GrtGcBridge",
  NULL,
  sizeof(functions_grt_gc_bridge)/sizeof(MYX_GRT_BUILTIN_FUNCTION),
  functions_grt_gc_bridge
};


/*
 * Functions
 */

#ifdef __cplusplus
}
#endif

//----------------------------------------------------------------------------------------------------------------------

/** 
 * This mapper contains a list of generic canvases associated with their paths in a generic runtime environment. 
 * The path string is utf-8 encoded.
 */
typedef hash_map<string, CGenericCanvas*> CCanvasMap;

/**
 * The GRT-to-GC bridge is a helper class to connect the runtime with one or more generic canvases.
 */
class CGrtToGcBridge
{
private:
  MYX_GRT* FRuntime;
  MYX_GRT_MODULE* FModule;
  CCanvasMap FCanvasMap;
public:
  CGrtToGcBridge(MYX_GRT* Runtime);

  void AddCanvas(const char* Path, CGenericCanvas* Canvas);
  void Module(MYX_GRT_MODULE* AModule);
  MYX_GRT_MODULE* Module(void) { return FModule; };
  void RemoveCanvas(const char* Path);
};

//----------------------------------------------------------------------------------------------------------------------

#endif
