package com.mysql.grt;

public class GrtCallbackNative implements GrtCallback {

	public void setApplicationPath(String applicationPath) {

		if (System.getProperty("os.name").indexOf("Windows") > -1) {
			//Debug
			System.load(applicationPath + "msvcr71d.dll");
			//Release
			//System.load(applicationPath + "msvcr71.dll");

			System.load(applicationPath + "iconv.dll");
			System.load(applicationPath + "intl.dll");
			System.load(applicationPath + "zlib.dll");
			System.load(applicationPath + "libglib-2.0-0.dll");
			System.load(applicationPath + "libgmodule-2.0-0.dll");
			System.load(applicationPath + "libgobject-2.0-0.dll");
			System.load(applicationPath + "libgthread-2.0-0.dll");
			System.load(applicationPath + "libxml2.dll");
			System.load(applicationPath + "libmysql.dll");
			System.load(applicationPath + "libmysqlx.dll");
			System.load(applicationPath + "libmysqlgrt.dll");
			System.load(applicationPath + "libmysqlgrtbuiltinmodule.dll");
		} else if (System.getProperty("os.name").indexOf("Linux") > -1) {
			System.load("/usr/lib/libmysqlclient.so");
			System.load("/usr/lib/libglib-2.0.so");

			System.load(applicationPath + "myx_grt_java.so");
		}
	}

	/**
	 * Calls a GRT function from the given module
	 * 
	 * @param myx_grt_pointer
	 *            pointer (casted as long) that points to the native grt
	 *            instance
	 * @param module
	 *            name of the module that implements the function
	 * @param name
	 *            name of the function to call
	 * @param params
	 *            parameters that should be passed to the function as grt XML
	 *            string
	 */
	public native String callGrtFunction(long myx_grt_pointer, String module,
			String functionName, String arguments);

	public native Object getGrtGlobalById(long myx_grt_pointer, String id);

	public native Object getGrtGlobalAsObject(long myx_grt_pointer,
			String objectPath);

	public native String getGrtGlobalAsString(long myx_grt_pointer,
			String objectPath);

	public native int getGrtGlobalAsInt(long myx_grt_pointer, String objectPath);

	public native double getGrtGlobalAsReal(long myx_grt_pointer,
			String objectPath);

	public native void setGrtGlobalFromObject(long myx_grt_pointer,
			String objectPath, Object value);

	public native void setGrtGlobalFromString(long myx_grt_pointer,
			String objectPath, String value);

	public native void setGrtGlobalFromInt(long myx_grt_pointer,
			String objectPath, int value);

	public native void setGrtGlobalFromReal(long myx_grt_pointer,
			String objectPath, double value);

	public native int getGrtGlobalListSize(long myx_grt_pointer,
			String objectPath);

	public native Object getGrtGlobalListItem(long myx_grt_pointer,
			String objectPath, int index);

	public native void addGrtGlobalListItem(long myx_grt_pointer,
			String objectPath, Object item);

	public native void removeGrtGlobalListItem(long myx_grt_pointer,
			String objectPath, int index);

	public native Object getGrtGlobalDictItem(long myx_grt_pointer,
			String objectPath, String key);

	public native void addGrtGlobalDictItem(long myx_grt_pointer,
			String objectPath, String key, Object value);

	public native void removeGrtGlobalDictItem(long myx_grt_pointer,
			String objectPath, String key);

	public native int processMessages(long myx_grt_pointer, String msgs);
}