/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_gl_helper.h 
 * @brief Helper functions for creating OpenGL data and structures out of XML data.
 * 
 */

#ifndef __GC_GL_HELPER_H__
#define __GC_GL_HELPER_H__

#include <string>

using namespace std;

#define EPSILON 1E-6    // The distance two float values can have at most be still considered as being the same.

// Find a color by name.
bool ColorByName(string Name, GLubyte* Color);

// Find the given primitive and return its index in the Primitives array (for use e.g. in switch statements).
int FindPrimitive(xmlChar* Name);

// Reads the attribute with the given name (if it exists) and converts it to a float value.
bool GetFloatAttribute(xmlNodePtr Element, const char* Name, double& Value);

// Reads the attribute with the given name and treats it as color value.
bool ConvertColor(xmlNodePtr Element, const char* Name, const char* OpacityName, GLubyte* Color);

// Parses the given XML element for SVG drawing commands.
GLuint ReadTemplateDefinition(xmlNodePtr XML);

// Parses the given XML element for a font definition.
void ParseFontEntry(xmlNodePtr XML);

// Parses the given XML element for a texture definition.
void ParseTextureEntry(xmlNodePtr XML);

#endif // __GC_GL_HELPER_H__