/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _NET_NNTP_CLIENT_H_
#define _NET_NNTP_CLIENT_H_

#ifdef __cplusplus
extern "C" {
#endif

#if defined(__WIN__) || defined(_WIN32) || defined(_WIN64)
#define MYX_PUBLIC_FUNC __declspec(dllexport)
#else
#define MYX_PUBLIC_FUNC
#endif

#include "net_line_client.h"


/*
 * PUBLIC INTERFACE definition for MYSQLLibInterfaceMapper
 */

// PUBLIC_INTERFACE "libmysqlxnet"
#define libmysqlxnet_PUBLIC_INTERFACE_VERSION 1

  
typedef enum {
  MNNTPNoError=0,
  MNNTPOutOfMemory,
  MNNTPTimeoutError,
  MNNTPResolveError,
  MNNTPConnectError,
  MNNTPAuthError,
  MNNTPProtocolError,
  MNNTPBadIDError,
  MNNTPNetError
} MNNTPError;
  
/*
 * Structs
 */

// LibInterfachMapper generates classes for MNNTPArticleBody
typedef struct {
  unsigned int index;
  char *msg_id;
  unsigned int lines_num;
  char **lines;
} MNNTPArticleBody;

// LibInterfachMapper generates classes for MNNTPArticleHeader
typedef struct {
  unsigned int index;
  char *msg_id;
  unsigned int lines_num;
  char **lines;
} MNNTPArticleHeader;


// LibInterfachMapper generates classes for MNNTPArticleInfo
typedef struct {
  unsigned int index;
  char *msg_id;
  char *subject;
  char *from;
  char *date;
  char *references;
} MNNTPArticleInfo;
  
  
// LibInterfachMapper generates classes for MNNTPGroupIndex
typedef struct {
  unsigned int articles_num;
  MNNTPArticleInfo *articles;
} MNNTPGroupIndex;


// LibInterfachMapper generates classes for MNNTPGroup
typedef struct {
  char *name;
  char *description;
  unsigned int first;
  unsigned int last;
  unsigned int can_post;
} MNNTPGroup;

// LibInterfachMapper generates classes for MNNTPGroups
typedef struct MNNTPGroups {
  unsigned int groups_num;
  MNNTPGroup *groups;
} MNNTPGroups;


// LibInterfachMapper generates classes for MNetNNTPClient
typedef struct {
  MNetLineClient *client;
  unsigned int can_post;
  
  char *username;
  char *password;
  
  unsigned int timeout; /* in milliseconds */
} MNetNNTPClient;


/*
 * Functions
 */


MYX_PUBLIC_FUNC MNetNNTPClient * mnet_init_nntp(int use_ssl);

MYX_PUBLIC_FUNC MNNTPError mnet_nntp_connect(MNetNNTPClient *client, const char *host, int port);

MYX_PUBLIC_FUNC void mnet_nntp_set_auth_info(MNetNNTPClient *client, 
                                             const char *username,
                                             const char *password);

MYX_PUBLIC_FUNC MNNTPError mnet_nntp_disconnect(MNetNNTPClient *client);

MYX_PUBLIC_FUNC MNNTPGroups * mnet_nntp_list_groups(MNetNNTPClient *client, MNNTPError *error);
MYX_PUBLIC_FUNC int mnet_free_group_list(MNNTPGroups *groups);

MYX_PUBLIC_FUNC MNNTPGroupIndex *mnet_nntp_list_articles(MNetNNTPClient *client,
                                                         const char *group, 
                                                         unsigned int first, 
                                                         unsigned int last,
                                                         MNNTPError *error);
MYX_PUBLIC_FUNC int mnet_free_group_index(MNNTPGroupIndex *index);

MYX_PUBLIC_FUNC MNNTPArticleHeader *mnet_nntp_get_header(MNetNNTPClient *client,
                                                       const char *group,
                                                       unsigned int id,
                                                       MNNTPError *error);
MYX_PUBLIC_FUNC int mnet_free_article_header(MNNTPArticleHeader *header);

MYX_PUBLIC_FUNC MNNTPArticleBody *mnet_nntp_get_article(MNetNNTPClient *client,
                                                         const char *group,
                                                         unsigned int id,
                                                         MNNTPError *error);
MYX_PUBLIC_FUNC int mnet_free_article_body(MNNTPArticleBody *body);

MYX_PUBLIC_FUNC MNNTPError mnet_nntp_post_article(MNetNNTPClient *client,
                                                  const char *article);


#ifdef __cplusplus
}
#endif

#endif /* _NET_NNTP_CLIENT_H_ */
