program GrtBindingWizard;

uses
  Forms,
  Main in 'Main.pas' {MainForm},
  AuxFuncs in '..\AuxFuncs',
  TntSysUtils in '..\TNT\TntSysUtils.pas',
  SysUtils,
  Windows;

{$R *.res}

var
  JavaDevKitHome,
    JavaDevKitRuntimeLibPath,
    JavaHome,
    RuntimeLibPath,
    Path: WideString;
  JavaDevKitHomeFound,
    JavaDevKitRuntimeLibPathFound,
    JavaHomeFound,
    RuntimeLibFound,
    PathModified,
    JavaIsOk,
    QuietOnSuccess: Boolean;


begin
  Application.Initialize;
  Application.Title := 'MySQL GRT Binding Wizard';

  QuietOnSuccess := False;
  JavaIsOk := False;

  if (ParamCount>=1) then
    if (WideSameText(Paramstr(1), 'QuietOnSuccess')) then
      QuietOnSuccess := True;

  // Check SDK
  JavaDevKitHome := WideExcludeTrailingBackslash(
    ReadFromReg(HKEY_LOCAL_MACHINE,
    'SOFTWARE\JavaSoft\Java Development Kit\1.4', 'JavaHome',
    0, '', False));

  if (JavaDevKitHome<>'') then
  begin
    JavaDevKitRuntimeLibPath :=
      WideIncludeTrailingBackslash(JavaDevKitHome) +
      'jre\bin\client\';

    if (WideFileExists(JavaDevKitRuntimeLibPath + 'jvm.dll')) then
      JavaDevKitRuntimeLibPath :=
        WideExcludeTrailingBackslash(JavaDevKitRuntimeLibPath)
    else
      JavaDevKitRuntimeLibPath := '';
  end;

  // Check JRE
  JavaHome := WideExcludeTrailingBackslash(
    ReadFromReg(HKEY_LOCAL_MACHINE,
    'SOFTWARE\JavaSoft\Java Runtime Environment\1.4', 'JavaHome',
    0, '', False));

  RuntimeLibPath := WideExtractFilePath(
    ReadFromReg(HKEY_LOCAL_MACHINE,
      'SOFTWARE\JavaSoft\Java Runtime Environment\1.4', 'RuntimeLib',
      0, '', False));


  // If something is found, check if the paths are in the system path
  if ((JavaDevKitHome <> '') or (JavaHome <> '')) and
    ((JavaDevKitRuntimeLibPath <> '') or (RuntimeLibPath <> '')) then
  begin
    // Get system path
    Path := GetGlobalEnvironment('path', False);

    PathModified := False;

    JavaDevKitHomeFound :=
      (Pos(Tnt_WideUpperCase(JavaDevKitHome + '\bin'),
      Tnt_WideUpperCase(Path)) > 0);

    JavaDevKitRuntimeLibPathFound :=
      (Pos(Tnt_WideUpperCase(JavaDevKitRuntimeLibPath),
      Tnt_WideUpperCase(Path)) > 0);

    JavaHomeFound :=
      (Pos(Tnt_WideUpperCase(JavaHome + '\bin'),
      Tnt_WideUpperCase(Path)) > 0);

    RuntimeLibFound :=
      (Pos(Tnt_WideUpperCase(RuntimeLibPath),
      Tnt_WideUpperCase(Path)) > 0);


    if ((Not(JavaDevKitHomeFound)) and
      (Not(JavaHomeFound))) then
    begin
      if (Copy(Path, Length(Path), 1)<>';')then
        Path := Path + ';';

      if (JavaDevKitHome<>'') then
        Path := Path + JavaDevKitHome + '\bin'
      else
        Path := Path + JavaHome + '\bin';

      PathModified := True;
    end;

    if ((Not(JavaDevKitRuntimeLibPathFound)) and
      (Not(RuntimeLibFound))) then
    begin
      if (Copy(Path, Length(Path), 1)<>';')then
        Path := Path + ';';

      if (JavaDevKitRuntimeLibPath<>'') then
        Path := Path + JavaDevKitRuntimeLibPath
      else
        Path := Path + RuntimeLibPath;

      PathModified := True;
    end;

    if (PathModified) then
      SetGlobalEnvironment('path', Path, False);

    JavaIsOk := True;
  end;

  if (Not(QuietOnSuccess)) then
  begin
    Application.CreateForm(TMainForm, MainForm);

    if (JavaIsOk) then
    begin
      MainForm.TitelLbl.Caption :=
        'Java 1.4.2 Installation Verified';
      MainForm.InfoLbl.Caption :=
        'The Java 1.4.2 Runtime Environment was found and the ' +
        'appropriate directories are in the system path variable. '+
        'It is now safe to run your target application.';
    end;

    Application.Run;
  end;
end.
