<?php
# $Id: exporter.php,v 1.3 2002/06/28 10:06:08 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","exporter");
define("PAGE_TITLE","Exporter");

require_once("local.inc");
include_once(NGT_LIB."head.inc");

if( !isset($action) ) $action = "";

if( $action == "exportobjects" ) {

	print "<p>Exporting objects</p>\n";

	if( $errmsg = PluginNagiosWriteObjects() ) {
		print "Problem: ".$errmsg;
	} else {
		print "Done.";
	}

	exit();

} else if( $action == "exportconfig" ) {

	print "<p>Exporting configuration:</p>\n";

	foreach( $NAGIOS_CFGFILES as $fileid => $filename ) {
		print "<li> Writing file $filename.. ";
		if( $errmsg = PluginNagiosWriteConfig($fileid) ) {
			print $errmsg;
		} else {
			print "Done.";
		}
		print "<br>\n";
		flush();
	}

	exit();

}

?>
<br><br><br>
<table border="0">
<tr>
  <td>
  <form action="exporter.php" method="POST">
  <input type="submit" value="Export objects">
  <input type="hidden" name="action" value="exportobjects">
  </form>
  </td>
  <td>
  Saving the objects (hosts,services,contacts,..) to Nagios
  </td>
</tr>
<tr>
  <td>
  <form action="exporter.php" method="POST">
  <input type="submit" value="Export configuration">
  <input type="hidden" name="action" value="exportconfig">
  </form>
  </td>
  <td>
  Saving the configuration (nagios.cfg,CGI.cfg) to Nagios
  </td>
</tr>
</table>
<br><br><br>
<?
include_once(NGT_LIB."tail.inc");
?>
