#
# This script was written by Jeff Adams <jadams@netcentrics.com>
#
# See the Nessus Scripts License for details
#


if(description)
{
 script_id(12226);
 script_bugtraq_id(10257);
 script_version("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0431");
 
 name["english"] = "Quicktime player/plug-in Heap overflow";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using QuickTime, a popular media player/Plug-in
which handles many Media files.

This version has a Heap overflow which may allow an attacker
to execute arbitrary code on this host, with the rights of the user
running QuickTime.

More Info: http://eeye.com/html/Research/Advisories/AD20040502.html

Solution : Uninstall this software or upgrade to version 6.5.1 or higher.
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of QuickTime Player/Plug-in";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Jeff Adams");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_full_access.nasl");
		   
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/registry_full_access");


 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");
port = get_kb_item("SMB/transport");
if(!port)port = 139;


key = "SOFTWARE\Apple Computer, Inc.\Quicktime";
item = "Version";
version = registry_get_dword(key:key, item:item);
if(!version)exit(0);

if(version < 0x6518000)security_hole(port);


