
/*-------------------------------------------------------------*/
/* Unfortunately (Linux) :
     sizeof(struct sockaddr)==16 < sizeof(struct sockaddr_in6)==24
   So, a sockaddr cannot be used to store an IPv6 address.
   We define netwib_priv_sockaddr as an opaque structure sufficiently
   big to store every kind of address.
   Note : RFC2553 proposes struct sockaddr_storage, but it does
   not exists everywhere.
   We have 2 types to deal with "cast increases required
   alignment of target type" under Sparc processor.
*/
typedef struct {
  netwib_byte donotuse[32];
} netwib_priv_sockaddr;

/*-------------------------------------------------------------*/
netwib_err netwib_priv_sa_ipport_init_sali(const netwib_priv_sockaddr *psa,
                                           netwib_uint32 supposedsalen,
                                           netwib_iptype supposediptype,
                                           netwib_ip *pip,
                                           netwib_port *pport);
#define netwib_priv_sa_ipport_init_sal(psa,supposedsalen,pip,pport) netwib_priv_sa_ipport_init_sali(psa,supposedsalen,NETWIB_IPTYPE_UNKNOWN,pip,pport)
#define netwib_priv_sa_ipport_init_sai(psa,supposediptype,pip,pport) netwib_priv_sa_ipport_init_sali(psa,0xFFFFFFFFu,supposediptype,pip,pport)
#define netwib_priv_sa_ipport_init_sa(psa,pip,pport) netwib_priv_sa_ipport_init_sali(psa,0xFFFFFFFFu,NETWIB_IPTYPE_UNKNOWN,pip,pport)
#define netwib_priv_sa_ip_init_sali(psa,supposedsalen,supposediptype,pip) netwib_priv_sa_ipport_init_sali(psa,supposedsalen,supposediptype,pip,NULL)
#define netwib_priv_sa_ip_init_sal(psa,supposedsalen,pip) netwib_priv_sa_ipport_init_sal(psa,supposedsalen,pip,NULL)
#define netwib_priv_sa_ip_init_sai(psa,supposediptype,pip) netwib_priv_sa_ipport_init_sai(psa,supposediptype,pip,NULL)
#define netwib_priv_sa_ip_init_sa(psa,pip) netwib_priv_sa_ipport_init_sa(psa,pip,NULL)

/*-------------------------------------------------------------*/
/* note: if pip!=NULL, pip->iptype overwrites iptype */
netwib_err netwib_priv_sa_sal_init_iptport(netwib_constip *pip,
                                           netwib_iptype iptype,
                                           netwib_port port,
                                           netwib_priv_sockaddr *psa,
                                           netwib_uint32 *psalen);
/* use IPv4 by default to overwrite if pip is NULL */
#define netwib_priv_sa_sal_init_ipport(pip,port,psa,psalen) netwib_priv_sa_sal_init_iptport(pip,NETWIB_IPTYPE_IP4,port,psa,psalen)
#define netwib_priv_sa_sa_init_ip(pip,psa) netwib_priv_sa_sal_init_ipport(pip,0,psa,NULL)

/*-------------------------------------------------------------*/
netwib_err netwib_priv_sa_send(int fd,
                               netwib_constbuf *pbuf);
netwib_err netwib_priv_sa_sendto(int fd,
                                 netwib_constbuf *pbuf,
                                 const netwib_priv_sockaddr *psa,
                                 netwib_uint32 salen);

/*-------------------------------------------------------------*/
netwib_err netwib_priv_sa_recv(int fd,
                               netwib_buf *pbuf);
netwib_err netwib_priv_sa_recvfrom(int fd,
                                   netwib_buf *pbuf,
                                   netwib_priv_sockaddr *psa,
                                   netwib_uint32 *psalen);
