/* a led
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

*/

#ifndef LED_H
#define LED_H

#include <gdk/gdk.h>
#include <gtk/gtkwindow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_LED (led_get_type())
#define LED( obj ) (GTK_CHECK_CAST( (obj), TYPE_LED, Led ))
#define LED_CLASS( klass ) (GTK_CHECK_CLASS_CAST( (klass), TYPE_LED, LedClass ))
#define IS_LED( obj ) (GTK_CHECK_TYPE( (obj), TYPE_LED ))
#define IS_LED_CLASS( klass ) (GTK_CHECK_CLASS_TYPE( (klass), TYPE_LED ))

typedef enum {
	LED_NONE,
	LED_OFF,
	LED_RED,
	LED_GREEN,
	LED_BLUE,
	LED_CYAN,
	LED_MAGENTA,
	LED_YELLOW,
	LED_LAST
} LedColour;

typedef struct _Led {
	GtkPixmap pixmap;

	/* My instance vars.
	 */
	LedColour colour;		/* Current led colour */
	int type;			/* Pixmap set to use for drawing */
} Led;

typedef struct _LedClass {
	GtkPixmapClass parent_class;

	/* My methods.
	 */
} LedClass;

GtkType led_get_type( void );
GtkWidget *led_new( void );
void led_set_colour( Led *ld, LedColour colour );
void led_set_type( Led *ld, int type );

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* LED_H */
