/****************************************************************************/
/* |\   ======   /| **               MCL                ** |\   ======   /| */
/* |__\========/__| **       Masar Class Libraries      ** |__\========/__| */
/* |\            /| ** -------------------------------- ** |\            /| */
/* |  \        /  | **  Maurizio Sartori (c) 1998-2000  ** |  \        /  | */
/* |    \    /    | ** -------------------------------- ** |    \    /    | */
/* |    /=\/=\    | **            Written  by           ** |    /=\/=\    | */
/* |  /========\  | **     Maurizio Sartori 'masar'     ** |  /========\  | */
/* |/   ======   \| **     e-mail:  masar@libero.it     ** |/   ======   \| */
/****************************************************************************/
/*              This program comes with ABSOLUTELY NO WARRANTY              */
/*            for details refer to the GNU General Public License           */
/****************************************************************************/
/*\F $Id: adb.cpp,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $
*****************************************************************************/

static char Psz_RCS [] =
   "$Id: adb.cpp,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $";

/****************************************************************************/

#include <mcl/util/adb.hpp>

#define BUFFER_SIZE (1024)
#define FIELD_SIZE  (64)

/****************************************************************************/
/** Constructor
***
*\C Parameters:
*\P   isIStream   IN - Stream to read from
*\P   chFieldSep  IN - Field Separator. If set to '\n' lines are returned
*\P   pcszDefault IN - Default empty string
*****************************************************************************/
MCL_ASCII_DB::MCL_ASCII_DB (istream & isIStream,
                            CHAR chFieldSep,
                            PCSZ pcszDefault) :
   psz_Buff (NULL),
   psz_BuffPos (NULL),
   psz_BuffEnd (NULL),
   i_BuffSize (0),
   apcsz_Fields (NULL),
   i_FieldsSize (0),
   i_FieldsUsed (0),
   is_IStream (isIStream),
   l_StreamPos (0),
   ch_FieldSep (chFieldSep),
   pcsz_Default (pcszDefault)
   {
   *Psz_RCS = *Psz_RCS;                 // To fake compiler warnings

   psz_Buff = new CHAR [BUFFER_SIZE + BUFFER_SIZE + 1];
   if (psz_Buff)
      {
      psz_BuffPos = psz_Buff + BUFFER_SIZE;
      psz_BuffEnd = psz_BuffPos;
      i_BuffSize  = BUFFER_SIZE;
      }

   apcsz_Fields = new PCSZ[FIELD_SIZE];
   if (apcsz_Fields)
      {
      i_FieldsSize = FIELD_SIZE;
      i_FieldsUsed = 0;
//      apcsz_Fields[0] = NULL;
      }
   }

/****************************************************************************/
/** Clear all Fileds
***
*\C Returns:
*\R   MCL_OK
*\N   MCL_ERROR
*****************************************************************************/
inline MCL_APIRET MCL_ASCII_DB::ResetField (VOID)
   {
   if (apcsz_Fields == NULL)
      {
      return (MCL_ERROR);
      }

   i_FieldsUsed = 0;
//   apcsz_Fields[0] = NULL;

   return (MCL_OK);
   }

/****************************************************************************/
/** Reallocate Fields array when array is full
***
*\C Returns:
*\R   MCL_OK
*\N   MCL_ERROR
*****************************************************************************/
inline MCL_APIRET MCL_ASCII_DB::ReallocField (VOID)
   {
   PCSZ * apcszTmpFields = new PCSZ [i_FieldsSize + i_FieldsSize];

   if (apcszTmpFields == NULL)
      {
      return (MCL_ERROR);
      }

   for (INT i = 0; i < i_FieldsSize; ++i)
      {
      apcszTmpFields[i] = apcsz_Fields[i];
      }

   delete [] apcsz_Fields;

   apcsz_Fields = apcszTmpFields;
   i_FieldsSize += i_FieldsSize;

   return (MCL_OK);
   }

/****************************************************************************/
/** Add a pointer to the Fields array
***
*\C Parameters:
*\P   pcszField   IN - Pointer to add
***
*\C Returns:
*\R   MCL_OK
*\N   MCL_ERROR
*****************************************************************************/
inline MCL_APIRET MCL_ASCII_DB::AddField (PCSZ pcszField)
   {
   if ((i_FieldsUsed == i_FieldsSize) &&
       (ReallocField () != MCL_OK))
      {
      return (MCL_ERROR);
      }

   apcsz_Fields[i_FieldsUsed++] = pcszField;

   return (MCL_OK);
   }

/****************************************************************************/
/** Reacalc Fields offset when buffer is moved
***
*\C Parameters:
*\P   pcszNewField0   IN - New pointer of Field 0
***
*\C Returns:
*\R   MCL_OK
*\N   MCL_ERROR
*****************************************************************************/
inline MCL_APIRET MCL_ASCII_DB::RecalcField (PCSZ pcszNewField0)
   {
   if ((apcsz_Fields == NULL) ||
       (pcszNewField0 == NULL))
      {
      return (MCL_ERROR);
      }

   PCSZ pcszOldField0 = apcsz_Fields[0];

   for (INT i = 0; i < i_FieldsUsed; ++i)
      {
      apcsz_Fields[i] = pcszNewField0 + (apcsz_Fields[i] - pcszOldField0);
      }

   return (MCL_OK);
   }

/****************************************************************************/
/** Write the terminal NULL Field
***
*\C Returns:
*\R   MCL_OK
*\N   MCL_ERROR
*****************************************************************************/
//inline MCL_APIRET MCL_ASCII_DB::TerminateField (VOID)
//   {
//   MCL_APIRET mclApiRet;
//
//   if ((mclApiRet = AddField (NULL)) != MCL_OK)
//      {
//      return (mclApiRet);
//      }
//
//   i_FieldsUsed--;
//
//   return (MCL_OK);
//   }

/****************************************************************************/
/** Read next line of data and parse it
***
*\C Returns:
*\R   MCL_OK
*\N   MCL_ERROR
*****************************************************************************/
MCL_APIRET MCL_ASCII_DB::Next (VOID)
   {
   MCL_APIRET mclApiRet = MCL_ERROR;
   PSZ pszPos;

//   if (apcsz_Fields[0] != NULL)
   if (i_FieldsUsed > 0)
      {
      l_StreamPos += psz_BuffPos - apcsz_Fields[0];
      }

   if ((psz_BuffPos == NULL) ||
       ((mclApiRet = ResetField ()) != MCL_OK) ||
       ((mclApiRet = AddField (psz_BuffPos)) != MCL_OK))
      {
      return (mclApiRet);
      }

   if ((psz_BuffPos == psz_BuffEnd) &&
       ((mclApiRet = ReadBuffer ()) != MCL_OK))
      {
      ResetField ();
      return (mclApiRet);
      }

   mclApiRet = MCL_OK;
   pszPos = psz_BuffPos;
   while (*pszPos != '\n')
      {
      if (*pszPos == ch_FieldSep)
         {
         *pszPos = 0;

         if ((mclApiRet = AddField (pszPos + 1)) != MCL_OK)
            {
            return (mclApiRet);
            }
         }

      ++pszPos;
      if (pszPos == psz_BuffEnd)
         {
         mclApiRet = ReadBuffer ();

         if (mclApiRet != MCL_OK)
            {
            if (mclApiRet == MCL_ERROR_FILE_END)
               {
               break;
               }
            else
               {
               return (mclApiRet);
               }
            }

         pszPos = psz_BuffPos;
         }
      }

   if (*(pszPos - 1) == '\r')
      {
      *(pszPos - 1) = 0;
      }

   *pszPos++ = 0;

   psz_BuffPos = (pszPos <= psz_BuffEnd) ? pszPos : psz_BuffEnd;

//   TerminateField ();

   return (mclApiRet);
   }

/****************************************************************************/
/** Read the new buffer and reallocate it if needed
***
*\C Returns:
*\R   MCL_OK
*\N   MCL_ERROR
*****************************************************************************/
MCL_APIRET MCL_ASCII_DB::ReadBuffer (VOID)
   {
   MCL_APIRET mclApiRet;
   PSZ pszNewBuff;
   PSZ pszNewField;

   psz_BuffPos = psz_BuffEnd;

   if (is_IStream.eof ())
      {
      return (MCL_ERROR_FILE_END);
      }

   if (is_IStream.fail ())
      {
      return (MCL_ERROR);
      }

   if (i_FieldsUsed > 0)
      {
      if (apcsz_Fields[0] < (psz_Buff + i_BuffSize))
        {
        pszNewBuff = new CHAR [4 * i_BuffSize + 1 ];
        if (pszNewBuff == NULL)
           {
           return (MCL_ERROR_OUT_MEMORY);
           }

        i_BuffSize += i_BuffSize;

        pszNewField = pszNewBuff + i_BuffSize - (psz_BuffEnd - apcsz_Fields[0]);

        memcpy (pszNewField, apcsz_Fields[0], psz_BuffEnd - apcsz_Fields[0]);
        if ((mclApiRet = RecalcField (pszNewField)) != MCL_OK)
           {
           return (mclApiRet);
           }

        delete [] psz_Buff;
        psz_Buff = pszNewBuff;
        }
     else
        {
        pszNewField = psz_Buff + i_BuffSize - (psz_BuffEnd - apcsz_Fields[0]);

        memcpy (pszNewField, apcsz_Fields[0], psz_BuffEnd - apcsz_Fields[0]);

        if ((mclApiRet = RecalcField (pszNewField)) != MCL_OK)
           {
           return (mclApiRet);
           }
        }
     }

   psz_BuffPos = psz_Buff + i_BuffSize;
   is_IStream.read (psz_BuffPos, i_BuffSize);
   psz_BuffEnd = psz_BuffPos + is_IStream.gcount ();

   if (is_IStream.gcount () == 0)
      {
      return (MCL_ERROR_FILE_END);
      }

   return (MCL_OK);
   }

/****************************************************************************/
/** Copy current record to the MCL_ASCII_DB_RECORD object
***
*\C Parameters:
*\P   mclAdbRecord OUT - Where to copy the record
***
*\C Returns:
*\R   MCL_OK
*\N   MCL_ERROR
*****************************************************************************/
MCL_APIRET MCL_ASCII_DB::CopyRecord (MCL_ASCII_DB_RECORD & mclAdbRecord)
   {
   if ((psz_Buff == NULL) || (apcsz_Fields == NULL))
      {
      return (MCL_ERROR);
      }

   if (i_FieldsUsed == 0)
      {
      mclAdbRecord.i_FieldsUsed = 0;
      return (MCL_OK);
      }

   if ((mclAdbRecord.psz_Buff == NULL) ||
       (mclAdbRecord.i_BuffSize < (psz_BuffPos - apcsz_Fields[0])))
      {
      mclAdbRecord.psz_Buff = new CHAR [psz_BuffPos - apcsz_Fields[0]];
      if (mclAdbRecord.psz_Buff == NULL)
         {
         mclAdbRecord.i_BuffSize = 0;
         mclAdbRecord.i_FieldsUsed = 0;
         return (MCL_ERROR);
         }
      mclAdbRecord.i_BuffSize = psz_BuffPos - apcsz_Fields[0];
      }

   if ((mclAdbRecord.apcsz_Fields == NULL) ||
       (mclAdbRecord.i_FieldsSize < (i_FieldsUsed + 1)))
      {
      mclAdbRecord.apcsz_Fields = new PCSZ [FIELD_SIZE];
      if (mclAdbRecord.apcsz_Fields == NULL)
         {
         mclAdbRecord.i_FieldsSize = 0;
         mclAdbRecord.i_FieldsUsed = 0;
         return (MCL_ERROR);
         }
      mclAdbRecord.i_FieldsSize = i_FieldsUsed + 1;
      }

   memcpy (mclAdbRecord.psz_Buff, apcsz_Fields[0],
           psz_BuffPos - apcsz_Fields[0]);

   for (INT i = 0; i < i_FieldsUsed; ++i)
      {
      mclAdbRecord.apcsz_Fields[i] =
         mclAdbRecord.psz_Buff + (apcsz_Fields[i] - apcsz_Fields[0]);
      }
   mclAdbRecord.i_FieldsUsed = i_FieldsUsed;

   return (MCL_OK);
   }

/****************************************************************************/
/** Constructor
***
*\C Parameters:
*\P   pcszDefault IN - Default empty string
*****************************************************************************/
MCL_ASCII_DB_RECORD::MCL_ASCII_DB_RECORD (PCSZ pcszDefault) :
   psz_Buff (NULL),
   i_BuffSize (0),
   apcsz_Fields (NULL),
   i_FieldsSize (0),
   i_FieldsUsed (0),
   pcsz_Default (pcszDefault)
   {
   }

/****************************************************************************/
/** Destructor
***
*\C Parameters:
*\P   none
*****************************************************************************/
MCL_ASCII_DB_RECORD::~MCL_ASCII_DB_RECORD (VOID)
   {
   if (psz_Buff)
      {
      delete [] psz_Buff;
      }
   if (apcsz_Fields)
      {
      delete [] apcsz_Fields;
      }
   }

